/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.zenscript.type;

import org.objectweb.asm.Type;
import stanhebben.zenscript.annotations.CompareType;
import stanhebben.zenscript.annotations.OperatorType;
import stanhebben.zenscript.compiler.IEnvironmentGlobal;
import stanhebben.zenscript.compiler.IEnvironmentMethod;
import stanhebben.zenscript.expression.Expression;
import stanhebben.zenscript.expression.ExpressionAs;
import stanhebben.zenscript.expression.ExpressionNull;
import stanhebben.zenscript.expression.partial.IPartialExpression;
import stanhebben.zenscript.type.IZenIterator;
import stanhebben.zenscript.type.ZenType;
import stanhebben.zenscript.util.ZenPosition;
import stanhebben.zenscript.util.ZenTypeUtil;

public class ZenTypeDoubleObject
extends ZenType {
    public static final ZenTypeDoubleObject INSTANCE = new ZenTypeDoubleObject();

    private ZenTypeDoubleObject() {
    }

    @Override
    public Expression unary(ZenPosition position, IEnvironmentGlobal environment, Expression value, OperatorType operator) {
        return DOUBLE.unary(position, environment, value.cast(position, environment, DOUBLE), operator);
    }

    @Override
    public Expression binary(ZenPosition position, IEnvironmentGlobal environment, Expression left, Expression right, OperatorType operator) {
        return DOUBLE.binary(position, environment, left.cast(position, environment, DOUBLE), right, operator);
    }

    @Override
    public Expression trinary(ZenPosition position, IEnvironmentGlobal environment, Expression first, Expression second, Expression third, OperatorType operator) {
        return DOUBLE.trinary(position, environment, first.cast(position, environment, DOUBLE), second, third, operator);
    }

    @Override
    public Expression compare(ZenPosition position, IEnvironmentGlobal environment, Expression left, Expression right, CompareType type) {
        return DOUBLE.compare(position, environment, left.cast(position, environment, DOUBLE), right, type);
    }

    @Override
    public IPartialExpression getMember(ZenPosition position, IEnvironmentGlobal environment, IPartialExpression value, String name) {
        return DOUBLE.getMember(position, environment, value.eval(environment).cast(position, environment, DOUBLE), name);
    }

    @Override
    public IPartialExpression getStaticMember(ZenPosition position, IEnvironmentGlobal environment, String name) {
        return DOUBLE.getStaticMember(position, environment, name);
    }

    @Override
    public Expression call(ZenPosition position, IEnvironmentGlobal environment, Expression receiver, Expression ... arguments) {
        return DOUBLE.call(position, environment, receiver.cast(position, environment, DOUBLE), arguments);
    }

    @Override
    public IZenIterator makeIterator(int numValues, IEnvironmentMethod methodOutput) {
        return DOUBLE.makeIterator(numValues, methodOutput);
    }

    @Override
    public boolean canCastImplicit(ZenType type, IEnvironmentGlobal environment) {
        return DOUBLE.canCastImplicit(type, environment);
    }

    @Override
    public boolean canCastExplicit(ZenType type, IEnvironmentGlobal environment) {
        return DOUBLE.canCastExplicit(type, environment);
    }

    @Override
    public Expression cast(ZenPosition position, IEnvironmentGlobal environment, Expression value, ZenType type) {
        if (type.getNumberType() > 0 || type == STRING) {
            return new ExpressionAs(position, value, type);
        }
        if (this.canCastExpansion(environment, type)) {
            return this.castExpansion(position, environment, value, type);
        }
        return new ExpressionAs(position, value, type);
    }

    @Override
    public Class toJavaClass() {
        return Double.class;
    }

    @Override
    public Type toASMType() {
        return Type.getType(Double.class);
    }

    @Override
    public int getNumberType() {
        return 6;
    }

    @Override
    public String getSignature() {
        return ZenTypeUtil.signature(Double.class);
    }

    @Override
    public boolean isPointer() {
        return true;
    }

    @Override
    public void compileCast(ZenPosition position, IEnvironmentMethod environment, ZenType type) {
        if (type != this) {
            if (type == DOUBLE) {
                environment.getOutput().invokeVirtual(Double.class, "doubleValue", Double.TYPE, new Class[0]);
            } else if (type == STRING) {
                environment.getOutput().invokeVirtual(Double.class, "toString", String.class, new Class[0]);
            } else {
                environment.getOutput().invokeVirtual(Double.class, "doubleValue", Double.TYPE, new Class[0]);
                DOUBLE.compileCast(position, environment, type);
            }
        }
    }

    @Override
    public String getName() {
        return "double";
    }

    @Override
    public Expression defaultValue(ZenPosition position) {
        return new ExpressionNull(position);
    }
}

