/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.zenscript.type.natives;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.compiler.IEnvironmentGlobal;
import stanhebben.zenscript.compiler.ITypeRegistry;
import stanhebben.zenscript.expression.Expression;
import stanhebben.zenscript.expression.ExpressionArray;
import stanhebben.zenscript.expression.ExpressionInvalid;
import stanhebben.zenscript.expression.ExpressionJavaCallStatic;
import stanhebben.zenscript.expression.ExpressionJavaCallVirtual;
import stanhebben.zenscript.type.ZenType;
import stanhebben.zenscript.type.ZenTypeArray;
import stanhebben.zenscript.type.ZenTypeArrayBasic;
import stanhebben.zenscript.util.ZenPosition;

public class JavaMethod {
    public static final int PRIORITY_INVALID = -1;
    public static final int PRIORITY_LOW = 1;
    public static final int PRIORITY_MEDIUM = 2;
    public static final int PRIORITY_HIGH = 3;
    private final Class owner;
    private final Method method;
    private final ZenType[] parameterTypes;
    private final boolean[] optional;
    private final ZenType returnType;

    public static JavaMethod get(ITypeRegistry types, Class cls, String name, Class ... parameterTypes) {
        try {
            Method method = cls.getMethod(name, parameterTypes);
            return new JavaMethod(cls, method, types);
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException("method " + name + " not found in class " + cls.getName(), ex);
        }
        catch (SecurityException ex) {
            throw new RuntimeException("method retrieval not permitted", ex);
        }
    }

    public static JavaMethod select(boolean doStatic, List<JavaMethod> methods, IEnvironmentGlobal environment, Expression ... arguments) {
        int bestPriority = -1;
        JavaMethod bestMethod = null;
        boolean isValid = false;
        for (JavaMethod method : methods) {
            if (method.isStatic() != doStatic) continue;
            int priority = method.getPriority(environment, arguments);
            if (priority == bestPriority) {
                isValid = false;
                continue;
            }
            if (priority <= bestPriority) continue;
            isValid = true;
            bestMethod = method;
            bestPriority = priority;
        }
        return isValid ? bestMethod : null;
    }

    public static ZenType[] predict(List<JavaMethod> methods, int numArguments, IEnvironmentGlobal environment) {
        ZenType[] results = new ZenType[numArguments];
        boolean[] ambiguous = new boolean[numArguments];
        for (JavaMethod method : methods) {
            if (!method.accepts(numArguments)) continue;
            for (int i = 0; i < numArguments; ++i) {
                if (i >= method.parameterTypes.length - 1 && method.method.isVarArgs()) {
                    if (numArguments == method.parameterTypes.length) {
                        ambiguous[i] = true;
                    } else if (numArguments > method.parameterTypes.length) {
                        if (results[i] != null) {
                            ambiguous[i] = true;
                        } else {
                            results[i] = ((ZenTypeArray)method.parameterTypes[method.parameterTypes.length - 1]).getBaseType();
                        }
                    }
                }
                if (results[i] != null) {
                    ambiguous[i] = true;
                    continue;
                }
                results[i] = method.parameterTypes[i];
            }
        }
        for (int i = 0; i < results.length; ++i) {
            if (!ambiguous[i]) continue;
            results[i] = null;
        }
        return results;
    }

    public JavaMethod(Class owner, Method method, ITypeRegistry types) {
        this.owner = owner;
        this.method = method;
        this.returnType = types.getType(method.getGenericReturnType());
        this.parameterTypes = new ZenType[method.getParameterTypes().length];
        this.optional = new boolean[this.parameterTypes.length];
        for (int i = 0; i < this.parameterTypes.length; ++i) {
            this.parameterTypes[i] = types.getType(method.getGenericParameterTypes()[i]);
            this.optional[i] = false;
            for (Annotation annotation : method.getParameterAnnotations()[i]) {
                if (!(annotation instanceof Optional)) continue;
                this.optional[i] = true;
            }
        }
        if (method.isVarArgs()) {
            this.optional[this.parameterTypes.length - 1] = true;
        }
    }

    public boolean isStatic() {
        return (this.method.getModifiers() & 8) > 0;
    }

    public ZenType getReturnType() {
        return this.returnType;
    }

    public ZenType[] getParameterTypes() {
        return this.parameterTypes;
    }

    public Class getOwner() {
        return this.owner;
    }

    public Method getMethod() {
        return this.method;
    }

    public boolean accepts(IEnvironmentGlobal environment, Expression ... arguments) {
        return this.getPriority(environment, arguments) > 0;
    }

    public boolean accepts(int numArguments) {
        if (numArguments > this.parameterTypes.length) {
            return this.method.isVarArgs();
        }
        if (numArguments == this.parameterTypes.length) {
            return true;
        }
        for (int i = numArguments; i < this.parameterTypes.length; ++i) {
            if (this.optional[i]) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getPriority(IEnvironmentGlobal environment, Expression ... arguments) {
        ZenType argType;
        int result = 3;
        if (arguments.length > this.parameterTypes.length) {
            if (!this.method.isVarArgs()) return -1;
            ZenType arrayType = this.parameterTypes[this.method.getParameterTypes().length - 1];
            ZenType baseType = ((ZenTypeArray)arrayType).getBaseType();
            for (int i = this.parameterTypes.length - 1; i < arguments.length; ++i) {
                argType = arguments[i].getType();
                if (argType.equals(baseType)) continue;
                if (!argType.canCastImplicit(baseType, environment)) return -1;
                result = Math.min(result, 1);
            }
        } else if (arguments.length < this.parameterTypes.length) {
            result = 2;
            int checkUntil = this.parameterTypes.length;
            if (this.method.isVarArgs()) {
                --checkUntil;
            }
            for (int i = arguments.length; i < checkUntil; ++i) {
                if (this.optional[i]) continue;
                return -1;
            }
        }
        int checkUntil = arguments.length;
        if (arguments.length == this.parameterTypes.length && this.method.isVarArgs()) {
            ZenType arrayType = this.parameterTypes[this.method.getParameterTypes().length - 1];
            ZenType baseType = ((ZenTypeArray)arrayType).getBaseType();
            argType = arguments[arguments.length - 1].getType();
            if (!argType.equals(arrayType) && !argType.equals(baseType)) {
                if (argType.canCastImplicit(arrayType, environment)) {
                    result = Math.min(result, 1);
                } else {
                    if (!argType.canCastImplicit(baseType, environment)) return -1;
                    result = Math.min(result, 1);
                }
            }
            checkUntil = arguments.length - 1;
        }
        for (int i = 0; i < checkUntil; ++i) {
            ZenType paramType;
            ZenType argType2 = arguments[i].getType();
            if (argType2.equals(paramType = this.parameterTypes[i])) continue;
            if (!argType2.canCastImplicit(paramType, environment)) return -1;
            result = Math.min(result, 1);
        }
        return result;
    }

    public Expression callVirtual(ZenPosition position, IEnvironmentGlobal environment, Expression receiver, Expression ... arguments) {
        if (this.isStatic()) {
            environment.error(position, "trying to call a static method dynamically");
            return new ExpressionInvalid(position, environment.getType(this.method.getReturnType()));
        }
        Expression[] actual = this.rematch(position, environment, arguments);
        return new ExpressionJavaCallVirtual(position, this, receiver, actual);
    }

    public Expression callStatic(ZenPosition position, IEnvironmentGlobal environment, Expression ... arguments) {
        if (this.isStatic()) {
            Expression[] actual = this.rematch(position, environment, arguments);
            return new ExpressionJavaCallStatic(position, this, actual);
        }
        environment.error(position, "trying to call a non-static method statically");
        return new ExpressionInvalid(position, environment.getType(this.method.getReturnType()));
    }

    private Expression[] rematch(ZenPosition position, IEnvironmentGlobal environment, Expression ... arguments) {
        int i;
        if (arguments.length == 0 && this.parameterTypes.length == 0) {
            return arguments;
        }
        Expression[] result = new Expression[this.method.getParameterTypes().length];
        for (int i2 = arguments.length; i2 < this.method.getParameterTypes().length; ++i2) {
            result[i2] = this.parameterTypes[i2].defaultValue(position);
        }
        int doUntil = this.parameterTypes.length;
        if (this.method.isVarArgs()) {
            doUntil = arguments.length - 1;
            ZenType paramType = this.parameterTypes[this.parameterTypes.length - 1];
            ZenType baseType = ((ZenTypeArray)paramType).getBaseType();
            if (arguments.length == this.parameterTypes.length) {
                ZenType argType = arguments[arguments.length - 1].getType();
                result[arguments.length - 1] = argType.equals(paramType) ? arguments[arguments.length - 1] : (argType.equals(baseType) ? new ExpressionArray(position, arguments[arguments.length - 1]) : (argType.canCastImplicit(paramType, environment) ? arguments[arguments.length - 1].cast(position, environment, paramType) : new ExpressionArray(position, arguments[arguments.length - 1]).cast(position, environment, paramType)));
            } else if (arguments.length > this.parameterTypes.length) {
                int offset = this.parameterTypes.length - 1;
                Expression[] values = new Expression[arguments.length - offset];
                for (int i3 = 0; i3 < values.length; ++i3) {
                    values[i3] = arguments[offset + i3].cast(position, environment, baseType);
                }
                result[arguments.length - 1] = new ExpressionArray(position, values, (ZenTypeArrayBasic)paramType);
            }
        }
        for (i = arguments.length; i < doUntil; ++i) {
            result[i] = this.parameterTypes[i].defaultValue(position);
        }
        for (i = 0; i < Math.min(arguments.length, doUntil); ++i) {
            result[i] = arguments[i].cast(position, environment, this.parameterTypes[i]);
        }
        return result;
    }
}

