/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.entities.player;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import micdoodle8.mods.galacticraft.api.recipe.ISchematicPage;
import micdoodle8.mods.galacticraft.api.recipe.SchematicRegistry;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.blocks.GCBlocks;
import micdoodle8.mods.galacticraft.core.command.CommandGCInv;
import micdoodle8.mods.galacticraft.core.inventory.InventoryExtended;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;

public class GCPlayerStats
implements IExtendedEntityProperties {
    public static final String GC_PLAYER_PROP = "GCPlayerStats";
    public WeakReference<EntityPlayerMP> player;
    public InventoryExtended extendedInventory = new InventoryExtended();
    public int airRemaining;
    public int airRemaining2;
    public int thermalLevel;
    public int damageCounter;
    public int spaceshipTier = 1;
    public ItemStack[] rocketStacks = new ItemStack[2];
    public int rocketType;
    public int fuelLevel;
    public Item rocketItem;
    public ItemStack launchpadStack;
    public boolean usingParachute;
    public ItemStack parachuteInSlot;
    public ItemStack lastParachuteInSlot;
    public ItemStack frequencyModuleInSlot;
    public ItemStack lastFrequencyModuleInSlot;
    public ItemStack maskInSlot;
    public ItemStack lastMaskInSlot;
    public ItemStack gearInSlot;
    public ItemStack lastGearInSlot;
    public ItemStack tankInSlot1;
    public ItemStack lastTankInSlot1;
    public ItemStack tankInSlot2;
    public ItemStack lastTankInSlot2;
    public ItemStack thermalHelmetInSlot;
    public ItemStack lastThermalHelmetInSlot;
    public ItemStack thermalChestplateInSlot;
    public ItemStack lastThermalChestplateInSlot;
    public ItemStack thermalLeggingsInSlot;
    public ItemStack lastThermalLeggingsInSlot;
    public ItemStack thermalBootsInSlot;
    public ItemStack lastThermalBootsInSlot;
    public int launchAttempts = 0;
    public int spaceRaceInviteTeamID;
    public boolean usingPlanetSelectionGui;
    public String savedPlanetList = "";
    public int openPlanetSelectionGuiCooldown;
    public boolean hasOpenedPlanetSelectionGui = false;
    public int chestSpawnCooldown;
    public Vector3 chestSpawnVector;
    public int teleportCooldown;
    public int chatCooldown;
    public double distanceSinceLastStep;
    public int lastStep;
    public double coordsTeleportedFromX;
    public double coordsTeleportedFromZ;
    public int spaceStationDimensionID = -1;
    public boolean oxygenSetupValid;
    public boolean lastOxygenSetupValid;
    public boolean touchedGround;
    public boolean lastOnGround;
    public boolean inLander;
    public boolean justLanded;
    public ArrayList<ISchematicPage> unlockedSchematics = new ArrayList();
    public ArrayList<ISchematicPage> lastUnlockedSchematics = new ArrayList();
    public int cryogenicChamberCooldown;
    public boolean receivedSoundWarning;
    public boolean openedSpaceRaceManager = false;
    public boolean newInOrbit = true;

    public GCPlayerStats(EntityPlayerMP player) {
        this.player = new WeakReference<EntityPlayerMP>(player);
    }

    public void saveNBTData(NBTTagCompound nbt) {
        nbt.func_74782_a("ExtendedInventoryGC", (NBTBase)this.extendedInventory.writeToNBT(new NBTTagList()));
        nbt.func_74768_a("playerAirRemaining", this.airRemaining);
        nbt.func_74768_a("damageCounter", this.damageCounter);
        nbt.func_74757_a("OxygenSetupValid", this.oxygenSetupValid);
        nbt.func_74757_a("usingParachute2", this.usingParachute);
        nbt.func_74757_a("usingPlanetSelectionGui", this.usingPlanetSelectionGui);
        nbt.func_74768_a("teleportCooldown", this.teleportCooldown);
        nbt.func_74780_a("coordsTeleportedFromX", this.coordsTeleportedFromX);
        nbt.func_74780_a("coordsTeleportedFromZ", this.coordsTeleportedFromZ);
        nbt.func_74768_a("spaceStationDimensionID", this.spaceStationDimensionID);
        nbt.func_74768_a("thermalLevel", this.thermalLevel);
        Collections.sort(this.unlockedSchematics);
        NBTTagList tagList = new NBTTagList();
        for (ISchematicPage page : this.unlockedSchematics) {
            if (page == null) continue;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74768_a("UnlockedPage", page.getPageID());
            tagList.func_74742_a((NBTBase)nbttagcompound);
        }
        nbt.func_74782_a("Schematics", (NBTBase)tagList);
        nbt.func_74768_a("rocketStacksLength", this.rocketStacks.length);
        nbt.func_74768_a("SpaceshipTier", this.spaceshipTier);
        nbt.func_74768_a("FuelLevel", this.fuelLevel);
        if (this.rocketItem != null) {
            ItemStack returnRocket = new ItemStack(this.rocketItem, 1, this.rocketType);
            nbt.func_74782_a("ReturnRocket", (NBTBase)returnRocket.func_77955_b(new NBTTagCompound()));
        }
        NBTTagList var2 = new NBTTagList();
        for (int var3 = 0; var3 < this.rocketStacks.length; ++var3) {
            if (this.rocketStacks[var3] == null) continue;
            NBTTagCompound var4 = new NBTTagCompound();
            var4.func_74774_a("Slot", (byte)var3);
            this.rocketStacks[var3].func_77955_b(var4);
            var2.func_74742_a((NBTBase)var4);
        }
        nbt.func_74782_a("RocketItems", (NBTBase)var2);
        NBTTagCompound var4 = new NBTTagCompound();
        if (this.launchpadStack != null) {
            nbt.func_74782_a("LaunchpadStack", (NBTBase)this.launchpadStack.func_77955_b(var4));
        } else {
            nbt.func_74782_a("LaunchpadStack", (NBTBase)var4);
        }
        nbt.func_74768_a("CryogenicChamberCooldown", this.cryogenicChamberCooldown);
        nbt.func_74757_a("ReceivedSoundWarning", this.receivedSoundWarning);
    }

    public void loadNBTData(NBTTagCompound nbt) {
        ItemStack returnRocket;
        ItemStack[] saveinv;
        this.airRemaining = nbt.func_74762_e("playerAirRemaining");
        this.damageCounter = nbt.func_74762_e("damageCounter");
        this.oxygenSetupValid = this.lastOxygenSetupValid = nbt.func_74767_n("OxygenSetupValid");
        this.thermalLevel = nbt.func_74762_e("thermalLevel");
        NBTTagList nbttaglist = nbt.func_150295_c("Inventory", 10);
        this.extendedInventory.readFromNBTOld(nbttaglist);
        if (nbt.func_74764_b("ExtendedInventoryGC")) {
            this.extendedInventory.readFromNBT(nbt.func_150295_c("ExtendedInventoryGC", 10));
        }
        if ((saveinv = CommandGCInv.getSaveData(((EntityPlayerMP)this.player.get()).func_146103_bH().getName().toLowerCase())) != null) {
            CommandGCInv.doLoad((EntityPlayerMP)this.player.get());
        }
        if (nbt.func_74764_b("SpaceshipTier")) {
            this.spaceshipTier = nbt.func_74762_e("SpaceshipTier");
        }
        if (nbt.func_74764_b("FuelLevel")) {
            this.fuelLevel = nbt.func_74762_e("FuelLevel");
        }
        if (nbt.func_74764_b("ReturnRocket") && (returnRocket = ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("ReturnRocket"))) != null) {
            this.rocketItem = returnRocket.func_77973_b();
            this.rocketType = returnRocket.func_77960_j();
        }
        this.usingParachute = nbt.func_74767_n("usingParachute2");
        this.usingPlanetSelectionGui = nbt.func_74767_n("usingPlanetSelectionGui");
        this.teleportCooldown = nbt.func_74762_e("teleportCooldown");
        this.coordsTeleportedFromX = nbt.func_74769_h("coordsTeleportedFromX");
        this.coordsTeleportedFromZ = nbt.func_74769_h("coordsTeleportedFromZ");
        this.spaceStationDimensionID = nbt.func_74762_e("spaceStationDimensionID");
        if (nbt.func_74767_n("usingPlanetSelectionGui")) {
            this.openPlanetSelectionGuiCooldown = 20;
        }
        if (nbt.func_74764_b("RocketItems") && nbt.func_74764_b("rocketStacksLength")) {
            NBTTagList var23 = nbt.func_150295_c("RocketItems", 10);
            int length = nbt.func_74762_e("rocketStacksLength");
            this.rocketStacks = new ItemStack[length];
            for (int var3 = 0; var3 < var23.func_74745_c(); ++var3) {
                NBTTagCompound var4 = var23.func_150305_b(var3);
                int var5 = var4.func_74771_c("Slot") & 0xFF;
                if (var5 < 0 || var5 >= this.rocketStacks.length) continue;
                this.rocketStacks[var5] = ItemStack.func_77949_a((NBTTagCompound)var4);
            }
        }
        this.unlockedSchematics = new ArrayList();
        for (int i = 0; i < nbt.func_150295_c("Schematics", 10).func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = nbt.func_150295_c("Schematics", 10).func_150305_b(i);
            int j = nbttagcompound.func_74762_e("UnlockedPage");
            SchematicRegistry.addUnlockedPage((EntityPlayerMP)this.player.get(), SchematicRegistry.getMatchingRecipeForID(j));
        }
        Collections.sort(this.unlockedSchematics);
        this.cryogenicChamberCooldown = nbt.func_74762_e("CryogenicChamberCooldown");
        if (nbt.func_74764_b("ReceivedSoundWarning")) {
            this.receivedSoundWarning = nbt.func_74767_n("ReceivedSoundWarning");
        }
        if (nbt.func_74764_b("LaunchpadStack")) {
            this.launchpadStack = ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("LaunchpadStack"));
            if (this.launchpadStack != null && this.launchpadStack.field_77994_a == 0) {
                this.launchpadStack = null;
            }
        } else {
            this.launchpadStack = new ItemStack(GCBlocks.landingPad, 9, 0);
        }
    }

    public void init(Entity entity, World world) {
    }

    public static void register(EntityPlayerMP player) {
        player.registerExtendedProperties(GC_PLAYER_PROP, (IExtendedEntityProperties)new GCPlayerStats(player));
    }

    public static GCPlayerStats get(EntityPlayerMP player) {
        return (GCPlayerStats)player.getExtendedProperties(GC_PLAYER_PROP);
    }

    public void copyFrom(GCPlayerStats oldData, boolean keepInv) {
        if (keepInv) {
            this.extendedInventory.copyInventory(oldData.extendedInventory);
        }
        this.spaceStationDimensionID = oldData.spaceStationDimensionID;
        this.unlockedSchematics = oldData.unlockedSchematics;
        this.receivedSoundWarning = oldData.receivedSoundWarning;
        this.openedSpaceRaceManager = oldData.openedSpaceRaceManager;
        this.spaceRaceInviteTeamID = oldData.spaceRaceInviteTeamID;
    }
}

