/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.nei.NEIGalacticraftConfig;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class ElectricIngotCompressorRecipeHandler
extends TemplateRecipeHandler {
    private static final ResourceLocation ingotCompressorTexture = new ResourceLocation(GalacticraftCore.ASSET_PREFIX, "textures/gui/electric_IngotCompressor.png");
    public static int ticksPassed;

    public String getRecipeId() {
        return "galacticraft.electricingotcompressor";
    }

    public int recipiesPerPage() {
        return 1;
    }

    public Set<Map.Entry<ArrayList<PositionedStack>, PositionedStack>> getRecipes() {
        HashMap recipes = new HashMap();
        for (Map.Entry<HashMap<Integer, PositionedStack>, PositionedStack> stack : NEIGalacticraftConfig.getIngotCompressorRecipes()) {
            ArrayList<PositionedStack> inputStacks = new ArrayList<PositionedStack>();
            for (Map.Entry<Integer, PositionedStack> input : stack.getKey().entrySet()) {
                inputStacks.add(input.getValue());
            }
            recipes.put(inputStacks, stack.getValue());
        }
        return recipes.entrySet();
    }

    public void drawBackground(int i) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((ResourceLocation)ingotCompressorTexture);
        GuiDraw.drawTexturedModalRect((int)20, (int)25, (int)18, (int)17, (int)137, (int)54);
        if (ticksPassed % 70 > 26) {
            GuiDraw.drawTexturedModalRect((int)103, (int)38, (int)176, (int)0, (int)17, (int)13);
        }
        GuiDraw.drawTexturedModalRect((int)79, (int)46, (int)176, (int)13, (int)Math.min(ticksPassed % 70, 53), (int)17);
    }

    public void onUpdate() {
        ++ticksPassed;
        super.onUpdate();
    }

    public void loadTransferRects() {
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getRecipeId())) {
            for (Map.Entry<ArrayList<PositionedStack>, PositionedStack> irecipe : this.getRecipes()) {
                this.arecipes.add(new ElectricCompressorRecipe(irecipe));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (Map.Entry<ArrayList<PositionedStack>, PositionedStack> irecipe : this.getRecipes()) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)irecipe.getValue().item, (ItemStack)result)) continue;
            this.arecipes.add(new ElectricCompressorRecipe(irecipe));
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        block0: for (Map.Entry<ArrayList<PositionedStack>, PositionedStack> irecipe : this.getRecipes()) {
            for (PositionedStack pstack : irecipe.getKey()) {
                if (!pstack.contains(ingredient)) continue;
                this.arecipes.add(new ElectricCompressorRecipe(irecipe));
                continue block0;
            }
        }
    }

    public ArrayList<PositionedStack> getIngredientStacks(int recipe) {
        return (ArrayList)((TemplateRecipeHandler.CachedRecipe)this.arecipes.get(recipe)).getIngredients();
    }

    public PositionedStack getResultStack(int recipe) {
        if (ticksPassed % 70 >= 53) {
            return ((TemplateRecipeHandler.CachedRecipe)this.arecipes.get(recipe)).getResult();
        }
        return null;
    }

    public String getRecipeName() {
        return "El. Ingot Compressor";
    }

    public String getGuiTexture() {
        return GalacticraftCore.TEXTURE_PREFIX + "textures/gui/electric_IngotCompressor.png";
    }

    public void drawForeground(int recipe) {
    }

    public class ElectricCompressorRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public ArrayList<PositionedStack> input;
        public PositionedStack output;

        public ArrayList<PositionedStack> getIngredients() {
            return (ArrayList)this.getCycledIngredients(ElectricIngotCompressorRecipeHandler.this.cycleticks / 20, this.input);
        }

        public PositionedStack getResult() {
            return this.output;
        }

        public ElectricCompressorRecipe(ArrayList<PositionedStack> pstack1, PositionedStack pstack2) {
            super((TemplateRecipeHandler)ElectricIngotCompressorRecipeHandler.this);
            ArrayList<PositionedStack> ingred = new ArrayList<PositionedStack>();
            for (PositionedStack stack : pstack1) {
                PositionedStack stack2 = stack.copy();
                stack2.item.field_77994_a *= 2;
                ingred.add(stack2);
            }
            this.input = ingred;
            pstack2.rely -= 8;
            this.output = pstack2;
        }

        public ElectricCompressorRecipe(Map.Entry<ArrayList<PositionedStack>, PositionedStack> recipe) {
            this(new ArrayList<PositionedStack>((Collection)recipe.getKey()), recipe.getValue().copy());
        }

        public PositionedStack getOtherStack() {
            if (ticksPassed % 70 >= 53) {
                PositionedStack outputCopy = this.output.copy();
                outputCopy.rely += 18;
                return outputCopy;
            }
            return null;
        }
    }
}

