/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.ItemList;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.FurnaceRecipeHandler;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.nei.NEIGalacticraftConfig;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class IngotCompressorRecipeHandler
extends TemplateRecipeHandler {
    private static final ResourceLocation ingotCompressorTexture = new ResourceLocation(GalacticraftCore.ASSET_PREFIX, "textures/gui/ingotCompressor.png");
    private static int ticksPassed;
    public static ArrayList<FurnaceRecipeHandler.FuelPair> afuels;
    public static TreeSet<Integer> efuels;

    public String getRecipeId() {
        return "galacticraft.ingotcompressor";
    }

    public int recipiesPerPage() {
        return 1;
    }

    public Set<Map.Entry<ArrayList<PositionedStack>, PositionedStack>> getRecipes() {
        HashMap recipes = new HashMap();
        for (Map.Entry<HashMap<Integer, PositionedStack>, PositionedStack> stack : NEIGalacticraftConfig.getIngotCompressorRecipes()) {
            ArrayList<PositionedStack> inputStacks = new ArrayList<PositionedStack>();
            for (Map.Entry<Integer, PositionedStack> input : stack.getKey().entrySet()) {
                inputStacks.add(input.getValue());
            }
            recipes.put(inputStacks, stack.getValue());
        }
        return recipes.entrySet();
    }

    public void drawBackground(int i) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((ResourceLocation)ingotCompressorTexture);
        GuiDraw.drawTexturedModalRect((int)20, (int)25, (int)18, (int)17, (int)137, (int)78);
        if (ticksPassed % 70 > 26) {
            GuiDraw.drawTexturedModalRect((int)103, (int)36, (int)176, (int)0, (int)17, (int)13);
        }
        GuiDraw.drawTexturedModalRect((int)79, (int)44, (int)176, (int)13, (int)Math.min(ticksPassed % 70, 53), (int)17);
        int yOffset = (int)Math.floor((double)(ticksPassed % 48) * 0.2916666666666667);
        GuiDraw.drawTexturedModalRect((int)83, (int)(35 + yOffset), (int)176, (int)(30 + yOffset), (int)14, (int)(14 - yOffset));
    }

    public void onUpdate() {
        ++ticksPassed;
        super.onUpdate();
    }

    public void loadTransferRects() {
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getRecipeId())) {
            for (Map.Entry<ArrayList<PositionedStack>, PositionedStack> irecipe : this.getRecipes()) {
                this.arecipes.add(new CompressorRecipe(irecipe));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (Map.Entry<ArrayList<PositionedStack>, PositionedStack> irecipe : this.getRecipes()) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)irecipe.getValue().item, (ItemStack)result)) continue;
            this.arecipes.add(new CompressorRecipe(irecipe));
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        block0: for (Map.Entry<ArrayList<PositionedStack>, PositionedStack> irecipe : this.getRecipes()) {
            for (PositionedStack pstack : irecipe.getKey()) {
                if (!pstack.contains(ingredient)) continue;
                this.arecipes.add(new CompressorRecipe(irecipe));
                continue block0;
            }
        }
    }

    public TemplateRecipeHandler newInstance() {
        if (afuels == null) {
            IngotCompressorRecipeHandler.findFuels();
        }
        return super.newInstance();
    }

    public ArrayList<PositionedStack> getIngredientStacks(int recipe) {
        return (ArrayList)((TemplateRecipeHandler.CachedRecipe)this.arecipes.get(recipe)).getIngredients();
    }

    public PositionedStack getResultStack(int recipe) {
        if (ticksPassed % 70 >= 53) {
            return ((TemplateRecipeHandler.CachedRecipe)this.arecipes.get(recipe)).getResult();
        }
        return null;
    }

    private static void removeFuels() {
        efuels = new TreeSet();
        efuels.add(Block.func_149682_b((Block)Blocks.field_150338_P));
        efuels.add(Block.func_149682_b((Block)Blocks.field_150420_aW));
        efuels.add(Block.func_149682_b((Block)Blocks.field_150444_as));
        efuels.add(Block.func_149682_b((Block)Blocks.field_150472_an));
        efuels.add(Block.func_149682_b((Block)Blocks.field_150466_ao));
        efuels.add(Block.func_149682_b((Block)Blocks.field_150447_bR));
    }

    private static void findFuels() {
        afuels = new ArrayList();
        for (ItemStack item : ItemList.items) {
            int burnTime;
            if (efuels.contains(Item.func_150891_b((Item)item.func_77973_b())) || (burnTime = TileEntityFurnace.func_145952_a((ItemStack)item)) <= 0) continue;
            FurnaceRecipeHandler.FuelPair fuelPair = new FurnaceRecipeHandler.FuelPair(item.func_77946_l(), burnTime);
            fuelPair.stack.relx = 57;
            fuelPair.stack.rely = 83;
            afuels.add(fuelPair);
        }
    }

    public String getRecipeName() {
        return "Ingot Compressor";
    }

    public String getGuiTexture() {
        return GalacticraftCore.TEXTURE_PREFIX + "textures/gui/ingotCompressor.png";
    }

    public void drawForeground(int recipe) {
    }

    static {
        IngotCompressorRecipeHandler.removeFuels();
    }

    public class CompressorRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public ArrayList<PositionedStack> input;
        public PositionedStack output;

        public ArrayList<PositionedStack> getIngredients() {
            return (ArrayList)this.getCycledIngredients(IngotCompressorRecipeHandler.this.cycleticks / 20, this.input);
        }

        public PositionedStack getResult() {
            return this.output;
        }

        public CompressorRecipe(ArrayList<PositionedStack> pstack1, PositionedStack pstack2) {
            super((TemplateRecipeHandler)IngotCompressorRecipeHandler.this);
            this.input = pstack1;
            this.output = pstack2;
        }

        public CompressorRecipe(Map.Entry<ArrayList<PositionedStack>, PositionedStack> recipe) {
            this(new ArrayList<PositionedStack>((Collection)recipe.getKey()), recipe.getValue().copy());
        }

        public List<PositionedStack> getOtherStacks() {
            ArrayList<PositionedStack> stacks = new ArrayList<PositionedStack>();
            PositionedStack stack = this.getOtherStack();
            if (stack != null) {
                stacks.add(stack);
            }
            return stacks;
        }

        public PositionedStack getOtherStack() {
            return IngotCompressorRecipeHandler.afuels.get((int)(ticksPassed / 48 % IngotCompressorRecipeHandler.afuels.size())).stack;
        }
    }
}

