/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.util;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.Iterator;
import java.util.UUID;
import micdoodle8.mods.galacticraft.core.util.GCLog;
import micdoodle8.mods.galacticraft.core.util.VersionUtil;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;

public class PlayerUtil {
    public static HashMap<String, GameProfile> knownSkins = new HashMap();

    public static EntityPlayerMP getPlayerForUsernameVanilla(MinecraftServer server, String username) {
        return VersionUtil.getPlayerForUsername(server, username);
    }

    public static EntityPlayerMP getPlayerBaseServerFromPlayerUsername(String username, boolean ignoreCase) {
        MinecraftServer server = MinecraftServer.func_71276_C();
        if (server != null) {
            EntityPlayerMP entityplayermp;
            if (ignoreCase) {
                return PlayerUtil.getPlayerForUsernameVanilla(server, username);
            }
            Iterator iterator = server.func_71203_ab().field_72404_b.iterator();
            do {
                if (iterator.hasNext()) continue;
                return null;
            } while (!(entityplayermp = (EntityPlayerMP)iterator.next()).func_70005_c_().equalsIgnoreCase(username));
            return entityplayermp;
        }
        GCLog.severe("Warning: Could not find player base server instance for player " + username);
        return null;
    }

    public static EntityPlayerMP getPlayerBaseServerFromPlayer(EntityPlayer player, boolean ignoreCase) {
        if (player == null) {
            return null;
        }
        if (player instanceof EntityPlayerMP) {
            return (EntityPlayerMP)player;
        }
        return PlayerUtil.getPlayerBaseServerFromPlayerUsername(player.func_70005_c_(), ignoreCase);
    }

    @SideOnly(value=Side.CLIENT)
    public static EntityClientPlayerMP getPlayerBaseClientFromPlayer(EntityPlayer player, boolean ignoreCase) {
        EntityClientPlayerMP clientPlayer = FMLClientHandler.instance().getClientPlayerEntity();
        if (clientPlayer == null && player != null) {
            GCLog.severe("Warning: Could not find player base client instance for player " + player.func_146103_bH().getName());
        }
        return clientPlayer;
    }

    @SideOnly(value=Side.CLIENT)
    public static GameProfile getOtherPlayerProfile(String name) {
        return knownSkins.get(name);
    }

    @SideOnly(value=Side.CLIENT)
    public static GameProfile makeOtherPlayerProfile(String strName, String strUUID) {
        GameProfile profile = null;
        for (Object e : FMLClientHandler.instance().getWorldClient().func_72910_y()) {
            GameProfile gp2;
            if (!(e instanceof AbstractClientPlayer) || !(gp2 = ((AbstractClientPlayer)e).func_146103_bH()).getName().equals(strName)) continue;
            profile = gp2;
            break;
        }
        if (profile == null) {
            try {
                UUID uuid = strUUID.isEmpty() ? UUID.randomUUID() : UUID.fromString(strUUID);
                profile = VersionUtil.constructGameProfile(uuid, strName);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (profile == null) {
            profile = VersionUtil.constructGameProfile(UUID.randomUUID(), strName);
        }
        knownSkins.put(strName, profile);
        return profile;
    }
}

