/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.client.gui.screen;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.eventhandler.Event;
import java.nio.FloatBuffer;
import micdoodle8.mods.galacticraft.api.event.client.CelestialBodyRenderEvent;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.Moon;
import micdoodle8.mods.galacticraft.api.galaxies.Planet;
import micdoodle8.mods.galacticraft.api.galaxies.Satellite;
import micdoodle8.mods.galacticraft.api.galaxies.SolarSystem;
import micdoodle8.mods.galacticraft.api.galaxies.Star;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.proxy.ClientProxyCore;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector3f;

public class InGameScreen {
    private TextureManager renderEngine;
    private static FloatBuffer colorBuffer = GLAllocation.func_74529_h((int)16);
    private float yPlane;
    private float frameA;
    private float frameBx;
    private float frameBz;
    private float centreX;
    private float centreZ;
    private float scale;
    private float cornerAx;
    private float cornerAz;
    private float cornerBx;
    private float cornerBz;
    private float tickDrawn;
    public boolean initialise;
    public boolean initialiseLast;
    private boolean readyToInitialise;
    private int tileCount;
    private int callCount;

    public InGameScreen(float scaleX, float scaleZ) {
        this.renderEngine = FMLClientHandler.instance().getClient().field_71446_o;
        this.yPlane = 0.91f;
        this.frameA = 0.098f;
        this.cornerAx = 0.0f;
        this.cornerAz = 0.0f;
        this.cornerBx = 1.0f;
        this.cornerBz = 1.0f;
        this.tickDrawn = -1.0f;
        this.initialise = true;
        this.initialiseLast = false;
        this.readyToInitialise = false;
        this.tileCount = 0;
        this.callCount = 0;
        this.centreX = scaleX / 2.0f;
        this.centreZ = scaleZ / 2.0f;
        this.frameBx = scaleX - this.frameA;
        this.frameBz = scaleZ - this.frameA;
        this.scale = Math.max(scaleX, scaleZ) - 0.2f;
        if (scaleX < scaleZ) {
            this.cornerAx = (1.0f - scaleX / scaleZ) / 2.0f;
            this.cornerBx = 1.0f - this.cornerAx;
        } else if (scaleZ < scaleX) {
            this.cornerAz = (1.0f - scaleZ / scaleX) / 2.0f;
            this.cornerBz = 1.0f - this.cornerAz;
        }
    }

    public void drawScreen(int type, float ticks) {
        if (this.initialise) {
            if (!this.initialiseLast) {
                this.tickDrawn = ticks;
                this.readyToInitialise = false;
                this.initialiseLast = true;
                return;
            }
            if (!this.readyToInitialise && ticks == this.tickDrawn) {
                return;
            }
            if (!this.readyToInitialise) {
                this.readyToInitialise = true;
                this.tickDrawn = ticks;
                this.tileCount = 1;
                return;
            }
            if (ticks == this.tickDrawn) {
                ++this.tileCount;
                return;
            }
            this.initialise = false;
            this.initialiseLast = false;
            this.readyToInitialise = false;
        }
        if (++this.callCount < this.tileCount) {
            if (this.callCount == 1 || this.tickDrawn == ticks) {
                this.tickDrawn = ticks;
                return;
            }
            this.initialise = true;
        }
        if (this.callCount == this.tileCount) {
            this.callCount = 0;
            if (this.tileCount > 1 && ticks != this.tickDrawn) {
                this.initialise = true;
            }
        }
        this.tickDrawn = ticks;
        GL11.glPushMatrix();
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        if (type > 0) {
            GL11.glEnable((int)2896);
            GL11.glEnable((int)16384);
            GL11.glDisable((int)16385);
            GL11.glEnable((int)2903);
            GL11.glColorMaterial((int)1032, (int)5634);
            float ambient = 0.2f;
            float diffuse = 1.0f;
            float specular = 0.9f;
            float ambient2 = 0.6f;
            GL11.glLight((int)16384, (int)4611, (FloatBuffer)InGameScreen.setColorBuffer(0.5f, 0.95f, 0.5f, 0.0f));
            GL11.glLight((int)16384, (int)4609, (FloatBuffer)InGameScreen.setColorBuffer(diffuse, diffuse, diffuse, 1.0f));
            GL11.glLight((int)16384, (int)4608, (FloatBuffer)InGameScreen.setColorBuffer(ambient, ambient, ambient, 1.0f));
            GL11.glLight((int)16384, (int)4610, (FloatBuffer)InGameScreen.setColorBuffer(specular, specular, 1.0f, 1.0f));
            GL11.glShadeModel((int)7424);
            GL11.glLightModel((int)2899, (FloatBuffer)InGameScreen.setColorBuffer(ambient2, ambient2, ambient2, 1.0f));
        }
        switch (type) {
            case 0: {
                this.drawBlackBackground(0.09f);
                break;
            }
            case 1: {
                if (ClientProxyCore.overworldTextureClient != null) {
                    GL11.glBindTexture((int)3553, (int)ClientProxyCore.overworldTextureClient.func_110552_b());
                } else {
                    this.renderEngine.func_110577_a(new ResourceLocation(GalacticraftCore.ASSET_PREFIX, "textures/gui/celestialbodies/earth.png"));
                    if (!ClientProxyCore.overworldTextureRequestSent) {
                        GalacticraftCore.packetPipeline.sendToServer(new PacketSimple(PacketSimple.EnumSimplePacket.S_REQUEST_OVERWORLD_IMAGE, new Object[0]));
                        ClientProxyCore.overworldTextureRequestSent = true;
                    }
                }
                this.draw2DTexture();
                break;
            }
            case 2: {
                this.drawBlackBackground(0.0f);
                this.drawCelestialBodies(ticks);
                break;
            }
            case 3: {
                this.drawBlackBackground(0.0f);
                this.drawCelestialBodiesZ(GalacticraftCore.planetOverworld, ticks);
            }
        }
        RenderHelper.func_74519_b();
        GL11.glPopMatrix();
    }

    private static FloatBuffer setColorBuffer(float p_74521_0_, float p_74521_1_, float p_74521_2_, float p_74521_3_) {
        colorBuffer.clear();
        colorBuffer.put(p_74521_0_).put(p_74521_1_).put(p_74521_2_).put(p_74521_3_);
        colorBuffer.flip();
        return colorBuffer;
    }

    private void draw2DTexture() {
        Tessellator tess = Tessellator.field_78398_a;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        tess.func_78370_a(255, 255, 255, 255);
        tess.func_78382_b();
        tess.func_78374_a((double)this.frameA, (double)this.yPlane, (double)this.frameBz, (double)this.cornerAx, (double)this.cornerBz);
        tess.func_78374_a((double)this.frameBx, (double)this.yPlane, (double)this.frameBz, (double)this.cornerBx, (double)this.cornerBz);
        tess.func_78374_a((double)this.frameBx, (double)this.yPlane, (double)this.frameA, (double)this.cornerBx, (double)this.cornerAz);
        tess.func_78374_a((double)this.frameA, (double)this.yPlane, (double)this.frameA, (double)this.cornerAx, (double)this.cornerAz);
        tess.func_78381_a();
    }

    private void drawBlackBackground(float greyLevel) {
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)3553);
        Tessellator tess = Tessellator.field_78398_a;
        GL11.glColor4f((float)greyLevel, (float)greyLevel, (float)greyLevel, (float)1.0f);
        tess.func_78382_b();
        tess.func_78377_a((double)this.frameA, (double)(this.yPlane - 0.005f), (double)this.frameBz);
        tess.func_78377_a((double)this.frameBx, (double)(this.yPlane - 0.005f), (double)this.frameBz);
        tess.func_78377_a((double)this.frameBx, (double)(this.yPlane - 0.005f), (double)this.frameA);
        tess.func_78377_a((double)this.frameA, (double)(this.yPlane - 0.005f), (double)this.frameA);
        tess.func_78381_a();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3553);
    }

    private void drawCelestialBodies(float ticks) {
        for (SolarSystem solarSystem : GalaxyRegistry.getRegisteredSolarSystems().values()) {
            Star star = solarSystem.getMainStar();
            if (star == null || star.getBodyIcon() == null) continue;
            this.drawCelestialBody(star, 0.0f, 0.0f, ticks, 5.5f);
        }
        for (Planet planet : GalaxyRegistry.getRegisteredPlanets().values()) {
            if (planet.getBodyIcon() == null) continue;
            Vector3f pos = this.getCelestialBodyPosition(planet, ticks);
            this.drawCelestialBody(planet, pos.x, pos.y, ticks, 2.8f);
        }
    }

    private void drawCelestialBodiesZ(CelestialBody planet, float ticks) {
        Vector3f pos;
        this.drawCelestialBody(planet, 0.0f, 0.0f, ticks, 11.0f);
        for (Moon moon : GalaxyRegistry.getRegisteredMoons().values()) {
            if (moon.getParentPlanet() != planet || moon.getBodyIcon() == null) continue;
            pos = this.getCelestialBodyPosition(moon, ticks);
            this.drawCelestialBody(moon, pos.x, pos.y, ticks, 3.0f);
        }
        for (Satellite satellite : GalaxyRegistry.getRegisteredSatellites().values()) {
            if (satellite.getParentPlanet() != planet) continue;
            pos = this.getCelestialBodyPosition(satellite, ticks);
            this.drawCelestialBody(satellite, pos.x, pos.y, ticks, 3.0f);
        }
    }

    private void drawTexturedRect(float x, float z, float width, float height) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)x, (double)this.yPlane, (double)(z + height), 0.0, 1.0);
        tessellator.func_78374_a((double)(x + width), (double)this.yPlane, (double)(z + height), 1.0, 1.0);
        tessellator.func_78374_a((double)(x + width), (double)this.yPlane, (double)z, 1.0, 0.0);
        tessellator.func_78374_a((double)x, (double)this.yPlane, (double)z, 0.0, 0.0);
        tessellator.func_78381_a();
    }

    private void drawCelestialBody(CelestialBody planet, float xPos, float zPos, float ticks, float relSize) {
        if (xPos + this.centreX > this.frameBx || xPos + this.centreX < this.frameA) {
            return;
        }
        if (zPos + this.centreZ > this.frameBz || zPos + this.centreZ < this.frameA) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(xPos + this.centreX), (float)0.0f, (float)(zPos + this.centreZ));
        float alpha = 1.0f;
        CelestialBodyRenderEvent.Pre preEvent = new CelestialBodyRenderEvent.Pre(planet, planet.getBodyIcon(), 12);
        MinecraftForge.EVENT_BUS.post((Event)preEvent);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        if (preEvent.celestialBodyTexture != null) {
            this.renderEngine.func_110577_a(preEvent.celestialBodyTexture);
        }
        if (!preEvent.isCanceled()) {
            float size = relSize / 70.0f * this.scale;
            this.drawTexturedRect(-size / 2.0f, -size / 2.0f, size, size);
        }
        CelestialBodyRenderEvent.Post postEvent = new CelestialBodyRenderEvent.Post(planet);
        MinecraftForge.EVENT_BUS.post((Event)postEvent);
        GL11.glPopMatrix();
    }

    private Vector3f getCelestialBodyPosition(CelestialBody cBody, float ticks) {
        float timeScale = cBody instanceof Planet ? 200.0f : 2.0f;
        float distanceFromCenter = this.getScale(cBody) * this.scale;
        return new Vector3f((float)Math.sin(ticks / (timeScale * cBody.getRelativeOrbitTime()) + cBody.getPhaseShift()) * distanceFromCenter, (float)Math.cos(ticks / (timeScale * cBody.getRelativeOrbitTime()) + cBody.getPhaseShift()) * distanceFromCenter, 0.0f);
    }

    private float getScale(CelestialBody celestialBody) {
        return 0.007142857f * celestialBody.getRelativeDistanceFromCenter().unScaledDistance * (celestialBody instanceof Planet ? 25.0f : 3.0f);
    }
}

