/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.entities.player;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import micdoodle8.mods.galacticraft.api.event.oxygen.GCCoreOxygenSuffocationEvent;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntityAutoRocket;
import micdoodle8.mods.galacticraft.api.recipe.ISchematicPage;
import micdoodle8.mods.galacticraft.api.recipe.SchematicRegistry;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.IAtmosphericGas;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.GCBlocks;
import micdoodle8.mods.galacticraft.core.dimension.SpaceRace;
import micdoodle8.mods.galacticraft.core.dimension.SpaceRaceManager;
import micdoodle8.mods.galacticraft.core.dimension.WorldProviderOrbit;
import micdoodle8.mods.galacticraft.core.entities.EntityLanderBase;
import micdoodle8.mods.galacticraft.core.entities.EntityMeteor;
import micdoodle8.mods.galacticraft.core.entities.EntityParachest;
import micdoodle8.mods.galacticraft.core.entities.player.GCEntityPlayerMP;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStatsClient;
import micdoodle8.mods.galacticraft.core.items.GCItems;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.tick.TickHandlerServer;
import micdoodle8.mods.galacticraft.core.tile.TileEntityTelemetry;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.DamageSourceGC;
import micdoodle8.mods.galacticraft.core.util.EnumColor;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.OxygenUtil;
import micdoodle8.mods.galacticraft.core.util.PlayerUtil;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import micdoodle8.mods.galacticraft.core.wrappers.Footprint;
import net.minecraft.block.Block;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.LivingEvent;

public class GCPlayerHandler {
    private static final int OXYGENHEIGHTLIMIT = 450;
    private ConcurrentHashMap<UUID, GCPlayerStats> playerStatsMap = new ConcurrentHashMap();

    public ConcurrentHashMap<UUID, GCPlayerStats> getServerStatList() {
        return this.playerStatsMap;
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            this.onPlayerLogin((EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent
    public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            this.onPlayerLogout((EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            this.onPlayerRespawn((EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent
    public void onEntityConstructing(EntityEvent.EntityConstructing event) {
        if (event.entity instanceof EntityPlayerMP && GCPlayerStats.get((EntityPlayerMP)event.entity) == null) {
            GCPlayerStats.register((EntityPlayerMP)event.entity);
        }
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            this.onEntityConstructingClient(event);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onEntityConstructingClient(EntityEvent.EntityConstructing event) {
        if (event.entity instanceof EntityClientPlayerMP && GCPlayerStatsClient.get((EntityPlayerSP)((EntityClientPlayerMP)event.entity)) == null) {
            GCPlayerStatsClient.register((EntityPlayerSP)((EntityClientPlayerMP)event.entity));
        }
    }

    private void onPlayerLogin(EntityPlayerMP player) {
        GCPlayerStats oldData = this.playerStatsMap.remove(player.getPersistentID());
        if (oldData != null) {
            oldData.saveNBTData(player.getEntityData());
        }
        GCPlayerStats stats = GCPlayerStats.get(player);
        GalacticraftCore.packetPipeline.sendTo(new PacketSimple(PacketSimple.EnumSimplePacket.C_GET_CELESTIAL_BODY_LIST, new Object[0]), player);
    }

    private void onPlayerLogout(EntityPlayerMP player) {
    }

    private void onPlayerRespawn(EntityPlayerMP player) {
        GCPlayerStats oldData = this.playerStatsMap.remove(player.getPersistentID());
        GCPlayerStats stats = GCPlayerStats.get(player);
        if (oldData != null) {
            stats.copyFrom(oldData, false);
        }
        stats.player = new WeakReference<EntityPlayerMP>(player);
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.entityLiving instanceof EntityPlayerMP) {
            this.onPlayerUpdate((EntityPlayerMP)event.entityLiving);
        }
    }

    public static void checkGear(EntityPlayerMP player, GCPlayerStats GCPlayer, boolean forceSend) {
        ThermalArmorEvent armorEvent;
        GCPlayer.maskInSlot = GCPlayer.extendedInventory.func_70301_a(0);
        GCPlayer.gearInSlot = GCPlayer.extendedInventory.func_70301_a(1);
        GCPlayer.tankInSlot1 = GCPlayer.extendedInventory.func_70301_a(2);
        GCPlayer.tankInSlot2 = GCPlayer.extendedInventory.func_70301_a(3);
        GCPlayer.parachuteInSlot = GCPlayer.extendedInventory.func_70301_a(4);
        GCPlayer.frequencyModuleInSlot = GCPlayer.extendedInventory.func_70301_a(5);
        GCPlayer.thermalHelmetInSlot = GCPlayer.extendedInventory.func_70301_a(6);
        GCPlayer.thermalChestplateInSlot = GCPlayer.extendedInventory.func_70301_a(7);
        GCPlayer.thermalLeggingsInSlot = GCPlayer.extendedInventory.func_70301_a(8);
        GCPlayer.thermalBootsInSlot = GCPlayer.extendedInventory.func_70301_a(9);
        if (GCPlayer.frequencyModuleInSlot != GCPlayer.lastFrequencyModuleInSlot || forceSend) {
            if (FMLCommonHandler.instance().getMinecraftServerInstance() != null) {
                if (GCPlayer.frequencyModuleInSlot == null) {
                    GCPlayerHandler.sendGearUpdatePacket(player, EnumModelPacket.REMOVE_FREQUENCY_MODULE);
                    TileEntityTelemetry.frequencyModulePlayer(GCPlayer.lastFrequencyModuleInSlot, null);
                } else if (GCPlayer.frequencyModuleInSlot.func_77973_b() == GCItems.basicItem && GCPlayer.frequencyModuleInSlot.func_77960_j() == 19 && GCPlayer.lastFrequencyModuleInSlot == null) {
                    GCPlayerHandler.sendGearUpdatePacket(player, EnumModelPacket.ADD_FREQUENCY_MODULE);
                    TileEntityTelemetry.frequencyModulePlayer(GCPlayer.frequencyModuleInSlot, player);
                }
            }
            GCPlayer.lastFrequencyModuleInSlot = GCPlayer.frequencyModuleInSlot;
        }
        if (GCPlayer.maskInSlot != GCPlayer.lastMaskInSlot || forceSend) {
            if (GCPlayer.maskInSlot == null) {
                GCPlayerHandler.sendGearUpdatePacket(player, EnumModelPacket.REMOVEMASK);
            } else if (GCPlayer.maskInSlot.func_77973_b() == GCItems.oxMask && (GCPlayer.lastMaskInSlot == null || forceSend)) {
                GCPlayerHandler.sendGearUpdatePacket(player, EnumModelPacket.ADDMASK);
            }
            GCPlayer.lastMaskInSlot = GCPlayer.maskInSlot;
        }
        if (GCPlayer.gearInSlot != GCPlayer.lastGearInSlot || forceSend) {
            if (GCPlayer.gearInSlot == null) {
                GCPlayerHandler.sendGearUpdatePacket(player, EnumModelPacket.REMOVEGEAR);
            } else if (GCPlayer.gearInSlot.func_77973_b() == GCItems.oxygenGear && (GCPlayer.lastGearInSlot == null || forceSend)) {
                GCPlayerHandler.sendGearUpdatePacket(player, EnumModelPacket.ADDGEAR);
            }
            GCPlayer.lastGearInSlot = GCPlayer.gearInSlot;
        }
        if (GCPlayer.tankInSlot1 != GCPlayer.lastTankInSlot1 || forceSend) {
            if (GCPlayer.tankInSlot1 == null) {
                GCPlayerHandler.sendGearUpdatePacket(player, EnumModelPacket.REMOVE_LEFT_TANK);
            } else if (GCPlayer.lastTankInSlot1 == null || forceSend) {
                if (GCPlayer.tankInSlot1.func_77973_b() == GCItems.oxTankLight) {
                    GCPlayerHandler.sendGearUpdatePacket(player, EnumModelPacket.ADDLEFTGREENTANK);
                } else if (GCPlayer.tankInSlot1.func_77973_b() == GCItems.oxTankMedium) {
                    GCPlayerHandler.sendGearUpdatePacket(player, EnumModelPacket.ADDLEFTORANGETANK);
                } else if (GCPlayer.tankInSlot1.func_77973_b() == GCItems.oxTankHeavy) {
                    GCPlayerHandler.sendGearUpdatePacket(player, EnumModelPacket.ADDLEFTREDTANK);
                }
            } else if (GCPlayer.tankInSlot1.func_77973_b() != GCPlayer.lastTankInSlot1.func_77973_b()) {
                if (GCPlayer.tankInSlot1.func_77973_b() == GCItems.oxTankLight) {
                    GCPlayerHandler.sendGearUpdatePacket(player, EnumModelPacket.ADDLEFTGREENTANK);
                } else if (GCPlayer.tankInSlot1.func_77973_b() == GCItems.oxTankMedium) {
                    GCPlayerHandler.sendGearUpdatePacket(player, EnumModelPacket.ADDLEFTORANGETANK);
                } else if (GCPlayer.tankInSlot1.func_77973_b() == GCItems.oxTankHeavy) {
                    GCPlayerHandler.sendGearUpdatePacket(player, EnumModelPacket.ADDLEFTREDTANK);
                }
            }
            GCPlayer.lastTankInSlot1 = GCPlayer.tankInSlot1;
        }
        if (GCPlayer.tankInSlot2 != GCPlayer.lastTankInSlot2 || forceSend) {
            if (GCPlayer.tankInSlot2 == null) {
                GCPlayerHandler.sendGearUpdatePacket(player, EnumModelPacket.REMOVE_RIGHT_TANK);
            } else if (GCPlayer.lastTankInSlot2 == null || forceSend) {
                if (GCPlayer.tankInSlot2.func_77973_b() == GCItems.oxTankLight) {
                    GCPlayerHandler.sendGearUpdatePacket(player, EnumModelPacket.ADDRIGHTGREENTANK);
                } else if (GCPlayer.tankInSlot2.func_77973_b() == GCItems.oxTankMedium) {
                    GCPlayerHandler.sendGearUpdatePacket(player, EnumModelPacket.ADDRIGHTORANGETANK);
                } else if (GCPlayer.tankInSlot2.func_77973_b() == GCItems.oxTankHeavy) {
                    GCPlayerHandler.sendGearUpdatePacket(player, EnumModelPacket.ADDRIGHTREDTANK);
                }
            } else if (GCPlayer.tankInSlot2.func_77973_b() != GCPlayer.lastTankInSlot2.func_77973_b()) {
                if (GCPlayer.tankInSlot2.func_77973_b() == GCItems.oxTankLight) {
                    GCPlayerHandler.sendGearUpdatePacket(player, EnumModelPacket.ADDRIGHTGREENTANK);
                } else if (GCPlayer.tankInSlot2.func_77973_b() == GCItems.oxTankMedium) {
                    GCPlayerHandler.sendGearUpdatePacket(player, EnumModelPacket.ADDRIGHTORANGETANK);
                } else if (GCPlayer.tankInSlot2.func_77973_b() == GCItems.oxTankHeavy) {
                    GCPlayerHandler.sendGearUpdatePacket(player, EnumModelPacket.ADDRIGHTREDTANK);
                }
            }
            GCPlayer.lastTankInSlot2 = GCPlayer.tankInSlot2;
        }
        if (GCPlayer.parachuteInSlot != GCPlayer.lastParachuteInSlot || forceSend) {
            if (GCPlayer.parachuteInSlot == null) {
                if (GCPlayer.usingParachute) {
                    GCPlayerHandler.sendGearUpdatePacket(player, EnumModelPacket.REMOVE_PARACHUTE);
                }
            } else if (GCPlayer.lastParachuteInSlot == null || forceSend) {
                if (GCPlayer.usingParachute) {
                    GCPlayerHandler.sendGearUpdatePacket(player, EnumModelPacket.ADD_PARACHUTE, GCPlayer.parachuteInSlot.func_77960_j());
                }
            } else if (GCPlayer.parachuteInSlot.func_77960_j() != GCPlayer.lastParachuteInSlot.func_77960_j()) {
                GCPlayerHandler.sendGearUpdatePacket(player, EnumModelPacket.ADD_PARACHUTE, GCPlayer.parachuteInSlot.func_77960_j());
            }
            GCPlayer.lastParachuteInSlot = GCPlayer.parachuteInSlot;
        }
        if (GCPlayer.thermalHelmetInSlot != GCPlayer.lastThermalHelmetInSlot || forceSend) {
            armorEvent = new ThermalArmorEvent(0, GCPlayer.thermalHelmetInSlot);
            MinecraftForge.EVENT_BUS.post((Event)armorEvent);
            if (armorEvent.armorResult != ThermalArmorEvent.ArmorAddResult.NOTHING) {
                if (GCPlayer.thermalHelmetInSlot == null || armorEvent.armorResult == ThermalArmorEvent.ArmorAddResult.REMOVE) {
                    GCPlayerHandler.sendGearUpdatePacket(player, EnumModelPacket.REMOVE_THERMAL_HELMET);
                } else if (armorEvent.armorResult == ThermalArmorEvent.ArmorAddResult.ADD && (GCPlayer.lastThermalHelmetInSlot == null || forceSend)) {
                    GCPlayerHandler.sendGearUpdatePacket(player, EnumModelPacket.ADD_THERMAL_HELMET);
                }
            }
            GCPlayer.lastThermalHelmetInSlot = GCPlayer.thermalHelmetInSlot;
        }
        if (GCPlayer.thermalChestplateInSlot != GCPlayer.lastThermalChestplateInSlot || forceSend) {
            armorEvent = new ThermalArmorEvent(1, GCPlayer.thermalChestplateInSlot);
            MinecraftForge.EVENT_BUS.post((Event)armorEvent);
            if (armorEvent.armorResult != ThermalArmorEvent.ArmorAddResult.NOTHING) {
                if (GCPlayer.thermalChestplateInSlot == null || armorEvent.armorResult == ThermalArmorEvent.ArmorAddResult.REMOVE) {
                    GCPlayerHandler.sendGearUpdatePacket(player, EnumModelPacket.REMOVE_THERMAL_CHESTPLATE);
                } else if (armorEvent.armorResult == ThermalArmorEvent.ArmorAddResult.ADD && (GCPlayer.lastThermalChestplateInSlot == null || forceSend)) {
                    GCPlayerHandler.sendGearUpdatePacket(player, EnumModelPacket.ADD_THERMAL_CHESTPLATE);
                }
            }
            GCPlayer.lastThermalChestplateInSlot = GCPlayer.thermalChestplateInSlot;
        }
        if (GCPlayer.thermalLeggingsInSlot != GCPlayer.lastThermalLeggingsInSlot || forceSend) {
            armorEvent = new ThermalArmorEvent(2, GCPlayer.thermalLeggingsInSlot);
            MinecraftForge.EVENT_BUS.post((Event)armorEvent);
            if (armorEvent.armorResult != ThermalArmorEvent.ArmorAddResult.NOTHING) {
                if (GCPlayer.thermalLeggingsInSlot == null || armorEvent.armorResult == ThermalArmorEvent.ArmorAddResult.REMOVE) {
                    GCPlayerHandler.sendGearUpdatePacket(player, EnumModelPacket.REMOVE_THERMAL_LEGGINGS);
                } else if (armorEvent.armorResult == ThermalArmorEvent.ArmorAddResult.ADD && (GCPlayer.lastThermalLeggingsInSlot == null || forceSend)) {
                    GCPlayerHandler.sendGearUpdatePacket(player, EnumModelPacket.ADD_THERMAL_LEGGINGS);
                }
            }
            GCPlayer.lastThermalLeggingsInSlot = GCPlayer.thermalLeggingsInSlot;
        }
        if (GCPlayer.thermalBootsInSlot != GCPlayer.lastThermalBootsInSlot || forceSend) {
            armorEvent = new ThermalArmorEvent(3, GCPlayer.thermalBootsInSlot);
            MinecraftForge.EVENT_BUS.post((Event)armorEvent);
            if (armorEvent.armorResult != ThermalArmorEvent.ArmorAddResult.NOTHING) {
                if (GCPlayer.thermalBootsInSlot == null || armorEvent.armorResult == ThermalArmorEvent.ArmorAddResult.REMOVE) {
                    GCPlayerHandler.sendGearUpdatePacket(player, EnumModelPacket.REMOVE_THERMAL_BOOTS);
                } else if (armorEvent.armorResult == ThermalArmorEvent.ArmorAddResult.ADD && (GCPlayer.lastThermalBootsInSlot == null || forceSend)) {
                    GCPlayerHandler.sendGearUpdatePacket(player, EnumModelPacket.ADD_THERMAL_BOOTS);
                }
            }
            GCPlayer.lastThermalBootsInSlot = GCPlayer.thermalBootsInSlot;
        }
    }

    protected void checkThermalStatus(EntityPlayerMP player, GCPlayerStats playerStats) {
        IGalacticraftWorldProvider provider;
        float thermalLevelMod;
        ItemStack thermalPaddingHelm = playerStats.extendedInventory.func_70301_a(6);
        ItemStack thermalPaddingChestplate = playerStats.extendedInventory.func_70301_a(7);
        ItemStack thermalPaddingLeggings = playerStats.extendedInventory.func_70301_a(8);
        ItemStack thermalPaddingBoots = playerStats.extendedInventory.func_70301_a(9);
        if (player.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider && !player.field_71075_bZ.field_75098_d && (thermalLevelMod = (provider = (IGalacticraftWorldProvider)player.field_70170_p.field_73011_w).getThermalLevelModifier()) != 0.0f) {
            int thermalLevelCooldownBase;
            int thermalLevelTickCooldown = thermalLevelCooldownBase = (int)Math.floor(1.0f / (thermalLevelMod * (float)(thermalLevelMod > 0.0f ? 1 : -1)) * 200.0f);
            if (GalacticraftCore.isPlanetsLoaded) {
                if (thermalPaddingHelm != null && thermalPaddingChestplate != null && thermalPaddingLeggings != null && thermalPaddingBoots != null) {
                    int last = playerStats.thermalLevel;
                    if (playerStats.thermalLevel < 0) {
                        ++playerStats.thermalLevel;
                    } else if (playerStats.thermalLevel > 0) {
                        --playerStats.thermalLevel;
                    }
                    if (playerStats.thermalLevel != last) {
                        this.sendThermalLevelPacket(player, playerStats);
                    }
                    return;
                }
                if (thermalPaddingHelm != null) {
                    thermalLevelTickCooldown += thermalLevelCooldownBase;
                }
                if (thermalPaddingChestplate != null) {
                    thermalLevelTickCooldown += thermalLevelCooldownBase;
                }
                if (thermalPaddingLeggings != null) {
                    thermalLevelTickCooldown += thermalLevelCooldownBase;
                }
                if (thermalPaddingBoots != null) {
                    thermalLevelTickCooldown += thermalLevelCooldownBase;
                }
            }
            if ((player.field_70173_aa - 1) % thermalLevelTickCooldown == 0) {
                int last = playerStats.thermalLevel;
                playerStats.thermalLevel = (int)Math.min(Math.max((float)playerStats.thermalLevel + thermalLevelMod, -22.0f), 22.0f);
                if (playerStats.thermalLevel != last) {
                    this.sendThermalLevelPacket(player, playerStats);
                }
                if (Math.abs(playerStats.thermalLevel) >= 22) {
                    player.func_70097_a((DamageSource)DamageSourceGC.thermal, 1.5f);
                }
            }
            if (playerStats.thermalLevel < -15) {
                player.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 5, 2, true));
            }
            if (playerStats.thermalLevel > 15) {
                player.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, 5, 2, true));
            }
        }
    }

    protected void checkOxygen(EntityPlayerMP player, GCPlayerStats playerStats) {
        ItemStack tankInSlot = playerStats.extendedInventory.func_70301_a(2);
        ItemStack tankInSlot2 = playerStats.extendedInventory.func_70301_a(3);
        int drainSpacing = OxygenUtil.getDrainSpacing(tankInSlot, tankInSlot2);
        if (!(player.field_71093_bK != 0 && !(player.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider) || (player.field_71093_bK == 0 || ((IGalacticraftWorldProvider)player.field_70170_p.field_73011_w).hasBreathableAtmosphere()) && !(player.field_70163_u > 450.0) || player.field_71075_bZ.field_75098_d || player.field_70154_o instanceof EntityLanderBase || player.field_70154_o instanceof EntityAutoRocket)) {
            boolean airEmpty;
            if (tankInSlot == null) {
                playerStats.airRemaining = 0;
            }
            if (tankInSlot2 == null) {
                playerStats.airRemaining2 = 0;
            }
            if (drainSpacing > 0) {
                if ((player.field_70173_aa - 1) % drainSpacing == 0 && !OxygenUtil.isAABBInBreathableAirBlock((EntityLivingBase)player) && !playerStats.usingPlanetSelectionGui) {
                    if (tankInSlot != null && tankInSlot.func_77958_k() - tankInSlot.func_77960_j() > 0) {
                        tankInSlot.func_77972_a(1, (EntityLivingBase)player);
                    }
                    if (tankInSlot2 != null && tankInSlot2.func_77958_k() - tankInSlot2.func_77960_j() > 0) {
                        tankInSlot2.func_77972_a(1, (EntityLivingBase)player);
                    }
                }
                if (tankInSlot != null) {
                    playerStats.airRemaining = tankInSlot.func_77958_k() - tankInSlot.func_77960_j();
                }
                if (tankInSlot2 != null) {
                    playerStats.airRemaining2 = tankInSlot2.func_77958_k() - tankInSlot2.func_77960_j();
                }
            } else if ((player.field_70173_aa - 1) % 60 == 0) {
                if (OxygenUtil.isAABBInBreathableAirBlock((EntityLivingBase)player)) {
                    if (playerStats.airRemaining < 90 && tankInSlot != null) {
                        playerStats.airRemaining = Math.min(playerStats.airRemaining + 1, tankInSlot.func_77958_k() - tankInSlot.func_77960_j());
                    }
                    if (playerStats.airRemaining2 < 90 && tankInSlot2 != null) {
                        playerStats.airRemaining2 = Math.min(playerStats.airRemaining2 + 1, tankInSlot2.func_77958_k() - tankInSlot2.func_77960_j());
                    }
                } else {
                    if (playerStats.airRemaining > 0) {
                        playerStats.airRemaining = Math.max(playerStats.airRemaining - 1, 0);
                    }
                    if (playerStats.airRemaining2 > 0) {
                        playerStats.airRemaining2 = Math.max(playerStats.airRemaining2 - 1, 0);
                    }
                }
            }
            boolean bl = airEmpty = playerStats.airRemaining <= 0 && playerStats.airRemaining2 <= 0;
            if (player.func_70617_f_()) {
                playerStats.oxygenSetupValid = playerStats.lastOxygenSetupValid;
            } else {
                boolean bl2 = playerStats.oxygenSetupValid = OxygenUtil.hasValidOxygenSetup(player) && !airEmpty || OxygenUtil.isAABBInBreathableAirBlock((EntityLivingBase)player);
            }
            if (!playerStats.oxygenSetupValid && !player.field_70170_p.field_72995_K && player.func_70089_S() && playerStats.damageCounter == 0) {
                playerStats.damageCounter = ConfigManagerCore.suffocationCooldown;
                GCCoreOxygenSuffocationEvent.Pre suffocationEvent = new GCCoreOxygenSuffocationEvent.Pre((EntityLivingBase)player);
                MinecraftForge.EVENT_BUS.post((Event)suffocationEvent);
                if (!suffocationEvent.isCanceled()) {
                    player.func_70097_a((DamageSource)DamageSourceGC.oxygenSuffocation, (float)ConfigManagerCore.suffocationDamage);
                    GCCoreOxygenSuffocationEvent.Post suffocationEventPost = new GCCoreOxygenSuffocationEvent.Post((EntityLivingBase)player);
                    MinecraftForge.EVENT_BUS.post((Event)suffocationEventPost);
                }
            }
        } else if ((player.field_70173_aa - 1) % 20 == 0 && !player.field_71075_bZ.field_75098_d && playerStats.airRemaining < 90) {
            ++playerStats.airRemaining;
            ++playerStats.airRemaining2;
        } else if (player.field_71075_bZ.field_75098_d) {
            playerStats.airRemaining = 90;
            playerStats.airRemaining2 = 90;
        } else {
            playerStats.oxygenSetupValid = true;
        }
    }

    protected void throwMeteors(EntityPlayerMP player) {
        World world = player.field_70170_p;
        if (world.field_73011_w instanceof IGalacticraftWorldProvider && FMLCommonHandler.instance().getEffectiveSide() != Side.CLIENT && ((IGalacticraftWorldProvider)world.field_73011_w).getMeteorFrequency() > 0.0) {
            EntityMeteor meteor;
            double motZ;
            double motX;
            int z;
            int y;
            int x;
            EntityPlayer closestPlayer;
            int f = (int)(((IGalacticraftWorldProvider)world.field_73011_w).getMeteorFrequency() * 1000.0);
            if (world.field_73012_v.nextInt(f) == 0 && ((closestPlayer = world.func_72890_a((Entity)player, 100.0)) == null || closestPlayer.func_145782_y() <= player.func_145782_y())) {
                x = world.field_73012_v.nextInt(20) - 10;
                y = world.field_73012_v.nextInt(20) + 200;
                z = world.field_73012_v.nextInt(20) - 10;
                motX = world.field_73012_v.nextDouble() * 5.0;
                motZ = world.field_73012_v.nextDouble() * 5.0;
                meteor = new EntityMeteor(world, player.field_70165_t + (double)x, player.field_70163_u + (double)y, player.field_70161_v + (double)z, motX - 2.5, 0.0, motZ - 2.5, 1);
                if (!world.field_72995_K) {
                    world.func_72838_d((Entity)meteor);
                }
            }
            if (world.field_73012_v.nextInt(f * 3) == 0 && ((closestPlayer = world.func_72890_a((Entity)player, 100.0)) == null || closestPlayer.func_145782_y() <= player.func_145782_y())) {
                x = world.field_73012_v.nextInt(20) - 10;
                y = world.field_73012_v.nextInt(20) + 200;
                z = world.field_73012_v.nextInt(20) - 10;
                motX = world.field_73012_v.nextDouble() * 5.0;
                motZ = world.field_73012_v.nextDouble() * 5.0;
                meteor = new EntityMeteor(world, player.field_70165_t + (double)x, player.field_70163_u + (double)y, player.field_70161_v + (double)z, motX - 2.5, 0.0, motZ - 2.5, 6);
                if (!world.field_72995_K) {
                    world.func_72838_d((Entity)meteor);
                }
            }
        }
    }

    protected void checkCurrentItem(EntityPlayerMP player) {
        boolean noAtmosphericCombustion;
        ItemStack theCurrentItem = player.field_71071_by.func_70448_g();
        boolean bl = noAtmosphericCombustion = player.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider && (!((IGalacticraftWorldProvider)player.field_70170_p.field_73011_w).isGasPresent(IAtmosphericGas.OXYGEN) || ((IGalacticraftWorldProvider)player.field_70170_p.field_73011_w).isGasPresent(IAtmosphericGas.CO2));
        if (noAtmosphericCombustion && theCurrentItem != null) {
            int var1 = theCurrentItem.field_77994_a;
            int var2 = theCurrentItem.func_77960_j();
            if (player.field_71071_by.func_70448_g().func_77973_b() == Item.func_150898_a((Block)Blocks.field_150478_aa)) {
                ItemStack stack;
                player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = stack = new ItemStack(GCBlocks.unlitTorch, var1, 0);
            }
        } else if (!noAtmosphericCombustion && theCurrentItem != null) {
            int var1 = theCurrentItem.field_77994_a;
            int var2 = theCurrentItem.func_77960_j();
            if (player.field_71071_by.func_70448_g().func_77973_b() == Item.func_150898_a((Block)GCBlocks.unlitTorch)) {
                ItemStack stack;
                player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = stack = new ItemStack(Blocks.field_150478_aa, var1, 0);
            }
        }
    }

    public static void setUsingParachute(EntityPlayerMP player, GCPlayerStats playerStats, boolean tf) {
        playerStats.usingParachute = tf;
        if (tf) {
            int subtype = -1;
            if (playerStats.parachuteInSlot != null) {
                subtype = playerStats.parachuteInSlot.func_77960_j();
            }
            GCPlayerHandler.sendGearUpdatePacket(player, EnumModelPacket.ADD_PARACHUTE, subtype);
        } else {
            GCPlayerHandler.sendGearUpdatePacket(player, EnumModelPacket.REMOVE_PARACHUTE);
        }
    }

    protected static void updateFeet(EntityPlayerMP player, double motionX, double motionZ) {
        int iPosZ;
        int iPosY;
        int iPosX;
        double motionSqrd = motionX * motionX + motionZ * motionZ;
        if (motionSqrd > 0.001 && !player.field_71075_bZ.field_75100_b && player.field_70170_p.func_147439_a(iPosX = MathHelper.func_76128_c((double)player.field_70165_t), iPosY = MathHelper.func_76128_c((double)player.field_70163_u) - 1, iPosZ = MathHelper.func_76128_c((double)player.field_70161_v)) == GCBlocks.blockMoon && player.field_70170_p.func_72805_g(iPosX, iPosY, iPosZ) == 5) {
            GCPlayerStats playerStats = GCEntityPlayerMP.getPlayerStats(player);
            if (playerStats.distanceSinceLastStep > 0.35) {
                Vector3 pos = new Vector3((Entity)player);
                pos.y = (float)MathHelper.func_76128_c((double)(player.field_70163_u - 1.0)) + player.field_70170_p.field_73012_v.nextFloat() / 100.0f;
                switch (playerStats.lastStep) {
                    case 0: {
                        float a = (-player.field_70177_z + 90.0f) / 57.29578f;
                        pos.translate(new Vector3(MathHelper.func_76126_a((float)a) * 0.25f, 0.0, MathHelper.func_76134_b((float)a) * 0.25f));
                        break;
                    }
                    case 1: {
                        float a = (-player.field_70177_z - 90.0f) / 57.29578f;
                        pos.translate(new Vector3((double)MathHelper.func_76126_a((float)a) * 0.25, 0.0, (double)MathHelper.func_76134_b((float)a) * 0.25));
                    }
                }
                float rotation = player.field_70177_z - 180.0f;
                pos = WorldUtil.getFootprintPosition(player.field_70170_p, rotation, pos, new BlockVec3((Entity)player));
                long chunkKey = ChunkCoordIntPair.func_77272_a((int)(pos.intX() >> 4), (int)(pos.intZ() >> 4));
                TickHandlerServer.addFootprint(chunkKey, new Footprint(player.field_70170_p.field_73011_w.field_76574_g, pos, rotation), player.field_70170_p.field_73011_w.field_76574_g);
                ++playerStats.lastStep;
                playerStats.lastStep %= 2;
                playerStats.distanceSinceLastStep = 0.0;
            } else {
                playerStats.distanceSinceLastStep += motionSqrd;
            }
        }
    }

    protected void updateSchematics(EntityPlayerMP player, GCPlayerStats playerStats) {
        SchematicRegistry.addUnlockedPage(player, SchematicRegistry.getMatchingRecipeForID(0));
        SchematicRegistry.addUnlockedPage(player, SchematicRegistry.getMatchingRecipeForID(Integer.MAX_VALUE));
        Collections.sort(playerStats.unlockedSchematics);
        if (player.field_71135_a != null && (playerStats.unlockedSchematics.size() != playerStats.lastUnlockedSchematics.size() || (player.field_70173_aa - 1) % 100 == 0)) {
            Integer[] iArray = new Integer[playerStats.unlockedSchematics.size()];
            for (int i = 0; i < iArray.length; ++i) {
                ISchematicPage page = playerStats.unlockedSchematics.get(i);
                iArray[i] = page == null ? -2 : page.getPageID();
            }
            ArrayList<Object> objList = new ArrayList<Object>();
            objList.add(iArray);
            GalacticraftCore.packetPipeline.sendTo(new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_SCHEMATIC_LIST, objList), player);
        }
    }

    protected void sendPlanetList(EntityPlayerMP player, GCPlayerStats playerStats) {
        HashMap<String, Integer> map = WorldUtil.getArrayOfPossibleDimensions(WorldUtil.getPossibleDimensionsForSpaceshipTier(playerStats.spaceshipTier), player);
        String temp = "";
        int count = 0;
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            temp = temp.concat(entry.getKey() + (count < map.entrySet().size() - 1 ? "?" : ""));
            ++count;
        }
        if (!temp.equals(playerStats.savedPlanetList) || player.field_70173_aa % 5 == 0) {
            GalacticraftCore.packetPipeline.sendTo(new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_DIMENSION_LIST, new Object[]{player.func_146103_bH().getName(), temp}), player);
            playerStats.savedPlanetList = new String(temp);
        }
    }

    protected void sendAirRemainingPacket(EntityPlayerMP player, GCPlayerStats playerStats) {
        float f1 = Float.valueOf(playerStats.tankInSlot1 == null ? 0.0f : (float)playerStats.tankInSlot1.func_77958_k() / 90.0f).floatValue();
        float f2 = Float.valueOf(playerStats.tankInSlot2 == null ? 0.0f : (float)playerStats.tankInSlot2.func_77958_k() / 90.0f).floatValue();
        GalacticraftCore.packetPipeline.sendTo(new PacketSimple(PacketSimple.EnumSimplePacket.C_AIR_REMAINING, new Object[]{MathHelper.func_76141_d((float)((float)playerStats.airRemaining / f1)), MathHelper.func_76141_d((float)((float)playerStats.airRemaining2 / f2)), player.func_146103_bH().getName()}), player);
    }

    protected void sendThermalLevelPacket(EntityPlayerMP player, GCPlayerStats playerStats) {
        GalacticraftCore.packetPipeline.sendTo(new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_THERMAL_LEVEL, new Object[]{playerStats.thermalLevel}), player);
    }

    public static void sendGearUpdatePacket(EntityPlayerMP player, EnumModelPacket gearType) {
        MinecraftServer theServer = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (theServer != null && PlayerUtil.getPlayerForUsernameVanilla(theServer, player.func_146103_bH().getName()) != null) {
            GalacticraftCore.packetPipeline.sendToAllAround(new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_GEAR_SLOT, new Object[]{player.func_146103_bH().getName(), gearType.ordinal(), -1}), new NetworkRegistry.TargetPoint(player.field_70170_p.field_73011_w.field_76574_g, player.field_70165_t, player.field_70163_u, player.field_70161_v, 50.0));
        }
    }

    public static void sendGearUpdatePacket(EntityPlayerMP player, EnumModelPacket gearType, int subtype) {
        MinecraftServer theServer = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (theServer != null && PlayerUtil.getPlayerForUsernameVanilla(theServer, player.func_146103_bH().getName()) != null) {
            GalacticraftCore.packetPipeline.sendToAllAround(new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_GEAR_SLOT, new Object[]{player.func_146103_bH().getName(), gearType.ordinal(), subtype}), new NetworkRegistry.TargetPoint(player.field_70170_p.field_73011_w.field_76574_g, player.field_70165_t, player.field_70163_u, player.field_70161_v, 50.0));
        }
    }

    private void onPlayerUpdate(EntityPlayerMP player) {
        int tick = player.field_70173_aa - 1;
        if (tick == 25 && !GCEntityPlayerMP.getPlayerStats((EntityPlayerMP)player).openedSpaceRaceManager) {
            SpaceRace race = SpaceRaceManager.getSpaceRaceFromPlayer(player.func_146103_bH().getName());
            if (race == null || race.getTeamName().equals(SpaceRace.DEFAULT_NAME)) {
                GalacticraftCore.packetPipeline.sendTo(new PacketSimple(PacketSimple.EnumSimplePacket.C_OPEN_SPACE_RACE_GUI, new Object[0]), player);
            }
            GCEntityPlayerMP.getPlayerStats((EntityPlayerMP)player).openedSpaceRaceManager = true;
        }
        GCPlayerStats GCPlayer = GCPlayerStats.get(player);
        boolean isInGCDimension = player.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider;
        if (GCPlayer.cryogenicChamberCooldown > 0) {
            --GCPlayer.cryogenicChamberCooldown;
        }
        if (!player.field_70122_E && GCPlayer.lastOnGround) {
            GCPlayer.touchedGround = true;
        }
        if (GCPlayer.teleportCooldown > 0) {
            --GCPlayer.teleportCooldown;
        }
        if (GCPlayer.chatCooldown > 0) {
            --GCPlayer.chatCooldown;
        }
        if (GCPlayer.openPlanetSelectionGuiCooldown > 0) {
            --GCPlayer.openPlanetSelectionGuiCooldown;
            if (GCPlayer.openPlanetSelectionGuiCooldown == 1 && !GCPlayer.hasOpenedPlanetSelectionGui) {
                WorldUtil.toCelestialSelection(player, GCPlayer, GCPlayer.spaceshipTier);
                GCPlayer.hasOpenedPlanetSelectionGui = true;
            }
        }
        if (GCPlayer.usingParachute) {
            if (GCPlayer.lastParachuteInSlot != null) {
                player.field_70143_R = 0.0f;
            }
            if (player.field_70122_E) {
                GCPlayerHandler.setUsingParachute(player, GCPlayer, false);
            }
        }
        this.checkCurrentItem(player);
        if (GCPlayer.usingPlanetSelectionGui) {
            this.sendPlanetList(player, GCPlayer);
        }
        if (GCPlayer.damageCounter > 0) {
            --GCPlayer.damageCounter;
        }
        if (isInGCDimension) {
            if (tick % 30 == 0) {
                this.sendAirRemainingPacket(player, GCPlayer);
                this.sendThermalLevelPacket(player, GCPlayer);
            }
            if (player.field_70154_o instanceof EntityLanderBase) {
                GCPlayer.inLander = true;
                GCPlayer.justLanded = false;
            } else {
                if (GCPlayer.inLander) {
                    GCPlayer.justLanded = true;
                }
                GCPlayer.inLander = false;
            }
            if (player.field_70122_E && GCPlayer.justLanded) {
                GCPlayer.justLanded = false;
                if (player.getBedLocation(player.field_70170_p.field_73011_w.field_76574_g) == null) {
                    int i = 30000000;
                    int j = Math.min(i, Math.max(-i, MathHelper.func_76128_c((double)(player.field_70165_t + 0.5))));
                    int k = Math.min(256, Math.max(0, MathHelper.func_76128_c((double)(player.field_70163_u + 1.5))));
                    int l = Math.min(i, Math.max(-i, MathHelper.func_76128_c((double)(player.field_70161_v + 0.5))));
                    ChunkCoordinates coords = new ChunkCoordinates(j, k, l);
                    player.setSpawnChunk(coords, true, player.field_70170_p.field_73011_w.field_76574_g);
                }
                GalacticraftCore.packetPipeline.sendTo(new PacketSimple(PacketSimple.EnumSimplePacket.C_RESET_THIRD_PERSON, new Object[0]), player);
            }
            if (player.field_70170_p.field_73011_w instanceof WorldProviderOrbit) {
                player.field_70143_R = 0.0f;
                if (GCPlayer.newInOrbit) {
                    ((WorldProviderOrbit)player.field_70170_p.field_73011_w).sendPacketsToClient(player);
                    GCPlayer.newInOrbit = false;
                }
            } else {
                GCPlayer.newInOrbit = true;
            }
        } else {
            GCPlayer.newInOrbit = true;
        }
        GCPlayerHandler.checkGear(player, GCPlayer, false);
        if (GCPlayer.chestSpawnCooldown > 0) {
            --GCPlayer.chestSpawnCooldown;
            if (GCPlayer.chestSpawnCooldown == 180 && GCPlayer.chestSpawnVector != null) {
                EntityParachest chest = new EntityParachest(player.field_70170_p, GCPlayer.rocketStacks, GCPlayer.fuelLevel);
                chest.func_70107_b(GCPlayer.chestSpawnVector.x, GCPlayer.chestSpawnVector.y, GCPlayer.chestSpawnVector.z);
                if (!player.field_70170_p.field_72995_K) {
                    player.field_70170_p.func_72838_d((Entity)chest);
                }
            }
        }
        if (GCPlayer.launchAttempts > 0 && player.field_70154_o == null) {
            GCPlayer.launchAttempts = 0;
        }
        this.checkThermalStatus(player, GCPlayer);
        this.checkOxygen(player, GCPlayer);
        if (isInGCDimension && (GCPlayer.oxygenSetupValid != GCPlayer.lastOxygenSetupValid || tick % 100 == 0)) {
            GalacticraftCore.packetPipeline.sendTo(new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_OXYGEN_VALIDITY, new Object[]{GCPlayer.oxygenSetupValid}), player);
        }
        this.throwMeteors(player);
        this.updateSchematics(player, GCPlayer);
        if (tick % 250 == 0 && GCPlayer.frequencyModuleInSlot == null && !GCPlayer.receivedSoundWarning && isInGCDimension && player.field_70122_E && tick > 0) {
            player.func_145747_a((IChatComponent)new ChatComponentText((Object)((Object)EnumColor.YELLOW) + GCCoreUtil.translate("gui.frequencymodule.warning0") + " " + (Object)((Object)EnumColor.AQUA) + GCItems.basicItem.func_77653_i(new ItemStack(GCItems.basicItem, 1, 19)) + (Object)((Object)EnumColor.YELLOW) + " " + GCCoreUtil.translate("gui.frequencymodule.warning1")));
            GCPlayer.receivedSoundWarning = true;
        }
        GCPlayer.lastOxygenSetupValid = GCPlayer.oxygenSetupValid;
        GCPlayer.lastUnlockedSchematics = GCPlayer.unlockedSchematics;
        GCPlayer.lastOnGround = player.field_70122_E;
    }

    public static enum EnumModelPacket {
        ADDMASK,
        REMOVEMASK,
        ADDGEAR,
        REMOVEGEAR,
        ADDLEFTREDTANK,
        ADDLEFTORANGETANK,
        ADDLEFTGREENTANK,
        REMOVE_LEFT_TANK,
        ADDRIGHTREDTANK,
        ADDRIGHTORANGETANK,
        ADDRIGHTGREENTANK,
        REMOVE_RIGHT_TANK,
        ADD_PARACHUTE,
        REMOVE_PARACHUTE,
        ADD_FREQUENCY_MODULE,
        REMOVE_FREQUENCY_MODULE,
        ADD_THERMAL_HELMET,
        ADD_THERMAL_CHESTPLATE,
        ADD_THERMAL_LEGGINGS,
        ADD_THERMAL_BOOTS,
        REMOVE_THERMAL_HELMET,
        REMOVE_THERMAL_CHESTPLATE,
        REMOVE_THERMAL_LEGGINGS,
        REMOVE_THERMAL_BOOTS;

    }

    public static class ThermalArmorEvent
    extends Event {
        public ArmorAddResult armorResult = ArmorAddResult.NOTHING;
        public final int armorIndex;
        public final ItemStack armorStack;

        public ThermalArmorEvent(int armorIndex, ItemStack armorStack) {
            this.armorIndex = armorIndex;
            this.armorStack = armorStack;
        }

        public void setArmorAddResult(ArmorAddResult result) {
            this.armorResult = result;
        }

        public static enum ArmorAddResult {
            ADD,
            REMOVE,
            NOTHING;

        }
    }
}

