/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.entities.player;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.eventhandler.Event;
import micdoodle8.mods.galacticraft.api.entity.ICameraZoomEntity;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.GCBlocks;
import micdoodle8.mods.galacticraft.core.dimension.WorldProviderMoon;
import micdoodle8.mods.galacticraft.core.dimension.WorldProviderOrbit;
import micdoodle8.mods.galacticraft.core.entities.EntityLanderBase;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStatsClient;
import micdoodle8.mods.galacticraft.core.entities.player.IPlayerClient;
import micdoodle8.mods.galacticraft.core.event.EventWakePlayer;
import micdoodle8.mods.galacticraft.core.proxy.ClientProxyCore;
import micdoodle8.mods.galacticraft.core.tick.TickHandlerClient;
import micdoodle8.mods.galacticraft.core.tile.TileEntityAdvanced;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import micdoodle8.mods.galacticraft.core.wrappers.PlayerGearData;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraftforge.common.MinecraftForge;

public class PlayerClient
implements IPlayerClient {
    @Override
    public void moveEntity(EntityPlayerSP player, double par1, double par3, double par5) {
        this.updateFeet(player, par1, par5);
    }

    @Override
    public boolean wakeUpPlayer(EntityPlayerSP player, boolean par1, boolean par2, boolean par3) {
        return this.wakeUpPlayer(player, par1, par2, par3, false);
    }

    @Override
    public void onUpdate(EntityPlayerSP player) {
        GCPlayerStatsClient stats = GCPlayerStatsClient.get(player);
        ++stats.tick;
        if (stats.usingParachute && !player.field_71075_bZ.field_75100_b && !player.func_70072_I()) {
            player.field_70181_x = -0.5;
            player.field_70159_w *= 0.5;
            player.field_70179_y *= 0.5;
        }
    }

    @Override
    public boolean isEntityInsideOpaqueBlock(EntityPlayerSP player, boolean vanillaInside) {
        return !(player.field_70154_o instanceof EntityLanderBase) && vanillaInside;
    }

    @Override
    public void onLivingUpdatePre(EntityPlayerSP player) {
        GCPlayerStatsClient stats = GCPlayerStatsClient.get(player);
        if (player.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider) {
            double blockYmax;
            int zz;
            boolean freefall = true;
            int playerFeetOnY = (int)(player.field_70121_D.field_72338_b - 0.001);
            int xx = MathHelper.func_76128_c((double)player.field_70165_t);
            Block b = player.field_70170_p.func_147439_a(xx, playerFeetOnY, zz = MathHelper.func_76128_c((double)player.field_70161_v));
            if (b.func_149688_o() != Material.field_151579_a && !(b instanceof BlockLiquid) && player.field_70121_D.field_72338_b - (blockYmax = (double)playerFeetOnY + b.func_149669_A()) < 0.001 && player.field_70121_D.field_72338_b - blockYmax > -0.5) {
                AxisAlignedBB collisionBox;
                player.field_70122_E = true;
                if (b.func_149678_a(player.field_70170_p.func_72805_g(xx, playerFeetOnY, zz), false) && (collisionBox = b.func_149668_a(player.field_70170_p, xx, playerFeetOnY, zz)) != null && collisionBox.func_72326_a(player.field_70121_D)) {
                    player.field_70163_u -= player.field_70121_D.field_72338_b - blockYmax;
                    player.field_70121_D.func_72317_d(0.0, blockYmax - player.field_70121_D.field_72338_b, 0.0);
                }
                freefall = false;
            }
            if (player.field_70170_p.field_73011_w instanceof WorldProviderOrbit) {
                ((WorldProviderOrbit)player.field_70170_p.field_73011_w).spinUpdate(player, freefall);
            }
        }
        if (player.field_70121_D != null && stats.boundingBoxBefore == null) {
            stats.boundingBoxBefore = player.field_70121_D;
            player.field_70121_D.func_72324_b(stats.boundingBoxBefore.field_72340_a + 0.4, stats.boundingBoxBefore.field_72338_b + 0.9, stats.boundingBoxBefore.field_72339_c + 0.4, stats.boundingBoxBefore.field_72336_d - 0.4, stats.boundingBoxBefore.field_72337_e - 0.9, stats.boundingBoxBefore.field_72334_f - 0.4);
        } else if (player.field_70121_D != null && stats.boundingBoxBefore != null) {
            player.field_70121_D.func_72328_c(stats.boundingBoxBefore);
        }
    }

    @Override
    public void onLivingUpdatePost(EntityPlayerSP player) {
        boolean ridingThirdPersonEntity;
        GCPlayerStatsClient stats = GCPlayerStatsClient.get(player);
        if (stats.inFreefall) {
            player.field_70754_ba -= player.field_70721_aZ;
            player.field_70721_aZ = player.field_70722_aY;
        }
        boolean bl = ridingThirdPersonEntity = player.field_70154_o instanceof ICameraZoomEntity && ((ICameraZoomEntity)player.field_70154_o).defaultThirdPerson();
        if (ridingThirdPersonEntity && !stats.lastRidingCameraZoomEntity) {
            FMLClientHandler.instance().getClient().field_71474_y.field_74320_O = 1;
        }
        if (player.field_70154_o != null && player.field_70154_o instanceof ICameraZoomEntity) {
            stats.lastZoomed = true;
            TickHandlerClient.zoom(((ICameraZoomEntity)player.field_70154_o).getCameraZoom());
        } else if (stats.lastZoomed) {
            stats.lastZoomed = false;
            TickHandlerClient.zoom(4.0f);
        }
        stats.lastRidingCameraZoomEntity = ridingThirdPersonEntity;
        if (stats.usingParachute) {
            player.field_70143_R = 0.0f;
        }
        PlayerGearData gearData = ClientProxyCore.playerItemData.get(player.func_70005_c_());
        stats.usingParachute = false;
        if (gearData != null) {
            boolean bl2 = stats.usingParachute = gearData.getParachute() != null;
        }
        if (stats.usingParachute && player.field_70122_E) {
            stats.setParachute(false);
            FMLClientHandler.instance().getClient().field_71474_y.field_74320_O = stats.thirdPersonView;
        }
        if (!stats.lastUsingParachute && stats.usingParachute) {
            FMLClientHandler.instance().getClient().func_147118_V().func_147682_a((ISound)new PositionedSoundRecord(new ResourceLocation(GalacticraftCore.TEXTURE_PREFIX + "player.parachute"), 0.95f + player.func_70681_au().nextFloat() * 0.1f, 1.0f, (float)player.field_70165_t, (float)player.field_70163_u, (float)player.field_70161_v));
        }
        stats.lastUsingParachute = stats.usingParachute;
        stats.lastOnGround = player.field_70122_E;
    }

    @Override
    public float getBedOrientationInDegrees(EntityPlayerSP player, float vanillaDegrees) {
        if (player.field_71081_bT != null) {
            int x = player.field_71081_bT.field_71574_a;
            int y = player.field_71081_bT.field_71572_b;
            int z = player.field_71081_bT.field_71573_c;
            if (player.field_70170_p.func_147438_o(x, y, z) instanceof TileEntityAdvanced) {
                switch (player.field_70170_p.func_72805_g(x, y, z) - 4) {
                    case 0: {
                        return 90.0f;
                    }
                    case 1: {
                        return 270.0f;
                    }
                    case 2: {
                        return 180.0f;
                    }
                    case 3: {
                        return 0.0f;
                    }
                }
            } else {
                return vanillaDegrees;
            }
        }
        return vanillaDegrees;
    }

    private void updateFeet(EntityPlayerSP player, double motionX, double motionZ) {
        int iPosZ;
        int iPosY;
        int iPosX;
        GCPlayerStatsClient stats = GCPlayerStatsClient.get(player);
        double motionSqrd = motionX * motionX + motionZ * motionZ;
        if (motionSqrd > 0.001 && player.field_70170_p != null && player.field_70170_p.field_73011_w instanceof WorldProviderMoon && player.field_70154_o == null && !player.field_71075_bZ.field_75100_b && player.field_70170_p.func_147439_a(iPosX = (int)Math.floor(player.field_70165_t), iPosY = (int)Math.floor(player.field_70163_u - 2.0), iPosZ = (int)Math.floor(player.field_70161_v)) == GCBlocks.blockMoon && player.field_70170_p.func_72805_g(iPosX, iPosY, iPosZ) == 5) {
            if (stats.distanceSinceLastStep > 0.35) {
                Vector3 pos = new Vector3((Entity)player);
                pos.y = (float)MathHelper.func_76128_c((double)(player.field_70163_u - 1.0)) + player.func_70681_au().nextFloat() / 100.0f;
                switch (stats.lastStep) {
                    case 0: {
                        pos.translate(new Vector3(Math.sin(Math.toRadians(-player.field_70177_z + 90.0f)) * 0.25, 0.0, Math.cos(Math.toRadians(-player.field_70177_z + 90.0f)) * 0.25));
                        break;
                    }
                    case 1: {
                        pos.translate(new Vector3(Math.sin(Math.toRadians(-player.field_70177_z - 90.0f)) * 0.25, 0.0, Math.cos(Math.toRadians(-player.field_70177_z - 90.0f)) * 0.25));
                    }
                }
                pos = WorldUtil.getFootprintPosition(player.field_70170_p, player.field_70177_z - 180.0f, pos, new BlockVec3((Entity)player));
                long chunkKey = ChunkCoordIntPair.func_77272_a((int)(pos.intX() >> 4), (int)(pos.intZ() >> 4));
                ClientProxyCore.footprintRenderer.addFootprint(chunkKey, player.field_70170_p.field_73011_w.field_76574_g, pos, player.field_70177_z);
                ++stats.lastStep;
                stats.lastStep %= 2;
                stats.distanceSinceLastStep = 0.0;
            } else {
                stats.distanceSinceLastStep += motionSqrd;
            }
        }
    }

    public boolean wakeUpPlayer(EntityPlayerSP player, boolean par1, boolean par2, boolean par3, boolean bypass) {
        ChunkCoordinates c = player.field_71081_bT;
        if (c != null) {
            EventWakePlayer event = new EventWakePlayer((EntityPlayer)player, c.field_71574_a, c.field_71572_b, c.field_71573_c, par1, par2, par3, bypass);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (bypass || event.result == null || event.result == EntityPlayer.EnumStatus.OK) {
                return false;
            }
        }
        return true;
    }
}

