/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.nei.NEIGalacticraftConfig;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class CircuitFabricatorRecipeHandler
extends TemplateRecipeHandler {
    private static final ResourceLocation circuitFabricatorTexture = new ResourceLocation(GalacticraftCore.ASSET_PREFIX, "textures/gui/circuitFabricator.png");
    int ticksPassed;

    public String getRecipeId() {
        return "galacticraft.circuits";
    }

    public int recipiesPerPage() {
        return 1;
    }

    public Set<Map.Entry<ArrayList<PositionedStack>, PositionedStack>> getRecipes() {
        HashMap recipes = new HashMap();
        for (Map.Entry<HashMap<Integer, PositionedStack>, PositionedStack> stack : NEIGalacticraftConfig.getCircuitFabricatorRecipes()) {
            ArrayList<PositionedStack> inputStacks = new ArrayList<PositionedStack>();
            for (Map.Entry<Integer, PositionedStack> input : stack.getKey().entrySet()) {
                inputStacks.add(input.getValue());
            }
            recipes.put(inputStacks, stack.getValue());
        }
        return recipes.entrySet();
    }

    public void drawBackground(int i) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((ResourceLocation)circuitFabricatorTexture);
        GuiDraw.drawTexturedModalRect((int)-2, (int)9, (int)3, (int)4, (int)168, (int)64);
        GuiDraw.drawTexturedModalRect((int)68, (int)73, (int)73, (int)68, (int)96, (int)35);
        GuiDraw.drawTexturedModalRect((int)83, (int)25, (int)176, (int)(17 + 10 * (Math.min(this.ticksPassed % 70, 51) / 3 % 3)), (int)Math.min(this.ticksPassed % 70, 51), (int)10);
    }

    public void onUpdate() {
        ++this.ticksPassed;
        super.onUpdate();
    }

    public void loadTransferRects() {
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getRecipeId())) {
            for (Map.Entry<ArrayList<PositionedStack>, PositionedStack> irecipe : this.getRecipes()) {
                this.arecipes.add(new CachedCircuitRecipe(irecipe));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (Map.Entry<ArrayList<PositionedStack>, PositionedStack> irecipe : this.getRecipes()) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)irecipe.getValue().item, (ItemStack)result)) continue;
            this.arecipes.add(new CachedCircuitRecipe(irecipe));
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        block0: for (Map.Entry<ArrayList<PositionedStack>, PositionedStack> irecipe : this.getRecipes()) {
            for (PositionedStack pstack : irecipe.getKey()) {
                if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)ingredient, (ItemStack)pstack.item)) continue;
                this.arecipes.add(new CachedCircuitRecipe(irecipe));
                continue block0;
            }
        }
    }

    public ArrayList<PositionedStack> getIngredientStacks(int recipe) {
        return (ArrayList)((TemplateRecipeHandler.CachedRecipe)this.arecipes.get(recipe)).getIngredients();
    }

    public PositionedStack getResultStack(int recipe) {
        if (this.ticksPassed % 70 >= 51) {
            return ((TemplateRecipeHandler.CachedRecipe)this.arecipes.get(recipe)).getResult();
        }
        return null;
    }

    public String getRecipeName() {
        return "Circuit Fabricator";
    }

    public String getGuiTexture() {
        return GalacticraftCore.TEXTURE_PREFIX + "textures/gui/circuitFabricator.png";
    }

    public void drawForeground(int recipe) {
    }

    public class CachedCircuitRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public ArrayList<PositionedStack> input;
        public PositionedStack output;

        public ArrayList<PositionedStack> getIngredients() {
            return this.input;
        }

        public PositionedStack getResult() {
            return this.output;
        }

        public CachedCircuitRecipe(ArrayList<PositionedStack> pstack1, PositionedStack pstack2) {
            super((TemplateRecipeHandler)CircuitFabricatorRecipeHandler.this);
            this.input = pstack1;
            this.output = pstack2;
        }

        public CachedCircuitRecipe(Map.Entry<ArrayList<PositionedStack>, PositionedStack> recipe) {
            this(recipe.getKey(), recipe.getValue());
        }
    }
}

