/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import cpw.mods.fml.common.FMLCommonHandler;
import java.util.ArrayList;
import java.util.Iterator;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.client.gui.screen.DrawGameScreen;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityScreen
extends TileEntity {
    public static float FRAMEBORDER = 0.098f;
    public int imageType;
    public static int maxTypes;
    public DrawGameScreen screen;
    public boolean connectedUp;
    public boolean connectedDown;
    public boolean connectedLeft;
    public boolean connectedRight;
    public int connectionsUp;
    public int connectionsDown;
    public int connectionsLeft;
    public int connectionsRight;
    public boolean isMultiscreen;
    public int screenOffsetx = 0;
    public int screenOffsetz = 0;
    private int requiresUpdate = 0;

    public void func_145829_t() {
        super.func_145829_t();
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            this.screen = new DrawGameScreen(1.0f, 1.0f, this);
            GalacticraftCore.packetPipeline.sendToServer(new PacketSimple(PacketSimple.EnumSimplePacket.S_UPDATE_VIEWSCREEN_REQUEST, new Object[]{this.field_145850_b.field_73011_w.field_76574_g, this.field_145851_c, this.field_145848_d, this.field_145849_e}));
        }
    }

    public void updateClients() {
        int connectedFlags = 0;
        if (this.connectedUp) {
            connectedFlags += 8;
        }
        if (this.connectedDown) {
            connectedFlags += 4;
        }
        if (this.connectedLeft) {
            connectedFlags += 2;
        }
        if (this.connectedRight) {
            ++connectedFlags;
        }
        GalacticraftCore.packetPipeline.sendToDimension(new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_VIEWSCREEN, new Object[]{this.field_145851_c, this.field_145848_d, this.field_145849_e, this.imageType, connectedFlags}), this.field_145850_b.field_73011_w.field_76574_g);
    }

    public void func_145843_s() {
        int meta = this.func_145832_p() & 7;
        super.func_145843_s();
        this.breakScreen(meta);
    }

    public void breakScreen(int meta) {
        TileEntity tile;
        BlockVec3 vec = new BlockVec3(this);
        int side = this.getRight(meta);
        int left = this.connectionsLeft;
        int right = this.connectionsRight;
        int up = this.connectionsUp;
        int down = this.connectionsDown;
        boolean doUp = this.connectedUp;
        boolean doDown = this.connectedDown;
        boolean doLeft = this.connectedLeft;
        boolean doRight = this.connectedRight;
        for (int x = -left; x <= right; ++x) {
            for (int z = -up; z <= down; ++z) {
                if (x == 0 && z == 0) {
                    this.resetToSingle();
                    continue;
                }
                BlockVec3 newVec = vec.clone().modifyPositionFromSide(ForgeDirection.getOrientation((int)side), x).modifyPositionFromSide(ForgeDirection.DOWN, z);
                tile = newVec.getTileEntity((IBlockAccess)this.field_145850_b);
                if (!(tile instanceof TileEntityScreen) || tile.func_145832_p() != meta) continue;
                ((TileEntityScreen)tile).resetToSingle();
            }
        }
        this.connectedRight = false;
        this.connectedLeft = false;
        this.connectedDown = false;
        this.connectedUp = false;
        if (doUp && (tile = vec.getTileEntityOnSide(this.field_145850_b, 1)) instanceof TileEntityScreen && tile.func_145832_p() == meta && !tile.func_145837_r()) {
            if (doLeft) {
                ((TileEntityScreen)tile).connectedLeft = true;
            }
            if (doRight) {
                ((TileEntityScreen)tile).connectedRight = true;
            }
            ((TileEntityScreen)tile).connectedUp = true;
            ((TileEntityScreen)tile).refreshConnections(true);
        }
        if (doDown && (tile = vec.getTileEntityOnSide(this.field_145850_b, 0)) instanceof TileEntityScreen && tile.func_145832_p() == meta && !tile.func_145837_r()) {
            if (doLeft) {
                ((TileEntityScreen)tile).connectedLeft = true;
            }
            if (doRight) {
                ((TileEntityScreen)tile).connectedRight = true;
            }
            ((TileEntityScreen)tile).connectedDown = true;
            ((TileEntityScreen)tile).refreshConnections(true);
        }
        if (doLeft && (tile = vec.getTileEntityOnSide(this.field_145850_b, this.getLeft(meta))) instanceof TileEntityScreen && tile.func_145832_p() == meta && !tile.func_145837_r()) {
            if (doUp) {
                ((TileEntityScreen)tile).connectedUp = true;
            }
            if (doDown) {
                ((TileEntityScreen)tile).connectedDown = true;
            }
            ((TileEntityScreen)tile).connectedLeft = true;
            ((TileEntityScreen)tile).refreshConnections(true);
        }
        if (doRight && (tile = vec.getTileEntityOnSide(this.field_145850_b, this.getRight(meta))) instanceof TileEntityScreen && tile.func_145832_p() == meta && !tile.func_145837_r()) {
            if (doUp) {
                ((TileEntityScreen)tile).connectedUp = true;
            }
            if (doDown) {
                ((TileEntityScreen)tile).connectedDown = true;
            }
            ((TileEntityScreen)tile).connectedRight = true;
            ((TileEntityScreen)tile).refreshConnections(true);
        }
    }

    public void refreshConnections(boolean doScreen) {
        int side;
        this.log("Starting connection check");
        int meta = this.func_145832_p() & 7;
        if (meta < 2) {
            this.resetToSingle();
            return;
        }
        TileEntity tileUp = null;
        TileEntity tileDown = null;
        TileEntity tileLeft = null;
        TileEntity tileRight = null;
        BlockVec3 vec = new BlockVec3(this);
        if (this.connectedUp && (!((tileUp = vec.getTileEntityOnSide(this.field_145850_b, 1)) instanceof TileEntityScreen) || tileUp.func_145832_p() != meta || tileUp.func_145837_r())) {
            this.connectedUp = false;
        }
        if (this.connectedDown && (!((tileDown = vec.getTileEntityOnSide(this.field_145850_b, 0)) instanceof TileEntityScreen) || tileDown.func_145832_p() != meta || tileDown.func_145837_r())) {
            this.connectedDown = false;
        }
        if (this.connectedLeft && (!((tileLeft = vec.getTileEntityOnSide(this.field_145850_b, side = this.getLeft(meta))) instanceof TileEntityScreen) || tileLeft.func_145832_p() != meta || tileLeft.func_145837_r())) {
            this.connectedLeft = false;
        }
        if (this.connectedRight && (!((tileRight = vec.getTileEntityOnSide(this.field_145850_b, side = this.getRight(meta))) instanceof TileEntityScreen) || tileRight.func_145832_p() != meta || tileRight.func_145837_r())) {
            this.connectedRight = false;
        }
        if (this.connectedUp && (tileUp == null || !this.tryConnectUp((TileEntityScreen)tileUp))) {
            this.connectedUp = false;
        }
        if (this.connectedDown && (tileDown == null || !this.tryConnectDown((TileEntityScreen)tileDown))) {
            this.connectedDown = false;
        }
        if (this.connectedLeft && (tileLeft == null || !this.tryConnectLeft((TileEntityScreen)tileLeft))) {
            this.connectedLeft = false;
        }
        if (this.connectedRight && (tileRight == null || !this.tryConnectRight((TileEntityScreen)tileRight))) {
            this.connectedRight = false;
        }
        this.log("Ending connection check");
        if (doScreen) {
            this.checkScreenSize();
            this.func_70296_d();
        }
    }

    public boolean canUpdate() {
        return false;
    }

    public void changeChannel() {
        if (!this.field_145850_b.field_72995_K) {
            if (++this.imageType >= maxTypes) {
                this.imageType = 0;
            }
            this.connectedRight = true;
            this.connectedLeft = true;
            this.connectedDown = true;
            this.connectedUp = true;
            this.refreshConnections(true);
            this.func_70296_d();
            this.updateClients();
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.imageType = nbt.func_74762_e("type");
        this.connectionsDown = nbt.func_74762_e("connectionsDown");
        this.connectionsUp = nbt.func_74762_e("connectionsUp");
        this.connectionsLeft = nbt.func_74762_e("connectionsLeft");
        this.connectionsRight = nbt.func_74762_e("connectionsRight");
        this.isMultiscreen = nbt.func_74767_n("multiscreen");
        this.connectedUp = this.connectionsUp > 0;
        this.connectedDown = this.connectionsDown > 0;
        this.connectedLeft = this.connectionsLeft > 0;
        this.connectedRight = this.connectionsRight > 0;
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("type", this.imageType);
        nbt.func_74768_a("connectionsDown", this.connectionsDown);
        nbt.func_74768_a("connectionsUp", this.connectionsUp);
        nbt.func_74768_a("connectionsLeft", this.connectionsLeft);
        nbt.func_74768_a("connectionsRight", this.connectionsRight);
        nbt.func_74757_a("multiscreen", this.isMultiscreen);
    }

    public void checkScreenSize() {
        TileEntityScreen tileRight;
        TileEntity newTile;
        int up;
        this.log("Checking screen size");
        int down = 0;
        int left = 0;
        int right = 0;
        int meta = this.func_145832_p() & 7;
        BlockVec3 vec = new BlockVec3(this);
        TileEntityScreen tile = this;
        for (up = 0; up < 5 && tile.connectedUp; ++up) {
            newTile = vec.getTileEntityOnSide(this.field_145850_b, 1);
            if (newTile instanceof TileEntityScreen) {
                tile = (TileEntityScreen)newTile;
                vec.translate(0, 1, 0);
                continue;
            }
            System.out.println("Debug - connected up to a non-screen tile");
            tile.connectedUp = false;
            tile.func_70296_d();
            --up;
            break;
        }
        vec = new BlockVec3(this);
        tile = this;
        while (down < 5 && tile.connectedDown) {
            ++down;
            newTile = vec.getTileEntityOnSide(this.field_145850_b, 0);
            if (newTile instanceof TileEntityScreen) {
                tile = (TileEntityScreen)newTile;
                vec.translate(0, -1, 0);
                continue;
            }
            System.out.println("Debug - connected down to a non-screen tile");
            tile.connectedDown = false;
            tile.func_70296_d();
            --down;
            break;
        }
        vec = new BlockVec3(this);
        tile = this;
        int leftside = this.getLeft(meta);
        while (left < (up + down == 0 ? 1 : 5) && tile.connectedLeft) {
            ++left;
            TileEntity newTile2 = vec.getTileEntityOnSide(this.field_145850_b, leftside);
            if (newTile2 instanceof TileEntityScreen) {
                tile = (TileEntityScreen)newTile2;
                vec = vec.newVecSide(leftside);
                continue;
            }
            System.out.println("Debug - connected left to a non-screen tile");
            tile.connectedLeft = false;
            tile.func_70296_d();
            --left;
            break;
        }
        vec = new BlockVec3(this);
        tile = this;
        int rightside = this.getRight(meta);
        while (right < (up + down == 0 ? 1 : 5) && tile.connectedRight) {
            ++right;
            TileEntity newTile3 = vec.getTileEntityOnSide(this.field_145850_b, rightside);
            if (newTile3 instanceof TileEntityScreen) {
                tile = (TileEntityScreen)newTile3;
                vec = vec.newVecSide(rightside);
                continue;
            }
            System.out.println("Debug - connected right to a non-screen tile");
            tile.connectedRight = false;
            tile.func_70296_d();
            --right;
            break;
        }
        this.log("Screen size check midpoint " + up + " " + down + " " + left + " " + right + " ");
        vec = new BlockVec3(this);
        TileEntity newtile = vec.getTileEntityOnSide(this.field_145850_b, 1);
        TileEntityScreen tileUp = newtile instanceof TileEntityScreen ? (TileEntityScreen)newtile : null;
        newtile = vec.getTileEntityOnSide(this.field_145850_b, 0);
        TileEntityScreen tileDown = newtile instanceof TileEntityScreen ? (TileEntityScreen)newtile : null;
        newtile = vec.getTileEntityOnSide(this.field_145850_b, leftside);
        TileEntityScreen tileLeft = newtile instanceof TileEntityScreen ? (TileEntityScreen)newtile : null;
        newtile = vec.getTileEntityOnSide(this.field_145850_b, rightside);
        TileEntityScreen tileEntityScreen = tileRight = newtile instanceof TileEntityScreen ? (TileEntityScreen)newtile : null;
        if (left + right == 0 && up + down >= 1) {
            if (up > 0 && !tileUp.connectedUp) {
                up = 1;
                down = 0;
            } else {
                up = 0;
                down = tileDown != null && !tileDown.connectedDown ? 1 : 0;
            }
        }
        if (up + down == 0 && left + right >= 1) {
            if (left > 0 && !tileLeft.connectedLeft) {
                left = 1;
                right = 0;
            } else {
                left = 0;
                right = tileRight != null && !tileRight.connectedRight ? 1 : 0;
            }
        }
        if (up == 0) {
            this.connectedUp = false;
            if (tileUp != null) {
                tileUp.connectedDown = false;
            }
        }
        if (down == 0) {
            this.connectedDown = false;
            if (tileDown != null) {
                tileDown.connectedUp = false;
            }
        }
        if (left == 0) {
            this.connectedLeft = false;
            if (tileLeft != null) {
                tileLeft.connectedRight = false;
            }
        }
        if (right == 0) {
            this.connectedRight = false;
            if (tileRight != null) {
                tileRight.connectedLeft = false;
            }
        }
        this.log("Finished screen size check");
        this.checkWholeScreen(up, down, left, right);
    }

    private boolean checkWholeScreen(int up, int down, int left, int right) {
        if (up + down + left + right == 0) {
            this.resetToSingle();
            return true;
        }
        boolean screenWhole = true;
        boolean existingScreen = false;
        int barrierUp = up;
        int barrierDown = down;
        int barrierLeft = left;
        int barrierRight = right;
        int meta = this.func_145832_p() & 7;
        BlockVec3 vec = new BlockVec3(this);
        ArrayList<TileEntityScreen> screenList = new ArrayList<TileEntityScreen>();
        int side = this.getRight(meta);
        for (int x = -left; x <= right; ++x) {
            for (int z = -up; z <= down; ++z) {
                BlockVec3 newVec = vec.clone().modifyPositionFromSide(ForgeDirection.getOrientation((int)side), x).modifyPositionFromSide(ForgeDirection.DOWN, z);
                TileEntity tile = newVec.getTileEntity((IBlockAccess)this.field_145850_b);
                if (tile instanceof TileEntityScreen && tile.func_145832_p() == meta && !tile.func_145837_r()) {
                    TileEntityScreen screenTile = (TileEntityScreen)tile;
                    screenList.add(screenTile);
                    if (!screenTile.isMultiscreen) continue;
                    if (screenTile.connectionsUp > z + up) {
                        barrierUp = up - (screenTile.connectionsUp - z - up);
                        existingScreen = true;
                    }
                    if (screenTile.connectionsDown > down - z) {
                        barrierDown = down - (screenTile.connectionsDown + z - down);
                        existingScreen = true;
                    }
                    if (screenTile.connectionsLeft > x + left) {
                        barrierLeft = left - (screenTile.connectionsLeft - x - left);
                        existingScreen = true;
                    }
                    if (screenTile.connectionsRight <= right - x) continue;
                    barrierRight = right - (screenTile.connectionsRight + x - right);
                    existingScreen = true;
                    continue;
                }
                screenWhole = false;
            }
        }
        if (!screenWhole) {
            for (TileEntityScreen scr : screenList) {
                scr.resetToSingle();
            }
            return false;
        }
        if (existingScreen) {
            return this.checkWholeScreen(barrierUp, barrierDown, barrierLeft, barrierRight);
        }
        DrawGameScreen newScreen = null;
        boolean serverside = true;
        TileEntity bottomLeft = vec.clone().modifyPositionFromSide(ForgeDirection.getOrientation((int)side), -left).modifyPositionFromSide(ForgeDirection.DOWN, down).getTileEntity((IBlockAccess)this.field_145850_b);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            if (bottomLeft instanceof TileEntityScreen) {
                newScreen = new DrawGameScreen(1.0f + (float)left + (float)right, 1.0f + (float)up + (float)down, bottomLeft);
            }
            serverside = false;
        }
        Iterator it = screenList.iterator();
        for (int x = -left; x <= right; ++x) {
            for (int z = -up; z <= down; ++z) {
                TileEntityScreen screenTile = (TileEntityScreen)((Object)it.next());
                screenTile.screenOffsetx = x + left;
                screenTile.screenOffsetz = z + up;
                screenTile.screen = newScreen;
                screenTile.connectionsLeft = x + left;
                screenTile.connectionsRight = right - x;
                screenTile.connectionsUp = z + up;
                screenTile.connectionsDown = down - z;
                screenTile.isMultiscreen = true;
                if (serverside) {
                    screenTile.imageType = this.imageType;
                    screenTile.func_70296_d();
                    screenTile.updateClients();
                }
                screenTile.refreshConnections(false);
            }
        }
        this.connectionsUp = up;
        this.connectionsDown = down;
        this.connectionsLeft = left;
        this.connectionsRight = right;
        return true;
    }

    public void resetToSingle() {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            this.screen = new DrawGameScreen(1.0f, 1.0f, this);
        }
        this.screenOffsetx = 0;
        this.screenOffsetz = 0;
        this.connectionsUp = 0;
        this.connectionsDown = 0;
        this.connectionsLeft = 0;
        this.connectionsRight = 0;
        this.isMultiscreen = false;
        this.connectedUp = false;
        this.connectedRight = false;
        this.connectedLeft = false;
        this.connectedDown = false;
        this.func_70296_d();
    }

    private int getLeft(int meta) {
        switch (meta) {
            case 2: {
                return 4;
            }
            case 3: {
                return 5;
            }
            case 4: {
                return 3;
            }
            case 5: {
                return 2;
            }
        }
        return 4;
    }

    private int getRight(int meta) {
        switch (meta) {
            case 2: {
                return 5;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 2;
            }
            case 5: {
                return 3;
            }
        }
        return 5;
    }

    private boolean tryConnectUp(TileEntityScreen screenTile) {
        if (screenTile.connectedDown) {
            return true;
        }
        screenTile.connectedDown = true;
        if (this.connectedLeft) {
            screenTile.connectedLeft = true;
        }
        if (this.connectedRight) {
            screenTile.connectedRight = true;
        }
        screenTile.refreshConnections(false);
        if (this.connectedLeft ^ screenTile.connectedLeft || this.connectedRight ^ screenTile.connectedRight) {
            screenTile.connectedDown = false;
            return false;
        }
        return true;
    }

    private boolean tryConnectDown(TileEntityScreen screenTile) {
        if (screenTile.connectedUp) {
            return true;
        }
        screenTile.connectedUp = true;
        if (this.connectedLeft) {
            screenTile.connectedLeft = true;
        }
        if (this.connectedRight) {
            screenTile.connectedRight = true;
        }
        screenTile.refreshConnections(false);
        if (this.connectedLeft ^ screenTile.connectedLeft || this.connectedRight ^ screenTile.connectedRight) {
            screenTile.connectedUp = false;
            return false;
        }
        return true;
    }

    private boolean tryConnectLeft(TileEntityScreen screenTile) {
        if (screenTile.connectedRight) {
            return true;
        }
        if (screenTile.connectedUp && !this.connectedUp || screenTile.connectedDown && !this.connectedDown) {
            return false;
        }
        screenTile.connectedRight = true;
        if (this.connectedUp) {
            screenTile.connectedUp = true;
        }
        if (this.connectedDown) {
            screenTile.connectedDown = true;
        }
        screenTile.refreshConnections(false);
        if (this.connectedUp ^ screenTile.connectedUp || this.connectedDown ^ screenTile.connectedDown) {
            screenTile.connectedRight = false;
            return false;
        }
        return true;
    }

    private boolean tryConnectRight(TileEntityScreen screenTile) {
        if (screenTile.connectedLeft) {
            return true;
        }
        if (screenTile.connectedUp && !this.connectedUp || screenTile.connectedDown && !this.connectedDown) {
            return false;
        }
        screenTile.connectedLeft = true;
        if (this.connectedUp) {
            screenTile.connectedUp = true;
        }
        if (this.connectedDown) {
            screenTile.connectedDown = true;
        }
        screenTile.refreshConnections(false);
        if (this.connectedUp ^ screenTile.connectedUp || this.connectedDown ^ screenTile.connectedDown) {
            screenTile.connectedLeft = false;
            return false;
        }
        return true;
    }

    private void log(String msg) {
        String connections = "";
        if (this.connectedUp) {
            connections = "U";
        }
        if (this.connectedDown) {
            connections = connections + "D";
        }
        if (this.connectedLeft) {
            connections = connections + "L";
        }
        if (this.connectedRight) {
            connections = connections + "R";
        }
    }
}

