/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.world;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import micdoodle8.mods.galacticraft.core.util.GCLog;
import micdoodle8.mods.galacticraft.core.world.IChunkLoader;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.config.Configuration;

public class ChunkLoadingCallback
implements ForgeChunkManager.LoadingCallback {
    private static boolean loaded;
    private static HashMap<String, HashMap<Integer, HashSet<ChunkCoordinates>>> chunkLoaderList;
    private static boolean configLoaded;
    private static Configuration config;
    private static boolean loadOnLogin;

    public void ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world) {
        for (ForgeChunkManager.Ticket ticket : tickets) {
            int tileZ;
            int tileY;
            int tileX;
            TileEntity tile;
            NBTTagCompound nbt = ticket.getModData();
            if (nbt == null || !((tile = world.func_147438_o(tileX = nbt.func_74762_e("ChunkLoaderTileX"), tileY = nbt.func_74762_e("ChunkLoaderTileY"), tileZ = nbt.func_74762_e("ChunkLoaderTileZ"))) instanceof IChunkLoader)) continue;
            ((IChunkLoader)tile).onTicketLoaded(ticket, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadConfig(File file) {
        if (!configLoaded) {
            config = new Configuration(file);
        }
        try {
            loadOnLogin = config.get("CHUNKLOADING", "LoadOnLogin", true, "If you don't want each player's chunks to load when they log in, set to false.").getBoolean(true);
        }
        catch (Exception e) {
            GCLog.severe("Problem loading chunkloading config (\"core.conf\")");
        }
        finally {
            if (config.hasChanged()) {
                config.save();
            }
            configLoaded = true;
        }
    }

    public static void addToList(World world, int x, int y, int z, String playerName) {
        HashSet<Object> chunkLoaders;
        HashMap<Integer, HashSet<Object>> dimensionMap = chunkLoaderList.get(playerName);
        if (dimensionMap == null) {
            dimensionMap = new HashMap();
            chunkLoaderList.put(playerName, dimensionMap);
        }
        if ((chunkLoaders = dimensionMap.get(world.field_73011_w.field_76574_g)) == null) {
            chunkLoaders = new HashSet();
        }
        chunkLoaders.add(new ChunkCoordinates(x, y, z));
        dimensionMap.put(world.field_73011_w.field_76574_g, chunkLoaders);
        chunkLoaderList.put(playerName, dimensionMap);
    }

    public static void forceChunk(ForgeChunkManager.Ticket ticket, World world, int x, int y, int z, String playerName) {
        ChunkLoadingCallback.addToList(world, x, y, z, playerName);
        ChunkCoordIntPair chunkPos = new ChunkCoordIntPair(x >> 4, z >> 4);
        ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkCoordIntPair)chunkPos);
    }

    public static void save(WorldServer world) {
        try {
            File saveDir = ChunkLoadingCallback.getSaveDir();
            if (saveDir != null) {
                File saveFile = new File(saveDir, "chunkloaders.dat");
                if (!saveFile.exists()) {
                    saveFile.createNewFile();
                }
                DataOutputStream dataStream = new DataOutputStream(new FileOutputStream(saveFile));
                dataStream.writeInt(chunkLoaderList.size());
                for (Map.Entry<String, HashMap<Integer, HashSet<ChunkCoordinates>>> playerEntry : chunkLoaderList.entrySet()) {
                    dataStream.writeUTF(playerEntry.getKey());
                    dataStream.writeInt(playerEntry.getValue().size());
                    for (Map.Entry<Integer, HashSet<ChunkCoordinates>> dimensionEntry : playerEntry.getValue().entrySet()) {
                        dataStream.writeInt(dimensionEntry.getKey());
                        dataStream.writeInt(dimensionEntry.getValue().size());
                        for (ChunkCoordinates coords : dimensionEntry.getValue()) {
                            dataStream.writeInt(coords.field_71574_a);
                            dataStream.writeInt(coords.field_71572_b);
                            dataStream.writeInt(coords.field_71573_c);
                        }
                    }
                }
                dataStream.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static File getSaveDir() {
        if (DimensionManager.getWorld((int)0) != null) {
            File saveDir = new File(DimensionManager.getCurrentSaveRootDirectory(), "galacticraft");
            if (!saveDir.exists()) {
                saveDir.mkdirs();
            }
            return saveDir;
        }
        return null;
    }

    public static void load(WorldServer world) {
        if (loaded) {
            return;
        }
        try {
            File saveDir = ChunkLoadingCallback.getSaveDir();
            if (saveDir != null) {
                File saveFile;
                if (!saveDir.exists()) {
                    saveDir.mkdirs();
                }
                if ((saveFile = new File(saveDir, "chunkloaders.dat")).exists()) {
                    DataInputStream dataStream = new DataInputStream(new FileInputStream(saveFile));
                    int playerCount = dataStream.readInt();
                    for (int l = 0; l < playerCount; ++l) {
                        String ownerName = dataStream.readUTF();
                        int mapSize = dataStream.readInt();
                        HashMap dimensionMap = new HashMap();
                        for (int i = 0; i < mapSize; ++i) {
                            int dimensionID = dataStream.readInt();
                            HashSet<ChunkCoordinates> coords = new HashSet<ChunkCoordinates>();
                            dimensionMap.put(dimensionID, coords);
                            int coordSetSize = dataStream.readInt();
                            for (int j = 0; j < coordSetSize; ++j) {
                                coords.add(new ChunkCoordinates(dataStream.readInt(), dataStream.readInt(), dataStream.readInt()));
                            }
                        }
                        chunkLoaderList.put(ownerName, dimensionMap);
                    }
                    dataStream.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        loaded = true;
    }

    public static void onPlayerLogin(EntityPlayer player) {
        for (Map.Entry<String, HashMap<Integer, HashSet<ChunkCoordinates>>> playerEntry : chunkLoaderList.entrySet()) {
            if (!player.func_146103_bH().getName().equals(playerEntry.getKey())) continue;
            for (Map.Entry<Integer, HashSet<ChunkCoordinates>> dimensionEntry : playerEntry.getValue().entrySet()) {
                int dimID = dimensionEntry.getKey();
                if (!loadOnLogin) continue;
                MinecraftServer.func_71276_C().func_71218_a(dimID);
            }
        }
    }

    public static void onPlayerLogout(EntityPlayer player) {
    }

    static {
        chunkLoaderList = new HashMap();
    }
}

