/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.client.render;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.atomic.AtomicInteger;
import javax.imageio.ImageIO;
import net.minecraft.client.renderer.IImageBuffer;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SideOnly(value=Side.CLIENT)
public class ThreadDownloadImageDataGC
extends SimpleTexture {
    private static final Logger logger = LogManager.getLogger();
    private static final AtomicInteger threadDownloadCounter = new AtomicInteger(0);
    private final File field_152434_e;
    private final String imageUrl;
    private final IImageBuffer imageBuffer;
    private BufferedImage bufferedImage;
    private Thread imageThread;
    private boolean textureUploaded;

    public ThreadDownloadImageDataGC(File p_i1049_1_, String p_i1049_2_, ResourceLocation p_i1049_3_, IImageBuffer p_i1049_4_) {
        super(p_i1049_3_);
        this.field_152434_e = p_i1049_1_;
        this.imageUrl = p_i1049_2_;
        this.imageBuffer = p_i1049_4_;
    }

    private void checkTextureUploaded() {
        if (!this.textureUploaded && this.bufferedImage != null) {
            if (this.field_110568_b != null) {
                this.func_147631_c();
            }
            TextureUtil.func_110987_a((int)super.func_110552_b(), (BufferedImage)this.bufferedImage);
            this.textureUploaded = true;
        }
    }

    public int func_110552_b() {
        this.checkTextureUploaded();
        return super.func_110552_b();
    }

    public void setBufferedImage(BufferedImage p_147641_1_) {
        this.bufferedImage = p_147641_1_;
    }

    public void func_110551_a(IResourceManager p_110551_1_) {
        try {
            if (this.bufferedImage == null && this.field_110568_b != null) {
                super.func_110551_a(p_110551_1_);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.imageThread == null) {
            if (this.field_152434_e != null && this.field_152434_e.isFile()) {
                FMLLog.fine((String)"Loading http texture from local cache (%s)", (Object[])new Object[]{this.field_152434_e});
                try {
                    this.bufferedImage = ImageIO.read(this.field_152434_e);
                    if (this.imageBuffer != null) {
                        this.setBufferedImage(this.imageBuffer.func_78432_a(this.bufferedImage));
                    }
                }
                catch (IOException ioexception) {
                    logger.error("Couldn't load skin " + this.field_152434_e, (Throwable)ioexception);
                    this.func_152433_a();
                }
            } else {
                this.func_152433_a();
            }
        }
    }

    protected void func_152433_a() {
        this.imageThread = new Thread("Texture Downloader #" + threadDownloadCounter.incrementAndGet()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                HttpURLConnection httpurlconnection = null;
                FMLLog.fine((String)"Downloading http texture from %s to %s", (Object[])new Object[]{ThreadDownloadImageDataGC.this.imageUrl, ThreadDownloadImageDataGC.this.field_152434_e});
                try {
                    httpurlconnection = (HttpURLConnection)new URL(ThreadDownloadImageDataGC.this.imageUrl).openConnection();
                    httpurlconnection.setDoInput(true);
                    httpurlconnection.setDoOutput(false);
                    httpurlconnection.connect();
                    if (httpurlconnection.getResponseCode() / 100 == 2) {
                        BufferedImage bufferedimage;
                        if (ThreadDownloadImageDataGC.this.field_152434_e != null) {
                            FileUtils.copyInputStreamToFile((InputStream)httpurlconnection.getInputStream(), (File)ThreadDownloadImageDataGC.this.field_152434_e);
                            bufferedimage = ImageIO.read(ThreadDownloadImageDataGC.this.field_152434_e);
                        } else {
                            bufferedimage = ImageIO.read(httpurlconnection.getInputStream());
                        }
                        if (ThreadDownloadImageDataGC.this.imageBuffer != null) {
                            bufferedimage = ThreadDownloadImageDataGC.this.imageBuffer.func_78432_a(bufferedimage);
                        }
                        ThreadDownloadImageDataGC.this.setBufferedImage(bufferedimage);
                        return;
                    }
                }
                catch (Exception exception) {
                    logger.error("Couldn't download http texture", (Throwable)exception);
                    return;
                }
                finally {
                    if (httpurlconnection != null) {
                        httpurlconnection.disconnect();
                    }
                }
            }
        };
        this.imageThread.setDaemon(true);
        this.imageThread.start();
    }
}

