/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.items.GCItems;
import micdoodle8.mods.galacticraft.core.items.ItemOilCanister;
import micdoodle8.mods.galacticraft.core.proxy.ClientProxyCore;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.ItemFluidContainer;

public abstract class ItemCanisterGeneric
extends ItemFluidContainer {
    private String allowedFluid = null;
    public static final int EMPTY = 1001;

    public ItemCanisterGeneric(String assetName) {
        super(0, 1000);
        this.func_77656_e(1001);
        this.func_77625_d(1);
        this.setNoRepair();
        this.func_77655_b(assetName);
        this.func_77642_a(GCItems.oilCanister);
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack par1ItemStack) {
        return ClientProxyCore.galacticraftItem;
    }

    public CreativeTabs func_77640_w() {
        return GalacticraftCore.galacticraftItemsTab;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        par3List.add(new ItemStack(par1, 1, 1));
    }

    public ItemStack getContainerItem(ItemStack itemStack) {
        if (itemStack != null && itemStack.func_77973_b() == this.func_77668_q() && itemStack.func_77960_j() == 1001) {
            return null;
        }
        return new ItemStack(this.func_77668_q(), 1, 1001);
    }

    public void func_77663_a(ItemStack par1ItemStack, World par2World, Entity par3Entity, int par4, boolean par5) {
        if (1001 == par1ItemStack.func_77960_j()) {
            int stackSize = par1ItemStack.field_77994_a;
            if (!(par1ItemStack.func_77973_b() instanceof ItemOilCanister)) {
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74777_a("id", (short)Item.func_150891_b((Item)GCItems.oilCanister));
                tag.func_74774_a("Count", (byte)stackSize);
                tag.func_74777_a("Damage", (short)1001);
                par1ItemStack.func_77963_c(tag);
            }
        }
    }

    public void setAllowedFluid(String name) {
        this.allowedFluid = new String(name);
    }

    public String getAllowedFluid() {
        return this.allowedFluid;
    }

    public int fill(ItemStack container, FluidStack resource, boolean doFill) {
        if (resource == null || resource.getFluid() == null || !(container.func_77973_b() instanceof ItemCanisterGeneric)) {
            return 0;
        }
        String fluidName = resource.getFluid().getName();
        if (container.func_77960_j() == 1001) {
            if (ConfigManagerCore.enableDebug) {
                System.out.println("Searching for matching container for " + fluidName);
            }
            for (String key : GalacticraftCore.itemList.keySet()) {
                Item i;
                if (!key.contains("CanisterFull") || !((i = GalacticraftCore.itemList.get(key).func_77973_b()) instanceof ItemCanisterGeneric) || !fluidName.equalsIgnoreCase(((ItemCanisterGeneric)i).allowedFluid)) continue;
                if (ConfigManagerCore.enableDebug) {
                    System.out.println("Found " + key);
                }
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74777_a("id", (short)Item.func_150891_b((Item)i));
                tag.func_74774_a("Count", (byte)1);
                tag.func_74777_a("Damage", (short)1001);
                container.func_77963_c(tag);
                if (!ConfigManagerCore.enableDebug) break;
                System.out.println("Set container for " + ((ItemCanisterGeneric)container.func_77973_b()).allowedFluid + " to " + container.func_77973_b().getClass().getSimpleName());
                break;
            }
        }
        if (fluidName.equalsIgnoreCase(((ItemCanisterGeneric)container.func_77973_b()).allowedFluid)) {
            int added = super.fill(container, resource, doFill);
            container.func_77964_b(Math.min(1, container.func_77960_j() - added));
            return added;
        }
        return 0;
    }

    public FluidStack drain(ItemStack container, int maxDrain, boolean doDrain) {
        if (this.allowedFluid == null) {
            return null;
        }
        container.field_77990_d = null;
        super.fill(container, this.getFluid(container), true);
        return super.drain(container, maxDrain, doDrain);
    }

    public FluidStack getFluid(ItemStack container) {
        if (this.allowedFluid == null || 1001 == container.func_77960_j()) {
            return null;
        }
        Fluid fluid = FluidRegistry.getFluid((String)this.allowedFluid);
        if (fluid == null) {
            return null;
        }
        return new FluidStack(fluid, 1001 - container.func_77960_j());
    }
}

