/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import cpw.mods.fml.relauncher.Side;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseElectricBlockWithInventory;
import micdoodle8.mods.galacticraft.core.items.GCItems;
import micdoodle8.mods.galacticraft.core.items.ItemCanisterGeneric;
import micdoodle8.mods.galacticraft.core.items.ItemOilCanister;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class TileEntityRefinery
extends TileBaseElectricBlockWithInventory
implements ISidedInventory,
IFluidHandler {
    private final int tankCapacity = 24000;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public FluidTank oilTank = new FluidTank(this.tankCapacity);
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public FluidTank fuelTank = new FluidTank(this.tankCapacity);
    public static final int PROCESS_TIME_REQUIRED = 2;
    public static final int OUTPUT_PER_SECOND = 1;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int processTicks = 0;
    private ItemStack[] containingItems = new ItemStack[3];

    public TileEntityRefinery() {
        this.storage.setMaxExtract(60.0f);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            FluidStack liquid;
            if (this.containingItems[1] != null && (liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)this.containingItems[1])) != null && FluidRegistry.getFluidName((FluidStack)liquid).equalsIgnoreCase("Oil") && (this.oilTank.getFluid() == null || this.oilTank.getFluid().amount + liquid.amount <= this.oilTank.getCapacity())) {
                this.oilTank.fill(liquid, true);
                if (this.containingItems[1].func_77973_b() instanceof ItemOilCanister) {
                    this.containingItems[1] = new ItemStack(GCItems.oilCanister, 1, GCItems.oilCanister.func_77612_l());
                } else if (FluidContainerRegistry.isBucket((ItemStack)this.containingItems[1]) && FluidContainerRegistry.isFilledContainer((ItemStack)this.containingItems[1])) {
                    int amount = this.containingItems[1].field_77994_a;
                    this.containingItems[1] = new ItemStack(Items.field_151133_ar, amount);
                } else {
                    --this.containingItems[1].field_77994_a;
                    if (this.containingItems[1].field_77994_a == 0) {
                        this.containingItems[1] = null;
                    }
                }
            }
            this.checkFluidTankTransfer(2, this.fuelTank);
            if (this.canProcess() && this.hasEnoughEnergyToRun) {
                if (this.processTicks == 0) {
                    this.processTicks = 2;
                } else if (--this.processTicks <= 0) {
                    this.smeltItem();
                    this.processTicks = this.canProcess() ? 2 : 0;
                }
            } else {
                this.processTicks = 0;
            }
        }
    }

    private void checkFluidTankTransfer(int slot, FluidTank tank) {
        String liquidname;
        FluidStack liquid;
        if (this.containingItems[slot] != null && FluidContainerRegistry.isContainer((ItemStack)this.containingItems[slot]) && (liquid = tank.getFluid()) != null && liquid.amount > 0 && (liquidname = liquid.getFluid().getName()).equals("fuel")) {
            this.tryFillContainer(tank, liquid, slot, GCItems.fuelCanister);
        }
    }

    private void tryFillContainer(FluidTank tank, FluidStack liquid, int slot, Item canister) {
        ItemStack slotItem = this.containingItems[slot];
        boolean isCanister = slotItem.func_77973_b() instanceof ItemCanisterGeneric && slotItem.func_77960_j() > 1;
        int amountToFill = Math.min(liquid.amount, isCanister ? slotItem.func_77960_j() - 1 : 1000);
        if (isCanister && amountToFill > 0) {
            this.containingItems[slot] = new ItemStack(canister, 1, slotItem.func_77960_j() - amountToFill);
            tank.drain(amountToFill, true);
        } else if (amountToFill == 1000) {
            this.containingItems[slot] = FluidContainerRegistry.fillFluidContainer((FluidStack)liquid, (ItemStack)this.containingItems[slot]);
            if (this.containingItems[slot] == null) {
                this.containingItems[slot] = slotItem;
            } else {
                tank.drain(amountToFill, true);
            }
        }
    }

    public int getScaledOilLevel(int i) {
        return this.oilTank.getFluid() != null ? this.oilTank.getFluid().amount * i / this.oilTank.getCapacity() : 0;
    }

    public int getScaledFuelLevel(int i) {
        return this.fuelTank.getFluid() != null ? this.fuelTank.getFluid().amount * i / this.fuelTank.getCapacity() : 0;
    }

    public boolean canProcess() {
        if (this.oilTank.getFluid() == null || this.oilTank.getFluid().amount <= 0) {
            return false;
        }
        return !this.getDisabled(0);
    }

    public void smeltItem() {
        if (this.canProcess()) {
            int oilAmount = this.oilTank.getFluid().amount;
            int fuelSpace = this.fuelTank.getCapacity() - (this.fuelTank.getFluid() == null ? 0 : this.fuelTank.getFluid().amount);
            int amountToDrain = Math.min(Math.min(oilAmount, fuelSpace), 1);
            this.oilTank.drain(amountToDrain, true);
            this.fuelTank.fill(FluidRegistry.getFluidStack((String)"fuel", (int)amountToDrain), true);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.processTicks = nbt.func_74762_e("smeltingTicks");
        this.containingItems = this.readStandardItemsFromNBT(nbt);
        if (nbt.func_74764_b("oilTank")) {
            this.oilTank.readFromNBT(nbt.func_74775_l("oilTank"));
        }
        if (nbt.func_74764_b("fuelTank")) {
            this.fuelTank.readFromNBT(nbt.func_74775_l("fuelTank"));
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("smeltingTicks", this.processTicks);
        this.writeStandardItemsToNBT(nbt);
        if (this.oilTank.getFluid() != null) {
            nbt.func_74782_a("oilTank", (NBTBase)this.oilTank.writeToNBT(new NBTTagCompound()));
        }
        if (this.fuelTank.getFluid() != null) {
            nbt.func_74782_a("fuelTank", (NBTBase)this.fuelTank.writeToNBT(new NBTTagCompound()));
        }
    }

    @Override
    protected ItemStack[] getContainingItems() {
        return this.containingItems;
    }

    public String func_145825_b() {
        return GCCoreUtil.translate("container.refinery.name");
    }

    public boolean func_145818_k_() {
        return true;
    }

    public int[] func_94128_d(int side) {
        return new int[]{0, 1, 2};
    }

    public boolean func_102007_a(int slotID, ItemStack itemstack, int side) {
        if (this.func_94041_b(slotID, itemstack)) {
            switch (slotID) {
                case 0: {
                    return itemstack.func_77973_b() instanceof ItemElectricBase && ((ItemElectricBase)itemstack.func_77973_b()).getElectricityStored(itemstack) > 0.0f;
                }
                case 1: {
                    FluidStack stack = FluidContainerRegistry.getFluidForFilledItem((ItemStack)itemstack);
                    return stack != null && stack.getFluid() != null && stack.getFluid().getName().equalsIgnoreCase("oil");
                }
                case 2: {
                    return FluidContainerRegistry.isEmptyContainer((ItemStack)itemstack);
                }
            }
            return false;
        }
        return false;
    }

    public boolean func_102008_b(int slotID, ItemStack itemstack, int side) {
        if (this.func_94041_b(slotID, itemstack)) {
            switch (slotID) {
                case 0: {
                    return itemstack.func_77973_b() instanceof ItemElectricBase && ((ItemElectricBase)itemstack.func_77973_b()).getElectricityStored(itemstack) <= 0.0f || !this.shouldPullEnergy();
                }
                case 1: {
                    return FluidContainerRegistry.isEmptyContainer((ItemStack)itemstack);
                }
                case 2: {
                    FluidStack stack = FluidContainerRegistry.getFluidForFilledItem((ItemStack)itemstack);
                    return stack != null && stack.getFluid() != null && stack.getFluid().getName().equalsIgnoreCase("fuel");
                }
            }
            return false;
        }
        return false;
    }

    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        switch (slotID) {
            case 0: {
                return itemstack != null && ItemElectricBase.isElectricItem(itemstack.func_77973_b());
            }
            case 1: {
                FluidStack stack = FluidContainerRegistry.getFluidForFilledItem((ItemStack)itemstack);
                return stack != null && stack.getFluid() != null && stack.getFluid().getName().equalsIgnoreCase("oil") || FluidContainerRegistry.isContainer((ItemStack)itemstack);
            }
            case 2: {
                FluidStack stack2 = FluidContainerRegistry.getFluidForFilledItem((ItemStack)itemstack);
                return stack2 != null && stack2.getFluid() != null && stack2.getFluid().getName().equalsIgnoreCase("fuel") || FluidContainerRegistry.isContainer((ItemStack)itemstack);
            }
        }
        return false;
    }

    @Override
    public boolean shouldUseEnergy() {
        return this.canProcess();
    }

    @Override
    public ForgeDirection getElectricInputDirection() {
        return ForgeDirection.UP;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        if (from.equals((Object)ForgeDirection.getOrientation((int)(this.func_145832_p() + 2 ^ 1)))) {
            return this.fuelTank.getFluid() != null && this.fuelTank.getFluidAmount() > 0;
        }
        return false;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (from.equals((Object)ForgeDirection.getOrientation((int)(this.func_145832_p() + 2 ^ 1)))) {
            return this.fuelTank.drain(resource.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (from.equals((Object)ForgeDirection.getOrientation((int)(this.func_145832_p() + 2 ^ 1)))) {
            return this.drain(from, new FluidStack(GalacticraftCore.fluidFuel, maxDrain), doDrain);
        }
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        if (from.equals((Object)ForgeDirection.getOrientation((int)(this.func_145832_p() + 2)))) {
            return this.oilTank.getFluid() == null || this.oilTank.getFluidAmount() < this.oilTank.getCapacity();
        }
        return false;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        String liquidName;
        int used = 0;
        if (from.equals((Object)ForgeDirection.getOrientation((int)(this.func_145832_p() + 2))) && (liquidName = FluidRegistry.getFluidName((FluidStack)resource)) != null && liquidName.equalsIgnoreCase("Oil")) {
            used = this.oilTank.fill(resource, doFill);
        }
        return used;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        FluidTankInfo[] tankInfo = new FluidTankInfo[]{};
        if (from == ForgeDirection.getOrientation((int)(this.func_145832_p() + 2))) {
            tankInfo = new FluidTankInfo[]{new FluidTankInfo((IFluidTank)this.oilTank)};
        } else if (from == ForgeDirection.getOrientation((int)(this.func_145832_p() + 2 ^ 1))) {
            tankInfo = new FluidTankInfo[]{new FluidTankInfo((IFluidTank)this.fuelTank)};
        }
        return tankInfo;
    }
}

