/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.denseores;

import com.rwtema.denseores.DenseOre;
import com.rwtema.denseores.LogHelper;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.List;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.data.AnimationMetadataSection;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TextureOre
extends TextureAtlasSprite {
    private int n;
    private ResourceLocation textureLocation;
    public String name;
    public String base;
    public int type;
    public BufferedImage output_image = null;
    private int renderType = 0;

    public static String getDerivedName(String s2) {
        String s1 = "minecraft";
        int ind = s2.indexOf(58);
        if (ind >= 0) {
            if (ind > 1) {
                s1 = s2.substring(0, ind);
            }
            s2 = s2.substring(ind + 1, s2.length());
        }
        s1 = s1.toLowerCase();
        return "denseores:" + s1 + "/" + s2;
    }

    public TextureOre(DenseOre denseOre) {
        this(denseOre.texture, denseOre.underlyingBlocktexture);
        this.renderType = denseOre.rendertype;
    }

    public TextureOre(String par1Str, String base) {
        super(TextureOre.getDerivedName(par1Str));
        this.name = par1Str;
        this.base = base;
    }

    public boolean hasCustomLoader(IResourceManager manager, ResourceLocation location) {
        ResourceLocation location1 = new ResourceLocation(location.func_110624_b(), String.format("%s/%s%s", "textures", location.func_110623_a(), ".png"));
        try {
            manager.func_110536_a(location1);
            LogHelper.info("Dense Ores: Detected override for " + this.name, new Object[0]);
            return false;
        }
        catch (IOException e) {
            return true;
        }
    }

    public static ResourceLocation getBlockResource(String s2) {
        String s1 = "minecraft";
        int ind = s2.indexOf(58);
        if (ind >= 0) {
            if (ind > 1) {
                s1 = s2.substring(0, ind);
            }
            s2 = s2.substring(ind + 1, s2.length());
        }
        s1 = s1.toLowerCase();
        s2 = "textures/blocks/" + s2 + ".png";
        return new ResourceLocation(s1, s2);
    }

    public boolean load(IResourceManager manager, ResourceLocation location) {
        int w;
        BufferedImage stone_image;
        AnimationMetadataSection animation;
        int mp = Minecraft.func_71410_x().field_71474_y.field_151442_I;
        BufferedImage[] ore_image = new BufferedImage[1 + mp];
        try {
            IResource iresource = manager.func_110536_a(TextureOre.getBlockResource(this.name));
            IResource iresourceBase = manager.func_110536_a(TextureOre.getBlockResource(this.base));
            ore_image[0] = ImageIO.read(iresource.func_110527_b());
            animation = (AnimationMetadataSection)iresource.func_110526_a("animation");
            stone_image = ImageIO.read(iresourceBase.func_110527_b());
            w = ore_image[0].getWidth();
            if (stone_image.getWidth() != w) {
                IResource resource;
                List resourcePacks = manager.func_135056_b(TextureOre.getBlockResource(this.base));
                for (int i = resourcePacks.size() - 1; i >= 0 && (stone_image = ImageIO.read((resource = (IResource)resourcePacks.get(i)).func_110527_b())).getWidth() != w; --i) {
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return true;
        }
        if (stone_image.getWidth() != w) {
            LogHelper.error("Error generating texture" + this.name + ". Unable to find base texture with same size.");
            return true;
        }
        int h = ore_image[0].getHeight();
        this.output_image = new BufferedImage(w, h, 2);
        int[] ore_data = new int[w * w];
        int[] stone_data = new int[w * w];
        stone_image.getRGB(0, 0, w, w, stone_data, 0, w);
        for (int y = 0; y < h; y += w) {
            ore_image[0].getRGB(0, y, w, w, ore_data, 0, w);
            int[] new_data = TextureOre.createDenseTexture(w, ore_data, stone_data, this.renderType);
            this.output_image.setRGB(0, y, w, w, new_data, 0, w);
        }
        ore_image[0] = this.output_image;
        this.func_180598_a(ore_image, animation);
        LogHelper.info("Dense Ores: Succesfully generated dense ore texture for '" + this.name + "' with background '" + this.base + "'. Place " + this.name + "_dense.png in the assets folder to override.", new Object[0]);
        return false;
    }

    private static int[] createDenseTexture(int w, int[] ore_data, int[] stone_data, int renderType) {
        int[] dy2;
        int[] dx2;
        int[] new_data = new int[w * w];
        boolean[] same = new boolean[w * w];
        for (int i = 0; i < ore_data.length; ++i) {
            if (TextureOre.getAlpha(ore_data[i]) == 0) {
                same[i] = true;
                ore_data[i] = stone_data[i];
            } else {
                int b;
                int g;
                int r;
                same[i] = ore_data[i] == stone_data[i] ? true : (r = Math.abs(TextureOre.getRed(ore_data[i]) - TextureOre.getRed(stone_data[i]))) + (g = Math.abs(TextureOre.getGreen(ore_data[i]) - TextureOre.getGreen(stone_data[i]))) + (b = Math.abs(TextureOre.getBlue(ore_data[i]) - TextureOre.getBlue(stone_data[i]))) < 20;
            }
            new_data[i] = ore_data[i];
        }
        switch (renderType) {
            default: {
                dx2 = new int[]{-1, 2, 3};
                dy2 = new int[]{-1, 0, 1};
                break;
            }
            case 1: {
                dx2 = new int[]{-1, 1, 0, 0, -1, -1, 1, 1, -2, 2, 0, 0};
                dy2 = new int[]{0, 0, -1, 1, -1, 1, -1, 1, 0, 0, -2, 2};
                break;
            }
            case 2: {
                dx2 = new int[]{-1, 0, 1};
                dy2 = new int[]{-1, 0, 1};
                break;
            }
            case 3: {
                int[] dx2 = new int[]{-2, 2, 1, 1};
                int[] dy2 = new int[]{1, 1, -2, 2};
            }
            case 4: {
                dx2 = new int[]{-6, -3, 3, 6};
                dy2 = new int[]{0, 0, 0, 0};
                break;
            }
            case 5: {
                dx2 = new int[]{-5, -5, 5, 5};
                dy2 = new int[]{-5, 5, -5, 5};
                break;
            }
            case 6: {
                dx2 = new int[]{0, 1, 2, 3};
                dy2 = new int[]{0, -3, 2, -1};
                break;
            }
            case 7: {
                dx2 = new int[]{-1, 1, 0, 0};
                dy2 = new int[]{0, 0, -1, 1};
            }
        }
        block10: for (int i = 0; i < ore_data.length; ++i) {
            int x = i % w;
            int y = (i - x) / w;
            if (!same[i]) continue;
            for (int j = 0; j < dx2.length; ++j) {
                int new_x = x + dx2[j];
                int new_y = y + dy2[j];
                if (new_x < 0 || new_x >= w || new_y < 0 || new_y >= w || same[new_x + new_y * w]) continue;
                new_data[i] = ore_data[new_x + new_y * w];
                continue block10;
            }
        }
        return new_data;
    }

    public static int getAlpha(int col) {
        return (col & 0xFF000000) >> 24;
    }

    public static int getRed(int col) {
        return (col & 0xFF0000) >> 16;
    }

    public static int getGreen(int col) {
        return (col & 0xFF00) >> 8;
    }

    public static int getBlue(int col) {
        return col & 0xFF;
    }

    public static int makeCol(int red, int green, int blue, int alpha) {
        return alpha << 24 | red << 16 | green << 8 | blue;
    }
}

