/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.denseores;

import com.rwtema.denseores.BlockDenseOre;
import com.rwtema.denseores.DenseOresMod;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class WorldGenOres
implements IWorldGenerator {
    private static final String DENSEORES = "DenseOres";
    private static Random rand = new Random();

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        Chunk chunk = world.func_72964_e(chunkX, chunkZ);
        BlockDenseOre dense_ore_blocks = DenseOresMod.block;
        int id = 0;
        while (true) {
            if (id >= BlockDenseOre.maxMetdata) break;
            if (dense_ore_blocks.isValid(id)) {
                this.genChunk(chunk, random, dense_ore_blocks, id);
            }
            ++id;
        }
    }

    public void genChunk(Chunk chunk, Random random, BlockDenseOre dense_ore_blocks, int id) {
        for (int i = 0; i < 1000; ++i) {
            int x = random.nextInt(BlockDenseOre.maxMetdata);
            int y = 1 + random.nextInt(80);
            int z = random.nextInt(BlockDenseOre.maxMetdata);
            Block block = chunk.func_177438_a(x, y, z);
            if (block != dense_ore_blocks.getBlock(id) || chunk.func_177418_c(new BlockPos(x, y, z)) != dense_ore_blocks.entry[id].metadata) continue;
            this.overrideChunkBlock(chunk, x, y, z, dense_ore_blocks, id);
        }
    }

    public boolean overrideChunkBlock(Chunk chunk, int x, int y, int z, BlockDenseOre dense_ore_blocks, int id) {
        int i1 = z << 4 | x;
        Block block1 = chunk.func_177438_a(x, y, z);
        int k1 = chunk.func_177418_c(new BlockPos(x, y, z));
        if (block1 == dense_ore_blocks && k1 == id) {
            return false;
        }
        ExtendedBlockStorage extendedblockstorage = chunk.func_76587_i()[y >> 4];
        if (extendedblockstorage == null) {
            return false;
        }
        return extendedblockstorage.func_150819_a(x, y & 0xF, z) == dense_ore_blocks;
    }

    @SubscribeEvent
    public void retroGen(ChunkDataEvent.Load event) {
        NBTTagCompound chunkData = event.getData();
        NBTTagCompound rgen = chunkData.func_74775_l(DENSEORES);
        boolean regen = false;
        long worldSeed = event.world.func_72905_C();
        rand.setSeed(worldSeed);
        long xSeed = rand.nextLong() >> 3;
        long zSeed = rand.nextLong() >> 3;
        long chunkSeed = xSeed * (long)event.getChunk().field_76635_g + zSeed * (long)event.getChunk().field_76647_h ^ worldSeed;
        rand.setSeed(chunkSeed);
        BlockDenseOre dense_ore_blocks = DenseOresMod.block;
        NBTTagCompound b = rgen.func_74775_l(dense_ore_blocks.func_149739_a());
        int id = 0;
        while (true) {
            if (id >= BlockDenseOre.maxMetdata) break;
            if (dense_ore_blocks.isValid(id) && dense_ore_blocks.getEntry((int)id).retroGenId != b.func_74762_e(id + "")) {
                this.genChunk(event.getChunk(), rand, dense_ore_blocks, id);
                regen = true;
            }
            ++id;
        }
        if (regen) {
            event.getChunk().func_76630_e();
        }
    }

    @SubscribeEvent
    public void retroGenSave(ChunkDataEvent.Save event) {
        NBTTagCompound chunkData = event.getData();
        NBTTagCompound rgen = chunkData.func_74775_l(DENSEORES);
        BlockDenseOre dense_ore_blocks = DenseOresMod.block;
        NBTTagCompound b = rgen.func_74775_l(dense_ore_blocks.func_149739_a());
        int id = 0;
        while (true) {
            if (id >= BlockDenseOre.maxMetdata) break;
            if (dense_ore_blocks.isValid(id)) {
                b.func_74768_a(id + "", dense_ore_blocks.getEntry((int)id).retroGenId);
            }
            ++id;
        }
        rgen.func_74782_a(dense_ore_blocks.func_149739_a(), (NBTBase)b);
        chunkData.func_74782_a(DENSEORES, (NBTBase)rgen);
    }
}

