/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.denseores;

import com.rwtema.denseores.BlockDenseOre;
import com.rwtema.denseores.DenseOre;
import com.rwtema.denseores.DenseOresMod;
import com.rwtema.denseores.ItemBlockDenseOre;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;

public class DenseOresRegistry {
    public static Map<Integer, DenseOre> ores = new HashMap<Integer, DenseOre>();
    public static String blockPrefix = "denseores";

    public static void initVanillaOres() {
        DenseOresRegistry.registerOre(0, "minecraft:iron_ore", 0, 1.0, "stone", "iron_ore", 0, 0);
        DenseOresRegistry.registerOre(1, "minecraft:gold_ore", 0, 1.0, "stone", "gold_ore", 0, 0);
        DenseOresRegistry.registerOre(2, "minecraft:lapis_ore", 0, 1.0, "stone", "lapis_ore", 0, 0);
        DenseOresRegistry.registerOre(3, "minecraft:diamond_ore", 0, 1.0, "stone", "diamond_ore", 0, 0);
        DenseOresRegistry.registerOre(4, "minecraft:emerald_ore", 0, 1.0, "stone", "emerald_ore", 0, 0);
        DenseOresRegistry.registerOre(5, "minecraft:redstone_ore", 0, 1.0, "stone", "redstone_ore", 0, 0);
        DenseOresRegistry.registerOre(6, "minecraft:coal_ore", 0, 1.0, "stone", "coal_ore", 0, 0);
        DenseOresRegistry.registerOre(7, "minecraft:quartz_ore", 0, 1.0, "netherrack", "quartz_ore", 0, 0);
    }

    public static void buildBlocks() {
        int maxOre = 0;
        for (DenseOre ore : ores.values()) {
            maxOre = Math.max(ore.id, maxOre);
        }
        BlockDenseOre.maxMetdata = maxOre + 1;
        DenseOresMod.block = new BlockDenseOre();
        GameRegistry.registerBlock((Block)DenseOresMod.block, ItemBlockDenseOre.class, (String)"blockDenseOre");
        for (DenseOre ore : ores.values()) {
            DenseOresMod.block.setEntry(ore.id, ore);
            ore.setBlock(DenseOresMod.block);
        }
    }

    public static DenseOre registerOre(int id, String baseBlock, int metadata, double prob, String underlyingBlock, String texture, int retroGenId, int renderType) {
        if ("".equals(baseBlock) || "minecraft:air".equals(baseBlock)) {
            return null;
        }
        int ind = baseBlock.indexOf(58);
        if (ind > 1) {
            String modname = baseBlock.substring(0, ind);
            if (!"minecraft".equals(modname) && !Loader.isModLoaded((String)modname)) {
                return null;
            }
        } else {
            throw new RuntimeException("Block " + id + " is not formatted correctly. Must be in the form mod:block");
        }
        DenseOre ore = new DenseOre(id, baseBlock, metadata, prob, underlyingBlock, texture, retroGenId, renderType);
        ores.put(id, ore);
        return ore;
    }

    public static boolean hasEntry(int id) {
        return ores.containsKey(id);
    }

    public static void buildOreDictionary() {
        for (DenseOre ore : ores.values()) {
            int meta = ore.id;
            if (!DenseOresMod.block.isValid(meta)) continue;
            Block b = DenseOresMod.block.getBlock(meta);
            for (int oreid : OreDictionary.getOreIDs((ItemStack)new ItemStack(b, 1, ore.metadata))) {
                String k = OreDictionary.getOreName((int)oreid);
                if (!k.startsWith("ore")) continue;
                ore.baseOreDictionary = k;
                ore.oreDictionary = k = "dense" + k;
                OreDictionary.registerOre((String)k, (ItemStack)new ItemStack((Block)DenseOresMod.block, 1, meta));
            }
        }
    }
}

