/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.denseores.ModelBuilder;

import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.LinkedList;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.util.EnumFacing;

public class Bakellator {
    int side;
    int[] rawIntBuffer = new int[28];
    int vertexNo;
    int rawBufferIndex = 0;
    boolean isDrawing;
    int tintIndex;
    int color;
    LinkedList<BakedQuad> generalQuads;
    ArrayList<LinkedList<BakedQuad>> faceQuads;
    int normal;

    public SimpleBakedModel bake(TextureAtlasSprite texture) {
        return this.bake(texture, true, true, ItemCameraTransforms.field_178357_a);
    }

    public SimpleBakedModel bake(TextureAtlasSprite texture, boolean ambientOcclusion, boolean gui3d, ItemCameraTransforms camera) {
        SimpleBakedModel model = new SimpleBakedModel(this.generalQuads, this.faceQuads, ambientOcclusion, gui3d, texture, camera);
        this.reset();
        return model;
    }

    public Bakellator() {
        this.reset();
    }

    public void reset() {
        this.faceQuads = new ArrayList(6);
        this.generalQuads = new LinkedList();
        for (int i = 0; i < 6; ++i) {
            this.faceQuads.set(i, new LinkedList());
        }
        this.vertexNo = 0;
        this.side = 6;
        this.isDrawing = false;
        this.color = -1;
        this.tintIndex = -1;
        this.normal = 0;
    }

    public void setGeneral() {
        this.side = 6;
    }

    public void setFaceSide(int side) {
        this.side = side;
    }

    public void setFaceSide(EnumFacing facing) {
        this.side = facing.ordinal();
    }

    public void startDrawingQuads() {
        if (this.isDrawing) {
            throw new RuntimeException("Already drawing");
        }
        this.reset();
        this.isDrawing = true;
    }

    public void setTintIndex(int tintIndex) {
        this.tintIndex = tintIndex;
    }

    public void setColorOpaque_F(float r, float g, float b) {
        this.setColorOpaque((int)(r * 255.0f), (int)(g * 255.0f), (int)(b * 255.0f));
    }

    public void setColorRGBA_F(float r, float g, float b, float a) {
        this.setColorRGBA((int)(r * 255.0f), (int)(g * 255.0f), (int)(b * 255.0f), (int)(a * 255.0f));
    }

    public void setColorOpaque(int r, int g, int b) {
        this.setColorRGBA(r, g, b, 255);
    }

    public void setColorOpaque_I(int col) {
        int j = col >> 16 & 0xFF;
        int k = col >> 8 & 0xFF;
        int l = col & 0xFF;
        this.setColorOpaque(j, k, l);
    }

    public void setColorRGBA_I(int col, int alpha) {
        int k = col >> 16 & 0xFF;
        int l = col >> 8 & 0xFF;
        int i1 = col & 0xFF;
        this.setColorRGBA(k, l, i1, alpha);
    }

    public void setColorRGBA(int r, int g, int b, int a) {
        if (r > 255) {
            r = 255;
        }
        if (g > 255) {
            g = 255;
        }
        if (b > 255) {
            b = 255;
        }
        if (a > 255) {
            a = 255;
        }
        if (r < 0) {
            r = 0;
        }
        if (g < 0) {
            g = 0;
        }
        if (b < 0) {
            b = 0;
        }
        if (a < 0) {
            a = 0;
        }
        this.color = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? a << 24 | b << 16 | g << 8 | r : r << 24 | g << 16 | b << 8 | a;
    }

    public void setColorOpaque_B(byte p_154352_1_, byte p_154352_2_, byte p_154352_3_) {
        this.setColorOpaque(p_154352_1_ & 0xFF, p_154352_2_ & 0xFF, p_154352_3_ & 0xFF);
    }

    public void setNormal(float p_78375_1_, float p_78375_2_, float p_78375_3_) {
        byte b0 = (byte)(p_78375_1_ * 127.0f);
        byte b1 = (byte)(p_78375_2_ * 127.0f);
        byte b2 = (byte)(p_78375_3_ * 127.0f);
        this.normal = b0 & 0xFF | (b1 & 0xFF) << 8 | (b2 & 0xFF) << 16;
    }

    public void addVertexWithUV(double x, double y, double z, double u, double v) {
        this.rawIntBuffer[this.rawBufferIndex] = Float.floatToRawIntBits((float)x);
        this.rawIntBuffer[this.rawBufferIndex + 1] = Float.floatToRawIntBits((float)y);
        this.rawIntBuffer[this.rawBufferIndex + 2] = Float.floatToRawIntBits((float)z);
        this.rawIntBuffer[this.rawBufferIndex + 3] = this.color;
        this.rawIntBuffer[this.rawBufferIndex + 4] = Float.floatToRawIntBits((float)u);
        this.rawIntBuffer[this.rawBufferIndex + 5] = Float.floatToRawIntBits((float)v);
        this.rawBufferIndex += 7;
        ++this.vertexNo;
        if (this.vertexNo == 4) {
            BakedQuad quad = new BakedQuad(this.rawIntBuffer, this.tintIndex, FaceBakery.func_178410_a((int[])this.rawIntBuffer));
            if (this.side == 6) {
                this.generalQuads.add(quad);
            } else {
                this.faceQuads.get(this.side).add(quad);
            }
        }
    }
}

