/*
 * Decompiled with CFR 0.152.
 */
package com.chunkbase.mod.forge.mods.villageinfossp.platform;

import com.chunkbase.mod.forge.mods.villageinfossp.ModSettings;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class ModSettingsForge
implements ModSettings {
    private static final String COMMENT_LOGGING = "Enable logging";
    private static final String KEY_LOGGING = "logging";
    public static final String KEY_LOCAL_REFRESH = "refreshticks";
    public static final String COMMENT_LOCAL_REFRESH = "Refresh interval in ticks for local games";
    private Configuration forgeConfig;
    private boolean logging = false;
    private int localRefresh = 10;

    public ModSettingsForge(Configuration forgeConfig) {
        this.forgeConfig = forgeConfig;
        forgeConfig.load();
        this.syncWithForge();
    }

    @Override
    public boolean isLoggingEnabled() {
        return this.logging;
    }

    @Override
    public int getLocalRefreshInterval() {
        return this.localRefresh;
    }

    private void saveToForge() {
        this.forgeConfig.removeCategory(this.forgeConfig.getCategory("general"));
        this.syncWithForge();
    }

    private void syncWithForge() {
        Property logging = this.forgeConfig.get("general", KEY_LOGGING, this.logging);
        logging.comment = COMMENT_LOGGING;
        this.logging = logging.getBoolean(this.logging);
        Property localRefresh = this.forgeConfig.get("general", KEY_LOCAL_REFRESH, this.localRefresh);
        localRefresh.comment = COMMENT_LOCAL_REFRESH;
        this.localRefresh = localRefresh.getInt(this.localRefresh);
        this.forgeConfig.save();
    }
}

