/*
 * Decompiled with CFR 0.152.
 */
package mapwriter;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import mapwriter.BackgroundExecutor;
import mapwriter.BlockColourGen;
import mapwriter.ChunkManager;
import mapwriter.MwUtil;
import mapwriter.Render;
import mapwriter.forge.MwConfig;
import mapwriter.forge.MwForge;
import mapwriter.forge.MwKeyHandler;
import mapwriter.gui.MwGui;
import mapwriter.gui.MwGuiMarkerDialog;
import mapwriter.map.MapTexture;
import mapwriter.map.MapView;
import mapwriter.map.Marker;
import mapwriter.map.MarkerManager;
import mapwriter.map.MiniMap;
import mapwriter.map.Trail;
import mapwriter.map.UndergroundTexture;
import mapwriter.overlay.OverlaySlime;
import mapwriter.region.BlockColours;
import mapwriter.region.RegionManager;
import mapwriter.tasks.CloseRegionManagerTask;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGameOver;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class Mw {
    public Minecraft mc = null;
    public String worldName = "default";
    private String serverName = "default";
    private int serverPort = 0;
    public MwConfig config;
    public MwConfig worldConfig = null;
    private final File configDir;
    private final File saveDir;
    public File worldDir = null;
    public File imageDir = null;
    public boolean linearTextureScalingEnabled = true;
    public int coordsMode = 0;
    public boolean undergroundMode = false;
    public boolean teleportEnabled = true;
    public String teleportCommand = "tp";
    public int defaultTeleportHeight = 80;
    public int maxZoom = 5;
    public int minZoom = -5;
    public boolean useSavedBlockColours = false;
    public int maxChunkSaveDistSq = 16384;
    public boolean mapPixelSnapEnabled = true;
    public int textureSize = 2048;
    public int configTextureSize = 2048;
    public int maxDeathMarkers = 3;
    public int chunksPerTick = 5;
    public boolean portNumberInWorldNameEnabled = true;
    public String saveDirOverride = "";
    public boolean regionFileOutputEnabledSP = true;
    public boolean regionFileOutputEnabledMP = true;
    public int backgroundTextureMode = 0;
    private boolean onPlayerDeathAlreadyFired = false;
    public boolean ready = false;
    public boolean multiplayer = false;
    public int tickCounter = 0;
    public List<Integer> dimensionList = new ArrayList<Integer>();
    public double playerX = 0.0;
    public double playerZ = 0.0;
    public double playerY = 0.0;
    public int playerXInt = 0;
    public int playerYInt = 0;
    public int playerZInt = 0;
    public double playerHeading = 0.0;
    public int playerDimension = 0;
    public double mapRotationDegrees = 0.0;
    public static final String catWorld = "world";
    public static final String catMarkers = "markers";
    public static final String catOptions = "options";
    public static final String worldDirConfigName = "mapwriter.cfg";
    public static final String blockColourSaveFileName = "MapWriterBlockColours.txt";
    public static final String blockColourOverridesFileName = "MapWriterBlockColourOverrides.txt";
    public MapTexture mapTexture = null;
    public UndergroundTexture undergroundMapTexture = null;
    public BackgroundExecutor executor = null;
    public MiniMap miniMap = null;
    public MarkerManager markerManager = null;
    public BlockColours blockColours = null;
    public RegionManager regionManager = null;
    public ChunkManager chunkManager = null;
    public Trail playerTrail = null;
    public static Mw instance;

    public Mw(MwConfig config) {
        this.mc = Minecraft.func_71410_x();
        this.config = config;
        this.saveDir = new File(this.mc.field_71412_D, "saves");
        this.configDir = new File(this.mc.field_71412_D, "config");
        this.ready = false;
        RegionManager.logger = MwForge.logger;
        instance = this;
    }

    public String getWorldName() {
        IntegratedServer server;
        String worldName = this.multiplayer ? (this.portNumberInWorldNameEnabled ? String.format("%s_%d", this.serverName, this.serverPort) : String.format("%s", this.serverName)) : ((server = this.mc.func_71401_C()) != null ? server.func_71270_I() : "sp_world");
        worldName = MwUtil.mungeString(worldName);
        if (worldName == "") {
            worldName = "default";
        }
        return worldName;
    }

    public void loadConfig() {
        this.config.load();
        this.linearTextureScalingEnabled = this.config.getOrSetBoolean(catOptions, "linearTextureScaling", this.linearTextureScalingEnabled);
        this.useSavedBlockColours = this.config.getOrSetBoolean(catOptions, "useSavedBlockColours", this.useSavedBlockColours);
        this.teleportEnabled = this.config.getOrSetBoolean(catOptions, "teleportEnabled", this.teleportEnabled);
        this.teleportCommand = this.config.get(catOptions, "teleportCommand", this.teleportCommand).getString();
        this.coordsMode = this.config.getOrSetInt(catOptions, "coordsMode", this.coordsMode, 0, 2);
        this.maxChunkSaveDistSq = this.config.getOrSetInt(catOptions, "maxChunkSaveDistSq", this.maxChunkSaveDistSq, 1, 65536);
        this.mapPixelSnapEnabled = this.config.getOrSetBoolean(catOptions, "mapPixelSnapEnabled", this.mapPixelSnapEnabled);
        this.maxDeathMarkers = this.config.getOrSetInt(catOptions, "maxDeathMarkers", this.maxDeathMarkers, 0, 1000);
        this.chunksPerTick = this.config.getOrSetInt(catOptions, "chunksPerTick", this.chunksPerTick, 1, 500);
        this.saveDirOverride = this.config.get(catOptions, "saveDirOverride", this.saveDirOverride).getString();
        this.portNumberInWorldNameEnabled = this.config.getOrSetBoolean(catOptions, "portNumberInWorldNameEnabled", this.portNumberInWorldNameEnabled);
        this.undergroundMode = this.config.getOrSetBoolean(catOptions, "undergroundMode", this.undergroundMode);
        this.regionFileOutputEnabledSP = this.config.getOrSetBoolean(catOptions, "regionFileOutputEnabledSP", this.regionFileOutputEnabledSP);
        this.regionFileOutputEnabledMP = this.config.getOrSetBoolean(catOptions, "regionFileOutputEnabledMP", this.regionFileOutputEnabledMP);
        this.backgroundTextureMode = this.config.getOrSetInt(catOptions, "backgroundTextureMode", this.backgroundTextureMode, 0, 1);
        this.maxZoom = this.config.getOrSetInt(catOptions, "zoomOutLevels", this.maxZoom, 1, 256);
        this.minZoom = -this.config.getOrSetInt(catOptions, "zoomInLevels", -this.minZoom, 1, 256);
        this.configTextureSize = this.config.getOrSetInt(catOptions, "textureSize", this.configTextureSize, 1024, 8192);
        this.setTextureSize();
    }

    public void loadWorldConfig() {
        File worldConfigFile = new File(this.worldDir, worldDirConfigName);
        this.worldConfig = new MwConfig(worldConfigFile);
        this.worldConfig.load();
        this.dimensionList.clear();
        this.worldConfig.getIntList(catWorld, "dimensionList", this.dimensionList);
        this.addDimension(0);
        this.cleanDimensionList();
    }

    public void saveConfig() {
        this.config.setBoolean(catOptions, "linearTextureScaling", this.linearTextureScalingEnabled);
        this.config.setBoolean(catOptions, "useSavedBlockColours", this.useSavedBlockColours);
        this.config.setInt(catOptions, "textureSize", this.configTextureSize);
        this.config.setInt(catOptions, "coordsMode", this.coordsMode);
        this.config.setInt(catOptions, "maxChunkSaveDistSq", this.maxChunkSaveDistSq);
        this.config.setBoolean(catOptions, "mapPixelSnapEnabled", this.mapPixelSnapEnabled);
        this.config.setInt(catOptions, "maxDeathMarkers", this.maxDeathMarkers);
        this.config.setInt(catOptions, "chunksPerTick", this.chunksPerTick);
        this.config.setBoolean(catOptions, "undergroundMode", this.undergroundMode);
        this.config.setInt(catOptions, "backgroundTextureMode", this.backgroundTextureMode);
        this.config.save();
    }

    public void saveWorldConfig() {
        this.worldConfig.setIntList(catWorld, "dimensionList", this.dimensionList);
        this.worldConfig.save();
    }

    public void setTextureSize() {
        if (this.configTextureSize != this.textureSize) {
            int textureSize;
            int maxTextureSize = Render.getMaxTextureSize();
            for (textureSize = 1024; textureSize <= maxTextureSize && textureSize <= this.configTextureSize; textureSize *= 2) {
            }
            MwUtil.log("GL reported max texture size = %d", maxTextureSize);
            MwUtil.log("texture size from config = %d", this.configTextureSize);
            MwUtil.log("setting map texture size to = %d", textureSize /= 2);
            this.textureSize = textureSize;
            if (this.ready) {
                this.reloadMapTexture();
            }
        }
    }

    public void updatePlayer() {
        this.playerX = this.mc.field_71439_g.field_70165_t;
        this.playerY = this.mc.field_71439_g.field_70163_u;
        this.playerZ = this.mc.field_71439_g.field_70161_v;
        this.playerXInt = (int)Math.floor(this.playerX);
        this.playerYInt = (int)Math.floor(this.playerY);
        this.playerZInt = (int)Math.floor(this.playerZ);
        this.playerHeading = Math.toRadians(this.mc.field_71439_g.field_70177_z) + 1.5707963267948966;
        this.mapRotationDegrees = -this.mc.field_71439_g.field_70177_z + 180.0f;
    }

    public void addDimension(int dimension) {
        int i = this.dimensionList.indexOf(dimension);
        if (i < 0) {
            this.dimensionList.add(dimension);
        }
    }

    public void cleanDimensionList() {
        ArrayList<Integer> dimensionListCopy = new ArrayList<Integer>(this.dimensionList);
        this.dimensionList.clear();
        Iterator i$ = dimensionListCopy.iterator();
        while (i$.hasNext()) {
            int dimension = (Integer)i$.next();
            this.addDimension(dimension);
        }
    }

    public void toggleMarkerMode() {
        this.markerManager.nextGroup();
        this.markerManager.update();
        this.mc.field_71439_g.func_145747_a((IChatComponent)new ChatComponentText("group " + this.markerManager.getVisibleGroupName() + " selected"));
    }

    public void teleportTo(int x, int y, int z) {
        if (this.teleportEnabled) {
            this.mc.field_71439_g.func_71165_d(String.format("/%s %d %d %d", this.teleportCommand, x, y, z));
        } else {
            MwUtil.printBoth("teleportation is disabled in mapwriter.cfg");
        }
    }

    public void warpTo(String name) {
        if (this.teleportEnabled) {
            this.mc.field_71439_g.func_71165_d(String.format("/warp %s", name));
        } else {
            MwUtil.printBoth("teleportation is disabled in mapwriter.cfg");
        }
    }

    public void teleportToMapPos(MapView mapView, int x, int y, int z) {
        if (!this.teleportCommand.equals("warp")) {
            double scale = mapView.getDimensionScaling(this.playerDimension);
            this.teleportTo((int)((double)x / scale), y, (int)((double)z / scale));
        } else {
            MwUtil.printBoth("teleport command is set to 'warp', can only warp to markers");
        }
    }

    public void teleportToMarker(Marker marker) {
        if (this.teleportCommand.equals("warp")) {
            this.warpTo(marker.name);
        } else if (marker.dimension == this.playerDimension) {
            this.teleportTo(marker.x, marker.y, marker.z);
        } else {
            MwUtil.printBoth("cannot teleport to marker in different dimension");
        }
    }

    public void loadBlockColourOverrides(BlockColours bc) {
        File f = new File(this.configDir, blockColourOverridesFileName);
        if (f.isFile()) {
            MwUtil.logInfo("loading block colour overrides file %s", f);
            bc.loadFromFile(f);
        } else {
            MwUtil.logInfo("recreating block colour overrides file %s", f);
            BlockColours.writeOverridesFile(f);
            if (f.isFile()) {
                bc.loadFromFile(f);
            } else {
                MwUtil.logError("could not load block colour overrides from file %s", f);
            }
        }
    }

    public void saveBlockColours(BlockColours bc) {
        File f = new File(this.configDir, blockColourSaveFileName);
        MwUtil.logInfo("saving block colours to '%s'", f);
        bc.saveToFile(f);
    }

    public void reloadBlockColours() {
        BlockColours bc = new BlockColours();
        File f = new File(this.configDir, blockColourSaveFileName);
        if (this.useSavedBlockColours && f.isFile()) {
            MwUtil.logInfo("loading block colours from %s", f);
            bc.loadFromFile(f);
            this.loadBlockColourOverrides(bc);
        } else {
            MwUtil.logInfo("generating block colours", new Object[0]);
            this.loadBlockColourOverrides(bc);
            BlockColourGen.genBlockColours(bc);
            this.loadBlockColourOverrides(bc);
            this.saveBlockColours(bc);
        }
        this.blockColours = bc;
    }

    public void reloadMapTexture() {
        UndergroundTexture newTexture;
        MapTexture newMapTexture;
        this.executor.addTask(new CloseRegionManagerTask(this.regionManager));
        this.executor.close();
        MapTexture oldMapTexture = this.mapTexture;
        this.mapTexture = newMapTexture = new MapTexture(this.textureSize, this.linearTextureScalingEnabled);
        if (oldMapTexture != null) {
            oldMapTexture.close();
        }
        this.executor = new BackgroundExecutor();
        this.regionManager = new RegionManager(this.worldDir, this.imageDir, this.blockColours, this.minZoom, this.maxZoom);
        UndergroundTexture oldTexture = this.undergroundMapTexture;
        this.undergroundMapTexture = newTexture = new UndergroundTexture(this, this.textureSize, this.linearTextureScalingEnabled);
        if (oldTexture != null) {
            this.undergroundMapTexture.close();
        }
    }

    public void setCoordsMode(int mode) {
        this.coordsMode = Math.min(Math.max(0, mode), 2);
    }

    public int toggleCoords() {
        this.setCoordsMode((this.coordsMode + 1) % 3);
        return this.coordsMode;
    }

    public void toggleUndergroundMode() {
        this.undergroundMode = !this.undergroundMode;
        this.miniMap.view.setUndergroundMode(this.undergroundMode);
    }

    public void setServerDetails(String hostname, int port) {
        this.serverName = hostname;
        this.serverPort = port;
    }

    public void load() {
        if (this.ready) {
            return;
        }
        if (this.mc.field_71441_e == null || this.mc.field_71439_g == null) {
            MwUtil.log("Mw.load: world or player is null, cannot load yet", new Object[0]);
            return;
        }
        MwUtil.log("Mw.load: loading...", new Object[0]);
        IntegratedServer server = this.mc.func_71401_C();
        this.multiplayer = server == null;
        this.loadConfig();
        this.worldName = this.getWorldName();
        File saveDir = this.saveDir;
        if (this.saveDirOverride.length() > 0) {
            File d = new File(this.saveDirOverride);
            if (d.isDirectory()) {
                saveDir = d;
            } else {
                MwUtil.log("error: no such directory %s", this.saveDirOverride);
            }
        }
        this.worldDir = this.multiplayer ? new File(new File(saveDir, "mapwriter_mp_worlds"), this.worldName) : new File(new File(saveDir, "mapwriter_sp_worlds"), this.worldName);
        this.loadWorldConfig();
        this.imageDir = new File(this.worldDir, "images");
        if (!this.imageDir.exists()) {
            this.imageDir.mkdirs();
        }
        if (!this.imageDir.isDirectory()) {
            MwUtil.log("Mapwriter: ERROR: could not create images directory '%s'", this.imageDir.getPath());
        }
        this.tickCounter = 0;
        this.onPlayerDeathAlreadyFired = false;
        this.markerManager = new MarkerManager();
        this.markerManager.load(this.worldConfig, catMarkers);
        this.playerTrail = new Trail(this, "player");
        this.executor = new BackgroundExecutor();
        this.mapTexture = new MapTexture(this.textureSize, this.linearTextureScalingEnabled);
        this.undergroundMapTexture = new UndergroundTexture(this, this.textureSize, this.linearTextureScalingEnabled);
        this.reloadBlockColours();
        this.regionManager = new RegionManager(this.worldDir, this.imageDir, this.blockColours, this.minZoom, this.maxZoom);
        this.miniMap = new MiniMap(this);
        this.miniMap.view.setDimension(this.mc.field_71439_g.field_71093_bK);
        this.chunkManager = new ChunkManager(this);
        this.ready = true;
    }

    public void close() {
        MwUtil.log("Mw.close: closing...", new Object[0]);
        if (this.ready) {
            this.ready = false;
            this.chunkManager.close();
            this.chunkManager = null;
            this.executor.addTask(new CloseRegionManagerTask(this.regionManager));
            this.regionManager = null;
            MwUtil.log("waiting for %d tasks to finish...", this.executor.tasksRemaining());
            if (this.executor.close()) {
                MwUtil.log("error: timeout waiting for tasks to finish", new Object[0]);
            }
            MwUtil.log("done", new Object[0]);
            this.playerTrail.close();
            this.markerManager.save(this.worldConfig, catMarkers);
            this.markerManager.clear();
            this.miniMap.close();
            this.miniMap = null;
            this.undergroundMapTexture.close();
            this.mapTexture.close();
            this.saveWorldConfig();
            this.saveConfig();
            this.tickCounter = 0;
            OverlaySlime.reset();
        }
    }

    public void onWorldLoad(World world) {
        this.playerDimension = world.field_73011_w.field_76574_g;
        if (this.ready) {
            this.addDimension(this.playerDimension);
            this.miniMap.view.setDimension(this.playerDimension);
        }
    }

    public void onWorldUnload(World world) {
    }

    public void onTick() {
        this.load();
        if (this.ready && this.mc.field_71439_g != null) {
            this.updatePlayer();
            if (this.undergroundMode && this.tickCounter % 30 == 0) {
                this.undergroundMapTexture.update();
            }
            if (this.mc.field_71462_r instanceof GuiGameOver) {
                if (!this.onPlayerDeathAlreadyFired) {
                    this.onPlayerDeath();
                    this.onPlayerDeathAlreadyFired = true;
                }
            } else if (!(this.mc.field_71462_r instanceof MwGui)) {
                this.onPlayerDeathAlreadyFired = false;
                this.miniMap.view.setViewCentreScaled(this.playerX, this.playerZ, this.playerDimension);
                this.miniMap.drawCurrentMap();
            }
            for (int maxTasks = 50; !this.executor.processTaskQueue() && maxTasks > 0; --maxTasks) {
            }
            this.chunkManager.onTick();
            this.mapTexture.processTextureUpdates();
            this.playerTrail.onTick();
            ++this.tickCounter;
        }
    }

    public void onChunkLoad(Chunk chunk) {
        this.load();
        if (chunk != null && chunk.field_76637_e instanceof WorldClient) {
            if (this.ready) {
                this.chunkManager.addChunk(chunk);
            } else {
                MwUtil.logInfo("missed chunk (%d, %d)", chunk.field_76635_g, chunk.field_76647_h);
            }
        }
    }

    public void onChunkUnload(Chunk chunk) {
        if (this.ready && chunk != null && chunk.field_76637_e instanceof WorldClient) {
            this.chunkManager.removeChunk(chunk);
        }
    }

    public void onPlayerDeath() {
        if (this.ready && this.maxDeathMarkers > 0) {
            this.updatePlayer();
            int deleteCount = this.markerManager.countMarkersInGroup("playerDeaths") - this.maxDeathMarkers + 1;
            for (int i = 0; i < deleteCount; ++i) {
                this.markerManager.delMarker(null, "playerDeaths");
            }
            this.markerManager.addMarker(MwUtil.getCurrentDateString(), "playerDeaths", this.playerXInt, this.playerYInt, this.playerZInt, this.playerDimension, -65536);
            this.markerManager.setVisibleGroupName("playerDeaths");
            this.markerManager.update();
        }
    }

    public void onKeyDown(KeyBinding kb) {
        if (this.mc.field_71462_r == null && this.ready) {
            if (kb == MwKeyHandler.keyMapMode) {
                this.miniMap.nextOverlayMode(1);
            } else if (kb == MwKeyHandler.keyMapGui) {
                this.mc.func_147108_a((GuiScreen)new MwGui(this));
            } else if (kb == MwKeyHandler.keyNewMarker) {
                String group = this.markerManager.getVisibleGroupName();
                if (group.equals("none")) {
                    group = "group";
                }
                this.mc.func_147108_a((GuiScreen)new MwGuiMarkerDialog(null, this.markerManager, "", group, this.playerXInt, this.playerYInt, this.playerZInt, this.playerDimension));
            } else if (kb == MwKeyHandler.keyNextGroup) {
                this.markerManager.nextGroup();
                this.markerManager.update();
                this.mc.field_71439_g.func_145747_a((IChatComponent)new ChatComponentText("group " + this.markerManager.getVisibleGroupName() + " selected"));
            } else if (kb == MwKeyHandler.keyTeleport) {
                Marker marker = this.markerManager.getNearestMarkerInDirection(this.playerXInt, this.playerZInt, this.playerHeading);
                if (marker != null) {
                    this.teleportToMarker(marker);
                }
            } else if (kb == MwKeyHandler.keyZoomIn) {
                this.miniMap.view.adjustZoomLevel(-1);
            } else if (kb == MwKeyHandler.keyZoomOut) {
                this.miniMap.view.adjustZoomLevel(1);
            } else if (kb == MwKeyHandler.keyUndergroundMode) {
                this.toggleUndergroundMode();
            }
        }
    }
}

