/*
 * Decompiled with CFR 0.152.
 */
package fyber.redstonepastemod.client;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import fyber.redstonepastemod.BlockRedstonePaste;
import fyber.redstonepastemod.CommonProxy;
import fyber.redstonepastemod.RedstonePasteMod;
import fyber.redstonepastemod.TileEntityRedstonePaste;
import java.awt.Color;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.init.Blocks;
import net.minecraft.util.IIcon;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class RedstonePasteRenderer
implements ISimpleBlockRenderingHandler {
    private Color[] colorlist;
    private Vec3UV[][][] vecs_redstoneRepeaterIdle = null;
    private Vec3UV[][][] vecs_redstoneRepeaterActive = null;
    private Vec3UV[][] vecs_redstoneTorchActive = null;
    private Vec3UV[][] vecs_redstoneTorchIdle = null;
    private Vec3UV[][][] rotatedLockBarVecs = new Vec3UV[3][][];
    Vec3UV[][][] vecs_redstoneComparatorIdle = null;
    Vec3UV[][][] vecs_redstoneComparatorActive = null;

    public void calculateColorList() {
        float cf;
        int n;
        float colorskew = 0.5f;
        Color oncolor = new Color(255, 82, 0);
        Color offcolor = new Color(128, 180, 0);
        Color midcolor = new Color(230, 100, 0);
        String pasteColorOn = RedstonePasteMod.instance.pasteColorOn.replace('#', ' ').trim();
        String pasteColorMid = RedstonePasteMod.instance.pasteColorMid.replace('#', ' ').trim();
        String pasteColorOff = RedstonePasteMod.instance.pasteColorOff.replace('#', ' ').trim();
        Long l_on = 0L;
        Long l_mid = 0L;
        Long l_off = 0L;
        try {
            l_on = Long.parseLong(pasteColorOn, 16);
            l_mid = Long.parseLong(pasteColorMid, 16);
            l_off = Long.parseLong(pasteColorOff, 16);
            oncolor = new Color((int)((l_on & 0xFF0000L) >> 16), (int)((l_on & 0xFF00L) >> 8), (int)(l_on & 0xFFL));
            midcolor = new Color((int)((l_mid & 0xFF0000L) >> 16), (int)((l_mid & 0xFF00L) >> 8), (int)(l_mid & 0xFFL));
            offcolor = new Color((int)((l_off & 0xFF0000L) >> 16), (int)((l_off & 0xFF00L) >> 8), (int)(l_off & 0xFFL));
        }
        catch (Exception e) {
            System.out.println("RedstonePasteMod - Error processing colors, using default");
            oncolor = new Color(255, 82, 0);
            offcolor = new Color(128, 180, 0);
            midcolor = new Color(230, 100, 0);
        }
        int totalcolors = 16;
        int halfint = this.lerp(0, totalcolors, colorskew);
        halfint = 8;
        this.colorlist = new Color[totalcolors];
        for (n = 0; n < halfint; ++n) {
            cf = (float)n / (float)halfint;
            this.colorlist[n] = new Color(this.lerp(offcolor.getRed(), midcolor.getRed(), cf), this.lerp(offcolor.getGreen(), midcolor.getGreen(), cf), this.lerp(offcolor.getBlue(), midcolor.getBlue(), cf));
        }
        for (n = halfint; n < totalcolors; ++n) {
            cf = (float)(n - halfint) / (float)(totalcolors - 1 - halfint);
            this.colorlist[n] = new Color(this.lerp(midcolor.getRed(), oncolor.getRed(), cf), this.lerp(midcolor.getGreen(), oncolor.getGreen(), cf), this.lerp(midcolor.getBlue(), oncolor.getBlue(), cf));
        }
    }

    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
    }

    private void renderStandardBlockWithColorMultiplier(RenderBlocks renderer, Block par1Block, int par2, int par3, int par4, float par5, float par6, float par7, int face) {
        boolean originalAO = renderer.field_147863_w;
        renderer.field_147863_w = false;
        Tessellator tessellator = Tessellator.field_78398_a;
        float f3 = 0.5f;
        float f4 = 1.0f;
        float f5 = 0.8f;
        float f6 = 0.6f;
        float f7 = f4 * par5;
        float f8 = f4 * par6;
        float f9 = f4 * par7;
        float f10 = f3;
        float f11 = f5;
        float f12 = f6;
        float f13 = f3;
        float f14 = f5;
        float f15 = f6;
        float f16 = f3;
        float f17 = f5;
        float f18 = f6;
        if (par1Block != Blocks.field_150349_c) {
            f10 = f3 * par5;
            f11 = f5 * par5;
            f12 = f6 * par5;
            f13 = f3 * par6;
            f14 = f5 * par6;
            f15 = f6 * par6;
            f16 = f3 * par7;
            f17 = f5 * par7;
            f18 = f6 * par7;
        }
        int l = par1Block.func_149677_c(renderer.field_147845_a, par2, par3, par4);
        tessellator.func_78380_c(renderer.field_147855_j > 0.0 ? l : par1Block.func_149677_c(renderer.field_147845_a, par2, par3 - 1, par4));
        tessellator.func_78386_a(f10, f13, f16);
        IIcon icon = renderer.func_147793_a(par1Block, renderer.field_147845_a, par2, par3, par4, ForgeDirection.ROTATION_MATRIX[face][0]);
        renderer.func_147768_a(par1Block, (double)par2, (double)par3, (double)par4, icon);
        tessellator.func_78380_c(renderer.field_147857_k < 1.0 ? l : par1Block.func_149677_c(renderer.field_147845_a, par2, par3 + 1, par4));
        tessellator.func_78386_a(f7, f8, f9);
        icon = renderer.func_147793_a(par1Block, renderer.field_147845_a, par2, par3, par4, ForgeDirection.ROTATION_MATRIX[face][1]);
        renderer.func_147806_b(par1Block, (double)par2, (double)par3, (double)par4, icon);
        tessellator.func_78380_c(renderer.field_147851_l > 0.0 ? l : par1Block.func_149677_c(renderer.field_147845_a, par2, par3, par4 - 1));
        tessellator.func_78386_a(f11, f14, f17);
        icon = renderer.func_147793_a(par1Block, renderer.field_147845_a, par2, par3, par4, ForgeDirection.ROTATION_MATRIX[face][2]);
        renderer.func_147761_c(par1Block, (double)par2, (double)par3, (double)par4, icon);
        tessellator.func_78380_c(renderer.field_147853_m < 1.0 ? l : par1Block.func_149677_c(renderer.field_147845_a, par2, par3, par4 + 1));
        tessellator.func_78386_a(f11, f14, f17);
        icon = renderer.func_147793_a(par1Block, renderer.field_147845_a, par2, par3, par4, ForgeDirection.ROTATION_MATRIX[face][3]);
        renderer.func_147734_d(par1Block, (double)par2, (double)par3, (double)par4, icon);
        tessellator.func_78380_c(renderer.field_147859_h > 0.0 ? l : par1Block.func_149677_c(renderer.field_147845_a, par2 - 1, par3, par4));
        tessellator.func_78386_a(f12, f15, f18);
        icon = renderer.func_147793_a(par1Block, renderer.field_147845_a, par2, par3, par4, ForgeDirection.ROTATION_MATRIX[face][4]);
        renderer.func_147798_e(par1Block, (double)par2, (double)par3, (double)par4, icon);
        tessellator.func_78380_c(renderer.field_147861_i < 1.0 ? l : par1Block.func_149677_c(renderer.field_147845_a, par2 + 1, par3, par4));
        tessellator.func_78386_a(f12, f15, f18);
        icon = renderer.func_147793_a(par1Block, renderer.field_147845_a, par2, par3, par4, ForgeDirection.ROTATION_MATRIX[face][5]);
        renderer.func_147764_f(par1Block, (double)par2, (double)par3, (double)par4, icon);
        renderer.field_147863_w = originalAO;
    }

    private int lerp(int v0, int v1, float t) {
        return (int)Math.floor((float)v0 + (float)(v1 - v0) * t);
    }

    private float lerp(float v0, float v1, float t) {
        return v0 + (v1 - v0) * t;
    }

    public static void renderFaceYNeg(RenderBlocks renderer, Block par1Block, double par2, double par4, double par6, IIcon par8Icon) {
        Tessellator tessellator = Tessellator.field_78398_a;
        if (renderer.func_147744_b()) {
            par8Icon = renderer.field_147840_d;
        }
        double d3 = par8Icon.func_94214_a(renderer.field_147859_h * 16.0);
        double d4 = par8Icon.func_94214_a(renderer.field_147861_i * 16.0);
        double d5 = par8Icon.func_94207_b(renderer.field_147851_l * 16.0);
        double d6 = par8Icon.func_94207_b(renderer.field_147853_m * 16.0);
        if (renderer.field_147859_h < 0.0 || renderer.field_147861_i > 1.0) {
            d3 = par8Icon.func_94209_e();
            d4 = par8Icon.func_94212_f();
        }
        if (renderer.field_147851_l < 0.0 || renderer.field_147853_m > 1.0) {
            d5 = par8Icon.func_94206_g();
            d6 = par8Icon.func_94210_h();
        }
        double d7 = d4;
        double d8 = d3;
        double d9 = d5;
        double d10 = d6;
        if (renderer.field_147865_v == 2) {
            d3 = par8Icon.func_94214_a(renderer.field_147851_l * 16.0);
            d5 = par8Icon.func_94207_b(16.0 - renderer.field_147861_i * 16.0);
            d4 = par8Icon.func_94214_a(renderer.field_147853_m * 16.0);
            d6 = par8Icon.func_94207_b(16.0 - renderer.field_147859_h * 16.0);
            d9 = d5;
            d10 = d6;
            d7 = d3;
            d8 = d4;
            d5 = d6;
            d6 = d9;
        } else if (renderer.field_147865_v == 1) {
            d3 = par8Icon.func_94214_a(16.0 - renderer.field_147853_m * 16.0);
            d5 = par8Icon.func_94207_b(renderer.field_147859_h * 16.0);
            d4 = par8Icon.func_94214_a(16.0 - renderer.field_147851_l * 16.0);
            d6 = par8Icon.func_94207_b(renderer.field_147861_i * 16.0);
            d7 = d4;
            d8 = d3;
            d3 = d4;
            d4 = d8;
            d9 = d6;
            d10 = d5;
        } else if (renderer.field_147865_v == 3) {
            d3 = par8Icon.func_94214_a(16.0 - renderer.field_147859_h * 16.0);
            d4 = par8Icon.func_94214_a(16.0 - renderer.field_147861_i * 16.0);
            d5 = par8Icon.func_94207_b(16.0 - renderer.field_147851_l * 16.0);
            d6 = par8Icon.func_94207_b(16.0 - renderer.field_147853_m * 16.0);
            d7 = d4;
            d8 = d3;
            d9 = d5;
            d10 = d6;
        }
        double d11 = par2 + renderer.field_147859_h;
        double d12 = par2 + renderer.field_147861_i;
        double d13 = par4 + renderer.field_147855_j;
        double d14 = par6 + renderer.field_147851_l;
        double d15 = par6 + renderer.field_147853_m;
        if (renderer.field_147863_w) {
            tessellator.func_78386_a(renderer.field_147872_ap, renderer.field_147846_at, renderer.field_147854_ax);
            tessellator.func_78380_c(renderer.field_147864_al);
            tessellator.func_78374_a(d11, d13, d15, d8, d10);
            tessellator.func_78386_a(renderer.field_147852_aq, renderer.field_147860_au, renderer.field_147841_ay);
            tessellator.func_78380_c(renderer.field_147874_am);
            tessellator.func_78374_a(d11, d13, d14, d3, d5);
            tessellator.func_78386_a(renderer.field_147850_ar, renderer.field_147858_av, renderer.field_147839_az);
            tessellator.func_78380_c(renderer.field_147876_an);
            tessellator.func_78374_a(d12, d13, d14, d7, d9);
            tessellator.func_78386_a(renderer.field_147848_as, renderer.field_147856_aw, renderer.field_147833_aA);
            tessellator.func_78380_c(renderer.field_147870_ao);
            tessellator.func_78374_a(d12, d13, d15, d4, d6);
        } else {
            tessellator.func_78374_a(d11, d13, d15, d8, d10);
            tessellator.func_78374_a(d11, d13, d14, d3, d5);
            tessellator.func_78374_a(d12, d13, d14, d7, d9);
            tessellator.func_78374_a(d12, d13, d15, d4, d6);
        }
    }

    public static void renderFaceYPos(RenderBlocks renderer, Block par1Block, double par2, double par4, double par6, IIcon par8Icon) {
        Tessellator tessellator = Tessellator.field_78398_a;
        if (renderer.func_147744_b()) {
            par8Icon = renderer.field_147840_d;
        }
        double d3 = par8Icon.func_94214_a(renderer.field_147859_h * 16.0);
        double d4 = par8Icon.func_94214_a(renderer.field_147861_i * 16.0);
        double d5 = par8Icon.func_94207_b(renderer.field_147851_l * 16.0);
        double d6 = par8Icon.func_94207_b(renderer.field_147853_m * 16.0);
        if (renderer.field_147859_h < 0.0 || renderer.field_147861_i > 1.0) {
            d3 = par8Icon.func_94209_e();
            d4 = par8Icon.func_94212_f();
        }
        if (renderer.field_147851_l < 0.0 || renderer.field_147853_m > 1.0) {
            d5 = par8Icon.func_94206_g();
            d6 = par8Icon.func_94210_h();
        }
        double d7 = d4;
        double d8 = d3;
        double d9 = d5;
        double d10 = d6;
        if (renderer.field_147867_u == 1) {
            d3 = par8Icon.func_94214_a(renderer.field_147851_l * 16.0);
            d5 = par8Icon.func_94207_b(16.0 - renderer.field_147861_i * 16.0);
            d4 = par8Icon.func_94214_a(renderer.field_147853_m * 16.0);
            d6 = par8Icon.func_94207_b(16.0 - renderer.field_147859_h * 16.0);
            d9 = d5;
            d10 = d6;
            d7 = d3;
            d8 = d4;
            d5 = d6;
            d6 = d9;
        } else if (renderer.field_147867_u == 2) {
            d3 = par8Icon.func_94214_a(16.0 - renderer.field_147853_m * 16.0);
            d5 = par8Icon.func_94207_b(renderer.field_147859_h * 16.0);
            d4 = par8Icon.func_94214_a(16.0 - renderer.field_147851_l * 16.0);
            d6 = par8Icon.func_94207_b(renderer.field_147861_i * 16.0);
            d7 = d4;
            d8 = d3;
            d3 = d4;
            d4 = d8;
            d9 = d6;
            d10 = d5;
        } else if (renderer.field_147867_u == 3) {
            d3 = par8Icon.func_94214_a(16.0 - renderer.field_147859_h * 16.0);
            d4 = par8Icon.func_94214_a(16.0 - renderer.field_147861_i * 16.0);
            d5 = par8Icon.func_94207_b(16.0 - renderer.field_147851_l * 16.0);
            d6 = par8Icon.func_94207_b(16.0 - renderer.field_147853_m * 16.0);
            d7 = d4;
            d8 = d3;
            d9 = d5;
            d10 = d6;
        }
        double d11 = par2 + renderer.field_147859_h;
        double d12 = par2 + renderer.field_147861_i;
        double d13 = par4 + renderer.field_147857_k;
        double d14 = par6 + renderer.field_147851_l;
        double d15 = par6 + renderer.field_147853_m;
        if (renderer.field_147863_w) {
            tessellator.func_78386_a(renderer.field_147872_ap, renderer.field_147846_at, renderer.field_147854_ax);
            tessellator.func_78380_c(renderer.field_147864_al);
            tessellator.func_78374_a(d12, d13, d15, d4, d6);
            tessellator.func_78386_a(renderer.field_147852_aq, renderer.field_147860_au, renderer.field_147841_ay);
            tessellator.func_78380_c(renderer.field_147874_am);
            tessellator.func_78374_a(d12, d13, d14, d7, d9);
            tessellator.func_78386_a(renderer.field_147850_ar, renderer.field_147858_av, renderer.field_147839_az);
            tessellator.func_78380_c(renderer.field_147876_an);
            tessellator.func_78374_a(d11, d13, d14, d3, d5);
            tessellator.func_78386_a(renderer.field_147848_as, renderer.field_147856_aw, renderer.field_147833_aA);
            tessellator.func_78380_c(renderer.field_147870_ao);
            tessellator.func_78374_a(d11, d13, d15, d8, d10);
        } else {
            tessellator.func_78374_a(d12, d13, d15, d4, d6);
            tessellator.func_78374_a(d12, d13, d14, d7, d9);
            tessellator.func_78374_a(d11, d13, d14, d3, d5);
            tessellator.func_78374_a(d11, d13, d15, d8, d10);
        }
    }

    public static void renderFaceZNeg(RenderBlocks renderer, Block par1Block, double par2, double par4, double par6, IIcon par8Icon) {
        double d7;
        Tessellator tessellator = Tessellator.field_78398_a;
        if (renderer.func_147744_b()) {
            par8Icon = renderer.field_147840_d;
        }
        double d3 = par8Icon.func_94214_a(renderer.field_147859_h * 16.0);
        double d4 = par8Icon.func_94214_a(renderer.field_147861_i * 16.0);
        double d5 = par8Icon.func_94207_b(16.0 - renderer.field_147857_k * 16.0);
        double d6 = par8Icon.func_94207_b(16.0 - renderer.field_147855_j * 16.0);
        if (renderer.field_147842_e) {
            d7 = d3;
            d3 = d4;
            d4 = d7;
        }
        if (renderer.field_147859_h < 0.0 || renderer.field_147861_i > 1.0) {
            d3 = par8Icon.func_94209_e();
            d4 = par8Icon.func_94212_f();
        }
        if (renderer.field_147855_j < 0.0 || renderer.field_147857_k > 1.0) {
            d5 = par8Icon.func_94206_g();
            d6 = par8Icon.func_94210_h();
        }
        d7 = d4;
        double d8 = d3;
        double d9 = d5;
        double d10 = d6;
        if (renderer.field_147875_q == 2) {
            d3 = par8Icon.func_94214_a(renderer.field_147855_j * 16.0);
            d5 = par8Icon.func_94207_b(16.0 - renderer.field_147859_h * 16.0);
            d4 = par8Icon.func_94214_a(renderer.field_147857_k * 16.0);
            d6 = par8Icon.func_94207_b(16.0 - renderer.field_147861_i * 16.0);
            d9 = d5;
            d10 = d6;
            d7 = d3;
            d8 = d4;
            d5 = d6;
            d6 = d9;
        } else if (renderer.field_147875_q == 1) {
            d3 = par8Icon.func_94214_a(16.0 - renderer.field_147857_k * 16.0);
            d5 = par8Icon.func_94207_b(renderer.field_147861_i * 16.0);
            d4 = par8Icon.func_94214_a(16.0 - renderer.field_147855_j * 16.0);
            d6 = par8Icon.func_94207_b(renderer.field_147859_h * 16.0);
            d7 = d4;
            d8 = d3;
            d3 = d4;
            d4 = d8;
            d9 = d6;
            d10 = d5;
        } else if (renderer.field_147875_q == 3) {
            d3 = par8Icon.func_94214_a(16.0 - renderer.field_147859_h * 16.0);
            d4 = par8Icon.func_94214_a(16.0 - renderer.field_147861_i * 16.0);
            d5 = par8Icon.func_94207_b(renderer.field_147857_k * 16.0);
            d6 = par8Icon.func_94207_b(renderer.field_147855_j * 16.0);
            d7 = d4;
            d8 = d3;
            d9 = d5;
            d10 = d6;
        }
        double d11 = par2 + renderer.field_147859_h;
        double d12 = par2 + renderer.field_147861_i;
        double d13 = par4 + renderer.field_147855_j;
        double d14 = par4 + renderer.field_147857_k;
        double d15 = par6 + renderer.field_147851_l;
        if (renderer.field_147863_w) {
            tessellator.func_78386_a(renderer.field_147872_ap, renderer.field_147846_at, renderer.field_147854_ax);
            tessellator.func_78380_c(renderer.field_147864_al);
            tessellator.func_78374_a(d11, d14, d15, d7, d9);
            tessellator.func_78386_a(renderer.field_147852_aq, renderer.field_147860_au, renderer.field_147841_ay);
            tessellator.func_78380_c(renderer.field_147874_am);
            tessellator.func_78374_a(d12, d14, d15, d3, d5);
            tessellator.func_78386_a(renderer.field_147850_ar, renderer.field_147858_av, renderer.field_147839_az);
            tessellator.func_78380_c(renderer.field_147876_an);
            tessellator.func_78374_a(d12, d13, d15, d8, d10);
            tessellator.func_78386_a(renderer.field_147848_as, renderer.field_147856_aw, renderer.field_147833_aA);
            tessellator.func_78380_c(renderer.field_147870_ao);
            tessellator.func_78374_a(d11, d13, d15, d4, d6);
        } else {
            tessellator.func_78374_a(d11, d14, d15, d7, d9);
            tessellator.func_78374_a(d12, d14, d15, d3, d5);
            tessellator.func_78374_a(d12, d13, d15, d8, d10);
            tessellator.func_78374_a(d11, d13, d15, d4, d6);
        }
    }

    public static void renderFaceZPos(RenderBlocks renderer, Block par1Block, double par2, double par4, double par6, IIcon par8Icon) {
        double d7;
        Tessellator tessellator = Tessellator.field_78398_a;
        if (renderer.func_147744_b()) {
            par8Icon = renderer.field_147840_d;
        }
        double d3 = par8Icon.func_94214_a(renderer.field_147859_h * 16.0);
        double d4 = par8Icon.func_94214_a(renderer.field_147861_i * 16.0);
        double d5 = par8Icon.func_94207_b(16.0 - renderer.field_147857_k * 16.0);
        double d6 = par8Icon.func_94207_b(16.0 - renderer.field_147855_j * 16.0);
        if (renderer.field_147842_e) {
            d7 = d3;
            d3 = d4;
            d4 = d7;
        }
        if (renderer.field_147859_h < 0.0 || renderer.field_147861_i > 1.0) {
            d3 = par8Icon.func_94209_e();
            d4 = par8Icon.func_94212_f();
        }
        if (renderer.field_147855_j < 0.0 || renderer.field_147857_k > 1.0) {
            d5 = par8Icon.func_94206_g();
            d6 = par8Icon.func_94210_h();
        }
        d7 = d4;
        double d8 = d3;
        double d9 = d5;
        double d10 = d6;
        if (renderer.field_147873_r == 1) {
            d3 = par8Icon.func_94214_a(renderer.field_147855_j * 16.0);
            d6 = par8Icon.func_94207_b(16.0 - renderer.field_147859_h * 16.0);
            d4 = par8Icon.func_94214_a(renderer.field_147857_k * 16.0);
            d9 = d5 = (double)par8Icon.func_94207_b(16.0 - renderer.field_147861_i * 16.0);
            d10 = d6;
            d7 = d3;
            d8 = d4;
            d5 = d6;
            d6 = d9;
        } else if (renderer.field_147873_r == 2) {
            d3 = par8Icon.func_94214_a(16.0 - renderer.field_147857_k * 16.0);
            d5 = par8Icon.func_94207_b(renderer.field_147859_h * 16.0);
            d4 = par8Icon.func_94214_a(16.0 - renderer.field_147855_j * 16.0);
            d6 = par8Icon.func_94207_b(renderer.field_147861_i * 16.0);
            d7 = d4;
            d8 = d3;
            d3 = d4;
            d4 = d8;
            d9 = d6;
            d10 = d5;
        } else if (renderer.field_147873_r == 3) {
            d3 = par8Icon.func_94214_a(16.0 - renderer.field_147859_h * 16.0);
            d4 = par8Icon.func_94214_a(16.0 - renderer.field_147861_i * 16.0);
            d5 = par8Icon.func_94207_b(renderer.field_147857_k * 16.0);
            d6 = par8Icon.func_94207_b(renderer.field_147855_j * 16.0);
            d7 = d4;
            d8 = d3;
            d9 = d5;
            d10 = d6;
        }
        double d11 = par2 + renderer.field_147859_h;
        double d12 = par2 + renderer.field_147861_i;
        double d13 = par4 + renderer.field_147855_j;
        double d14 = par4 + renderer.field_147857_k;
        double d15 = par6 + renderer.field_147853_m;
        if (renderer.field_147863_w) {
            tessellator.func_78386_a(renderer.field_147872_ap, renderer.field_147846_at, renderer.field_147854_ax);
            tessellator.func_78380_c(renderer.field_147864_al);
            tessellator.func_78374_a(d11, d14, d15, d3, d5);
            tessellator.func_78386_a(renderer.field_147852_aq, renderer.field_147860_au, renderer.field_147841_ay);
            tessellator.func_78380_c(renderer.field_147874_am);
            tessellator.func_78374_a(d11, d13, d15, d8, d10);
            tessellator.func_78386_a(renderer.field_147850_ar, renderer.field_147858_av, renderer.field_147839_az);
            tessellator.func_78380_c(renderer.field_147876_an);
            tessellator.func_78374_a(d12, d13, d15, d4, d6);
            tessellator.func_78386_a(renderer.field_147848_as, renderer.field_147856_aw, renderer.field_147833_aA);
            tessellator.func_78380_c(renderer.field_147870_ao);
            tessellator.func_78374_a(d12, d14, d15, d7, d9);
        } else {
            tessellator.func_78374_a(d11, d14, d15, d3, d5);
            tessellator.func_78374_a(d11, d13, d15, d8, d10);
            tessellator.func_78374_a(d12, d13, d15, d4, d6);
            tessellator.func_78374_a(d12, d14, d15, d7, d9);
        }
    }

    public static void renderFaceXNeg(RenderBlocks renderer, Block par1Block, double par2, double par4, double par6, IIcon par8Icon) {
        double d7;
        Tessellator tessellator = Tessellator.field_78398_a;
        if (renderer.func_147744_b()) {
            par8Icon = renderer.field_147840_d;
        }
        double d3 = par8Icon.func_94214_a(renderer.field_147851_l * 16.0);
        double d4 = par8Icon.func_94214_a(renderer.field_147853_m * 16.0);
        double d5 = par8Icon.func_94207_b(16.0 - renderer.field_147857_k * 16.0);
        double d6 = par8Icon.func_94207_b(16.0 - renderer.field_147855_j * 16.0);
        if (renderer.field_147842_e) {
            d7 = d3;
            d3 = d4;
            d4 = d7;
        }
        if (renderer.field_147851_l < 0.0 || renderer.field_147853_m > 1.0) {
            d3 = par8Icon.func_94209_e();
            d4 = par8Icon.func_94212_f();
        }
        if (renderer.field_147855_j < 0.0 || renderer.field_147857_k > 1.0) {
            d5 = par8Icon.func_94206_g();
            d6 = par8Icon.func_94210_h();
        }
        d7 = d4;
        double d8 = d3;
        double d9 = d5;
        double d10 = d6;
        if (renderer.field_147869_t == 1) {
            d3 = par8Icon.func_94214_a(renderer.field_147855_j * 16.0);
            d5 = par8Icon.func_94207_b(16.0 - renderer.field_147853_m * 16.0);
            d4 = par8Icon.func_94214_a(renderer.field_147857_k * 16.0);
            d6 = par8Icon.func_94207_b(16.0 - renderer.field_147851_l * 16.0);
            d9 = d5;
            d10 = d6;
            d7 = d3;
            d8 = d4;
            d5 = d6;
            d6 = d9;
        } else if (renderer.field_147869_t == 2) {
            d3 = par8Icon.func_94214_a(16.0 - renderer.field_147857_k * 16.0);
            d5 = par8Icon.func_94207_b(renderer.field_147851_l * 16.0);
            d4 = par8Icon.func_94214_a(16.0 - renderer.field_147855_j * 16.0);
            d6 = par8Icon.func_94207_b(renderer.field_147853_m * 16.0);
            d7 = d4;
            d8 = d3;
            d3 = d4;
            d4 = d8;
            d9 = d6;
            d10 = d5;
        } else if (renderer.field_147869_t == 3) {
            d3 = par8Icon.func_94214_a(16.0 - renderer.field_147851_l * 16.0);
            d4 = par8Icon.func_94214_a(16.0 - renderer.field_147853_m * 16.0);
            d5 = par8Icon.func_94207_b(renderer.field_147857_k * 16.0);
            d6 = par8Icon.func_94207_b(renderer.field_147855_j * 16.0);
            d7 = d4;
            d8 = d3;
            d9 = d5;
            d10 = d6;
        }
        double d11 = par2 + renderer.field_147859_h;
        double d12 = par4 + renderer.field_147855_j;
        double d13 = par4 + renderer.field_147857_k;
        double d14 = par6 + renderer.field_147851_l;
        double d15 = par6 + renderer.field_147853_m;
        if (renderer.field_147863_w) {
            tessellator.func_78386_a(renderer.field_147872_ap, renderer.field_147846_at, renderer.field_147854_ax);
            tessellator.func_78380_c(renderer.field_147864_al);
            tessellator.func_78374_a(d11, d13, d15, d7, d9);
            tessellator.func_78386_a(renderer.field_147852_aq, renderer.field_147860_au, renderer.field_147841_ay);
            tessellator.func_78380_c(renderer.field_147874_am);
            tessellator.func_78374_a(d11, d13, d14, d3, d5);
            tessellator.func_78386_a(renderer.field_147850_ar, renderer.field_147858_av, renderer.field_147839_az);
            tessellator.func_78380_c(renderer.field_147876_an);
            tessellator.func_78374_a(d11, d12, d14, d8, d10);
            tessellator.func_78386_a(renderer.field_147848_as, renderer.field_147856_aw, renderer.field_147833_aA);
            tessellator.func_78380_c(renderer.field_147870_ao);
            tessellator.func_78374_a(d11, d12, d15, d4, d6);
        } else {
            tessellator.func_78374_a(d11, d13, d15, d7, d9);
            tessellator.func_78374_a(d11, d13, d14, d3, d5);
            tessellator.func_78374_a(d11, d12, d14, d8, d10);
            tessellator.func_78374_a(d11, d12, d15, d4, d6);
        }
    }

    public static void renderFaceXPos(RenderBlocks renderer, Block par1Block, double par2, double par4, double par6, IIcon par8Icon) {
        double d7;
        Tessellator tessellator = Tessellator.field_78398_a;
        if (renderer.func_147744_b()) {
            par8Icon = renderer.field_147840_d;
        }
        double d3 = par8Icon.func_94214_a(renderer.field_147851_l * 16.0);
        double d4 = par8Icon.func_94214_a(renderer.field_147853_m * 16.0);
        double d5 = par8Icon.func_94207_b(16.0 - renderer.field_147857_k * 16.0);
        double d6 = par8Icon.func_94207_b(16.0 - renderer.field_147855_j * 16.0);
        if (renderer.field_147842_e) {
            d7 = d3;
            d3 = d4;
            d4 = d7;
        }
        if (renderer.field_147851_l < 0.0 || renderer.field_147853_m > 1.0) {
            d3 = par8Icon.func_94209_e();
            d4 = par8Icon.func_94212_f();
        }
        if (renderer.field_147855_j < 0.0 || renderer.field_147857_k > 1.0) {
            d5 = par8Icon.func_94206_g();
            d6 = par8Icon.func_94210_h();
        }
        d7 = d4;
        double d8 = d3;
        double d9 = d5;
        double d10 = d6;
        if (renderer.field_147871_s == 2) {
            d3 = par8Icon.func_94214_a(renderer.field_147855_j * 16.0);
            d5 = par8Icon.func_94207_b(16.0 - renderer.field_147851_l * 16.0);
            d4 = par8Icon.func_94214_a(renderer.field_147857_k * 16.0);
            d6 = par8Icon.func_94207_b(16.0 - renderer.field_147853_m * 16.0);
            d9 = d5;
            d10 = d6;
            d7 = d3;
            d8 = d4;
            d5 = d6;
            d6 = d9;
        } else if (renderer.field_147871_s == 1) {
            d3 = par8Icon.func_94214_a(16.0 - renderer.field_147857_k * 16.0);
            d5 = par8Icon.func_94207_b(renderer.field_147853_m * 16.0);
            d4 = par8Icon.func_94214_a(16.0 - renderer.field_147855_j * 16.0);
            d6 = par8Icon.func_94207_b(renderer.field_147851_l * 16.0);
            d7 = d4;
            d8 = d3;
            d3 = d4;
            d4 = d8;
            d9 = d6;
            d10 = d5;
        } else if (renderer.field_147871_s == 3) {
            d3 = par8Icon.func_94214_a(16.0 - renderer.field_147851_l * 16.0);
            d4 = par8Icon.func_94214_a(16.0 - renderer.field_147853_m * 16.0);
            d5 = par8Icon.func_94207_b(renderer.field_147857_k * 16.0);
            d6 = par8Icon.func_94207_b(renderer.field_147855_j * 16.0);
            d7 = d4;
            d8 = d3;
            d9 = d5;
            d10 = d6;
        }
        double d11 = par2 + renderer.field_147861_i;
        double d12 = par4 + renderer.field_147855_j;
        double d13 = par4 + renderer.field_147857_k;
        double d14 = par6 + renderer.field_147851_l;
        double d15 = par6 + renderer.field_147853_m;
        if (renderer.field_147863_w) {
            tessellator.func_78386_a(renderer.field_147872_ap, renderer.field_147846_at, renderer.field_147854_ax);
            tessellator.func_78380_c(renderer.field_147864_al);
            tessellator.func_78374_a(d11, d12, d15, d8, d10);
            tessellator.func_78386_a(renderer.field_147852_aq, renderer.field_147860_au, renderer.field_147841_ay);
            tessellator.func_78380_c(renderer.field_147874_am);
            tessellator.func_78374_a(d11, d12, d14, d4, d6);
            tessellator.func_78386_a(renderer.field_147850_ar, renderer.field_147858_av, renderer.field_147839_az);
            tessellator.func_78380_c(renderer.field_147876_an);
            tessellator.func_78374_a(d11, d13, d14, d7, d9);
            tessellator.func_78386_a(renderer.field_147848_as, renderer.field_147856_aw, renderer.field_147833_aA);
            tessellator.func_78380_c(renderer.field_147870_ao);
            tessellator.func_78374_a(d11, d13, d15, d3, d5);
        } else {
            tessellator.func_78374_a(d11, d12, d15, d8, d10);
            tessellator.func_78374_a(d11, d12, d14, d4, d6);
            tessellator.func_78374_a(d11, d13, d14, d7, d9);
            tessellator.func_78374_a(d11, d13, d15, d3, d5);
        }
    }

    private void renderPasteFace(RenderBlocks renderer, int strength, int face, int facedata, int x, int y, int z, IIcon icon1) {
        double facedist = 0.015625;
        facedist = 0.015625;
        BlockRedstonePaste block = RedstonePasteMod.instance.blockRedstonePaste;
        if (strength < 0) {
            strength = 0;
        }
        if (strength > 15) {
            strength = 15;
        }
        Tessellator.field_78398_a.func_78370_a(this.colorlist[strength].getRed(), this.colorlist[strength].getGreen(), this.colorlist[strength].getBlue(), 255);
        switch (face) {
            case 0: {
                renderer.field_147867_u = 1;
                if ((facedata & 1) == 1) {
                    renderer.func_147782_a(0.25, 0.0, 0.0, 0.75, facedist, 0.5);
                    RedstonePasteRenderer.renderFaceYPos(renderer, (Block)block, x, y, z, icon1);
                    renderer.field_147875_q = 1;
                    RedstonePasteRenderer.renderFaceZNeg(renderer, (Block)block, x, y, z, icon1);
                    renderer.field_147875_q = 0;
                }
                if ((facedata & 2) == 2) {
                    renderer.func_147782_a(0.25, 0.0, 0.5, 0.75, facedist, 1.0);
                    RedstonePasteRenderer.renderFaceYPos(renderer, (Block)block, x, y, z, icon1);
                    renderer.field_147873_r = 1;
                    RedstonePasteRenderer.renderFaceZPos(renderer, (Block)block, x, y, z, icon1);
                    renderer.field_147873_r = 0;
                }
                renderer.field_147867_u = 0;
                if ((facedata & 4) == 4) {
                    renderer.func_147782_a(0.0, 0.0, 0.25, 0.5, facedist + 0.001, 0.75);
                    RedstonePasteRenderer.renderFaceYPos(renderer, (Block)block, x, y, z, icon1);
                    renderer.field_147869_t = 1;
                    RedstonePasteRenderer.renderFaceXNeg(renderer, (Block)block, x, y, z, icon1);
                    renderer.field_147869_t = 0;
                }
                if ((facedata & 8) != 8) break;
                renderer.func_147782_a(0.5, 0.0, 0.25, 1.0, facedist + 0.001, 0.75);
                RedstonePasteRenderer.renderFaceYPos(renderer, (Block)block, x, y, z, icon1);
                renderer.field_147871_s = 1;
                RedstonePasteRenderer.renderFaceXPos(renderer, (Block)block, x, y, z, icon1);
                renderer.field_147871_s = 0;
                break;
            }
            case 1: {
                renderer.field_147865_v = 1;
                if ((facedata & 1) == 1) {
                    renderer.func_147782_a(0.25, 1.0 - facedist, 0.0, 0.75, 1.0, 0.5);
                    RedstonePasteRenderer.renderFaceYNeg(renderer, (Block)block, x, y, z, icon1);
                    renderer.field_147875_q = 1;
                    RedstonePasteRenderer.renderFaceZNeg(renderer, (Block)block, x, y, z, icon1);
                    renderer.field_147875_q = 0;
                }
                if ((facedata & 2) == 2) {
                    renderer.func_147782_a(0.25, 1.0 - facedist, 0.5, 0.75, 1.0, 1.0);
                    RedstonePasteRenderer.renderFaceYNeg(renderer, (Block)block, x, y, z, icon1);
                    renderer.field_147873_r = 1;
                    RedstonePasteRenderer.renderFaceZPos(renderer, (Block)block, x, y, z, icon1);
                    renderer.field_147873_r = 0;
                }
                renderer.field_147865_v = 0;
                if ((facedata & 4) == 4) {
                    renderer.func_147782_a(0.0, 1.0 - facedist - 0.001, 0.25, 0.5, 1.0, 0.75);
                    RedstonePasteRenderer.renderFaceYNeg(renderer, (Block)block, x, y, z, icon1);
                    renderer.field_147869_t = 1;
                    RedstonePasteRenderer.renderFaceXNeg(renderer, (Block)block, x, y, z, icon1);
                    renderer.field_147869_t = 0;
                }
                if ((facedata & 8) != 8) break;
                renderer.func_147782_a(0.5, 1.0 - facedist - 0.001, 0.25, 1.0, 1.0, 0.75);
                RedstonePasteRenderer.renderFaceYNeg(renderer, (Block)block, x, y, z, icon1);
                renderer.field_147871_s = 1;
                RedstonePasteRenderer.renderFaceXPos(renderer, (Block)block, x, y, z, icon1);
                renderer.field_147871_s = 0;
                break;
            }
            case 2: {
                renderer.field_147873_r = 1;
                if ((facedata & 1) == 1) {
                    renderer.func_147782_a(0.25, 0.0, 0.0, 0.75, 0.5, facedist);
                    RedstonePasteRenderer.renderFaceZPos(renderer, (Block)block, x, y, z, icon1);
                    renderer.field_147865_v = 1;
                    RedstonePasteRenderer.renderFaceYNeg(renderer, (Block)block, x, y, z, icon1);
                    renderer.field_147865_v = 0;
                }
                if ((facedata & 2) == 2) {
                    renderer.func_147782_a(0.25, 0.5, 0.0, 0.75, 1.0, facedist);
                    RedstonePasteRenderer.renderFaceZPos(renderer, (Block)block, x, y, z, icon1);
                    renderer.field_147867_u = 1;
                    RedstonePasteRenderer.renderFaceYPos(renderer, (Block)block, x, y, z, icon1);
                    renderer.field_147867_u = 0;
                }
                renderer.field_147873_r = 0;
                if ((facedata & 4) == 4) {
                    renderer.func_147782_a(0.0, 0.25, 0.0, 0.5, 0.75, facedist + 0.001);
                    RedstonePasteRenderer.renderFaceZPos(renderer, (Block)block, x, y, z, icon1);
                    RedstonePasteRenderer.renderFaceXNeg(renderer, (Block)block, x, y, z, icon1);
                }
                if ((facedata & 8) != 8) break;
                renderer.func_147782_a(0.5, 0.25, 0.0, 1.0, 0.75, facedist + 0.001);
                RedstonePasteRenderer.renderFaceZPos(renderer, (Block)block, x, y, z, icon1);
                RedstonePasteRenderer.renderFaceXPos(renderer, (Block)block, x, y, z, icon1);
                break;
            }
            case 3: {
                renderer.field_147875_q = 1;
                if ((facedata & 1) == 1) {
                    renderer.func_147782_a(0.25, 0.0, 1.0 - facedist, 0.75, 0.5, 1.0);
                    RedstonePasteRenderer.renderFaceZNeg(renderer, (Block)block, x, y, z, icon1);
                    renderer.field_147865_v = 1;
                    RedstonePasteRenderer.renderFaceYNeg(renderer, (Block)block, x, y, z, icon1);
                    renderer.field_147865_v = 0;
                }
                if ((facedata & 2) == 2) {
                    renderer.func_147782_a(0.25, 0.5, 1.0 - facedist, 0.75, 1.0, 1.0);
                    RedstonePasteRenderer.renderFaceZNeg(renderer, (Block)block, x, y, z, icon1);
                    renderer.field_147867_u = 1;
                    RedstonePasteRenderer.renderFaceYPos(renderer, (Block)block, x, y, z, icon1);
                    renderer.field_147867_u = 0;
                }
                renderer.field_147875_q = 0;
                if ((facedata & 4) == 4) {
                    renderer.func_147782_a(0.0, 0.25, 1.0 - facedist - 0.001, 0.5, 0.75, 1.0);
                    RedstonePasteRenderer.renderFaceZNeg(renderer, (Block)block, x, y, z, icon1);
                    RedstonePasteRenderer.renderFaceXNeg(renderer, (Block)block, x, y, z, icon1);
                }
                if ((facedata & 8) != 8) break;
                renderer.func_147782_a(0.5, 0.25, 1.0 - facedist - 0.001, 1.0, 0.75, 1.0);
                RedstonePasteRenderer.renderFaceZNeg(renderer, (Block)block, x, y, z, icon1);
                RedstonePasteRenderer.renderFaceXPos(renderer, (Block)block, x, y, z, icon1);
                break;
            }
            case 4: {
                renderer.field_147871_s = 1;
                if ((facedata & 1) == 1) {
                    renderer.func_147782_a(0.0, 0.0, 0.25, facedist, 0.5, 0.75);
                    RedstonePasteRenderer.renderFaceXPos(renderer, (Block)block, x, y, z, icon1);
                    RedstonePasteRenderer.renderFaceYNeg(renderer, (Block)block, x, y, z, icon1);
                }
                if ((facedata & 2) == 2) {
                    renderer.func_147782_a(0.0, 0.5, 0.25, facedist, 1.0, 0.75);
                    RedstonePasteRenderer.renderFaceXPos(renderer, (Block)block, x, y, z, icon1);
                    RedstonePasteRenderer.renderFaceYPos(renderer, (Block)block, x, y, z, icon1);
                }
                renderer.field_147871_s = 0;
                if ((facedata & 4) == 4) {
                    renderer.func_147782_a(0.0, 0.25, 0.0, facedist + 0.001, 0.75, 0.5);
                    RedstonePasteRenderer.renderFaceXPos(renderer, (Block)block, x, y, z, icon1);
                    RedstonePasteRenderer.renderFaceZNeg(renderer, (Block)block, x, y, z, icon1);
                }
                if ((facedata & 8) != 8) break;
                renderer.func_147782_a(0.0, 0.25, 0.5, facedist + 0.001, 0.75, 1.0);
                RedstonePasteRenderer.renderFaceXPos(renderer, (Block)block, x, y, z, icon1);
                RedstonePasteRenderer.renderFaceZPos(renderer, (Block)block, x, y, z, icon1);
                break;
            }
            case 5: {
                renderer.field_147869_t = 1;
                if ((facedata & 1) == 1) {
                    renderer.func_147782_a(1.0 - facedist, 0.0, 0.25, 1.0, 0.5, 0.75);
                    RedstonePasteRenderer.renderFaceXNeg(renderer, (Block)block, x, y, z, icon1);
                    RedstonePasteRenderer.renderFaceYNeg(renderer, (Block)block, x, y, z, icon1);
                }
                if ((facedata & 2) == 2) {
                    renderer.func_147782_a(1.0 - facedist, 0.5, 0.25, 1.0, 1.0, 0.75);
                    RedstonePasteRenderer.renderFaceXNeg(renderer, (Block)block, x, y, z, icon1);
                    RedstonePasteRenderer.renderFaceYPos(renderer, (Block)block, x, y, z, icon1);
                }
                renderer.field_147869_t = 0;
                if ((facedata & 4) == 4) {
                    renderer.func_147782_a(1.0 - facedist - 0.001, 0.25, 0.0, 1.0, 0.75, 0.5);
                    RedstonePasteRenderer.renderFaceXNeg(renderer, (Block)block, x, y, z, icon1);
                    RedstonePasteRenderer.renderFaceZNeg(renderer, (Block)block, x, y, z, icon1);
                }
                if ((facedata & 8) != 8) break;
                renderer.func_147782_a(1.0 - facedist - 0.001, 0.25, 0.5, 1.0, 0.75, 1.0);
                RedstonePasteRenderer.renderFaceXNeg(renderer, (Block)block, x, y, z, icon1);
                RedstonePasteRenderer.renderFaceZPos(renderer, (Block)block, x, y, z, icon1);
            }
        }
    }

    private void renderSlabFace(RenderBlocks renderer, int face, int facedata, int x, int y, int z) {
        boolean noOverride = renderer.field_147840_d == null;
        Block maskBlockID = Block.func_149729_e((int)(facedata & 0xFFFF));
        int maskBlockDamage = facedata >> 16;
        if (maskBlockID == Blocks.field_150333_U && maskBlockDamage == 0) {
            maskBlockID = Blocks.field_150348_b;
        }
        if (maskBlockID == null) {
            maskBlockID = Blocks.field_150348_b;
            maskBlockDamage = 0;
        }
        if (noOverride) {
            renderer.func_147757_a(maskBlockID.func_149691_a(1, maskBlockDamage));
        }
        switch (face) {
            case 0: {
                renderer.func_147782_a(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
                break;
            }
            case 1: {
                renderer.func_147782_a(0.0, 0.5, 0.0, 1.0, 1.0, 1.0);
                break;
            }
            case 2: {
                renderer.func_147782_a(0.0, 0.0, 0.0, 1.0, 1.0, 0.5);
                break;
            }
            case 3: {
                renderer.func_147782_a(0.0, 0.0, 0.5, 1.0, 1.0, 1.0);
                break;
            }
            case 4: {
                renderer.func_147782_a(0.0, 0.0, 0.0, 0.5, 1.0, 1.0);
                break;
            }
            case 5: {
                renderer.func_147782_a(0.5, 0.0, 0.0, 1.0, 1.0, 1.0);
            }
        }
        renderer.field_147837_f = true;
        renderer.func_147784_q(maskBlockID, x, y, z);
        renderer.field_147837_f = false;
        if (noOverride) {
            renderer.func_147771_a();
        }
    }

    private static void rotateAroundX(Vec3 vec, int deg) {
        float f1 = 0.0f;
        float f2 = 1.0f;
        switch (deg) {
            case 0: {
                f1 = 1.0f;
                f2 = 0.0f;
                break;
            }
            case 90: {
                f1 = 0.0f;
                f2 = 1.0f;
                break;
            }
            case 180: {
                f1 = -1.0f;
                f2 = 0.0f;
                break;
            }
            case 270: {
                f1 = 0.0f;
                f2 = -1.0f;
            }
        }
        double d0 = vec.field_72450_a;
        double d1 = vec.field_72448_b * (double)f1 + vec.field_72449_c * (double)f2;
        double d2 = vec.field_72449_c * (double)f1 - vec.field_72448_b * (double)f2;
        vec.field_72450_a = d0;
        vec.field_72448_b = d1;
        vec.field_72449_c = d2;
    }

    private static void rotateAroundY(Vec3 vec, int deg) {
        float f1 = 0.0f;
        float f2 = 1.0f;
        switch (deg) {
            case 0: {
                f1 = 1.0f;
                f2 = 0.0f;
                break;
            }
            case 90: {
                f1 = 0.0f;
                f2 = 1.0f;
                break;
            }
            case 180: {
                f1 = -1.0f;
                f2 = 0.0f;
                break;
            }
            case 270: {
                f1 = 0.0f;
                f2 = -1.0f;
            }
        }
        double d0 = vec.field_72450_a * (double)f1 + vec.field_72449_c * (double)f2;
        double d1 = vec.field_72448_b;
        double d2 = vec.field_72449_c * (double)f1 - vec.field_72450_a * (double)f2;
        vec.field_72450_a = d0;
        vec.field_72448_b = d1;
        vec.field_72449_c = d2;
    }

    private static void rotateAroundZ(Vec3 vec, int deg) {
        float f1 = 0.0f;
        float f2 = 1.0f;
        switch (deg) {
            case 0: {
                f1 = 1.0f;
                f2 = 0.0f;
                break;
            }
            case 90: {
                f1 = 0.0f;
                f2 = 1.0f;
                break;
            }
            case 180: {
                f1 = -1.0f;
                f2 = 0.0f;
                break;
            }
            case 270: {
                f1 = 0.0f;
                f2 = -1.0f;
            }
        }
        double d0 = vec.field_72450_a * (double)f1 + vec.field_72448_b * (double)f2;
        double d1 = vec.field_72448_b * (double)f1 - vec.field_72450_a * (double)f2;
        double d2 = vec.field_72449_c;
        vec.field_72450_a = d0;
        vec.field_72448_b = d1;
        vec.field_72449_c = d2;
    }

    private static Vec3 rotateVecX(Vec3 vec, int deg) {
        Vec3 newvec = Vec3.func_72443_a((double)(vec.field_72450_a - 0.5), (double)(vec.field_72448_b - 0.5), (double)(vec.field_72449_c - 0.5));
        newvec.func_72440_a((float)Math.toRadians(deg));
        newvec.field_72450_a += 0.5;
        newvec.field_72448_b += 0.5;
        newvec.field_72449_c += 0.5;
        return newvec;
    }

    private static Vec3 rotateVecY(Vec3 vec, int deg) {
        Vec3 newvec = Vec3.func_72443_a((double)(vec.field_72450_a - 0.5), (double)(vec.field_72448_b - 0.5), (double)(vec.field_72449_c - 0.5));
        newvec.func_72442_b((float)Math.toRadians(deg));
        newvec.field_72450_a += 0.5;
        newvec.field_72448_b += 0.5;
        newvec.field_72449_c += 0.5;
        return newvec;
    }

    private static Vec3 rotateVecZ(Vec3 vec, int deg) {
        Vec3 newvec = Vec3.func_72443_a((double)(vec.field_72450_a - 0.5), (double)(vec.field_72448_b - 0.5), (double)(vec.field_72449_c - 0.5));
        newvec.func_72446_c((float)Math.toRadians(deg));
        newvec.field_72450_a += 0.5;
        newvec.field_72448_b += 0.5;
        newvec.field_72449_c += 0.5;
        return newvec;
    }

    private static void swapVectors(Vec3 vec1, Vec3 vec2) {
        Vec3 temp = Vec3.func_72443_a((double)vec1.field_72450_a, (double)vec1.field_72448_b, (double)vec1.field_72449_c);
        vec1.field_72450_a = vec2.field_72450_a;
        vec1.field_72448_b = vec2.field_72448_b;
        vec1.field_72449_c = vec2.field_72449_c;
        vec2.field_72450_a = temp.field_72450_a;
        vec2.field_72448_b = temp.field_72448_b;
        vec2.field_72449_c = temp.field_72449_c;
    }

    private Vec3UV[][][] computeStandardBlockRotations(RenderBlocks renderer, Block block) {
        Vec3UV[][][] rotatedvecs = new Vec3UV[6][][];
        for (int rotation = 0; rotation < 6; ++rotation) {
            Vec3UV[][] vecs = this.computeStandardBlock(renderer, block, 0, 0, 0, 0);
            for (int f = 0; f < 6; ++f) {
                for (int v = 0; v < 4; ++v) {
                    Vec3 newvec = Vec3.func_72443_a((double)vecs[f][v].x, (double)vecs[f][v].y, (double)vecs[f][v].z);
                    switch (rotation) {
                        case 0: {
                            newvec = RedstonePasteRenderer.rotateVecY(newvec, 180);
                            break;
                        }
                        case 1: {
                            newvec = RedstonePasteRenderer.rotateVecX(newvec, 180);
                            newvec = RedstonePasteRenderer.rotateVecY(newvec, 180);
                            break;
                        }
                        case 2: {
                            newvec = RedstonePasteRenderer.rotateVecX(newvec, 270);
                            break;
                        }
                        case 3: {
                            newvec = RedstonePasteRenderer.rotateVecX(newvec, 90);
                            newvec = RedstonePasteRenderer.rotateVecZ(newvec, 180);
                            break;
                        }
                        case 4: {
                            newvec = RedstonePasteRenderer.rotateVecZ(newvec, 90);
                            newvec = RedstonePasteRenderer.rotateVecX(newvec, 270);
                            break;
                        }
                        case 5: {
                            newvec = RedstonePasteRenderer.rotateVecZ(newvec, 270);
                            newvec = RedstonePasteRenderer.rotateVecX(newvec, 270);
                        }
                    }
                    vecs[f][v].x = newvec.field_72450_a;
                    vecs[f][v].y = newvec.field_72448_b;
                    vecs[f][v].z = newvec.field_72449_c;
                }
            }
            rotatedvecs[rotation] = vecs;
        }
        return rotatedvecs;
    }

    private Vec3UV[][] computeRotations(Vec3UV[] originalvecs, int veccount) {
        Vec3UV[][] rotatedvecs = new Vec3UV[6][];
        for (int rotation = 0; rotation < 6; ++rotation) {
            Vec3UV[] vecs = new Vec3UV[veccount];
            for (int v = 0; v < veccount; ++v) {
                Vec3 newvec = Vec3.func_72443_a((double)originalvecs[v].x, (double)originalvecs[v].y, (double)originalvecs[v].z);
                switch (rotation) {
                    case 0: {
                        newvec = RedstonePasteRenderer.rotateVecY(newvec, 180);
                        break;
                    }
                    case 1: {
                        newvec = RedstonePasteRenderer.rotateVecX(newvec, 180);
                        newvec = RedstonePasteRenderer.rotateVecY(newvec, 180);
                        break;
                    }
                    case 2: {
                        newvec = RedstonePasteRenderer.rotateVecX(newvec, 270);
                        break;
                    }
                    case 3: {
                        newvec = RedstonePasteRenderer.rotateVecX(newvec, 90);
                        newvec = RedstonePasteRenderer.rotateVecZ(newvec, 180);
                        break;
                    }
                    case 4: {
                        newvec = RedstonePasteRenderer.rotateVecZ(newvec, 90);
                        newvec = RedstonePasteRenderer.rotateVecX(newvec, 270);
                        break;
                    }
                    case 5: {
                        newvec = RedstonePasteRenderer.rotateVecZ(newvec, 270);
                        newvec = RedstonePasteRenderer.rotateVecX(newvec, 270);
                    }
                }
                vecs[v] = new Vec3UV(newvec.field_72450_a, newvec.field_72448_b, newvec.field_72449_c, originalvecs[v].u, originalvecs[v].v);
            }
            rotatedvecs[rotation] = vecs;
        }
        return rotatedvecs;
    }

    private void renderRepeaterFace(RenderBlocks renderer, int face, int facedata, int x, int y, int z, IBlockAccess world) {
        Tessellator tessellator = Tessellator.field_78398_a;
        int facerotation = facedata & 3;
        if (face == 1 && facerotation == 0) {
            facerotation = 2;
        } else if (face == 1 && facerotation == 2) {
            facerotation = 0;
        } else if (face == 2 && facerotation == 1) {
            facerotation = 3;
        } else if (face == 2 && facerotation == 3) {
            facerotation = 1;
        } else if (face == 5 && facerotation == 1) {
            facerotation = 3;
        } else if (face == 5 && facerotation == 3) {
            facerotation = 1;
        }
        tessellator.func_78386_a(1.0f, 1.0f, 1.0f);
        boolean devmode = false;
        if (this.vecs_redstoneRepeaterIdle == null || devmode) {
            renderer.func_147782_a(0.0, 0.0, 0.0, 1.0, 0.125, 1.0);
            renderer.func_147757_a(RedstonePasteMod.instance.blockRedstonePaste.repeaterIcon_Idle);
            this.vecs_redstoneRepeaterIdle = this.computeStandardBlockRotations(renderer, (Block)Blocks.field_150413_aR);
            renderer.func_147771_a();
        }
        if (this.vecs_redstoneRepeaterActive == null || devmode) {
            renderer.func_147782_a(0.0, 0.0, 0.0, 1.0, 0.125, 1.0);
            renderer.func_147757_a(RedstonePasteMod.instance.blockRedstonePaste.repeaterIcon_Active);
            this.vecs_redstoneRepeaterActive = this.computeStandardBlockRotations(renderer, (Block)Blocks.field_150416_aS);
            renderer.func_147771_a();
        }
        Vec3UV[][][] vecs = (facedata & 4) > 0 ? this.vecs_redstoneRepeaterActive : this.vecs_redstoneRepeaterIdle;
        boolean par5 = true;
        boolean par6 = true;
        boolean par7 = true;
        float f3 = 0.5f;
        float f4 = 1.0f;
        float f5 = 0.8f;
        float f6 = 0.6f;
        float f7 = f4 * (float)par5;
        float f8 = f4 * (float)par6;
        float f9 = f4 * (float)par7;
        float f10 = f3;
        float f11 = f5;
        float f12 = f6;
        float f13 = f3;
        float f14 = f5;
        float f15 = f6;
        float f16 = f3;
        float f17 = f5;
        float f18 = f6;
        for (int f = 0; f < 6; ++f) {
            switch (f) {
                case 0: {
                    tessellator.func_78386_a(f10, f13, f16);
                    break;
                }
                case 1: {
                    tessellator.func_78386_a(f7, f8, f9);
                    break;
                }
                case 2: {
                    tessellator.func_78386_a(f11, f14, f17);
                    break;
                }
                case 3: {
                    tessellator.func_78386_a(f11, f14, f17);
                    break;
                }
                case 4: {
                    tessellator.func_78386_a(f12, f15, f18);
                    break;
                }
                case 5: {
                    tessellator.func_78386_a(f12, f15, f18);
                    break;
                }
                default: {
                    tessellator.func_78386_a(1.0f, 1.0f, 1.0f);
                }
            }
            for (int v = 0; v < 4; ++v) {
                Vec3UV[] thisface = vecs[face][f];
                int uvnum = v;
                if (f == 1) {
                    uvnum += facerotation;
                    uvnum &= 3;
                }
                tessellator.func_78374_a(thisface[v].x + (double)x, thisface[v].y + (double)y, thisface[v].z + (double)z, thisface[uvnum].u, thisface[uvnum].v);
            }
        }
        facerotation = facedata & 3;
        tessellator.func_78386_a(1.0f, 1.0f, 1.0f);
        boolean repeateractive = (facedata & 4) > 1;
        this.renderTorchOriented(renderer, face, facerotation, repeateractive, x, y, z, 0.0f, -0.18f, 0.31f);
        float baseposition = 0.065f;
        int delayswitch = (facedata & 0x18) >> 3;
        if (RedstonePasteMod.instance.blockRedstonePaste.isRepeaterLocked(world, x, y, z)) {
            this.renderLockBarOriented(renderer, face, facedata, x, y, z);
        } else {
            this.renderTorchOriented(renderer, face, facerotation, repeateractive, x, y, z, 0.0f, -0.18f, baseposition - 0.126f * (float)delayswitch);
        }
    }

    private void renderLockBarOriented(RenderBlocks renderer, int face, int facedata, int x, int y, int z) {
        float xoffset = 0.0f;
        float yoffset = 0.0f;
        float zoffset = 0.0f;
        float size = 0.125f;
        int repeaterSetting = (facedata & 0x18) >> 3;
        float sixteenth = 0.0625f;
        float position = sixteenth * (float)(6 + repeaterSetting * 2);
        position = 0.0f;
        int worlddir = BlockRedstonePaste.repeaterDirectionToWorldDirection(face, facedata);
        if (worlddir == -1) {
            return;
        }
        if (this.rotatedLockBarVecs[0] == null) {
            renderer.func_147782_a(0.125, 0.0, 0.0, 0.875, (double)size, (double)size);
            this.rotatedLockBarVecs[0] = this.computeStandardBlock(renderer, Blocks.field_150357_h, 0, 0, 0, 0);
        }
        if (this.rotatedLockBarVecs[1] == null) {
            renderer.func_147782_a(0.0, 0.0, 0.125, (double)size, (double)size, 0.875);
            this.rotatedLockBarVecs[1] = this.computeStandardBlock(renderer, Blocks.field_150357_h, 0, 0, 0, 0);
        }
        if (this.rotatedLockBarVecs[2] == null) {
            renderer.func_147782_a(0.0, 0.125, 0.0, (double)size, 0.875, (double)size);
            this.rotatedLockBarVecs[2] = this.computeStandardBlock(renderer, Blocks.field_150357_h, 0, 0, 0, 0);
        }
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78386_a(1.0f, 1.0f, 1.0f);
        int repeaterDir = facedata & 3;
        Vec3UV[][] vecs = this.rotatedLockBarVecs[0];
        block0 : switch (face) {
            case 0: 
            case 1: {
                yoffset = face == 0 ? sixteenth * 2.0f : 1.0f - sixteenth * 4.0f;
                switch (repeaterDir) {
                    case 0: {
                        vecs = this.rotatedLockBarVecs[0];
                        zoffset = sixteenth * (float)(8 - repeaterSetting * 2);
                        break;
                    }
                    case 1: {
                        vecs = this.rotatedLockBarVecs[1];
                        xoffset = sixteenth * (float)(6 + repeaterSetting * 2);
                        break;
                    }
                    case 2: {
                        vecs = this.rotatedLockBarVecs[0];
                        zoffset = sixteenth * (float)(6 + repeaterSetting * 2);
                        break;
                    }
                    case 3: {
                        vecs = this.rotatedLockBarVecs[1];
                        xoffset = sixteenth * (float)(8 - repeaterSetting * 2);
                    }
                }
                break;
            }
            case 2: 
            case 3: {
                zoffset = face == 2 ? sixteenth * 2.0f : 1.0f - sixteenth * 4.0f;
                switch (repeaterDir) {
                    case 0: {
                        vecs = this.rotatedLockBarVecs[0];
                        yoffset = sixteenth * (float)(8 - repeaterSetting * 2);
                        break;
                    }
                    case 1: {
                        vecs = this.rotatedLockBarVecs[2];
                        xoffset = sixteenth * (float)(6 + repeaterSetting * 2);
                        break;
                    }
                    case 2: {
                        vecs = this.rotatedLockBarVecs[0];
                        yoffset = sixteenth * (float)(6 + repeaterSetting * 2);
                        break;
                    }
                    case 3: {
                        vecs = this.rotatedLockBarVecs[2];
                        xoffset = sixteenth * (float)(8 - repeaterSetting * 2);
                    }
                }
                break;
            }
            case 4: 
            case 5: {
                xoffset = face == 4 ? sixteenth * 2.0f : 1.0f - sixteenth * 4.0f;
                switch (repeaterDir) {
                    case 0: {
                        vecs = this.rotatedLockBarVecs[1];
                        yoffset = sixteenth * (float)(8 - repeaterSetting * 2);
                        break block0;
                    }
                    case 1: {
                        vecs = this.rotatedLockBarVecs[2];
                        zoffset = sixteenth * (float)(6 + repeaterSetting * 2);
                        break block0;
                    }
                    case 2: {
                        vecs = this.rotatedLockBarVecs[1];
                        yoffset = sixteenth * (float)(6 + repeaterSetting * 2);
                        break block0;
                    }
                    case 3: {
                        vecs = this.rotatedLockBarVecs[2];
                        zoffset = sixteenth * (float)(8 - repeaterSetting * 2);
                    }
                }
            }
        }
        float f3 = 0.5f;
        float f4 = 1.0f;
        float f5 = 0.8f;
        float f6 = 0.6f;
        float f7 = f4;
        float f8 = f4;
        float f9 = f4;
        float f10 = f3;
        float f11 = f5;
        float f12 = f6;
        float f13 = f3;
        float f14 = f5;
        float f15 = f6;
        float f16 = f3;
        float f17 = f5;
        float f18 = f6;
        for (int f = 0; f < 6; ++f) {
            switch (f) {
                case 0: {
                    tessellator.func_78386_a(f10, f13, f16);
                    break;
                }
                case 1: {
                    tessellator.func_78386_a(f7, f8, f9);
                    break;
                }
                case 2: {
                    tessellator.func_78386_a(f11, f14, f17);
                    break;
                }
                case 3: {
                    tessellator.func_78386_a(f11, f14, f17);
                    break;
                }
                case 4: {
                    tessellator.func_78386_a(f12, f15, f18);
                    break;
                }
                case 5: {
                    tessellator.func_78386_a(f12, f15, f18);
                }
            }
            for (int v = 0; v < 4; ++v) {
                tessellator.func_78374_a((double)x + vecs[f][v].x + (double)xoffset, (double)y + vecs[f][v].y + (double)yoffset, (double)z + vecs[f][v].z + (double)zoffset, vecs[f][v].u, vecs[f][v].v);
            }
        }
    }

    private void renderTorchOriented(RenderBlocks renderer, int face, int facerotation, boolean torchactive, int x, int y, int z, float xoffset, float yoffset, float zoffset) {
        Vec3UV[] vecs;
        boolean devmode = false;
        if (this.vecs_redstoneTorchActive == null || devmode) {
            vecs = this.computeTorchAtAngle(renderer, Blocks.field_150429_aA, 0.0, 0.0, 0.0, 0.0, 0.0, 0);
            this.vecs_redstoneTorchActive = this.computeRotations(vecs, 24);
        }
        if (this.vecs_redstoneTorchIdle == null || devmode) {
            vecs = this.computeTorchAtAngle(renderer, Blocks.field_150437_az, 0.0, 0.0, 0.0, 0.0, 0.0, 0);
            this.vecs_redstoneTorchIdle = this.computeRotations(vecs, 24);
        }
        Vec3UV[] torch = torchactive ? this.vecs_redstoneTorchActive[face] : this.vecs_redstoneTorchIdle[face];
        Vec3 vec = Vec3.func_72443_a((double)((double)xoffset + 0.5), (double)((double)yoffset + 0.5), (double)((double)zoffset + 0.5));
        switch (face) {
            case 0: {
                vec = Vec3.func_72443_a((double)((double)xoffset + 0.5), (double)((double)yoffset + 0.5), (double)((double)zoffset + 0.5));
                break;
            }
            case 1: {
                vec = Vec3.func_72443_a((double)((double)xoffset + 0.5), (double)((double)(-yoffset) + 0.5), (double)((double)zoffset + 0.5));
                break;
            }
            case 2: {
                vec = Vec3.func_72443_a((double)((double)xoffset + 0.5), (double)((double)zoffset + 0.5), (double)((double)yoffset + 0.5));
                break;
            }
            case 3: {
                vec = Vec3.func_72443_a((double)((double)xoffset + 0.5), (double)((double)zoffset + 0.5), (double)((double)(-yoffset) + 0.5));
                break;
            }
            case 4: {
                vec = Vec3.func_72443_a((double)((double)yoffset + 0.5), (double)((double)zoffset + 0.5), (double)((double)xoffset + 0.5));
                break;
            }
            case 5: {
                vec = Vec3.func_72443_a((double)((double)(-yoffset) + 0.5), (double)((double)zoffset + 0.5), (double)((double)xoffset + 0.5));
            }
        }
        int[] degtrans = new int[]{0, 90, 180, 270};
        int[] degtrans2 = new int[]{0, 270, 180, 90};
        switch (face) {
            case 0: 
            case 1: {
                vec = RedstonePasteRenderer.rotateVecY(vec, degtrans2[facerotation]);
                break;
            }
            case 2: 
            case 3: {
                vec = RedstonePasteRenderer.rotateVecZ(vec, degtrans2[facerotation]);
                break;
            }
            case 4: 
            case 5: {
                vec = RedstonePasteRenderer.rotateVecX(vec, degtrans[facerotation]);
            }
        }
        xoffset = (float)vec.field_72450_a - 0.5f;
        yoffset = (float)vec.field_72448_b - 0.5f;
        zoffset = (float)vec.field_72449_c - 0.5f;
        for (int n = 0; n < 24; ++n) {
            Tessellator.field_78398_a.func_78374_a((double)x + torch[n].x + (double)xoffset, (double)y + torch[n].y + (double)yoffset, (double)z + torch[n].z + (double)zoffset, torch[n].u, torch[n].v);
        }
    }

    private void renderComparatorFace(RenderBlocks renderer, int face, int facedata, int x, int y, int z, IBlockAccess world) {
        renderer.func_147782_a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        Tessellator tessellator = Tessellator.field_78398_a;
        int facerotation = facedata & 3;
        if (face == 1 && facerotation == 0) {
            facerotation = 2;
        } else if (face == 1 && facerotation == 2) {
            facerotation = 0;
        } else if (face == 2 && facerotation == 1) {
            facerotation = 3;
        } else if (face == 2 && facerotation == 3) {
            facerotation = 1;
        } else if (face == 5 && facerotation == 1) {
            facerotation = 3;
        } else if (face == 5 && facerotation == 3) {
            facerotation = 1;
        }
        tessellator.func_78386_a(1.0f, 1.0f, 1.0f);
        boolean devmode = false;
        if (this.vecs_redstoneComparatorIdle == null || devmode) {
            renderer.func_147782_a(0.0, 0.0, 0.0, 1.0, 0.125, 1.0);
            renderer.func_147757_a(RedstonePasteMod.instance.blockRedstonePaste.comparatorIcon_Idle);
            this.vecs_redstoneComparatorIdle = this.computeStandardBlockRotations(renderer, (Block)Blocks.field_150441_bU);
            renderer.func_147771_a();
        }
        if (this.vecs_redstoneComparatorActive == null || devmode) {
            renderer.func_147782_a(0.0, 0.0, 0.0, 1.0, 0.125, 1.0);
            renderer.func_147757_a(RedstonePasteMod.instance.blockRedstonePaste.comparatorIcon_Active);
            this.vecs_redstoneComparatorActive = this.computeStandardBlockRotations(renderer, (Block)Blocks.field_150455_bV);
            renderer.func_147771_a();
        }
        boolean comparatormode = (facedata & 4) > 0;
        boolean comparatoractive = (facedata & 0x78) > 0;
        Vec3UV[][][] vecs = comparatoractive ? this.vecs_redstoneComparatorActive : this.vecs_redstoneComparatorIdle;
        boolean par5 = true;
        boolean par6 = true;
        boolean par7 = true;
        float f3 = 0.5f;
        float f4 = 1.0f;
        float f5 = 0.8f;
        float f6 = 0.6f;
        float f7 = f4 * (float)par5;
        float f8 = f4 * (float)par6;
        float f9 = f4 * (float)par7;
        float f10 = f3;
        float f11 = f5;
        float f12 = f6;
        float f13 = f3;
        float f14 = f5;
        float f15 = f6;
        float f16 = f3;
        float f17 = f5;
        float f18 = f6;
        for (int f = 0; f < 6; ++f) {
            switch (f) {
                case 0: {
                    tessellator.func_78386_a(f10, f13, f16);
                    break;
                }
                case 1: {
                    tessellator.func_78386_a(f7, f8, f9);
                    break;
                }
                case 2: {
                    tessellator.func_78386_a(f11, f14, f17);
                    break;
                }
                case 3: {
                    tessellator.func_78386_a(f11, f14, f17);
                    break;
                }
                case 4: {
                    tessellator.func_78386_a(f12, f15, f18);
                    break;
                }
                case 5: {
                    tessellator.func_78386_a(f12, f15, f18);
                    break;
                }
                default: {
                    tessellator.func_78386_a(1.0f, 1.0f, 1.0f);
                }
            }
            for (int v = 0; v < 4; ++v) {
                Vec3UV[] thisface = vecs[face][f];
                int uvnum = v;
                if (f == 1) {
                    uvnum += facerotation;
                    uvnum &= 3;
                }
                tessellator.func_78374_a(thisface[v].x + (double)x, thisface[v].y + (double)y, thisface[v].z + (double)z, thisface[uvnum].u, thisface[uvnum].v);
            }
        }
        tessellator.func_78386_a(1.0f, 1.0f, 1.0f);
        facerotation = facedata & 3;
        this.renderTorchOriented(renderer, face, facerotation, comparatormode, x, y, z, 0.0f, comparatormode ? -0.1875f : -0.375f, 0.31f);
        this.renderTorchOriented(renderer, face, facerotation, comparatoractive, x, y, z, 0.1875f, -0.1875f, -0.25f);
        this.renderTorchOriented(renderer, face, facerotation, comparatoractive, x, y, z, -0.1875f, -0.1875f, -0.25f);
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78380_c(block.func_149677_c(renderer.field_147845_a, x, y, z));
        float f = 1.0f;
        int l = block.func_149720_d(renderer.field_147845_a, x, y, z);
        float f1 = (float)(l >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(l >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(l & 0xFF) / 255.0f;
        if (EntityRenderer.field_78517_a) {
            float f4 = (f1 * 30.0f + f2 * 59.0f + f3 * 11.0f) / 100.0f;
            float f5 = (f1 * 30.0f + f2 * 70.0f) / 100.0f;
            float f6 = (f1 * 30.0f + f3 * 70.0f) / 100.0f;
            f1 = f4;
            f2 = f5;
            f3 = f6;
        }
        tessellator.func_78386_a(f * f1, f * f2, f * f3);
        renderer.func_147782_a(0.0, 0.015625, 0.0, 1.0, 0.015625, 1.0);
        IIcon icon1 = RedstonePasteMod.instance.blockRedstonePaste.func_149691_a(0, 0);
        int[] faces = new int[6];
        int[] strengths = new int[6];
        TileEntityRedstonePaste te = (TileEntityRedstonePaste)world.func_147438_o(x, y, z);
        if (te != null) {
            for (int n = 0; n < 6; ++n) {
                faces[n] = te.faces[n];
                strengths[n] = te.facedata[n];
            }
        }
        boolean noOverride = false;
        if (renderer.field_147840_d == null) {
            noOverride = true;
        }
        for (int n = 0; n < 6; ++n) {
            if (faces[n] > 0 && noOverride) {
                this.renderPasteFace(renderer, strengths[n], n, faces[n], x, y, z, icon1);
            }
            if (te.facetype[n] == 1) {
                this.renderSlabFace(renderer, n, te.facedata[n], x, y, z);
            }
            if (te.facetype[n] == 2 && noOverride) {
                this.renderRepeaterFace(renderer, n, te.facedata[n], x, y, z, world);
            }
            if (te.facetype[n] != 3 || !noOverride) continue;
            this.renderComparatorFace(renderer, n, te.facedata[n], x, y, z, world);
        }
        renderer.func_147771_a();
        return true;
    }

    public int getRenderId() {
        return CommonProxy.renderRedstonePasteID;
    }

    private Vec3UV[] computeFaceYNeg(RenderBlocks renderer, double par2, double par4, double par6, IIcon par8Icon) {
        Tessellator tessellator = Tessellator.field_78398_a;
        if (renderer.func_147744_b()) {
            par8Icon = renderer.field_147840_d;
        }
        double d3 = par8Icon.func_94214_a(renderer.field_147859_h * 16.0);
        double d4 = par8Icon.func_94214_a(renderer.field_147861_i * 16.0);
        double d5 = par8Icon.func_94207_b(renderer.field_147851_l * 16.0);
        double d6 = par8Icon.func_94207_b(renderer.field_147853_m * 16.0);
        if (renderer.field_147859_h < 0.0 || renderer.field_147861_i > 1.0) {
            d3 = par8Icon.func_94209_e();
            d4 = par8Icon.func_94212_f();
        }
        if (renderer.field_147851_l < 0.0 || renderer.field_147853_m > 1.0) {
            d5 = par8Icon.func_94206_g();
            d6 = par8Icon.func_94210_h();
        }
        double d7 = d4;
        double d8 = d3;
        double d9 = d5;
        double d10 = d6;
        if (renderer.field_147865_v == 2) {
            d3 = par8Icon.func_94214_a(renderer.field_147851_l * 16.0);
            d5 = par8Icon.func_94207_b(16.0 - renderer.field_147861_i * 16.0);
            d4 = par8Icon.func_94214_a(renderer.field_147853_m * 16.0);
            d6 = par8Icon.func_94207_b(16.0 - renderer.field_147859_h * 16.0);
            d9 = d5;
            d10 = d6;
            d7 = d3;
            d8 = d4;
            d5 = d6;
            d6 = d9;
        } else if (renderer.field_147865_v == 1) {
            d3 = par8Icon.func_94214_a(16.0 - renderer.field_147853_m * 16.0);
            d5 = par8Icon.func_94207_b(renderer.field_147859_h * 16.0);
            d4 = par8Icon.func_94214_a(16.0 - renderer.field_147851_l * 16.0);
            d6 = par8Icon.func_94207_b(renderer.field_147861_i * 16.0);
            d7 = d4;
            d8 = d3;
            d3 = d4;
            d4 = d8;
            d9 = d6;
            d10 = d5;
        } else if (renderer.field_147865_v == 3) {
            d3 = par8Icon.func_94214_a(16.0 - renderer.field_147859_h * 16.0);
            d4 = par8Icon.func_94214_a(16.0 - renderer.field_147861_i * 16.0);
            d5 = par8Icon.func_94207_b(16.0 - renderer.field_147851_l * 16.0);
            d6 = par8Icon.func_94207_b(16.0 - renderer.field_147853_m * 16.0);
            d7 = d4;
            d8 = d3;
            d9 = d5;
            d10 = d6;
        }
        double d11 = par2 + renderer.field_147859_h;
        double d12 = par2 + renderer.field_147861_i;
        double d13 = par4 + renderer.field_147855_j;
        double d14 = par6 + renderer.field_147851_l;
        double d15 = par6 + renderer.field_147853_m;
        Vec3UV[] vecs = new Vec3UV[]{new Vec3UV(d11, d13, d15, d8, d10), new Vec3UV(d11, d13, d14, d3, d5), new Vec3UV(d12, d13, d14, d7, d9), new Vec3UV(d12, d13, d15, d4, d6)};
        return vecs;
    }

    private Vec3UV[] computeFaceYPos(RenderBlocks renderer, double par2, double par4, double par6, IIcon par8Icon) {
        Tessellator tessellator = Tessellator.field_78398_a;
        if (renderer.func_147744_b()) {
            par8Icon = renderer.field_147840_d;
        }
        double d3 = par8Icon.func_94214_a(renderer.field_147859_h * 16.0);
        double d4 = par8Icon.func_94214_a(renderer.field_147861_i * 16.0);
        double d5 = par8Icon.func_94207_b(renderer.field_147851_l * 16.0);
        double d6 = par8Icon.func_94207_b(renderer.field_147853_m * 16.0);
        if (renderer.field_147859_h < 0.0 || renderer.field_147861_i > 1.0) {
            d3 = par8Icon.func_94209_e();
            d4 = par8Icon.func_94212_f();
        }
        if (renderer.field_147851_l < 0.0 || renderer.field_147853_m > 1.0) {
            d5 = par8Icon.func_94206_g();
            d6 = par8Icon.func_94210_h();
        }
        double d7 = d4;
        double d8 = d3;
        double d9 = d5;
        double d10 = d6;
        if (renderer.field_147867_u == 1) {
            d3 = par8Icon.func_94214_a(renderer.field_147851_l * 16.0);
            d5 = par8Icon.func_94207_b(16.0 - renderer.field_147861_i * 16.0);
            d4 = par8Icon.func_94214_a(renderer.field_147853_m * 16.0);
            d6 = par8Icon.func_94207_b(16.0 - renderer.field_147859_h * 16.0);
            d9 = d5;
            d10 = d6;
            d7 = d3;
            d8 = d4;
            d5 = d6;
            d6 = d9;
        } else if (renderer.field_147867_u == 2) {
            d3 = par8Icon.func_94214_a(16.0 - renderer.field_147853_m * 16.0);
            d5 = par8Icon.func_94207_b(renderer.field_147859_h * 16.0);
            d4 = par8Icon.func_94214_a(16.0 - renderer.field_147851_l * 16.0);
            d6 = par8Icon.func_94207_b(renderer.field_147861_i * 16.0);
            d7 = d4;
            d8 = d3;
            d3 = d4;
            d4 = d8;
            d9 = d6;
            d10 = d5;
        } else if (renderer.field_147867_u == 3) {
            d3 = par8Icon.func_94214_a(16.0 - renderer.field_147859_h * 16.0);
            d4 = par8Icon.func_94214_a(16.0 - renderer.field_147861_i * 16.0);
            d5 = par8Icon.func_94207_b(16.0 - renderer.field_147851_l * 16.0);
            d6 = par8Icon.func_94207_b(16.0 - renderer.field_147853_m * 16.0);
            d7 = d4;
            d8 = d3;
            d9 = d5;
            d10 = d6;
        }
        double d11 = par2 + renderer.field_147859_h;
        double d12 = par2 + renderer.field_147861_i;
        double d13 = par4 + renderer.field_147857_k;
        double d14 = par6 + renderer.field_147851_l;
        double d15 = par6 + renderer.field_147853_m;
        Vec3UV[] vecs = new Vec3UV[]{new Vec3UV(d12, d13, d15, d4, d6), new Vec3UV(d12, d13, d14, d7, d9), new Vec3UV(d11, d13, d14, d3, d5), new Vec3UV(d11, d13, d15, d8, d10)};
        return vecs;
    }

    private Vec3UV[] computeFaceZNeg(RenderBlocks renderer, double par2, double par4, double par6, IIcon par8Icon) {
        double d7;
        Tessellator tessellator = Tessellator.field_78398_a;
        if (renderer.func_147744_b()) {
            par8Icon = renderer.field_147840_d;
        }
        double d3 = par8Icon.func_94214_a(renderer.field_147859_h * 16.0);
        double d4 = par8Icon.func_94214_a(renderer.field_147861_i * 16.0);
        double d5 = par8Icon.func_94207_b(16.0 - renderer.field_147857_k * 16.0);
        double d6 = par8Icon.func_94207_b(16.0 - renderer.field_147855_j * 16.0);
        if (renderer.field_147842_e) {
            d7 = d3;
            d3 = d4;
            d4 = d7;
        }
        if (renderer.field_147859_h < 0.0 || renderer.field_147861_i > 1.0) {
            d3 = par8Icon.func_94209_e();
            d4 = par8Icon.func_94212_f();
        }
        if (renderer.field_147855_j < 0.0 || renderer.field_147857_k > 1.0) {
            d5 = par8Icon.func_94206_g();
            d6 = par8Icon.func_94210_h();
        }
        d7 = d4;
        double d8 = d3;
        double d9 = d5;
        double d10 = d6;
        if (renderer.field_147875_q == 2) {
            d3 = par8Icon.func_94214_a(renderer.field_147855_j * 16.0);
            d5 = par8Icon.func_94207_b(16.0 - renderer.field_147859_h * 16.0);
            d4 = par8Icon.func_94214_a(renderer.field_147857_k * 16.0);
            d6 = par8Icon.func_94207_b(16.0 - renderer.field_147861_i * 16.0);
            d9 = d5;
            d10 = d6;
            d7 = d3;
            d8 = d4;
            d5 = d6;
            d6 = d9;
        } else if (renderer.field_147875_q == 1) {
            d3 = par8Icon.func_94214_a(16.0 - renderer.field_147857_k * 16.0);
            d5 = par8Icon.func_94207_b(renderer.field_147861_i * 16.0);
            d4 = par8Icon.func_94214_a(16.0 - renderer.field_147855_j * 16.0);
            d6 = par8Icon.func_94207_b(renderer.field_147859_h * 16.0);
            d7 = d4;
            d8 = d3;
            d3 = d4;
            d4 = d8;
            d9 = d6;
            d10 = d5;
        } else if (renderer.field_147875_q == 3) {
            d3 = par8Icon.func_94214_a(16.0 - renderer.field_147859_h * 16.0);
            d4 = par8Icon.func_94214_a(16.0 - renderer.field_147861_i * 16.0);
            d5 = par8Icon.func_94207_b(renderer.field_147857_k * 16.0);
            d6 = par8Icon.func_94207_b(renderer.field_147855_j * 16.0);
            d7 = d4;
            d8 = d3;
            d9 = d5;
            d10 = d6;
        }
        double d11 = par2 + renderer.field_147859_h;
        double d12 = par2 + renderer.field_147861_i;
        double d13 = par4 + renderer.field_147855_j;
        double d14 = par4 + renderer.field_147857_k;
        double d15 = par6 + renderer.field_147851_l;
        Vec3UV[] vecs = new Vec3UV[]{new Vec3UV(d11, d14, d15, d7, d9), new Vec3UV(d12, d14, d15, d3, d5), new Vec3UV(d12, d13, d15, d8, d10), new Vec3UV(d11, d13, d15, d4, d6)};
        return vecs;
    }

    private Vec3UV[] computeFaceZPos(RenderBlocks renderer, double par2, double par4, double par6, IIcon par8Icon) {
        double d7;
        Tessellator tessellator = Tessellator.field_78398_a;
        if (renderer.func_147744_b()) {
            par8Icon = renderer.field_147840_d;
        }
        double d3 = par8Icon.func_94214_a(renderer.field_147859_h * 16.0);
        double d4 = par8Icon.func_94214_a(renderer.field_147861_i * 16.0);
        double d5 = par8Icon.func_94207_b(16.0 - renderer.field_147857_k * 16.0);
        double d6 = par8Icon.func_94207_b(16.0 - renderer.field_147855_j * 16.0);
        if (renderer.field_147842_e) {
            d7 = d3;
            d3 = d4;
            d4 = d7;
        }
        if (renderer.field_147859_h < 0.0 || renderer.field_147861_i > 1.0) {
            d3 = par8Icon.func_94209_e();
            d4 = par8Icon.func_94212_f();
        }
        if (renderer.field_147855_j < 0.0 || renderer.field_147857_k > 1.0) {
            d5 = par8Icon.func_94206_g();
            d6 = par8Icon.func_94210_h();
        }
        d7 = d4;
        double d8 = d3;
        double d9 = d5;
        double d10 = d6;
        if (renderer.field_147873_r == 1) {
            d3 = par8Icon.func_94214_a(renderer.field_147855_j * 16.0);
            d6 = par8Icon.func_94207_b(16.0 - renderer.field_147859_h * 16.0);
            d4 = par8Icon.func_94214_a(renderer.field_147857_k * 16.0);
            d9 = d5 = (double)par8Icon.func_94207_b(16.0 - renderer.field_147861_i * 16.0);
            d10 = d6;
            d7 = d3;
            d8 = d4;
            d5 = d6;
            d6 = d9;
        } else if (renderer.field_147873_r == 2) {
            d3 = par8Icon.func_94214_a(16.0 - renderer.field_147857_k * 16.0);
            d5 = par8Icon.func_94207_b(renderer.field_147859_h * 16.0);
            d4 = par8Icon.func_94214_a(16.0 - renderer.field_147855_j * 16.0);
            d6 = par8Icon.func_94207_b(renderer.field_147861_i * 16.0);
            d7 = d4;
            d8 = d3;
            d3 = d4;
            d4 = d8;
            d9 = d6;
            d10 = d5;
        } else if (renderer.field_147873_r == 3) {
            d3 = par8Icon.func_94214_a(16.0 - renderer.field_147859_h * 16.0);
            d4 = par8Icon.func_94214_a(16.0 - renderer.field_147861_i * 16.0);
            d5 = par8Icon.func_94207_b(renderer.field_147857_k * 16.0);
            d6 = par8Icon.func_94207_b(renderer.field_147855_j * 16.0);
            d7 = d4;
            d8 = d3;
            d9 = d5;
            d10 = d6;
        }
        double d11 = par2 + renderer.field_147859_h;
        double d12 = par2 + renderer.field_147861_i;
        double d13 = par4 + renderer.field_147855_j;
        double d14 = par4 + renderer.field_147857_k;
        double d15 = par6 + renderer.field_147853_m;
        Vec3UV[] vecs = new Vec3UV[]{new Vec3UV(d11, d14, d15, d3, d5), new Vec3UV(d11, d13, d15, d8, d10), new Vec3UV(d12, d13, d15, d4, d6), new Vec3UV(d12, d14, d15, d7, d9)};
        return vecs;
    }

    private Vec3UV[] computeFaceXNeg(RenderBlocks renderer, double par2, double par4, double par6, IIcon par8Icon) {
        double d7;
        Tessellator tessellator = Tessellator.field_78398_a;
        if (renderer.func_147744_b()) {
            par8Icon = renderer.field_147840_d;
        }
        double d3 = par8Icon.func_94214_a(renderer.field_147851_l * 16.0);
        double d4 = par8Icon.func_94214_a(renderer.field_147853_m * 16.0);
        double d5 = par8Icon.func_94207_b(16.0 - renderer.field_147857_k * 16.0);
        double d6 = par8Icon.func_94207_b(16.0 - renderer.field_147855_j * 16.0);
        if (renderer.field_147842_e) {
            d7 = d3;
            d3 = d4;
            d4 = d7;
        }
        if (renderer.field_147851_l < 0.0 || renderer.field_147853_m > 1.0) {
            d3 = par8Icon.func_94209_e();
            d4 = par8Icon.func_94212_f();
        }
        if (renderer.field_147855_j < 0.0 || renderer.field_147857_k > 1.0) {
            d5 = par8Icon.func_94206_g();
            d6 = par8Icon.func_94210_h();
        }
        d7 = d4;
        double d8 = d3;
        double d9 = d5;
        double d10 = d6;
        if (renderer.field_147869_t == 1) {
            d3 = par8Icon.func_94214_a(renderer.field_147855_j * 16.0);
            d5 = par8Icon.func_94207_b(16.0 - renderer.field_147853_m * 16.0);
            d4 = par8Icon.func_94214_a(renderer.field_147857_k * 16.0);
            d6 = par8Icon.func_94207_b(16.0 - renderer.field_147851_l * 16.0);
            d9 = d5;
            d10 = d6;
            d7 = d3;
            d8 = d4;
            d5 = d6;
            d6 = d9;
        } else if (renderer.field_147869_t == 2) {
            d3 = par8Icon.func_94214_a(16.0 - renderer.field_147857_k * 16.0);
            d5 = par8Icon.func_94207_b(renderer.field_147851_l * 16.0);
            d4 = par8Icon.func_94214_a(16.0 - renderer.field_147855_j * 16.0);
            d6 = par8Icon.func_94207_b(renderer.field_147853_m * 16.0);
            d7 = d4;
            d8 = d3;
            d3 = d4;
            d4 = d8;
            d9 = d6;
            d10 = d5;
        } else if (renderer.field_147869_t == 3) {
            d3 = par8Icon.func_94214_a(16.0 - renderer.field_147851_l * 16.0);
            d4 = par8Icon.func_94214_a(16.0 - renderer.field_147853_m * 16.0);
            d5 = par8Icon.func_94207_b(renderer.field_147857_k * 16.0);
            d6 = par8Icon.func_94207_b(renderer.field_147855_j * 16.0);
            d7 = d4;
            d8 = d3;
            d9 = d5;
            d10 = d6;
        }
        double d11 = par2 + renderer.field_147859_h;
        double d12 = par4 + renderer.field_147855_j;
        double d13 = par4 + renderer.field_147857_k;
        double d14 = par6 + renderer.field_147851_l;
        double d15 = par6 + renderer.field_147853_m;
        Vec3UV[] vecs = new Vec3UV[]{new Vec3UV(d11, d13, d15, d7, d9), new Vec3UV(d11, d13, d14, d3, d5), new Vec3UV(d11, d12, d14, d8, d10), new Vec3UV(d11, d12, d15, d4, d6)};
        return vecs;
    }

    private Vec3UV[] computeFaceXPos(RenderBlocks renderer, double par2, double par4, double par6, IIcon par8Icon) {
        double d7;
        Tessellator tessellator = Tessellator.field_78398_a;
        if (renderer.func_147744_b()) {
            par8Icon = renderer.field_147840_d;
        }
        double d3 = par8Icon.func_94214_a(renderer.field_147851_l * 16.0);
        double d4 = par8Icon.func_94214_a(renderer.field_147853_m * 16.0);
        double d5 = par8Icon.func_94207_b(16.0 - renderer.field_147857_k * 16.0);
        double d6 = par8Icon.func_94207_b(16.0 - renderer.field_147855_j * 16.0);
        if (renderer.field_147842_e) {
            d7 = d3;
            d3 = d4;
            d4 = d7;
        }
        if (renderer.field_147851_l < 0.0 || renderer.field_147853_m > 1.0) {
            d3 = par8Icon.func_94209_e();
            d4 = par8Icon.func_94212_f();
        }
        if (renderer.field_147855_j < 0.0 || renderer.field_147857_k > 1.0) {
            d5 = par8Icon.func_94206_g();
            d6 = par8Icon.func_94210_h();
        }
        d7 = d4;
        double d8 = d3;
        double d9 = d5;
        double d10 = d6;
        if (renderer.field_147871_s == 2) {
            d3 = par8Icon.func_94214_a(renderer.field_147855_j * 16.0);
            d5 = par8Icon.func_94207_b(16.0 - renderer.field_147851_l * 16.0);
            d4 = par8Icon.func_94214_a(renderer.field_147857_k * 16.0);
            d6 = par8Icon.func_94207_b(16.0 - renderer.field_147853_m * 16.0);
            d9 = d5;
            d10 = d6;
            d7 = d3;
            d8 = d4;
            d5 = d6;
            d6 = d9;
        } else if (renderer.field_147871_s == 1) {
            d3 = par8Icon.func_94214_a(16.0 - renderer.field_147857_k * 16.0);
            d5 = par8Icon.func_94207_b(renderer.field_147853_m * 16.0);
            d4 = par8Icon.func_94214_a(16.0 - renderer.field_147855_j * 16.0);
            d6 = par8Icon.func_94207_b(renderer.field_147851_l * 16.0);
            d7 = d4;
            d8 = d3;
            d3 = d4;
            d4 = d8;
            d9 = d6;
            d10 = d5;
        } else if (renderer.field_147871_s == 3) {
            d3 = par8Icon.func_94214_a(16.0 - renderer.field_147851_l * 16.0);
            d4 = par8Icon.func_94214_a(16.0 - renderer.field_147853_m * 16.0);
            d5 = par8Icon.func_94207_b(renderer.field_147857_k * 16.0);
            d6 = par8Icon.func_94207_b(renderer.field_147855_j * 16.0);
            d7 = d4;
            d8 = d3;
            d9 = d5;
            d10 = d6;
        }
        double d11 = par2 + renderer.field_147861_i;
        double d12 = par4 + renderer.field_147855_j;
        double d13 = par4 + renderer.field_147857_k;
        double d14 = par6 + renderer.field_147851_l;
        double d15 = par6 + renderer.field_147853_m;
        Vec3UV[] vecs = new Vec3UV[]{new Vec3UV(d11, d12, d15, d8, d10), new Vec3UV(d11, d12, d14, d4, d6), new Vec3UV(d11, d13, d14, d7, d9), new Vec3UV(d11, d13, d15, d3, d5)};
        return vecs;
    }

    private Vec3UV[][] computeStandardBlock(RenderBlocks renderer, Block par1Block, int par2, int par3, int par4, int face) {
        renderer.field_147863_w = false;
        Tessellator tessellator = Tessellator.field_78398_a;
        float f3 = 0.5f;
        float f4 = 1.0f;
        float f5 = 0.8f;
        float f6 = 0.6f;
        float f10 = f3;
        float f11 = f5;
        float f12 = f6;
        float f13 = f3;
        float f14 = f5;
        float f15 = f6;
        float f16 = f3;
        float f17 = f5;
        float f18 = f6;
        par2 = 0;
        par3 = 0;
        par4 = 0;
        Vec3UV[][] vecs = new Vec3UV[6][];
        IIcon icon = renderer.func_147793_a(par1Block, renderer.field_147845_a, par2, par3, par4, ForgeDirection.ROTATION_MATRIX[face][0]);
        vecs[0] = this.computeFaceYNeg(renderer, par2, par3, par4, icon);
        icon = renderer.func_147793_a(par1Block, renderer.field_147845_a, par2, par3, par4, ForgeDirection.ROTATION_MATRIX[face][1]);
        vecs[1] = this.computeFaceYPos(renderer, par2, par3, par4, icon);
        icon = renderer.func_147793_a(par1Block, renderer.field_147845_a, par2, par3, par4, ForgeDirection.ROTATION_MATRIX[face][2]);
        vecs[2] = this.computeFaceZNeg(renderer, par2, par3, par4, icon);
        icon = renderer.func_147793_a(par1Block, renderer.field_147845_a, par2, par3, par4, ForgeDirection.ROTATION_MATRIX[face][3]);
        vecs[3] = this.computeFaceZPos(renderer, par2, par3, par4, icon);
        icon = renderer.func_147793_a(par1Block, renderer.field_147845_a, par2, par3, par4, ForgeDirection.ROTATION_MATRIX[face][4]);
        vecs[4] = this.computeFaceXNeg(renderer, par2, par3, par4, icon);
        icon = renderer.func_147793_a(par1Block, renderer.field_147845_a, par2, par3, par4, ForgeDirection.ROTATION_MATRIX[face][5]);
        vecs[5] = this.computeFaceXPos(renderer, par2, par3, par4, icon);
        return vecs;
    }

    private Vec3UV[] computeTorchAtAngle(RenderBlocks renderer, Block par1Block, double par2, double par4, double par6, double par8, double par10, int par12) {
        Tessellator tessellator = Tessellator.field_78398_a;
        IIcon icon = renderer.func_147787_a(par1Block, 0, par12);
        if (renderer.func_147744_b()) {
            icon = renderer.field_147840_d;
        }
        double d5 = icon.func_94209_e();
        double d6 = icon.func_94206_g();
        double d7 = icon.func_94212_f();
        double d8 = icon.func_94210_h();
        double d9 = icon.func_94214_a(7.0);
        double d10 = icon.func_94207_b(6.0);
        double d11 = icon.func_94214_a(9.0);
        double d12 = icon.func_94207_b(8.0);
        double d13 = icon.func_94214_a(7.0);
        double d14 = icon.func_94207_b(13.0);
        double d15 = icon.func_94214_a(9.0);
        double d16 = icon.func_94207_b(15.0);
        double d17 = (par2 += 0.5) - 0.5;
        double d18 = par2 + 0.5;
        double d19 = (par6 += 0.5) - 0.5;
        double d20 = par6 + 0.5;
        double d21 = 0.0625;
        double d22 = 0.625;
        Vec3UV[] vecs = new Vec3UV[]{new Vec3UV(par2 + par8 * (1.0 - d22) - d21, par4 + d22, par6 + par10 * (1.0 - d22) - d21, d9, d10), new Vec3UV(par2 + par8 * (1.0 - d22) - d21, par4 + d22, par6 + par10 * (1.0 - d22) + d21, d9, d12), new Vec3UV(par2 + par8 * (1.0 - d22) + d21, par4 + d22, par6 + par10 * (1.0 - d22) + d21, d11, d12), new Vec3UV(par2 + par8 * (1.0 - d22) + d21, par4 + d22, par6 + par10 * (1.0 - d22) - d21, d11, d10), new Vec3UV(par2 + d21 + par8, par4, par6 - d21 + par10, d15, d14), new Vec3UV(par2 + d21 + par8, par4, par6 + d21 + par10, d15, d16), new Vec3UV(par2 - d21 + par8, par4, par6 + d21 + par10, d13, d16), new Vec3UV(par2 - d21 + par8, par4, par6 - d21 + par10, d13, d14), new Vec3UV(par2 - d21, par4 + 1.0, d19, d5, d6), new Vec3UV(par2 - d21 + par8, par4 + 0.0, d19 + par10, d5, d8), new Vec3UV(par2 - d21 + par8, par4 + 0.0, d20 + par10, d7, d8), new Vec3UV(par2 - d21, par4 + 1.0, d20, d7, d6), new Vec3UV(par2 + d21, par4 + 1.0, d20, d5, d6), new Vec3UV(par2 + par8 + d21, par4 + 0.0, d20 + par10, d5, d8), new Vec3UV(par2 + par8 + d21, par4 + 0.0, d19 + par10, d7, d8), new Vec3UV(par2 + d21, par4 + 1.0, d19, d7, d6), new Vec3UV(d17, par4 + 1.0, par6 + d21, d5, d6), new Vec3UV(d17 + par8, par4 + 0.0, par6 + d21 + par10, d5, d8), new Vec3UV(d18 + par8, par4 + 0.0, par6 + d21 + par10, d7, d8), new Vec3UV(d18, par4 + 1.0, par6 + d21, d7, d6), new Vec3UV(d18, par4 + 1.0, par6 - d21, d5, d6), new Vec3UV(d18 + par8, par4 + 0.0, par6 - d21 + par10, d5, d8), new Vec3UV(d17 + par8, par4 + 0.0, par6 - d21 + par10, d7, d8), new Vec3UV(d17, par4 + 1.0, par6 - d21, d7, d6)};
        return vecs;
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return false;
    }

    private class Vec3UV {
        double x;
        double y;
        double z;
        double u;
        double v;

        public Vec3UV(double x, double y, double z, double u, double v) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.u = u;
            this.v = v;
        }
    }
}

