/* gm_spy.sma is part of GabenMod
*  Copyright 2005-2006 by Basic-Master (AMX Mod X Dev Team)
*
*  Yes, Gabe, this mod is dedicated to you, we hope you like
*  it as much as we do! Nevertheless, VALVe, your code still
*  sucks. Especially your HL2SDK, it's a nightmare. Someday
*  Gaben will appear and eat you and your SDK >_<. HE WILL!
*
*/

#include <amxmodx>
#include <amxmisc>
#include <cstrike>
#include <fakemeta>
#include "gabenmod"
#if defined CSDM_COMPILATION
#include <csdm>
#endif

//#define CHANGE_PLAYERINFO	// Change the playerinfo message you get for disguised players

#define SPEED_REQP 50		// Speed
#define SILENCE_REQP 50		// Silence, no footsteps
#define RANDOM_INVS_REQP 65	// Random Invisibility
#define SILENCED_M4A1_REQP 45	// Silenced m4a1 on respawn
#define STRENGTH_REQP 70	// Strength, extra hp+armor
#define SILENTKILL_REQP 50	// Silent kill, 100 damage on touch

#define AllKeys (1<<0)|(1<<1)|(1<<2)|(1<<3)|(1<<4)|(1<<5)|(1<<6)|(1<<7)|(1<<8)|(1<<9) // Menu keys

#define PLUGIN "GM Spy"
#define AUTHOR "Basic-Master"

new gHasClass[33]
new gDisguised[33]
new gFeigned[33]
/* 
* 0: Speed
* 1: Silence, no footsteps
* 2: Random Invisibility
* 3: Silenced M4A1 on respawn
* 4: Strength, extra hp+armor
* 5: Silent kill
*/
new gSkills[33][6]
new gCanStab[33]

new mSpyMenu // Spy Menu
new mSpyCallback // Callback for the spy menu
new mCTMenu // Disguise Menu (CTs)
new mTMenu // Disguise Menu (Ts)

new gWpnInfo[33][2]
new wpn_wpn, wpn_clip, wpn_ammo

new pt_button

new gVisible[33]
new temp[256]

new gIsEnabled

public plugin_init() {
	register_plugin(PLUGIN, GABENMOD_VERSION, AUTHOR)
	gm_RegClass("Spy", "Extended Spy abilities", "cmd_init", "cmd_menu", "cmd_buy", 0)
	register_forward(FM_PlayerPreThink, "hook_prethink")
	register_event("CurWeapon", "hook_wpn", "be")
	register_forward(FM_Touch, "hook_touch")
	/* Menu "Spy Menu" */
	mSpyMenu = menu_create("Spy Menu", "mh_SpyMenu")
	mSpyCallback = menu_makecallback("mc_SpyMenu")
	menu_additem(mSpyMenu, "Enemy disguise", "", 0, mSpyCallback)
	menu_additem(mSpyMenu, "Friendly disguise", "", 0, mSpyCallback)
	menu_additem(mSpyMenu, "Feign silently", "", 0, mSpyCallback)
	menu_additem(mSpyMenu, "Buy menu", "", 0, mSpyCallback)
	/* Menu "Disguise Menu (CTs)" */
	mCTMenu = menu_create("Disguise Menu (CTs)", "mh_DisguseMenuCT")
	menu_additem(mCTMenu, "Seal Team 6")
	menu_additem(mCTMenu, "GSG-9")
	menu_additem(mCTMenu, "SAS")
	menu_additem(mCTMenu, "GIGN")
	/* Menu "Disguise Menu (Ts)" */
	mTMenu = menu_create("Disguise Menu (Ts)", "mh_DisguseMenuT")
	menu_additem(mTMenu, "Phoenix Connexion")
	menu_additem(mTMenu, "Elite Crew")
	menu_additem(mTMenu, "Arctic Avengers")
	menu_additem(mTMenu, "Guerilla Warfare")
	/* Menu "Buy Menu" */
	register_menucmd(register_menuid("BuyMenu"), AllKeys, "PressedBuyMenu")
	
	gIsEnabled = gm_IsEnabled()
}

public plugin_precache() {
	// CT models
	engfunc(EngFunc_PrecacheModel, "models/player/urban/urban.mdl")
	engfunc(EngFunc_PrecacheModel, "models/player/gsg9/gsg9.mdl")
	engfunc(EngFunc_PrecacheModel, "models/player/sas/sas.mdl")
	engfunc(EngFunc_PrecacheModel, "models/player/gign/gign.mdl")
	// T models
	engfunc(EngFunc_PrecacheModel, "models/player/terror/terror.mdl")
	engfunc(EngFunc_PrecacheModel, "models/player/leet/leet.mdl")
	engfunc(EngFunc_PrecacheModel, "models/player/arctic/arctic.mdl")
	engfunc(EngFunc_PrecacheModel, "models/player/guerilla/guerilla.mdl")
	// Sounds
	engfunc(EngFunc_PrecacheSound, "weapons/cbar_hitbod1.wav")
}

public gm_UsingSkillCommand(id, skillid) {
	if (gHasClass[id] && gm_IsValidPlayer(id) && skillid < 4)
		mh_SpyMenu(id, mSpyMenu, skillid-1)
}

public cmd_init(id, hasclass) {
	gHasClass[id] = hasclass
	gCanStab[id] = hasclass
	gDisguised[id] = 0
	gFeigned[id] = 0
	
	if (gIsEnabled) {
		if (hasclass)
			gm_Respawn(id)
		else {
			engfunc(EngFunc_SetClientMaxspeed, id, 320.0)
			set_pev(id, pev_maxspeed, 320.0)
			set_pev(id, pev_flTimeStepSound, 400)
			
			if (gSkills[id][2])
				remove_task(id+100)
			if (gm_IsValidPlayer(id)) {
				cs_reset_user_model(id)
				gm_SetRendering(id)
				gVisible[id] = 1
			}
		}
	}
	
	for(new i=0;i<6;i++)
		gSkills[id][i] = 0
}

public cmd_menu(id) {
	if (!gIsEnabled) return
	
	if (!gm_IsValidPlayer(id)) {
		client_print(id, print_chat, "[GM] You must be alive to use this function!")
		return
	}
	
	menu_display(id, mSpyMenu, 0)
}

public cmd_buy(id) {
	if (gIsEnabled)
		show_buymenu(id)
}

public gm_Respawn(id) {
	if (!gIsEnabled || !gm_IsValidPlayer(id))
		return
	
	if (gHasClass[id]) {
		// Speed
		if (gSkills[id][0]) {
			engfunc(EngFunc_SetClientMaxspeed, id, 380.0)
			set_pev(id, pev_maxspeed, 380.0)
		}
		else {
			engfunc(EngFunc_SetClientMaxspeed, id, 325.0)
			set_pev(id, pev_maxspeed, 325.0)
		}
		// Health+Armor
		if (gSkills[id][4]) {
			set_user_health(id, 120.0)
			cs_set_user_armor(id, 75, CS_ARMOR_VESTHELM)
		}
		else {
			set_user_health(id, 90.0)
			cs_set_user_armor(id, 10, CS_ARMOR_KEVLAR)
		}
		// Disguise stuff
		if (gDisguised[id]) {
			cs_reset_user_model(id)
			client_print(id, print_chat, "[GM] Your model has been reset. Use the /menu function to disguise again.")
		}
		gDisguised[id] = 0
		// Weapons
		set_task(0.1, "task_giveweapons", id)
	}
}

public task_giveweapons(id) {
	if (gIsEnabled && gm_IsValidPlayer(id)) {
		// Strip and give weapons (knife+m3+usp+ammo)
		gm_StripWeapons(id)
		gm_CreateOwnedItem(id, "weapon_knife")
		new ent = gm_CreateOwnedItem(id, "weapon_usp")
		cs_set_weapon_silen(ent, 1)
		gm_CreateOwnedItem(id, "ammo_45acp")
		gm_CreateOwnedItem(id, "ammo_45acp")
		// TMP
		gm_CreateOwnedItem(id, "weapon_tmp")
		gm_CreateOwnedItem(id, "ammo_9mm")
		gm_CreateOwnedItem(id, "ammo_9mm")
		// Skills
		if (gSkills[id][0]) {
			engfunc(EngFunc_SetClientMaxspeed, id, 350.0)
			set_pev(id, pev_maxspeed, 350.0)
		}
		else {
			engfunc(EngFunc_SetClientMaxspeed, id, 320.0)
			set_pev(id, pev_maxspeed, 320.0)
		}
		if (gSkills[id][1])
			set_pev(id, pev_flTimeStepSound, 999)
		if (gSkills[id][3]) {
			// M4A1
			ent = gm_CreateOwnedItem(id, "weapon_m4a1")
			if (pev_valid(ent)) {
				cs_set_weapon_silen(ent, 1)
				cs_set_user_bpammo(id, CSW_M4A1, 45)
			}
			// Select it
			set_task(0.3, "task_selectm4", id+200)
		}
	}
}

public task_selectm4(id) {
	id -= 200
	if (gIsEnabled && gm_IsValidPlayer(id))
		client_cmd(id, "weapon_m4a1")
}

public hook_wpn(id) {
	if (gIsEnabled && gHasClass[id] && gm_IsValidPlayer(id)) {
		wpn_wpn = get_user_weapon(id, wpn_clip, wpn_ammo)
		if (gSkills[id][0]) {
			engfunc(EngFunc_SetClientMaxspeed, id, 380.0)
			set_pev(id, pev_maxspeed, 380.0)
		}
		else {
			engfunc(EngFunc_SetClientMaxspeed, id, 325.0)
			set_pev(id, pev_maxspeed, 325.0)
		}
		if (gDisguised[id] && (wpn_wpn != gWpnInfo[id][0] || wpn_clip < gWpnInfo[id][1])) {
			cs_reset_user_model(id)
			gDisguised[id] = 0
			client_print(id, print_center, "You are not longer disguised.")
		}
		
		gWpnInfo[id][0] = wpn_wpn
		gWpnInfo[id][1] = wpn_clip
	}
}

public task_invisible(id) {
	set_task(random_float(3.0, 10.0), "task_invisible", id)
	id -= 100
	if (!gFeigned[id]) {
		if (gVisible[id]) {
			message_begin(MSG_ONE, get_user_msgid("ScreenFade"), {0, 0, 0}, id)
			write_short(50) // duration in 0.01s
			write_short(50) // holdtime in 0.01s
			write_short(10) // fadetime in 0.01s
			write_byte(0)	// r
			write_byte(150)	// g
			write_byte(80) // b
			write_byte(50)	// alpha
			message_end()
			
			gm_SetRendering(id, kRenderFxPulseSlowWide, 0, 0, 0, kRenderTransAlpha, 85)
		}
		else {
			message_begin(MSG_ONE, get_user_msgid("ScreenFade"), {0, 0, 0}, id)
			write_short(50) // duration in 0.01s
			write_short(50) // holdtime in 0.01s
			write_short(10) // fadetime in 0.01s
			write_byte(150)	// r
			write_byte(80)	// g
			write_byte(0) 	// b
			write_byte(50)	// alpha
			message_end()
			
			gm_SetRendering(id)
		}
		gVisible[id] = gVisible[id] ? 0: 1
	}
}

public hook_touch(ptr, ptd) {
	if (ptr && ptd && ptr < 33 && ptd < 33) {
		if (gCanStab[ptd] && gSkills[ptd][5] && get_ent_speed(ptd) > 50) {
			if ((!get_cvar_num("mp_friendlyfire") && get_user_team(ptd) != get_user_team(ptr)) || (get_cvar_num("mp_friendlyfire"))) {
				gm_ExtraDamage(ptd, ptr, 160, "knife", 0)
				emit_sound(ptr, CHAN_AUTO, "weapons/cbar_hitbod1.wav", VOL_NORM, ATTN_NORM, 0, PITCH_NORM)
				gCanStab[ptd] = 0
				set_task(5.0, "task_resetstab", ptd)
			}
		}
	}
}

public task_resetstab(id) {
	gCanStab[id] = 1
}

public hook_prethink(id) {
	if (gHasClass[id] && gm_IsValidPlayer(id)) {
		pt_button = pev(id, pev_button)
		// Show user if pressing another button than jump or duck
		if (gFeigned[id] && pt_button != 0 && pt_button != IN_JUMP && pt_button != IN_DUCK && pt_button != IN_JUMP|IN_DUCK) {
			gm_SetRendering(id)
			gVisible[id] = 1
			gFeigned[id] = 0
			client_print(id, print_center, "You are not longer feigned.")
			return FMRES_HANDLED
		}
		// Check if user is pressing attack
		if (gSkills[id][1]) {
			set_pev(id, pev_flTimeStepSound, 999)
			return FMRES_HANDLED
		}
	}
	return FMRES_IGNORED
}

/* Menu Spy Menu */
public mh_SpyMenu(id, menu, item) {
	if (!gm_IsValidPlayer(id)) {
		client_print(id, print_chat, "[GM] You must be alive to use this function!")
		return
	}

	switch (item) {
		// Enemy disguise
		case 0: {
			if (cs_get_user_team(id) == CS_TEAM_CT)
				menu_display(id, mTMenu, 0)
			else
				menu_display(id, mCTMenu, 0)
		}
		// Friendly disguise
		case 1: { 
			if (cs_get_user_team(id) == CS_TEAM_CT)
				menu_display(id, mCTMenu, 0)
			else
				menu_display(id, mTMenu, 0)
		}
		// Feign silently
		case 2: {
			gFeigned[id] = 1
			gm_SetRendering(id, kRenderFxPulseSlowWide, 0, 0, 0, kRenderTransAlpha, 20)
			gVisible[id] = 0
			client_print(id, print_center, "You are now feigned.")
		}
		// Buy menu
		case 3: {
			cmd_buy(id)
		}
	}
}

public mc_SpyMenu(id, menu, item) {
	if (item == 2)
		return gFeigned[id] ? ITEM_DISABLED: ITEM_ENABLED
	return ITEM_ENABLED
}

/* Menu Disguise Menu (CTs) */
public mh_DisguseMenuCT(id, menu, item) {
	switch (item) {
		case 0: {
			cs_set_user_model(id, "urban")
			client_print(id, print_chat, "[GM] You're now disguised as Seal Team 6.")
			gDisguised[id] = 1
		}
		case 1: {
			cs_set_user_model(id, "gsg9")
			client_print(id, print_chat, "[GM] You're now disguised as GSG-9.")
			gDisguised[id] = 1
		}
		case 2: {
			cs_set_user_model(id, "sas")
			client_print(id, print_chat, "[GM] You're now disguised as SAS.")
			gDisguised[id] = 1
		}
		case 3: {
			cs_set_user_model(id, "gign")
			client_print(id, print_chat, "[GM] You're now disguised as GIGN.")
			gDisguised[id] = 1
		}
	}
}

/* Menu Disguise Menu (Ts) */
public mh_DisguseMenuT(id, menu, item) {
	switch (item) {
		case 0: {
			cs_set_user_model(id, "terror")
			client_print(id, print_chat, "[GM] You're now disguised as Phoenix Connexion.")
			gDisguised[id] = 1
		}
		case 1: {
			cs_set_user_model(id, "leet")
			client_print(id, print_chat, "[GM] You're now disguised as Elite Crew.")
			gDisguised[id] = 1
		}
		case 2: {
			cs_set_user_model(id, "arctic")
			client_print(id, print_chat, "[GM] You're now disguised as Arctic Avengers.")
			gDisguised[id] = 1
		}
		case 3: {
			cs_set_user_model(id, "guerilla")
			client_print(id, print_chat, "[GM] You're now disguised as Guerilla Warfare.")
			gDisguised[id] = 1
		}
	}
}

/* Menu Buy menu */
show_buymenu(id) {
	new keys = (1<<9)
	temp = "\yBuy menu^n^n"
	/* Speed */
	if (gSkills[id][0]) {
		add(temp, 255, "\w1. Drop Speed^n")
		keys |= (1<<0)
	}
	else if (gm_GetPoints(id) >= SPEED_REQP) {
		addpointitem("\w1. Buy Speed", SPEED_REQP)
		keys |= (1<<0)
	}
	else
		addpointitem("\d1. Buy Speed", SPEED_REQP)
	/* Silence, no footsteps */
	if (gSkills[id][1]) {
		add(temp, 255, "\w2. Drop Silence^n")
		keys |= (1<<1)
	}
	else if (gm_GetPoints(id) >= SILENCE_REQP) {
		addpointitem("\w2. Buy Silence (no footsteps)", SILENCE_REQP)
		keys |= (1<<1)
	}
	else
		addpointitem("\d2. Buy Silence (no footsteps)", SILENCE_REQP)
	/* Random Invisibility */
	if (gSkills[id][2]) {
		add(temp, 255, "\w3. Drop Random Invisibility^n")
		keys |= (1<<2)
	}
	else if (gm_GetPoints(id) >= RANDOM_INVS_REQP) {
		addpointitem("\w3. Buy Random Invisibility", RANDOM_INVS_REQP)
		keys |= (1<<2)
	}
	else
		addpointitem("\d3. Buy Random Invisibility", RANDOM_INVS_REQP)
	/* Random Invisibility */
	if (gSkills[id][3]) {
		add(temp, 255, "\w4. Drop Silenced M4A1^n")
		keys |= (1<<3)
	}
	else if (gm_GetPoints(id) >= SILENCED_M4A1_REQP) {
		addpointitem("\w4. Buy Silenced M4A1", SILENCED_M4A1_REQP)
		keys |= (1<<3)
	}
	else
		addpointitem("\d4. Buy Silenced M4A1", SILENCED_M4A1_REQP)
	/* Strength, extra hp+armor */
	if (gSkills[id][4]) {
		add(temp, 255, "\w5. Drop Strength^n")
		keys |= (1<<4)
	}
	else if (gm_GetPoints(id) >= STRENGTH_REQP) {
		addpointitem("\w5. Buy Strength (extra hp+armor)", STRENGTH_REQP)
		keys |= (1<<4)
	}
	else
		addpointitem("\d5. Buy Strength (extra hp+armor)", STRENGTH_REQP)
	/* Silent Kill */
	if (gSkills[id][5]) {
		add(temp, 255, "\w6. Drop Silent Kill^n")
		keys |= (1<<5)
	}
	else if (gm_GetPoints(id) >= SILENTKILL_REQP) {
		addpointitem("\w6. Buy Silent Kill", SILENTKILL_REQP)
		keys |= (1<<5)
	}
	else
		addpointitem("\d6. Buy Silent Kill", SILENTKILL_REQP)
	add(temp, 255, "^n\w0. Exit")
	
	show_menu(id, keys, temp, -1, "BuyMenu") // Display menu
}

addpointitem(title[], points) {
	new tmp[64]
	format(tmp, 63, "%s (%d points)^n", title, points)
	add(temp, 255, tmp)
}

public PressedBuyMenu(id, key) {
	switch (key) {
		case 0: { // Speed
			if (gSkills[id][0]) {
				gm_AddPoints(id, SPEED_REQP)
				gSkills[id][0] = 0
				engfunc(EngFunc_SetClientMaxspeed, id, 320.0)
				set_pev(id, pev_maxspeed, 320.0)
				client_print(id, print_chat, "[GM] You've dropped Speed and got %d points back.", SPEED_REQP)
			}
			else if (gm_GetPoints(id) >= SPEED_REQP) {
				gm_RemPoints(id, SPEED_REQP)
				gSkills[id][0] = 1
				engfunc(EngFunc_SetClientMaxspeed, id, 380.0)
				set_pev(id, pev_maxspeed, 380.0)
				client_print(id, print_chat, "[GM] fun You've just bought Speed for %d points.", SPEED_REQP)
			}
		}
		case 1: { // Silence, no footsteps
			if (gSkills[id][1]) {
				gm_AddPoints(id, SILENCE_REQP)
				gSkills[id][1] = 0
				set_pev(id, pev_flTimeStepSound, 400) // default
				client_print(id, print_chat, "[GM] You've dropped Silence and got %d points back.", SILENCE_REQP)
			}
			else if (gm_GetPoints(id) >= SILENCE_REQP) {
				gm_RemPoints(id, SILENCE_REQP)
				gSkills[id][1] = 1
				set_pev(id, pev_flTimeStepSound, 999)
				client_print(id, print_chat, "[GM] You've just bought Silence for %d points.", SILENCE_REQP)
			}
		}
		case 2: { // Random Invisibility
			if (gSkills[id][2]) {
				gm_AddPoints(id, RANDOM_INVS_REQP)
				gSkills[id][2] = 0
				gm_SetRendering(id)
				gVisible[id] = 1
				remove_task(id +100)
				client_print(id, print_chat, "[GM] You've dropped Random Invisibility and got %d points back.", RANDOM_INVS_REQP)
			}
			else if (gm_GetPoints(id) >= RANDOM_INVS_REQP) {
				gm_RemPoints(id, RANDOM_INVS_REQP)
				gSkills[id][2] = 1
				set_task(random_float(3.0, 10.0), "task_invisible", id+100)
				client_print(id, print_chat, "[GM] You've just bought Random Invisibility for %d points.", RANDOM_INVS_REQP)
			}
		}
		case 3: { // Silenced M4A1 on respawn
			if (gSkills[id][3]) {
				gm_AddPoints(id, SILENCED_M4A1_REQP)
				gSkills[id][3] = 0
				client_print(id, print_chat, "[GM] You've dropped Silenced M4A1 and got %d points back.", SILENCED_M4A1_REQP)
			}
			else if (gm_GetPoints(id) >= SILENCED_M4A1_REQP) {
				gm_RemPoints(id, SILENCED_M4A1_REQP)
				gSkills[id][3] = 1
				client_print(id, print_chat, "[GM] You've just bought Silenced M4A1 for %d points. You will get it on your next respawn.", SILENCED_M4A1_REQP)
			}
		}
		case 4: { // Strength, extra hp+armor
			if (gSkills[id][4]) {
				gm_AddPoints(id, STRENGTH_REQP)
				gSkills[id][4] = 0
				client_print(id, print_chat, "[GM] You've dropped Strength and got %d points back.", STRENGTH_REQP)
			}
			else if (gm_GetPoints(id) >= STRENGTH_REQP) {
				gm_RemPoints(id, STRENGTH_REQP)
				gSkills[id][4] = 1
				client_print(id, print_chat, "[GM] You've just bought Strength for %d points.", STRENGTH_REQP)
			}
		}
		case 5: { // Silent Kill
			if (gSkills[id][5]) {
				gm_AddPoints(id, SILENTKILL_REQP)
				gSkills[id][5] = 0
				client_print(id, print_chat, "[GM] You've dropped Silent Kill and got %d points back.", SILENTKILL_REQP)
			}
			else if (gm_GetPoints(id) >= SILENTKILL_REQP) {
				gm_RemPoints(id, SILENTKILL_REQP)
				gSkills[id][5] = 1
				client_print(id, print_chat, "[GM] You've just bought Silent Kill for %d points.", SILENTKILL_REQP)
			}
		}
		case 9: {
			return
		}
	}
	show_buymenu(id)
}

#if defined CHANGE_PLAYERINFO
public gm_PlayerInfo(id, player, playerclass[]) {
	if (gHasClass[id] && gDisguised[id]) {
		get_user_name(player, temp, 255)
		if (cs_get_user_team(player) == CS_TEAM_T) {
			set_hudmessage(0, 0, 255, -1.0, 0.55, 1, 0.1, 0.3, 0.0, 0.0, 3)
			show_hudmessage(id, "%s^n%s^n^nCounter-Terrorist", temp, playerclass)
		}
		else {
			set_hudmessage(255, 0, 0, -1.0, 0.55, 1, 0.1, 0.3, 0.0, 0.0, 3)
			show_hudmessage(id, "%s^n%s^n^nTerrorist", temp, playerclass)
		}
	}
	
	return PLUGIN_HANDLED
}
#endif


public gm_EnablingMod() {
	gIsEnabled = 1
}

public gm_DisablingMod() {
	gIsEnabled = 0
	static players[32], count
	get_players(players, count)
	for(new i=0;i<count;i++) {
		if (gm_IsValidPlayer(players[i]))
			cs_reset_user_model(players[i])
	}
}