/* gm_pointsaver.sma is part of GabenMod [extension]
*  Copyright 2005-2006 by Basic-Master (AMX Mod X Dev Team)
*
*  Yes, Gabe, this mod is dedicated to you, we hope you like
*  it as much as we do! Nevertheless, VALVe, your code still
*  sucks. Especially your HL2SDK, it's a nightmare. Someday
*  Gaben will appear and eat you and your SDK >_<. HE WILL!
*
*/

#include <amxmodx>
#include <amxmisc>
#include <nvault>
#include "gabenmod"

#define PLUGIN "GM Pointsaver"
#define VERSION "1.0"
#define AUTHOR "Basic-Master"

new gPointVault
new cSavePrice, cSavePoints

new gExtraPoints[33]

public plugin_init() {
	register_plugin(PLUGIN, GABENMOD_VERSION, AUTHOR)
	
	cSavePrice = register_cvar("gm_save_price", "16")	// Price for x Extra Points
	cSavePoints = register_cvar("gm_save_points", "1")	// Number of saved points for /buyxp
	
	register_saycmd("savexp", "cmd_savexp", -1, "")
	register_saycmd("savepoints", "cmd_savexp", -1, "")
	register_saycmd("buyxp", "cmd_buyxp", -1, "")
	register_saycmd("buyextra", "cmd_buyxp", -1, "")
	register_saycmd("buypoints", "cmd_buyxp", -1, "")
	register_saycmd("buybonus", "cmd_buyxp", -1, "")
	
	gPointVault = nvault_open("GM Extra Points")
}

register_saycmd(saycommand[], function[], flags, info[]) {
	new temp[64]
	format(temp, 63, "say /%s", saycommand)
	register_clcmd(temp, function, flags, info)
	format(temp, 63, "say .%s", saycommand)
	register_clcmd(temp, function, flags, info)
	format(temp, 63, "say_team /%s", saycommand)
	register_clcmd(temp, function, flags, info)
	format(temp, 63, "say_team .%s", saycommand)
	register_clcmd(temp, function, flags, info)
}

public plugin_end() {
	nvault_close(gPointVault)
}

public gm_UserJoined(id) {
	set_task(0.1, "task_checkplayer", id)
}

public task_checkplayer(id) {
	if (is_user_connected(id)) {
		new key[64], steamid[32]
		new value[32], extrapoints, timestmp
		get_user_authid(id, steamid, 31)
		format(key, 63, "%s-extrapoints", steamid)
		extrapoints = str_to_num(value)
		if (nvault_lookup(gPointVault, key, value, 31, timestmp) && extrapoints > 0) {
			if (gm_IsEnabled())
				client_print(id, print_chat, "[GM] You saved %d XP Points, giving them back to you...", extrapoints)
			gm_AddPoints(id, extrapoints, 0)
		}
		else if (gm_IsEnabled()) {
			client_print(id, print_chat, "[GM] You haven't bought any additional start points yet.")
			client_print(id, print_chat, "[GM] You can buy %d XP for %d Points using the /buypoints command.", get_pcvar_num(cSavePoints), get_pcvar_num(cSavePrice))
		}
		gExtraPoints[id] = extrapoints
	}
	else
		gExtraPoints[id] = 0
}

public cmd_savexp(id) {
	if (!gm_IsEnabled()) return PLUGIN_CONTINUE
	
	client_print(id, print_chat, "[GM] You cannot save all your points. You have to buy XP using the /buypoints command to get additional points when you join.")
	return PLUGIN_HANDLED
}

public cmd_buyxp(id) {
	if (!gm_IsEnabled()) return PLUGIN_CONTINUE
	
	if (gm_GetPoints(id, 0) - get_cvar_num("gm_startpoints") >= get_pcvar_num(cSavePrice) && gm_GetPoints(id) >= get_pcvar_num(cSavePrice)) {
		// remove points and add extra points
		gm_RemPoints(id, get_pcvar_num(cSavePrice), 0)
		gExtraPoints[id] += get_pcvar_num(cSavePoints)
		// save
		new key[64], steamid[32], value[32]
		get_user_authid(id, steamid, 31)
		format(key, 63, "%s-extrapoints", steamid)
		num_to_str(gExtraPoints[id], value, 31)
		nvault_set(gPointVault, key, value)		
		// msg
		client_print(id, print_chat, "[GM] You've just bought %d XP for %d Points.", get_pcvar_num(cSavePoints), get_pcvar_num(cSavePrice))
	}
	else
		client_print(id, print_chat, "[GM] You haven't got enough points to use this function.")
	return PLUGIN_HANDLED
}
