/* gm_pointskeeper.sma is part of GabenMod [extension]
*  Copyright 2005-2006 by Basic-Master (AMX Mod X Dev Team)
*
*  Yes, Gabe, this mod is dedicated to you, we hope you like
*  it as much as we do! Nevertheless, VALVe, your code still
*  sucks. Especially your HL2SDK, it's a nightmare. Someday
*  Gaben will appear and eat you and your SDK >_<. HE WILL!
*
*/

#include <amxmodx>
#include <amxmisc>
#include "gabenmod"

#define PLUGIN "GM Points Keeper"
#define AUTHOR "Basic-Master"

new gRestorePlayerPoints = 1

new gSteamIDs[32][32]

public plugin_init() {
	register_plugin(PLUGIN, GABENMOD_VERSION, AUTHOR)
	register_forward(FM_ClientDisconnect, "hook_disconnect")
	
	set_task(300.0, "task_nomoregive") // 5 minutes should be enough
}

public task_nomoregive() {
	gRestorePlayerPoints = 0
	
	new file[128]
	get_configsdir(file, 127)
	add(file, 127, "/user_temppoints.cfg")
	if (file_exists(file))
		delete_file(file)
}

public plugin_end() {
	new file[128], line[128], points
	get_configsdir(file, 127)
	add(file, 127, "/user_temppoints.cfg")
	
	if (file_exists(file))
		delete_file(file)
	
	for(new i=0;i<32;i++) {
		if (!equali(gSteamIDs[i], "")) {
			points = gm_GetPoints(i+1, 0)
			
			format(line, 127, "%s$%d", gSteamIDs[i], points)
			write_file(file, line)
		}
	}
}

public gm_UserJoined(id) {
	if (is_user_bot(id)) {
		copy(gSteamIDs[id-1], 31, "")
		return PLUGIN_CONTINUE
	}
	
	get_user_authid(id, gSteamIDs[id-1], 31)
	
	if (gRestorePlayerPoints) {
		new auth[32], file[128], line, linestr[128], tmp
		
		get_user_authid(id, auth, 31)
		add(auth, 31, "$")
		get_configsdir(file, 127)
		add(file, 127, "/user_temppoints.cfg")
		
		if (file_exists(file)) {
			while (read_file(file, line, linestr, 127, tmp)) {
				if (containi(linestr, auth) == 0) {
					strtok(linestr, auth, 31, file, 127, '$', 1)
					tmp = str_to_num(file)
					if (tmp > get_cvar_num("gm_startpoints")) {
						gm_SetPoints(id, tmp, 0)
						if (gm_IsEnabled())
							client_print(id, print_chat, "[GM] You got your %d points back but be aware: You'll lose them once you leave.", tmp)
					}
					write_file(file, "", line)
					return PLUGIN_CONTINUE
				}
				line++
			}
		}
	}
	return PLUGIN_CONTINUE
}

public hook_disconnect(id) {
	copy(gSteamIDs[id-1], 31, "")
}
