/* gm_spawn.sma is part of GabenMod
*  Copyright 2005-2006 by Basic-Master (AMX Mod X Dev Team)
*
*  Yes, Gabe, this mod is dedicated to you, we hope you like
*  it as much as we do! Nevertheless, VALVe, your code still
*  sucks. Especially your HL2SDK, it's a nightmare. Someday
*  Gaben will appear and eat you and your SDK >_<. HE WILL!
*
*/

#include <amxmodx>
#include <amxmisc>
#include <fakemeta>
#include <cstrike>
#include "gabenmod"

//#define ENT_DEBUG // dev only

#define PLUGIN "GM Spawn"
#define AUTHOR "Basic-Master"

#define WALL_MINS Float:{ -88.0, -6.0, -19.0 }
#define WALL_MAXS Float:{  88.0,  6.0, 169.0 }

#define MAX_HOSTAGES	64

#define WALLS_MAX 	64
#define GABE_MAX 	64
#define ITEMS_MAX 	256
#define TELE_MAX	64
#define MAX_ENTS	1400

enum {
	TYPE_UNDEFINED = 0,
	TYPE_TELEPORTER,
	TYPE_HOSTAGE,
	TYPE_WALL,
	TYPE_ITEM,
	TYPE_GABEN
}

#define TELEPORTER_MODEL "models/teleporter.mdl"

new mGabenModMenu, mConnectMenu = 0 // Menu
new ht_wall, ht_item, ht_class_id, CsArmorType:ht_armortype, ht_teleporter
new Float:ht_fVec[3], ht_out, CsTeams:ht_team, ht_tmp, ht_following
new pt_btn, pt_wpn, pt_tmp1, pt_tmp2

new gHostageEnt[MAX_HOSTAGES], gHostageCount = 0

new gWalls[WALLS_MAX], CsTeams:gWallTeam[WALLS_MAX], gWallAngle[WALLS_MAX]
new gWallCount = 0

new gGaben[GABE_MAX]
new gGabeCount = 0

new Float:gItemOrigin[ITEMS_MAX][3]
new gItemClass[ITEMS_MAX]
new gItemCount = 0, gSpawnedItemCount = 0, gWrittenEntDump = 0
new gItemEnt[ITEMS_MAX], gItemRespawning[ITEMS_MAX], gItemCreated[ITEMS_MAX]

new CsTeams:gTeleTeam[TELE_MAX], gTeleOut[TELE_MAX], gTeleEnt[TELE_MAX]
new gSelectedTeleporter[33], gLastTeleporter[MAX_ENTS], gOldTeleporter[MAX_ENTS], gTeleAdmin = -1
new gTeleCount = 0		

new gItemType[MAX_ENTS]

new cKickPlayers, cKickSpeed, cCheckEnts, cLeastFreeEnts

new gLaser //, gTeleLine

new gIsEnabled = 1

new gItemNames[17][] = { "item_longjump", "item_healthkit", "item_thighpack", "item_kevlar", "item_assaultsuit", "weapon_hegrenade", "weapon_flashbang", "weapon_smokegrenade", "ammo_45acp", "ammo_9mm", "ammo_50ae", "ammo_357sig", "ammo_57mm", 
			"ammo_buckshot", "ammo_338magnum", "ammo_762nato", "ammo_556nato" } 
			
public plugin_init() {
	register_plugin(PLUGIN, GABENMOD_VERSION, AUTHOR)
	register_forward(FM_PlayerPreThink, "hook_prethink")
	register_forward(FM_Touch, "hook_touch")
	register_clcmd("gm_wallmenu", "cmd_wallmenu", ADMIN_MENU, "- Shows the wall menu")
	register_clcmd("gm_menu", "cmd_wallmenu", ADMIN_MENU, "- Shows the wall menu")
	register_cvar("gm_movestep", "10")
	
	cKickPlayers = register_cvar("gm_wall_kickplayers", "1") 	// Accelerate players when touching a wall
	cKickSpeed = register_cvar("gm_wall_kickspeed", "1200")		// Speed for acceleration
	cCheckEnts = register_cvar("gm_ent_check", "1")			// Check entity count, remove items if there are too many
	cLeastFreeEnts = register_cvar("gm_leastfreeents", "60")		// Least free ents, increase if your server crashes with an ED_ALLOC error
	/* The Menu */
	mGabenModMenu = menu_create("GabenMod Menu", "mh_GabenModMenu")
	// Wall Stuff
	menu_additem(mGabenModMenu, "Make wall", "", ADMIN_MENU)
	menu_additem(mGabenModMenu, "Remove wall", "", ADMIN_MENU)
	menu_additem(mGabenModMenu, "Remove all walls", "", ADMIN_MENU)
	menu_additem(mGabenModMenu, "Set wall to T Wall", "", ADMIN_MENU)
	menu_additem(mGabenModMenu, "Set wall to CT Wall", "", ADMIN_MENU)
	menu_additem(mGabenModMenu, "Set wall to Spectator Wall", "", ADMIN_MENU)
	menu_additem(mGabenModMenu, "Set wall to Neutral Wall", "", ADMIN_MENU)
	menu_additem(mGabenModMenu, "Rotate wall by 90", "", ADMIN_MENU)
	menu_additem(mGabenModMenu, "Move wall up", "", ADMIN_MENU)
	menu_additem(mGabenModMenu, "Move wall down", "", ADMIN_MENU)
	menu_additem(mGabenModMenu, "Save walls", "", ADMIN_MENU)
	menu_addblank(mGabenModMenu, 0)
	// Gaben
	menu_additem(mGabenModMenu, "Make Gaben", "", ADMIN_MENU)
	menu_additem(mGabenModMenu, "Remove Gaben", "", ADMIN_MENU)
	menu_additem(mGabenModMenu, "Remove every Gaben", "", ADMIN_MENU)
	menu_additem(mGabenModMenu, "Save Gaben", "", ADMIN_MENU)
	menu_addblank(mGabenModMenu, 0)
	// Items
	menu_additem(mGabenModMenu, "Spawn Longjump Item", "", ADMIN_MENU)
	menu_additem(mGabenModMenu, "Spawn Health Kit", "", ADMIN_MENU)
	menu_additem(mGabenModMenu, "Spawn Defusekit", "", ADMIN_MENU)
	menu_additem(mGabenModMenu, "Spawn Kevlar Vest", "", ADMIN_MENU)
	menu_additem(mGabenModMenu, "Spawn Kevlar Vest+Helmet", "", ADMIN_MENU)
	menu_addblank(mGabenModMenu, 0)
	// Grenades
	menu_additem(mGabenModMenu, "Spawn HE Grenade", "", ADMIN_MENU)
	menu_additem(mGabenModMenu, "Spawn Flashbang", "", ADMIN_MENU)
	menu_additem(mGabenModMenu, "Spawn Smokegrenade", "", ADMIN_MENU)
	menu_addblank(mGabenModMenu, 0)
	// Ammo
	menu_additem(mGabenModMenu, "Spawn USP+UMP45 Ammo", "", ADMIN_MENU)
	menu_additem(mGabenModMenu, "Spawn MP5+Glock Ammo", "", ADMIN_MENU)
	menu_additem(mGabenModMenu, "Spawn Deagle Ammo", "", ADMIN_MENU)
	menu_additem(mGabenModMenu, "Spawn P228 Ammo", "", ADMIN_MENU)
	menu_additem(mGabenModMenu, "Spawn Five-Seven Ammo", "", ADMIN_MENU)
	menu_additem(mGabenModMenu, "Spawn Shotgun Ammo", "", ADMIN_MENU)
	menu_additem(mGabenModMenu, "Spawn P90 Ammo", "", ADMIN_MENU)
	menu_additem(mGabenModMenu, "Spawn AK47 Ammo", "", ADMIN_MENU)
	menu_additem(mGabenModMenu, "Spawn M4A1/M249 Ammo", "", ADMIN_MENU)
	menu_addblank(mGabenModMenu, 0)
	menu_additem(mGabenModMenu, "Remove every item", "", ADMIN_MENU)
	menu_additem(mGabenModMenu, "Remove item", "", ADMIN_MENU)
	menu_additem(mGabenModMenu, "Save items", "", ADMIN_MENU)
	menu_addblank(mGabenModMenu, 0)
	// Teleporters
	menu_additem(mGabenModMenu, "Make Teleporter for Ts", "", ADMIN_MENU)
	menu_additem(mGabenModMenu, "Make Teleporter for CTs", "", ADMIN_MENU)
	menu_additem(mGabenModMenu, "Make Neutral Teleporter", "", ADMIN_MENU)
	menu_additem(mGabenModMenu, "Make Teleporter Destination", "", ADMIN_MENU)
	menu_additem(mGabenModMenu, "Delete Teleporter", "", ADMIN_MENU)
	menu_additem(mGabenModMenu, "Get Teleporter ID", "", ADMIN_MENU)
	menu_additem(mGabenModMenu, "Connect Teleporters", "", ADMIN_MENU)
	menu_additem(mGabenModMenu, "Remove All Teleporters ", "", ADMIN_MENU)
	menu_additem(mGabenModMenu, "Save Teleporters ", "", ADMIN_MENU)
	menu_addblank(mGabenModMenu, 0)
	// Miscellaneous stuff
	menu_additem(mGabenModMenu, "Reload everything", "", ADMIN_MENU)
	menu_additem(mGabenModMenu, "Enable/Disable Godmode", "", ADMIN_MENU)
	menu_additem(mGabenModMenu, "Enable/Disable Semiclip", "", ADMIN_MENU)
	menu_addblank(mGabenModMenu, 0)
	
	// Load walls and stuff
	set_task(0.1, "task_load")
	// Get hostages
	new startent = -1, lastent = 0, setstartent = 0
	while (lastent != startent || setstartent) {
		lastent = engfunc(EngFunc_FindEntityByString, lastent, "classname", "hostage_entity")
		setstartent = 0
		
		if (pev_valid(lastent)) {
			if (startent == 0) {
				startent = lastent
				setstartent = 1
			}
			
			if (lastent < MAX_ENTS)
				gItemType[lastent] = TYPE_HOSTAGE
			if (gHostageCount < MAX_HOSTAGES) {
				gHostageEnt[gHostageCount] = lastent
				gLastTeleporter[lastent] = -1
				gHostageCount++
			}
		}
		else
			break
	}
	// Reset variable
	arrayset(gLastTeleporter, -1, MAX_ENTS)
	
	set_task(5.0, "task_check_ents", 0, "", 0, "ab", 1)
}

public task_load() {
	if (gIsEnabled) {
		load_walls()
		load_gaben()
		load_items()
		load_teleporters()
		
		log_amx("Loaded %d walls, %d Gabens, %d items and %d teleporters successfully!", gWallCount, gGabeCount, gItemCount, gTeleCount)
	}
}

public plugin_precache() {
	engfunc(EngFunc_PrecacheModel, "models/wall_n.mdl")
	engfunc(EngFunc_PrecacheModel, "models/wall_r.mdl")
	engfunc(EngFunc_PrecacheModel, "models/w_medkit.mdl")
	engfunc(EngFunc_PrecacheModel, "sprites/gaben.spr")
	gLaser = engfunc(EngFunc_PrecacheModel, "sprites/laserbeam.spr")
	//gTeleLine = engfunc(EngFunc_PrecacheModel, "sprites/arrow1.spr")
	engfunc(EngFunc_PrecacheModel, TELEPORTER_MODEL)
	
	engfunc(EngFunc_PrecacheSound, "items/smallmedkit1.wav")
	engfunc(EngFunc_PrecacheSound, "items/suitchargeok1.wav")
	engfunc(EngFunc_PrecacheSound, "debris/beamstart10.wav")
}

load_walls() {
	new temp[32], key[32], data[64]
	new i, team, angle
	new origin[3], Float:fOrigin[3]
	
	for(i=0;i<WALLS_MAX;i++) {
		/* The vault part */
		format(key, 31, "wall-%d", i)
		if (!gm_ReadMapInfo(key, data, 63))
			break
		// Coordinates
		copyc(temp, 31, data, 32)
		origin[0] = str_to_num(temp)
		copy(data, 31, data[strlen(temp)+1])
		copyc(temp, 31, data, 32)
		origin[1] = str_to_num(temp)
		copy(data, 31, data[strlen(temp)+1])
		copyc(temp, 31, data, 32)
		origin[2] = str_to_num(temp)
		// Angle (either 0 or 1)
		copy(data, 31, data[strlen(temp)+1])
		copyc(temp, 31, data, 32)
		angle = str_to_num(temp)
		// The team
		copy(data, 31, data[strlen(temp)+1])
		copyc(temp, 31, data, 32)
		team = str_to_num(temp)
		// Some cast stuff
		fOrigin[0] = float(origin[0])
		fOrigin[1] = float(origin[1])
		fOrigin[2] = float(origin[2])
		/* The wall part */
		make_wall(fOrigin, angle, CsTeams:team)
	}
}

load_gaben() {
	new temp[32], key[32], data[32]
	new i
	new origin[3], Float:fOrigin[3]
	
	for(i=0;i<GABE_MAX;i++) {
		/* The vault part */
		format(key, 31, "gaben-%d",  i)
		if (!gm_ReadMapInfo(key, data, 31))
			break
		
		// Coordinates
		copyc(temp, 31, data, 32)
		origin[0] = str_to_num(temp)
		copy(data, 31, data[strlen(temp)+1])
		copyc(temp, 31, data, 32)
		origin[1] = str_to_num(temp)
		copy(data, 31, data[strlen(temp)+1])
		copyc(temp, 31, data, 32)
		origin[2] = str_to_num(temp)
		
		fOrigin[0] = float(origin[0])
		fOrigin[1] = float(origin[1])
		fOrigin[2] = float(origin[2])
		/* The gabe part */
		make_gaben(fOrigin)
	}
}

load_items() {
	new temp[32], key[32], data[128]
	new i, itemtype
	new Float:fOrigin[3]
	
	for(i=0;i<ITEMS_MAX;i++) {
		/* The vault part */
		format(key, 31, "item-%d", i)
		if (!gm_ReadMapInfo(key, data, 127))
			break
		
		// Coordinates
		copyc(temp, 31, data, 32)
		fOrigin[0] = str_to_float(temp)
		copy(data, 127, data[strlen(temp)+1])
		copyc(temp, 31, data, 32)
		fOrigin[1] = str_to_float(temp)
		copy(data, 127, data[strlen(temp)+1])
		copyc(temp, 31, data, 32)
		fOrigin[2] = str_to_float(temp)
		// Item type
		copy(data, 127, data[strlen(temp)+1])
		copyc(temp, 31, data, 32)
		itemtype = str_to_num(temp)
		// Spawn it
		make_item(fOrigin, itemtype)
	}
}

load_teleporters() {
	new temp[32], key[32], data[128]
	new i, CsTeams:team, out
	new Float:fOrigin[3]
	
	for(i=0;i<ITEMS_MAX;i++) {
		/* The vault part */
		format(key, 31, "teleporter-%d", i)
		if (!gm_ReadMapInfo(key, data, 127))
			break
		
		// Coordinates
		copyc(temp, 31, data, 32)
		fOrigin[0] = str_to_float(temp)
		copy(data, 127, data[strlen(temp)+1])
		copyc(temp, 31, data, 32)
		fOrigin[1] = str_to_float(temp)
		copy(data, 127, data[strlen(temp)+1])
		copyc(temp, 31, data, 32)
		fOrigin[2] = str_to_float(temp)
		// Team
		copy(data, 127, data[strlen(temp)+1])
		copyc(temp, 31, data, 32)
		team = CsTeams:str_to_num(temp)
		// Out Teleporter
		copy(data, 127, data[strlen(temp)+1])
		copyc(temp, 31, data, 32)
		out = str_to_num(temp)
		// Spawn it
		make_teleporter(fOrigin, team, out)
	}
}

// Forwards

public hook_prethink(id) {
	if (gIsEnabled && gm_IsValidPlayer(id)) {
		pt_btn = pev(id, pev_button)
		if (pt_btn&IN_ATTACK || pt_btn&IN_ATTACK) {
			if (gm_AimingAtWall(id)) {
				pt_wpn = get_user_weapon(id, pt_tmp1, pt_tmp2)
				if (pt_wpn == CSW_HEGRENADE || pt_wpn == CSW_FLASHBANG || pt_wpn == CSW_SMOKEGRENADE)
					return FMRES_HANDLED
				else {
					pt_btn &= ~IN_ATTACK
					pt_btn &= ~IN_ATTACK2
					set_pev(id, pev_button, pt_btn)
					return FMRES_SUPERCEDE
				}
			}
		}
	}
	return FMRES_IGNORED
}

public hook_touch(ptr, ptd) {
	if (gIsEnabled && ptr && ptd) {
		if ((ptr < 33 && gm_IsValidPlayer(ptr)) || gItemType[ptr] == TYPE_HOSTAGE) {
			if (gItemType[ptd] == TYPE_WALL) {
				ht_wall = get_wall(ptd)
				if (ht_wall != -1) {
					if (gItemType[ptr] == TYPE_HOSTAGE) {
						if (!task_exists(ptr+30000))
							teleport_hostage(ptr+30000)
					}
					else if (gWallTeam[ht_wall] != CS_TEAM_UNASSIGNED) {
						if (cs_get_user_team(ptr) == gWallTeam[ht_wall]) {
							set_pev(ptd, pev_solid, SOLID_NOT)
							if (get_pcvar_num(cKickPlayers))
								set_task(0.1, "task_speed", ptr)
							set_task(0.2, "task_makesolid", ptd)
						}
						else if (!is_user_bot(ptr))
							user_slap(ptr, 1)
					}
					
					return FMRES_OVERRIDE
				}
			}
			else if (ptr != gTeleAdmin && gItemType[ptd] == TYPE_TELEPORTER) {
				ht_teleporter = get_teleporter(ptd)
				if (ht_teleporter != -1) {
					if (gLastTeleporter[ptr] == ht_teleporter) {
						gm_VelocityByAim(ptr, 1000, ht_fVec)
						ht_fVec[2] = 0.0
						set_pev(ptr, pev_velocity, ht_fVec)
					}
					else {
						ht_out = gTeleOut[ht_teleporter]
						ht_team = gTeleTeam[ht_teleporter]
						ht_following = (gm_IsValidPlayer(ptr)) ? hostage_following(ptr) : 0
					
						if (gItemType[ptr] != TYPE_HOSTAGE && ht_team != CS_TEAM_SPECTATOR && ht_team != cs_get_user_team(ptr)) {
							gm_VelocityByAim(ptr, 1000, ht_fVec)
							ht_fVec[2] = 0.0
							set_pev(ptr, pev_velocity, ht_fVec)
							
							if (ht_team == CS_TEAM_UNASSIGNED) {
								user_slap(ptr, 1)
								client_print(ptr, print_center, "You cannot use this teleporter")
							}
							else
								client_print(ptr, print_center, "You cannot use this teleporter")
							
							return FMRES_HANDLED
						}
						else if (ht_out == -1) {
							gLastTeleporter[ptr] = ht_teleporter
							
							gm_VelocityByAim(ptr, 1000, ht_fVec)
							ht_fVec[2] = 0.0
							set_pev(ptr, pev_velocity, ht_fVec)
							// reset
							set_task(5.0, "task_reset_tele", ptr)
							if (gItemType[ptr] != TYPE_HOSTAGE)
								client_print(ptr, print_center, "Teleporter is not connected to another teleporter")
						}
						else if (gItemType[ptr] == TYPE_HOSTAGE || !ht_following || (ht_following && pev(ptr, pev_button)&IN_USE)) {
							pev(gTeleEnt[ht_out], pev_origin, ht_fVec)
							ht_fVec[2] += 71.0
							if (engfunc(EngFunc_PointContents, ht_fVec) == CONTENTS_EMPTY) {
								ht_fVec[0] -= 16.0
								ht_fVec[1] -= 16.0
								ht_fVec[2] -= 32.0
								if (engfunc(EngFunc_PointContents, ht_fVec) == CONTENTS_EMPTY) {
									ht_fVec[0] += 32.0
									ht_fVec[1] += 32.0
									ht_fVec[2] += 64.0
									if (engfunc(EngFunc_PointContents, ht_fVec) == CONTENTS_EMPTY) {
										pev(gTeleEnt[ht_out], pev_origin, ht_fVec)
										ht_fVec[2] += 81.0
										ht_tmp = engfunc(EngFunc_FindEntityInSphere, 0, ht_fVec, 30.0)
										if (!gm_IsValidPlayer(ht_tmp) && gItemType[ht_tmp] != TYPE_HOSTAGE) {
											// values, zomg.
											gOldTeleporter[ptr] = ht_teleporter
											gLastTeleporter[ptr] = ht_out
											// sound
											engfunc(EngFunc_EmitSound, ptr, CHAN_AUTO, "debris/beamstart10.wav", VOL_NORM, ATTN_NORM, 0, PITCH_NORM)
											// screen fade, for players only
											if (gItemType[ptr] != TYPE_HOSTAGE) {
												message_begin(MSG_ONE_UNRELIABLE, get_user_msgid("ScreenFade"), {0, 0, 0}, ptr)
												write_short(50) // duration in 0.01s
												write_short(50) // holdtime in 0.01s
												write_short(10) // fadetime in 0.01s
												write_byte(150)	// r
												write_byte(100)	// g
												write_byte(255) // b
												write_byte(100)	// alpha
												message_end()
											}
											else
												ht_fVec[2] -= 30.0
											// actual teleport and stuff
											engfunc(EngFunc_SetOrigin, ptr, ht_fVec)
											set_pev(ptr, pev_velocity, Float:{ 0.0, 0.0, 50.0 })
											// check stuck
											set_task(0.3, "task_checkstuck", ptr)
											// break here
											return FMRES_SUPERCEDE
										}
										else if (gItemType[ptr] != TYPE_HOSTAGE)
											client_print(ptr, print_center, "Teleporter currently blocked!")
									}
								}
								else if (gItemType[ptr] != TYPE_HOSTAGE)
									client_print(ptr, print_center, "Teleporter currently blocked!")
							}
							else if (gItemType[ptr] != TYPE_HOSTAGE)
								client_print(ptr, print_center, "Teleporter currently blocked!")
						}
						else if (gItemType[ptr] != TYPE_HOSTAGE)
							client_print(ptr, print_center, "Hold ^"use^" pressed to teleport")
					}
				}
			}
		}
		else if (ptd < 33 && pev_valid(ptr) && is_user_connected(ptd)) {
			ht_item = get_item(ptr)
			if (ht_item != -1) {
				if (gItemRespawning[ht_item])
					return FMRES_SUPERCEDE
			
				
				ht_class_id = gItemClass[ht_item]
				if (ht_class_id == 5 || ht_class_id == 6 || ht_class_id == 7) {
					// don't remove if user already has it
					if (ht_class_id == 5 && cs_get_user_bpammo(ptd, CSW_HEGRENADE) > 0)
						return FMRES_SUPERCEDE
					if (ht_class_id == 6 && cs_get_user_bpammo(ptd, CSW_FLASHBANG) > 0)
						return FMRES_SUPERCEDE
					if (ht_class_id == 7 && cs_get_user_bpammo(ptd, CSW_SMOKEGRENADE) > 0)
						return FMRES_SUPERCEDE
					// save pos
					pev(ptr, pev_origin, gItemOrigin[ht_item])
					// hide+respawn
					set_pev(ptr, pev_effects, pev(ptr, pev_effects)|EF_NODRAW)
					gItemRespawning[ht_item] = 1
					set_task(20.0, "task_spawngrenade", ht_item+10000)
					// give item
					gm_CreateOwnedItem(ptd, gItemNames[ht_class_id])
					// end
					return FMRES_SUPERCEDE
				}
				else if ((ht_class_id == 3 || ht_class_id == 4) && cs_get_user_armor(ptd, ht_armortype) >= 100)
					return FMRES_SUPERCEDE
			}
		}
	}
	
	return FMRES_IGNORED
}

public teleport_hostage(id) {
	id -= 30000
	if (!gIsEnabled || !pev_valid(id)) return
	
	new ct = cs_get_hostage_foll(id)
	if (gm_IsValidPlayer(ct)) {
		new Float:fAngle[3], Float:fForward[3], Float:fOrigin[3]
		new Float:randomnum
		
		pev(ct, pev_origin, fOrigin)
		pev(ct, pev_v_angle, fAngle)
		fAngle[2] = 0.0
		engfunc(EngFunc_MakeVectors, fAngle)
		global_get(glb_v_forward, fForward)
		
		randomnum = random_float(-80.0, -150.0)
		fAngle[0] = fOrigin[0] + fForward[0] * randomnum
		fAngle[1] = fOrigin[1] + fForward[1] * randomnum
		fAngle[2] = fOrigin[2]
		
		if (engfunc(EngFunc_PointContents, fAngle) == CONTENTS_EMPTY) {
			fAngle[0] = fOrigin[0] + fForward[0] * randomnum -25
			fAngle[1] = fOrigin[1] + fForward[1] * randomnum -25
			if (engfunc(EngFunc_PointContents, fAngle) == CONTENTS_EMPTY) {
				fAngle[0] = fOrigin[0] + fForward[0] * randomnum +25
				fAngle[1] = fOrigin[1] + fForward[1] * randomnum +25
				if (engfunc(EngFunc_PointContents, fAngle) == CONTENTS_EMPTY) {
					fAngle[0] = fOrigin[0] + fForward[0] * randomnum
					fAngle[1] = fOrigin[1] + fForward[1] * randomnum
					if (engfunc(EngFunc_FindEntityInSphere, 0, fAngle, 30.0) == 0)
						engfunc(EngFunc_SetOrigin, id, fAngle)
					else
						set_task(0.5, "teleport_hostage", id+30000)
				}
				else
					set_task(0.5, "teleport_hostage", id+30000)
			}
			else
				set_task(0.5, "teleport_hostage", id+30000)
		}
		else
			set_task(0.5, "teleport_hostage", id+30000)
	}
}

public task_spawngrenade(itemid) {
	itemid -= 10000
	gItemRespawning[itemid] = 0
	set_pev(gItemEnt[itemid], pev_effects, pev(gItemEnt[itemid], pev_effects)&~EF_NODRAW)
	emit_sound(gItemEnt[itemid], CHAN_WEAPON, "items/suitchargeok1.wav", 1.0, ATTN_NORM, 0, 150)
}

public task_speed(id) {
	if (gIsEnabled && is_user_connected(id)) {
		new Float:fVec[3]
		gm_VelocityByAim(id, get_pcvar_num(cKickSpeed), fVec)
		fVec[2] = 0.0
		set_pev(id, pev_velocity, fVec)
	}
}

public task_makesolid(id) {
	if (gIsEnabled && pev_valid(id))
		set_pev(id, pev_solid, SOLID_BBOX)
}

// Functions

make_wall(Float:origin[3], angle, CsTeams: team) {
	new ent = engfunc(EngFunc_CreateNamedEntity, engfunc(EngFunc_AllocString, "func_wall"))
	new Float:wallmins[3], Float:wallmaxs[3]
	new Float:ftmp
	// make the wall
	set_pev(ent, pev_classname, "gm_wall")
	wallmins = WALL_MINS
	wallmaxs = WALL_MAXS
	if (angle)
		engfunc(EngFunc_SetModel, ent, "models/wall_n.mdl")
	else {
		ftmp = wallmins[1]
		wallmins[1] = wallmins[0]
		wallmins[0] = ftmp
		ftmp = wallmaxs[1]
		wallmaxs[1] = wallmaxs[0]
		wallmaxs[0] = ftmp
		
		engfunc(EngFunc_SetModel, ent, "models/wall_r.mdl")
	}
	dllfunc(DLLFunc_Spawn, ent)
	// set sizes etc.
	engfunc(EngFunc_SetSize, ent, wallmins, wallmaxs)
	set_pev(ent, pev_mins, wallmins)
	set_pev(ent, pev_maxs, wallmaxs)
	set_pev(ent, pev_absmin, wallmins)
	set_pev(ent, pev_absmax, wallmaxs)
	origin[0] += random_float(-0.4, 0.4)
	origin[1] += random_float(-0.4, 0.4)
	engfunc(EngFunc_SetOrigin, ent, origin)
	set_pev(ent, pev_movetype, MOVETYPE_FLY)
	set_pev(ent, pev_solid, SOLID_BBOX)
	set_pev(ent, pev_takedamage, 0.0)
	// register wall
	if (gWallCount != WALLS_MAX) {
		gWalls[gWallCount] = ent
		gWallTeam[gWallCount] = team
		gWallAngle[gWallCount] = angle
		gWallCount++
	}
	gItemType[ent] = TYPE_WALL
	// end
	return ent
}

remove_wall(wallid) {
	if (pev_valid(gWalls[wallid]))
		engfunc(EngFunc_RemoveEntity, gWalls[wallid])
	gItemType[gWalls[wallid]] = TYPE_UNDEFINED
	for(new i=wallid;i<gWallCount-1;i++) {
		gWalls[i] = gWalls[i+1]
		gWallAngle[i] = gWallAngle[i+1]
		gWallTeam[i] = gWallTeam[i+1]
	}
	gWallCount--
	return 1
}

rotate_wall(wallid) {
	// not the best method but should work
	new Float:fOrigin[3]
	gWallAngle[wallid] = gWallAngle[wallid] ? 0: 1
	pev(gWalls[wallid], pev_origin, fOrigin)
	engfunc(EngFunc_RemoveEntity, gWalls[wallid])
	gItemType[gWalls[wallid]] = TYPE_UNDEFINED
	gWalls[wallid] = make_wall(fOrigin, gWallAngle[wallid], gWallTeam[wallid])
	gItemType[gWalls[wallid]] = TYPE_WALL
}

get_wall(ent) {
	for(new i=0;i<gWallCount;i++) {
		if (gWalls[i] == ent)
			return i
	}
	return -1
}

/* Gabe Functions */

make_gaben(Float:origin[3]) {
	// create a sprite of him!
	new ent = engfunc(EngFunc_CreateNamedEntity, engfunc(EngFunc_AllocString, "env_sprite"))
	set_pev(ent, pev_classname, "gm_gaben")
	engfunc(EngFunc_SetOrigin, ent, origin)
	engfunc(EngFunc_SetModel, ent, "sprites/gaben.spr")
	set_keyvalue(ent, "scale", "0.4")
	// register the ent
	gGaben[gGabeCount] = ent
	gGabeCount++
	gItemType[ent] = TYPE_GABEN
	// end
	return ent
}

remove_gabe(gabeid) {
	// :'(
	engfunc(EngFunc_RemoveEntity, gGaben[gabeid])
	gItemType[gGaben[gabeid]] = TYPE_UNDEFINED
	for(new i=gabeid;i<gGabeCount-1;i++)
		gGaben[i] = gGaben[i+1]
	gGabeCount--
	return 1
}


get_gabe(ent) {
	for(new i=0;i<gGabeCount;i++) {
		if (gGaben[i] == ent)
			return i
	}
	return -1
}

/* Item functions */

make_item(Float:origin[3], itemtype, idx = -1) {
	new nid, item
	// HE, Flash, Smoke; adapetd from CSDM, thanks!
	if (itemtype == 5 || itemtype == 6 || itemtype == 7) {
		nid = engfunc(EngFunc_AllocString, "info_target")
		item = engfunc(EngFunc_CreateNamedEntity, nid)
		if (!item)
			return log_error(10, "Cannot create item type: %d", itemtype)
			
		set_pev(item, pev_classname, gItemNames[itemtype])
		switch (itemtype) {
			case 5: { engfunc(EngFunc_SetModel, item, "models/w_hegrenade.mdl"); }
			case 6: { engfunc(EngFunc_SetModel, item, "models/w_flashbang.mdl"); }
			case 7: { engfunc(EngFunc_SetModel, item, "models/w_smokegrenade.mdl"); }
		}
		set_pev(item, pev_origin, origin)
		
		set_pev(item, pev_solid, SOLID_TRIGGER)
		set_pev(item, pev_movetype, MOVETYPE_TOSS)
		
		// spawning the entity would make it untouchable
	}
	else {
		nid = engfunc(EngFunc_AllocString, gItemNames[itemtype])
		item = engfunc(EngFunc_CreateNamedEntity, nid)
		if (!item)
			return log_error(10, "Cannot create item type: %d", itemtype)
		
		engfunc(EngFunc_SetOrigin, item, origin)
		dllfunc(DLLFunc_Spawn, item)
		
		set_task(0.1, "task_removethink", item+20000)
	}
	
	if (idx == -1) {
		// register item
		gItemEnt[gItemCount] = item
		gItemOrigin[gItemCount] = origin
		gItemClass[gItemCount] = itemtype
		gItemCreated[gItemCount] = 1
		gItemRespawning[gItemCount] = 0
		gItemCount++
	}
	else {
		gItemEnt[idx] = item
		gItemCreated[idx] = 1
		gItemRespawning[idx] = 0
	}
	gItemType[item] = TYPE_ITEM
	gSpawnedItemCount++
	// end
	return item
}

public task_removethink(id) {
	id -= 20000
	if (pev_valid(id) && pev(id, pev_owner) == 0)
		set_pev(id, pev_nextthink, 0)
}

get_item(ent) {
	if (!pev_valid(ent) || is_user_connected(ent)) return -1
	
	for(new i=0;i<gItemCount;i++) {
		if (ent == gItemEnt[i])
			return i
	}
	return -1
}

remove_item(itemid, ent) {
	// remove ent
	engfunc(EngFunc_RemoveEntity, ent)
	gItemType[ent] = TYPE_UNDEFINED
	if (gItemRespawning[itemid])
		remove_task(itemid+10000)
	// rearrange item list
	for(new i=itemid;i<gItemCount-1;i++) {
		gItemOrigin[i] = gItemOrigin[i+1]
		gItemClass[i] = gItemClass[i+1]
		gItemEnt[i] = gItemEnt[i+1]
		gItemRespawning[i] = gItemRespawning[i+1]
	}
	gItemRespawning[gItemCount] = 0
	gItemCreated[gItemCount] = 0
	gItemCount--
	gSpawnedItemCount--
	
	return 1
}

/* Teleporter functions */


make_teleporter(Float:fOrigin[3], CsTeams:team, out_tele = -1) {
	// ent stuff
	new ent = engfunc(EngFunc_CreateNamedEntity, engfunc(EngFunc_AllocString, "info_target"))
	set_pev(ent, pev_classname, "gm_teleporter")
	engfunc(EngFunc_SetModel, ent, TELEPORTER_MODEL)
	engfunc(EngFunc_SetOrigin, ent, fOrigin)
	engfunc(EngFunc_SetSize, ent, { -32.0, -32.0, -3.0 }, { 32.0, 32.0, 8.0 }) 
	set_pev(ent, pev_absmin, { -32.0, -32.0, -3.0 })
	set_pev(ent, pev_absmax, { 32.0, 32.0, 8.0 })
	set_pev(ent, pev_mins, { -32.0, -32.0, -3.0 })
	set_pev(ent, pev_maxs, { 32.0, 32.0, 8.0 })
	dllfunc(DLLFunc_Spawn, ent)
	set_pev(ent, pev_solid, SOLID_BBOX)
	set_pev(ent, pev_movetype, MOVETYPE_TOSS)
	
	switch (team) {
		case CS_TEAM_T: 	gm_SetRendering(ent, kRenderFxGlowShell, 255, 0, 0, kRenderNormal, 60)
		case CS_TEAM_CT: 	gm_SetRendering(ent, kRenderFxGlowShell, 0, 0, 255, kRenderNormal, 60)
		case CS_TEAM_SPECTATOR:	gm_SetRendering(ent, kRenderFxGlowShell, 150, 150, 150, kRenderNormal, 60)
		default: 		gm_SetRendering(ent, kRenderFxGlowShell, 170, 42, 60, kRenderNormal, 60)
	}
	// register
	gTeleTeam[gTeleCount] = team
	gTeleOut[gTeleCount] = out_tele
	gTeleEnt[gTeleCount] = ent
	gTeleCount++
	gItemType[ent] = TYPE_TELEPORTER
	
	return gTeleCount-1
}

remove_teleporter(tele_id) {
	// remove teleporter
	gItemType[gTeleEnt[tele_id]] = TYPE_UNDEFINED
	engfunc(EngFunc_RemoveEntity, gTeleEnt[tele_id])
	for(new i=tele_id;i<gTeleCount-1;i++) {
		gTeleTeam[i] = gTeleTeam[i+1]
		gTeleOut[i] = gTeleOut[i+1]
		gTeleEnt[i] = gTeleEnt[i+1]
		
		if (gTeleOut[i] > tele_id)
			gTeleOut[i]--
		else if (gTeleOut[i] == tele_id)
			gTeleOut[i] = -1
	}
	gTeleCount--
	// remove (now invalid) connections
	new temp = -1
	while ((temp = get_teleporter_out(tele_id)) != -1)
		gTeleOut[temp] = -1
	// return 1, success
	return 1
}

// find teleporter near a position
get_teleporter(ent) {
	for(new i=0;i<gTeleCount;i++) {
		if (gTeleEnt[i] == ent)
			return i
	}
	
	return -1
}

get_teleporter_at(Float:fOrigin[3]) {
	new Float:fVec[3]
	for(new i=0;i<gTeleCount;i++) {
		pev(gTeleEnt[i], pev_origin, fVec)
		if (vec_distance(fVec, fOrigin) < 70)
			return i
	}
	return -1
}

// is this teleporter used as destination for another teleporter?
get_teleporter_out(tele_id) {
	for(new i=0;i<gTeleCount;i++) {
		if (i != tele_id && gTeleOut[i] == tele_id)
			return i
	}
	
	return -1
}

/*draw_teleporter(Float:fOrigin[3], r, g, b, duration) {
	// prepare stuff
	new origin[3], start[3], end[3]
	origin[0] = floatround(fOrigin[0])
	origin[1] = floatround(fOrigin[1])
	origin[2] = floatround(fOrigin[2])
	// lines on the Y axis
	// line 1
	start[0] = origin[0] + 20
	start[1] = origin[1] + 20
	start[2] = origin[2] + 60
	end[0] = origin[0] + 20
	end[1] = origin[1] + 20
	end[2] = origin[2] - 30
	draw_line(start, end, r, g, b, duration)
	// line 2
	start[0] -= 40
	end[0] -= 40
	draw_line(start, end, r, g, b, duration)
	// line 3
	start[1] -= 40
	end[1] -= 40
	draw_line(start, end, r, g, b, duration)
	// line 4
	start[0] += 40
	end[0] += 40
	draw_line(start, end, r, g, b, duration)
	// lines on the X/Z axis, part 1 (top)
	end[0] = start[0] = origin[0] - 20
	end[1] = start[1] = origin[1] - 20
	end[2] = start[2] = origin[2] + 60
	// line 1
	end[1] += 40
	draw_line(start, end, r, g, b, duration)
	// line 2
	start[1] += 40
	end[0] += 40
	draw_line(start, end, r, g, b, duration)
	// line 3
	start[0] += 40
	end[1] -= 40
	draw_line(start, end, r, g, b, duration)
	// line 4
	start[1] -= 40
	end[0] -= 40
	draw_line(start, end, r, g, b, duration)
	// lines on the X/Z axis, part 2 (bottom)
	end[0] = start[0] = origin[0] - 20
	end[1] = start[1] = origin[1] - 20
	end[2] = start[2] = origin[2] - 30
	// line 5
	end[1] += 40
	draw_line(start, end, r, g, b, duration)
	// line 6
	start[1] += 40
	end[0] += 40
	draw_line(start, end, r, g, b, duration)
	// line 7
	start[0] += 40
	end[1] -= 40
	draw_line(start, end, r, g, b, duration)
	//  line 8
	start[1] -= 40
	end[0] -= 40
	draw_line(start, end, r, g, b, duration)
}

draw_line(start[3], end[3], r, g, b, duration) {
	message_begin(MSG_BROADCAST, SVC_TEMPENTITY)
	write_byte(0)
	write_coord(start[0])
	write_coord(start[1])
	write_coord(start[2])
	write_coord(end[0])
	write_coord(end[1])
	write_coord(end[2])
	write_short(gTeleLine)
	write_byte(255)
	write_byte(255)
	write_byte(duration)
	write_byte(10)
	write_byte(0)
	write_byte(r)
	write_byte(g)
	write_byte(b)
	write_byte(200)
	write_byte(0)
	message_end()
}
*/

hostage_following(id) {
	for(new i=0;i<gHostageCount;i++) {
		if (cs_get_hostage_foll(gHostageEnt[i]) == id)
			return 1
	}
	return 0
}

public task_checkstuck(id) {
	if (gIsEnabled && (gItemType[id] == TYPE_HOSTAGE || gm_IsValidPlayer(id))) {
		new Float:fVec[3]
		pev(id, pev_velocity, fVec)
		if (fVec[2] == 50.0) {
			// teleport
			pev(gTeleEnt[gOldTeleporter[id]], pev_origin, fVec)
			engfunc(EngFunc_SetOrigin, id, fVec)
			gLastTeleporter[id] = gOldTeleporter[id]
			if (gItemType[id] == TYPE_HOSTAGE)
				set_pev(id, pev_health, 999999.0)
			else
				client_print(id, print_chat, "[GM] Teleported you back to your previous position because you were stuck.")
			// reset
			set_task(4.5, "task_reset_tele", id)
		}
		else {
			// speed
			if (gItemType[id] == TYPE_HOSTAGE) {
				fVec[0] = random_float(250.0, 1250.0)
				if (random_num(0, 1))
					fVec[0] *= -1
				fVec[1] = random_float(250.0, 1250.0)
				if (random_num(0, 1))
					fVec[1] *= -1
				fVec[2] = random_float(250.0, 1250.0)
				if (random_num(0, 1))
					fVec[2] *= -1
				
				set_pev(id, pev_health, 999999.0)
			}
			else {
				gm_VelocityByAim(id, 1000, fVec)
				fVec[2] = 0.0
			}
			set_pev(id, pev_velocity, fVec)
			// reset
			set_task(4.5, "task_reset_tele", id)
		}
	}
}

public task_reset_tele(id) {
	gLastTeleporter[id] = -1
}

// Connect Menu
public mh_ConnectMenu(id, menu, item) {
	if (!gIsEnabled) return
	
	if (item >= 0) {
		if (item >= gSelectedTeleporter[id])
			item++
		
		if (gSelectedTeleporter[id] >= gTeleCount)
			client_print(id, print_chat, "[GM] The teleporter you want to connect doesn't exist any more.")
		else {
			/*
			// whoa, variables
			new start[3], end[3], seltele
			seltele = gSelectedTeleporter[id]
			start[0] = floatround(gTeleOrigin[seltele][0])
			start[1] = floatround(gTeleOrigin[seltele][1])
			start[2] = floatround(gTeleOrigin[seltele][2])
			end[0] = floatround(gTeleOrigin[item][0])
			end[1] = floatround(gTeleOrigin[item][1])
			end[2] = floatround(gTeleOrigin[item][2])
			// effects and stuff
			draw_line(start, end, 255, 0, 0, 50)*/
			gTeleOut[gSelectedTeleporter[id]] = item
			client_print(id, print_chat, "[GM] Connected teleporter #%d with teleporter #%d.", gSelectedTeleporter[id], item)
		}
	}
	
	menu_display(id, mGabenModMenu, 5)
}
/* User commands */

public cmd_wallmenu(id, level, cid) {
	if (!gIsEnabled) return PLUGIN_CONTINUE
	
	if (cmd_access(id, level, cid, 0))
		menu_display(id, mGabenModMenu, 0)
	return PLUGIN_HANDLED
}

/* Menu Handler */

public mh_GabenModMenu(id, menu, item) {
	if (!gIsEnabled) return
	
	switch (item) {
		case -3: { // Exit
			gTeleAdmin = -1
		}
		case 0: { // Make a wall
			if (gWallCount < WALLS_MAX) {
				new Float:fVec[3], Float:fOrigin[3]
				new angle
				gm_VelocityByAim(id, 150, fVec)
				pev(id, pev_origin, fOrigin)
				fOrigin[0] += fVec[0]
				fOrigin[1] += fVec[1]
				fOrigin[2] -= 20.0
				pev(id, pev_v_angle, fVec)
				angle = floatround(fVec[1])
				if (angle < 0)
					angle += 360
				if (angle > 180)
					angle -= 180
				make_wall(fOrigin, (angle > 45 && angle < 135), cs_get_user_team(id))
			}
			else
				client_print(id, print_chat, "[GM] Cannot make any more walls!")
			menu_display(id, mGabenModMenu, 0)
		}
		case 1: { // Remove wall
			new ent, body, class[32]
			get_user_aiming(id, ent, body)
			if (pev_valid(ent)) {
				pev(ent, pev_classname, class, 31)
				if (equali("gm_wall", class)) {
					new wid = get_wall(ent)
					if (wid != -1)
						remove_wall(wid)
					else
						client_print(id, print_chat, "[GM] Invalid wall.")
				}
				else
					client_print(id, print_chat, "[GM] You are not aiming at a wall!")
			}
			else
				client_print(id, print_chat, "[GM] You are not aiming at a valid entity!")
			menu_display(id, mGabenModMenu, 0)
		}
		case 2: { // Remove all walls
			for(new i=gWallCount-1;i>-1;i--)
				remove_wall(i)
			menu_display(id, mGabenModMenu, 0)
		}
		case 3: { // Set wall to T-Wall
			new ent, body, class[32]
			get_user_aiming(id, ent, body)
			if (pev_valid(ent)) {
				pev(ent, pev_classname, class, 31)
				if (equali("gm_wall", class)) {
					new wid = get_wall(ent)
					if (wid != -1) {
						gWallTeam[wid] = CS_TEAM_T
						client_print(id, print_chat, "[GM] Set wall to T Wall.")
					}
					else
						client_print(id, print_chat, "[GM] Invalid wall.")
				}
				else
					client_print(id, print_chat, "[GM] You are not aiming at a wall!")
			}
			else
				client_print(id, print_chat, "[GM] You are not aiming at a valid entity!")
			menu_display(id, mGabenModMenu, 0)
		}
		case 4: { // Set wall to CT-Wall
			new ent, body, class[32]
			get_user_aiming(id, ent, body)
			if (pev_valid(ent)) {
				pev(ent, pev_classname, class, 31)
				if (equali("gm_wall", class)) {
					new wid = get_wall(ent)
					if (wid != -1) {
						gWallTeam[wid] = CS_TEAM_CT
						client_print(id, print_chat, "[GM] Set wall to CT Wall.")
					}
					else
						client_print(id, print_chat, "[GM] Invalid wall.")
				}
				else
					client_print(id, print_chat, "[GM] You are not aiming at a wall!")
			}
			else
				client_print(id, print_chat, "[GM] You are not aiming at a valid entity!")
			menu_display(id, mGabenModMenu, 0)
		}
		case 5: { // Set wall to Spec-Wall
			new ent, body, class[32]
			get_user_aiming(id, ent, body)
			if (pev_valid(ent)) {
				pev(ent, pev_classname, class, 31)
				if (equali("gm_wall", class)) {
					new wid = get_wall(ent)
					if (wid != -1) {
						gWallTeam[wid] = CS_TEAM_SPECTATOR
						client_print(id, print_chat, "[GM] Set wall to Spectator Wall.")
					}
					else
						client_print(id, print_chat, "[GM] Invalid wall.")
				}
				else
					client_print(id, print_chat, "[GM] You are not aiming at a wall!")
			}
			else
				client_print(id, print_chat, "[GM] You are not aiming at a valid entity!")
			menu_display(id, mGabenModMenu, 0)
		}
		case 6: { // Set wall to Neutral Wall
			new ent, body, class[32]
			get_user_aiming(id, ent, body)
			if (pev_valid(ent)) {
				pev(ent, pev_classname, class, 31)
				if (equali("gm_wall", class)) {
					new wid = get_wall(ent)
					if (wid != -1) {
						gWallTeam[wid] = CS_TEAM_UNASSIGNED
						client_print(id, print_chat, "[GM] Set wall to Neutral Wall.")
					}
					else
						client_print(id, print_chat, "[GM] Invalid wall.")
				}
				else
					client_print(id, print_chat, "[GM] You are not aiming at a wall!")
			}
			else
				client_print(id, print_chat, "[GM] You are not aiming at a valid entity!")
			menu_display(id, mGabenModMenu, 0)
		}
		case 7: { // Rotate wall by 90
			new ent, body, class[32]
			get_user_aiming(id, ent, body)
			if (pev_valid(ent)) {
				pev(ent, pev_classname, class, 31)
				if (equali("gm_wall", class)) {
					new wid = get_wall(ent)
					if (wid != -1)
						rotate_wall(wid)
					else
						client_print(id, print_chat, "[GM] Invalid wall.")
				}
				else
					client_print(id, print_chat, "[GM] You are not aiming at a wall!")
			}
			else
				client_print(id, print_chat, "[GM] You are not aiming at a valid entity!")
			menu_display(id, mGabenModMenu, 1)
		}
		case 8: { // Move wall up
			new ent, body, class[32]
			get_user_aiming(id, ent, body)
			if (pev_valid(ent)) {
				pev(ent, pev_classname, class, 31)
				if (equali("gm_wall", class)) {
					new Float:fVec[3]
					pev(ent, pev_origin, fVec)
					fVec[2] += get_cvar_num("gm_movestep")
					set_pev(ent, pev_origin, fVec)
				}
				else
					client_print(id, print_chat, "[GM] You are not aiming at a wall!")
			}
			else
				client_print(id, print_chat, "[GM] You are not aiming at a valid entity!")
			menu_display(id, mGabenModMenu, 1)
		}
		case 9: { // Move wall down
			new ent, body, class[32]
			get_user_aiming(id, ent, body)
			if (pev_valid(ent)) {
				pev(ent, pev_classname, class, 31)
				if (equali("gm_wall", class)) {
					new Float:fVec[3]
					pev(ent, pev_origin, fVec)
					fVec[2] -= get_cvar_num("gm_movestep")
					set_pev(ent, pev_origin, fVec)
				}
				else
					client_print(id, print_chat, "[GM] You are not aiming at a wall!")
			}
			else
				client_print(id, print_chat, "[GM] You are not aiming at a valid entity!")
			menu_display(id, mGabenModMenu, 1)
		}
		case 10: { // Save walls
			new key[32], data[32]
			new Float:fOrigin[3], origin[3]
			
			for(new i=0;i<WALLS_MAX;i++) {
				format(key, 31, "wall-%d", i)
				if (i < gWallCount) {
					pev(gWalls[i], pev_origin, fOrigin)
					origin[0] = floatround(fOrigin[0])
					origin[1] = floatround(fOrigin[1])
					origin[2] = floatround(fOrigin[2])
					format(data, 31, "%d %d %d %d %d", origin[0], origin[1], origin[2], gWallAngle[i], _:gWallTeam[i])
					gm_WriteMapInfo(key, data)
				}
				else if (!gm_DeleteMapInfo(key))
					break
			}
			client_print(id, print_chat, "[GM] Saved %d walls successfully!", gWallCount)
			menu_display(id, mGabenModMenu, 1)
		}
		case 11: { // Make Gaben
			if (gGabeCount < GABE_MAX) {
				new Float:fVec[3], Float:fOrigin[3]
				gm_VelocityByAim(id, 130, fVec)
				pev(id, pev_origin, fOrigin)
				fOrigin[0] += fVec[0]
				fOrigin[1] += fVec[1]
				fOrigin[2] += 20.0
				
				make_gaben(fOrigin)
				client_print(id, print_chat, "[GM] Gaben made.")
			}
			else
				client_print(id, print_chat, "[GM] Cannot make any more Gabens!")
			menu_display(id, mGabenModMenu, 1)
		}
		case 12: { // Remove Gaben
			new Float:origin[3]
			new class[32]
			pev(id, pev_origin, origin)
			new ent = 0
			while ((ent = engfunc(EngFunc_FindEntityInSphere, ent, origin, 150.0)) > 0) {
				pev(ent, pev_classname, class, 31)
				if (equali(class, "gm_gaben")) {
					remove_gabe(get_gabe(ent))
					ent = -2
					break
				}
			}
			if (ent == -2)
				client_print(id, print_chat, "[GM] How dare you to remove Gaben! Anyway, he left on his own.")
			else
				client_print(id, print_chat, "[GM] There's no Gaben next to you.")
			menu_display(id, mGabenModMenu, 1)
		}
		case 13: { // Remove every Gaben
			for(new i=0;i<gGabeCount;i++) {
				engfunc(EngFunc_RemoveEntity, gGaben[i])
				gItemType[gGaben[i]] = TYPE_UNDEFINED
				gGaben[i] = 0
			}
			gGabeCount = 0
			client_print(id, print_chat, "[GM] Removed every Gaben successfully (NOES).")
			menu_display(id, mGabenModMenu, 1)
		}
		case 14: { // Save Gaben
			new key[32], data[32]
			new Float:fOrigin[3], origin[3]
			
			for(new i=0;i<GABE_MAX;i++) {
				format(key, 31, "gaben-%d", i)
				if (i < gGabeCount) {
					pev(gGaben[i], pev_origin, fOrigin)
					origin[0] = floatround(fOrigin[0])
					origin[1] = floatround(fOrigin[1])
					origin[2] = floatround(fOrigin[2])
					format(data, 31, "%d %d %d", origin[0], origin[1], origin[2])
					gm_WriteMapInfo(key, data)
				}
				else if (!gm_DeleteMapInfo(key))
					break
			}
			client_print(id, print_chat, "[GM] Saved %d Gabens successfully!", gGabeCount)
			menu_display(id, mGabenModMenu, 2)
		}
		case 32: { // Remove every item
			new startent, lastent, itemid, i
			for(i=0;i<17;i++) {
				startent = 0
				lastent = 0
				while((lastent = engfunc(EngFunc_FindEntityByString, lastent, "classname", gItemNames[i])) > 0) {
					if (pev_valid(lastent) && !is_user_connected(pev(lastent, pev_owner))) {
						itemid = get_item(lastent)
						if (itemid != -1 && gItemCreated[itemid]) {
							engfunc(EngFunc_RemoveEntity, lastent)
							gItemType[lastent] = TYPE_UNDEFINED
							if (gItemRespawning[itemid])
								remove_task(itemid+10000)
						}
					}
						
					if (startent == 0)
						startent = lastent
					else if (startent == lastent)
						break
				}
			}
			gItemCount = 0
			gSpawnedItemCount = 0
			
			client_print(id, print_chat, "[GM] Removed every spawned item successfully.")
			menu_display(id, mGabenModMenu, 4)
		}
		case 33: { // Remove item
			new Float:fOrigin[3], origin[3]
			new ent = 0, itemid
			new class[32]
			
			get_user_origin(id, origin, 3)
			fOrigin[0] = float(origin[0])
			fOrigin[1] = float(origin[1])
			fOrigin[2] = float(origin[2])
			
			while ((ent = engfunc(EngFunc_FindEntityInSphere, ent, fOrigin, 5.0)) > 0) {
				itemid = get_item(ent)
				if (pev(ent, pev_owner) == 0 && itemid != -1) {
					copy(class, 31, gItemNames[gItemClass[itemid]])
					pev(ent, pev_origin, fOrigin)
					
					remove_item(itemid, ent)
					ent = -2
					break
				}
			}
			if (ent == -2) {
				client_print(id, print_chat, "[GM] Item ^"%s^" removed.", class)
				
				// a beam to the ent, wtf
				message_begin(MSG_BROADCAST, SVC_TEMPENTITY, origin, id)
				write_byte(1)
				write_short(id)
				write_coord(floatround(fOrigin[0]))
				write_coord(floatround(fOrigin[1]))
				write_coord(floatround(fOrigin[2]))
				write_short(gLaser)
				write_byte(0)
				write_byte(0)
				write_byte(30)
				write_byte(15)
				write_byte(60)
				write_byte(255)
				write_byte(0)
				write_byte(0)
				write_byte(175)
				write_byte(100)
				message_end()
			}
			else
				client_print(id, print_chat, "[GM] You are not looking at a valid item.")
			menu_display(id, mGabenModMenu, 4)
		}
		case 34: { // Save items
			new key[32], data[128]
			for(new i=0;i<ITEMS_MAX;i++) {
				format(key, 31, "item-%d", i)
				if (i < gItemCount) {
					format(data, 127, "%f %f %f %d", gItemOrigin[i][0], gItemOrigin[i][1], gItemOrigin[i][2], gItemClass[i])
					gm_WriteMapInfo(key, data)
				}
				else if (!gm_DeleteMapInfo(key))
					break
			}
			client_print(id, print_chat, "[GM] Saved %d items successfully!", gItemCount)
			menu_display(id, mGabenModMenu, 4)
		}
		case 35: { // Make Teleporter for Ts
			gTeleAdmin = id
			if (gTeleCount < TELE_MAX) {
				new Float:fOrigin[3]
				pev(id, pev_origin, fOrigin)
				fOrigin[2] += 20.0
				engfunc(EngFunc_SetOrigin, id, fOrigin)
				fOrigin[2] -= 40.0
				client_print(id, print_chat, "[GM] Teleporter for Terrorists made (id #%d)", make_teleporter(fOrigin, CS_TEAM_T))
			}
			else
				client_print(id, print_chat, "[GM] You cannot create any more teleporters!")
			menu_display(id, mGabenModMenu, 5)
		}
		case 36: { // Make Teleporter for CTs
			gTeleAdmin = id
			if (gTeleCount < TELE_MAX) {
				new Float:fOrigin[3]
				pev(id, pev_origin, fOrigin)
				fOrigin[2] += 20.0
				engfunc(EngFunc_SetOrigin, id, fOrigin)
				fOrigin[2] -= 40.0
				client_print(id, print_chat, "[GM] Teleporter for Counter-Terrorists made (id #%d)", make_teleporter(fOrigin, CS_TEAM_CT))
			}
			else
				client_print(id, print_chat, "[GM] You cannot create any more teleporters!")
			menu_display(id, mGabenModMenu, 5)
		}
		case 37: { // Make Neutral Teleporter
			gTeleAdmin = id
			if (gTeleCount < TELE_MAX) {
				new Float:fOrigin[3]
				pev(id, pev_origin, fOrigin)
				fOrigin[2] += 20.0
				engfunc(EngFunc_SetOrigin, id, fOrigin)
				fOrigin[2] -= 40.0
				client_print(id, print_chat, "[GM] Neutral Teleporter made (id #%d)", make_teleporter(fOrigin, CS_TEAM_SPECTATOR))
			}
			else
				client_print(id, print_chat, "[GM] You cannot create any more teleporters!")
			menu_display(id, mGabenModMenu, 5)
		}
		case 38: { // Make Teleporter Destination
			gTeleAdmin = id
			if (gTeleCount < TELE_MAX) {
				new Float:fOrigin[3]
				pev(id, pev_origin, fOrigin)
				fOrigin[2] += 20.0
				engfunc(EngFunc_SetOrigin, id, fOrigin)
				fOrigin[2] -= 40.0
				client_print(id, print_chat, "[GM] Teleporter Destination made (id #%d)", make_teleporter(fOrigin, CS_TEAM_UNASSIGNED))
			}
			else
				client_print(id, print_chat, "[GM] You cannot create any more teleporters!")
			menu_display(id, mGabenModMenu, 5)
		}
		case 39: { // Delete Teleporter
			gTeleAdmin = id
			new Float:fOrigin[3], tid
			pev(id, pev_origin, fOrigin)
			tid = get_teleporter_at(fOrigin)
			if (tid == -1)
				client_print(id, print_chat, "[GM] There's no teleporter next to you.")
			else {
				remove_teleporter(tid)
				client_print(id, print_chat, "[GM] Removed teleporter #%d successfully.", tid)
			}
			menu_display(id, mGabenModMenu, 5)
		}
		case 40: { // Get Teleporter ID
			gTeleAdmin = id
			new Float:fOrigin[3], tid
			pev(id, pev_origin, fOrigin)
			tid = get_teleporter_at(fOrigin)
			if (tid == -1)
				client_print(id, print_chat, "[GM] There's no teleporter next to you.")
			else {
				client_print(id, print_chat, "[GM] Found teleporter #%d next to you.", tid)
				if (gTeleOut[tid] == -1)
					client_print(id, print_chat, "[GM] This teleporter is not connected to another teleporter.")
				else
					client_print(id, print_chat, "[GM] This teleporter is connected to teleporter #%d.", gTeleOut[tid])
			}
			menu_display(id, mGabenModMenu, 5)
		}
		case 41: { // Connect Teleporters
			gTeleAdmin = id
			new Float:fOrigin[3], tid
			pev(id, pev_origin, fOrigin)
			tid = get_teleporter_at(fOrigin)
			if (tid == -1) {
				client_print(id, print_chat, "[GM] There's no teleporter next to you.")
				menu_display(id, mGabenModMenu, 5)
			}
			else {
				client_print(id, print_chat, "[GM] Found teleporter #%d next to you. Now select the teleporter you want to use as destination for this one.", tid)
				gSelectedTeleporter[id] = tid
				if (mConnectMenu)
					menu_destroy(mConnectMenu)
				mConnectMenu = menu_create("Connect Teleporters", "mh_ConnectMenu")
				
				new str[32]
				for(new i=0;i<gTeleCount;i++) {
					if (i != tid) {
						format(str, 31, "Teleporter #%d", i)
						menu_additem(mConnectMenu, str)
					}
				}
				menu_display(id, mConnectMenu, 0)
			}
		}
		case 42: { // Remove all teleporters
			if (gTeleCount == 0)
				client_print(id, print_chat, "[GM] There's no teleporter to remove.")
			else {
				for(new i=0;i<gTeleCount;i++) {
					engfunc(EngFunc_RemoveEntity, gTeleEnt[i])
					gItemType[gTeleEnt[i]] = 0
				}
				client_print(id, print_chat, "[GM] Removed %d teleporters successfully.", gTeleCount)
				gTeleCount = 0
			}
		}
		case 43: { // Save Teleporters
			new key[32], data[128], Float:fVec[3]
			for(new i=0;i<TELE_MAX;i++) {
				format(key, 31, "teleporter-%d", i)
				if (i < gTeleCount) {
					if (pev_valid(gTeleEnt[i])) {
						pev(gTeleEnt[i], pev_origin, fVec)
						format(data, 127, "%f %f %f %d %d", fVec[0], fVec[1], fVec[2], _:gTeleTeam[i], gTeleOut[i])
						gm_WriteMapInfo(key, data)
					}
				}
				else if (!gm_DeleteMapInfo(key))
					break
			}
			client_print(id, print_chat, "[GM] Saved %d teleporters successfully!", gTeleCount)
			
			menu_display(id, mGabenModMenu, 6)
		}
		case 44: { // Reload everything
			new i
			/* Walls */
			client_print(id, print_chat, "[GM] Reloading walls...")
			for(i=gWallCount-1;i>-1;i--)
				remove_wall(i)
			load_walls()
			/* Gabens */
			client_print(id, print_chat, "[GM] Reloading Gabens...")
			for(i=gGabeCount-1;i>-1;i--) {
				engfunc(EngFunc_RemoveEntity, gGaben[i])
				gItemType[gGaben[i]] = TYPE_UNDEFINED
				gGaben[i] = 0
			}
			gGabeCount = 0
			load_gaben()
			/* Items */
			client_print(id, print_chat, "[GM] Reloading items...")
			new startent, lastent, itemid
			for(i=0;i<17;i++) {
				startent = 0
				lastent = 0
				while((lastent = engfunc(EngFunc_FindEntityByString, lastent, "classname", gItemNames[i])) > 0) {
					if (pev_valid(lastent) && !is_user_connected(pev(lastent, pev_owner))) {
						itemid = get_item(lastent)
						if (itemid != -1 && gItemCreated[itemid]) {
							engfunc(EngFunc_RemoveEntity, lastent)
							gItemType[lastent] = TYPE_UNDEFINED
							if (gItemRespawning[itemid])
								remove_task(itemid+10000)
						}
					}
						
					if (startent == 0)
						startent = lastent
					else if (startent == lastent)
						break
				}
			}
			gItemCount = 0
			gSpawnedItemCount = 0
			load_items()
			/* Teleporters */
			client_print(id, print_chat, "[GM] Reloading teleporters...")
			for(i=0;i<gTeleCount;i++) {
				engfunc(EngFunc_RemoveEntity, gTeleEnt[i])
				gItemType[gTeleEnt[i]] = 0
			}
			gTeleCount = 0
			load_teleporters()
			/* Done */
			client_print(id, print_chat, "[GM] Done!")
			menu_display(id, mGabenModMenu, 6)
		}
		case 45: { // Enable/Disable Godmode
			new Float:takedmg
			pev(id, pev_takedamage, takedmg)
			if (takedmg == 0.0) {
				set_pev(id, pev_takedamage, 2.0)
				client_print(id, print_chat, "[GM] Godmode disabled.")
			}
			else {
				set_pev(id, pev_takedamage, 0.0)
				client_print(id, print_chat, "[GM] Godmode enabled.")
			}
			menu_display(id, mGabenModMenu, 6)
		}
		case 46: { // Enable/Disable Semiclip
			if (pev(id, pev_solid) == SOLID_NOT) {
				set_pev(id, pev_solid, SOLID_BBOX)
				client_print(id, print_chat, "[GM] Semiclip enabled.")
			}
			else {
				set_pev(id, pev_solid, SOLID_NOT)
				client_print(id, print_chat, "[GM] Semiclip disabled.")
			}
			menu_display(id, mGabenModMenu, 6)
		}
		default: {
			if (item > 14 && item < 33) { // Spawn item
				if (pev(id, pev_solid) != SOLID_NOT) {
					set_pev(id, pev_solid, SOLID_NOT)
					client_print(id, print_chat, "[GM] Your semiclip has been disabled. Use this menu to enable it again.")
				}
				
				new Float:origin[3]
				pev(id, pev_origin, origin)
				make_item(origin, item - 15)
			}
			
			if (item > 14 && item < 21)
				menu_display(id, mGabenModMenu, 2)
			else if (item > 20 && item < 28)
				menu_display(id, mGabenModMenu, 3)
			else if (item > 27)
				menu_display(id, mGabenModMenu, 4)
		}
	}
}

/* Ent Check, should help a lot to prevent/debug ED_Alloc crashes */

public task_check_ents() {
	/*for(new i=0;i<gTeleCount;i++) {
		switch (gTeleTeam[i]) {
			case CS_TEAM_T: draw_teleporter(gTeleOrigin[i], 255, 0, 0, 60)
			case CS_TEAM_CT: draw_teleporter(gTeleOrigin[i], 0, 0, 255, 60)
			case CS_TEAM_SPECTATOR: draw_teleporter(gTeleOrigin[i], 150, 150, 150, 60)
			default: draw_teleporter(gTeleOrigin[i], 255, 170, 42, 60)
		}
	}*/
	
	if (!gIsEnabled || !get_pcvar_num(cCheckEnts))
		return
	
	new curr_ents = engfunc(EngFunc_NumberOfEntities)
	new diff = global_get(glb_maxEntities) - curr_ents
	#if defined ENT_DEBUG
	client_print(0, print_chat, "** DEBUG: Free items: %d - Spawned items: %d", diff, gSpawnedItemCount)
	#endif
	
	if (diff < get_pcvar_num(cLeastFreeEnts)) { // too many ents
		if (gSpawnedItemCount == 0) {
			// entity dumps should help a lot to find possible ent leaks
			if (!gWrittenEntDump) {
				client_print(0, print_chat, "[GM DEBUG] Too many entities detected, writing entity dump...")
				set_task(1.0, "task_write_dump")
				gWrittenEntDump = 1
			}
		}
		else {
			#if defined ENT_DEBUG
			client_print(0, print_chat, "** DEBUG: Too many items, removing items...")
			#endif
			
			diff = get_pcvar_num(cLeastFreeEnts) - diff
			
			new tmp = gItemCount -1
			while (diff > 0 && tmp >= 0) {
				if (gItemCreated[tmp]) {
					if (gItemRespawning[tmp])
						remove_task(tmp+10000)
					else
						engfunc(EngFunc_RemoveEntity, gItemEnt[tmp])
					gItemCreated[tmp] = 0
					
					diff--
					gSpawnedItemCount--
				}
				tmp--
			}
			
			#if defined ENT_DEBUG
			client_print(0, print_chat, "** DEBUG: Removed %d item(s) temporarily...", get_pcvar_num(cLeastFreeEnts) - (global_get(glb_maxEntities) - curr_ents))
			#endif
			log_amx("Removed %d entities to keep %d free entity slots.", get_pcvar_num(cLeastFreeEnts) - (global_get(glb_maxEntities) - curr_ents), get_pcvar_num(cLeastFreeEnts))
		}
	}
	else if (gSpawnedItemCount != gItemCount && diff > get_pcvar_num(cLeastFreeEnts)) { // whoa, free ent slots, create our own again
		diff -= get_pcvar_num(cLeastFreeEnts)
		
		new tmp = gItemCount -1
		while (diff > 0 && tmp >= 0) {
			if (!gItemCreated[tmp]) {
				make_item(gItemOrigin[tmp], gItemClass[tmp], tmp)
				diff--
			}
			tmp--
		}
		
		#if defined ENT_DEBUG
		client_print(0, print_chat, "** DEBUG: Respawned %d item(s)...", (global_get(glb_maxEntities) - curr_ents) - get_pcvar_num(cLeastFreeEnts))
		#endif
		log_amx("Respawned %d item(s)...", (global_get(glb_maxEntities) - curr_ents) - get_pcvar_num(cLeastFreeEnts))
	}
}

public task_write_dump() {
	if (file_exists("ent_dump.log"))
		delete_file("ent_dump.log")
	
	new fstr[32], class[20], entsmax = global_get(glb_maxEntities)
	for(new i=0;i<entsmax;i++) {
		if (pev_valid(i)) {
			pev(i, pev_classname, class, 19)
			format(fstr, 31, "%d. %s", i, class)
			
		}
		else
			format(fstr, 31, "%d. <no ent>", i)
		write_file("ent_dump.log", fstr)
	}
}

// Most stuff copied from the menu part
public gm_EnablingMod() {
	/* reload stuff */
	load_walls()
	load_gaben()
	load_items()
	load_teleporters()
	
	gIsEnabled = 1
}

public gm_DisablingMod() {
	/* remove stuff */
	new i
	/* Walls */
	for(i=gWallCount-1;i>-1;i--)
		remove_wall(i)
	/* Gabens */
	for(i=gGabeCount-1;i>-1;i--) {
		engfunc(EngFunc_RemoveEntity, gGaben[i])
		gItemType[gGaben[i]] = TYPE_UNDEFINED
		gGaben[i] = 0
	}
	gGabeCount = 0
	/* Items */
	new startent, lastent, itemid
	for(i=0;i<17;i++) {
		startent = 0
		lastent = 0
		while((lastent = engfunc(EngFunc_FindEntityByString, lastent, "classname", gItemNames[i])) > 0) {
			if (pev_valid(lastent) && !is_user_connected(pev(lastent, pev_owner))) {
				itemid = get_item(lastent)
				if (itemid != -1 && gItemCreated[itemid]) {
					engfunc(EngFunc_RemoveEntity, lastent)
					gItemType[lastent] = TYPE_UNDEFINED
					if (gItemRespawning[itemid])
						remove_task(itemid+10000)
				}
			}
				
			if (startent == 0)
				startent = lastent
			else if (startent == lastent)
				break
		}
	}
	gItemCount = 0
	gSpawnedItemCount = 0
	/* Teleporters */
	for(i=0;i<gTeleCount;i++) {
		engfunc(EngFunc_RemoveEntity, gTeleEnt[i])
		gItemType[gTeleEnt[i]] = 0
	}
	gTeleCount = 0
	/* Variables */
	gIsEnabled = 0
}
