/* gm_hwguy.sma is part of GabenMod
*  Copyright 2005-2006 by Basic-Master (AMX Mod X Dev Team)
*
*  Yes, Gabe, this mod is dedicated to you, we hope you like
*  it as much as we do! Nevertheless, VALVe, your code still
*  sucks. Especially your HL2SDK, it's a nightmare. Someday
*  Gaben will appear and eat you and your SDK >_<. HE WILL!
*
*/

#include <amxmodx>
#include <amxmisc>
#include <cstrike>
#include <fakemeta>
#include "gabenmod"
#if defined CSDM_COMPILATION
#include <csdm>
#endif

#define PLUGIN "GM HWGuy"
#define AUTHOR "Basic-Master"

#define AMMO_REQP 14	 // Extra ammo
#define AUG_REQP 35	 // AUG
#define AK47_REQP 49	 // AK47
#define XM1014_REQP 21	 // XM 1014
#define SG552_REQP 35	 // SG 552
#define BULLET_REQP 70	 // Improved Bullets
#define STRENGTH_REQP 56 // Strength (HP+armor)

#define BULLET_DMGMUL 0.5 	// Extra damage (improved bullets)
#define EXTRADMG_MUL  0.2 	// Extra damage (default)

#define AllKeys (1<<0)|(1<<1)|(1<<2)|(1<<3)|(1<<4)|(1<<5)|(1<<6)|(1<<7)|(1<<8)|(1<<9) // Menu keys

/* Custom weapons:
* [0] = Extra ammo
* [1] = AUG
* [2] = AK47
* [3] = XM 1014
* [4] = SG 552
* [5] = Improved Bullets
* [6] = Strength (HP+armor)
*/
new gCustomWeapons[33][7]
new gHasClass[33]
new temp[256]
new gWpnInfo[33][2] // wpn+ammo
new wpn_wpn, wpn_clip, wpn_ammo
new wpn_bullet[3], wpn_origin[3]
new Float:wpn_fVec1[3], Float:wpn_fVec2[3]

public plugin_init() {
	register_plugin(PLUGIN, GABENMOD_VERSION, AUTHOR)
	register_event("CurWeapon", "hook_wpn", "b")
	gm_RegClass("HWGuy", "Extra damage, armor and machine gun", "cmd_init", "cmd_menu", "cmd_menu", 0)
	register_menucmd(register_menuid("BuyMenu"), AllKeys, "PressedBuyMenu")
}

public cmd_init(id, hasclass) {
	// (re-)set values
	gHasClass[id] = hasclass
	if (hasclass && gm_IsEnabled() && gm_IsValidPlayer(id))
		gm_Respawn(id)
	
	for (new i=0;i<7;i++)
		gCustomWeapons[id][i] = 0
}

public give_weapons(id) {
	if (!gm_IsEnabled() || !gm_IsValidPlayer(id))
		return
	
	// Strip weapons
	gm_StripWeapons(id)
	// Then give default weapons
	gm_CreateOwnedItem(id, "weapon_knife")
	gm_CreateOwnedItem(id, "weapon_p228")
	gm_CreateOwnedItem(id, "ammo_357sig")
	gm_CreateOwnedItem(id, "weapon_m249")
	gm_CreateOwnedItem(id, "ammo_556natobox")
	gm_CreateOwnedItem(id, "ammo_556natobox")
	gm_CreateOwnedItem(id, "weapon_hegrenade")
	cs_set_user_bpammo(id, CSW_HEGRENADE, 2)
	// Then the additional ones
	if (gCustomWeapons[id][1]) {
		gm_CreateOwnedItem(id, "weapon_aug")
		gm_CreateOwnedItem(id, "ammo_556nato")
	}
	if (gCustomWeapons[id][2]) {
		gm_CreateOwnedItem(id, "weapon_ak47")
		gm_CreateOwnedItem(id, "ammo_762nato")			
	}
	if (gCustomWeapons[id][3]) {
		gm_CreateOwnedItem(id, "weapon_xm1014")
		gm_CreateOwnedItem(id, "ammo_buckshot")
	}
	if (gCustomWeapons[id][4]) {
		gm_CreateOwnedItem(id, "weapon_sg552")
		gm_CreateOwnedItem(id, "ammo_556nato")
	}
	// And finally additional ammo (if bought)
	if (gCustomWeapons[id][0]) {
		/* 200+ bullets for machine gun */
		gm_CreateOwnedItem(id, "ammo_556natobox")
		gm_CreateOwnedItem(id, "ammo_556natobox")
		gm_CreateOwnedItem(id, "ammo_556natobox")
		gm_CreateOwnedItem(id, "ammo_556natobox")
		gm_CreateOwnedItem(id, "ammo_556natobox")
		/* and some for the p228 */
		gm_CreateOwnedItem(id, "ammo_357sig")
		gm_CreateOwnedItem(id, "ammo_357sig")
		
		if (gCustomWeapons[id][1]) { // AUG
			/* 90 bullets */
			gm_CreateOwnedItem(id, "ammo_556nato")
			gm_CreateOwnedItem(id, "ammo_556nato")
		}
		if (gCustomWeapons[id][2]) { // AK47
			/* 90 bullets */
			gm_CreateOwnedItem(id, "ammo_762nato")			
			gm_CreateOwnedItem(id, "ammo_762nato")			
		}
		if (gCustomWeapons[id][3]) { // XM 1014
			/* 32 bullets */
			gm_CreateOwnedItem(id, "ammo_buckshot")
			gm_CreateOwnedItem(id, "ammo_buckshot")
			gm_CreateOwnedItem(id, "ammo_buckshot")
		}
		if (gCustomWeapons[id][4]) { // SG 552
			/* 90 bullets */
			gm_CreateOwnedItem(id, "ammo_556nato")
			gm_CreateOwnedItem(id, "ammo_556nato")
		}
	}
}

public cmd_menu(id) {
	if (gm_IsEnabled())
		show_buymenu(id)
}

public gm_Respawn(id) {
	if (gm_IsEnabled() && gHasClass[id] && gm_IsValidPlayer(id)) {
		// Weapons+armor
		set_task(0.1, "give_weapons", id)
		if (gCustomWeapons[id][6]) {
			set_user_health(id, 150.0)
			cs_set_user_armor(id, 160, CS_ARMOR_VESTHELM)
		}
		else {
			set_user_health(id, 120.0)
			cs_set_user_armor(id, 120, CS_ARMOR_VESTHELM)
		}
		// Speed
		engfunc(EngFunc_SetClientMaxspeed, id, 330.0)
		set_pev(id, pev_maxspeed, 330.0)
	}
}

public hook_wpn(id) {
	if (!gm_IsEnabled() || !gHasClass[id] || !gm_IsValidPlayer(id))
		return PLUGIN_CONTINUE
	
	// speed
	engfunc(EngFunc_SetClientMaxspeed, id, 330.0)
	set_pev(id, pev_maxspeed, 330.0)
	// do something if a bullet has been fired
	wpn_wpn = get_user_weapon(id, wpn_clip, wpn_ammo)
	if (gWpnInfo[id][0] == wpn_wpn && gWpnInfo[id][1] > wpn_clip) {
		get_user_origin(id, wpn_origin)
		get_user_origin(id, wpn_bullet, 4)
		// Tracers!
		message_begin(MSG_BROADCAST, SVC_TEMPENTITY)
		write_byte(6)
		write_coord(wpn_origin[0])
		write_coord(wpn_origin[1])
		write_coord(wpn_origin[2])
		write_coord(wpn_bullet[0])
		write_coord(wpn_bullet[1])
		write_coord(wpn_bullet[2])
		message_end()
		// Screenfade, whoa, this looks nice
		message_begin(MSG_ONE_UNRELIABLE, get_user_msgid("ScreenFade"), {0, 0, 0}, id)
		write_short(60) // duration in 0.01s
		write_short(20) // holdtime in 0.01s
		write_short(40) // fadetime in 0.01s
		write_byte(255) // r
		write_byte(0) // g
		write_byte(0) // b
		write_byte(30)	// alpha
		message_end()
		// POWERFUL BULLETS, EH?!
		pev(id, pev_velocity, wpn_fVec1)
		gm_VelocityByAim(id, 10, wpn_fVec2)
		wpn_fVec1[0] -= wpn_fVec2[0]
		wpn_fVec1[1] -= wpn_fVec2[1]
		wpn_fVec1[2] -= wpn_fVec2[2]
		set_pev(id, pev_velocity, wpn_fVec1)
	}
	// ohes, weapon info
	gWpnInfo[id][0] = wpn_wpn
	gWpnInfo[id][1] = wpn_clip
	
	return PLUGIN_CONTINUE
}

public gm_DamageEvent(victim, attacker, weapon[], damage, extradamage) {
	if (gm_IsEnabled() && attacker && !extradamage && is_user_connected(attacker) && gHasClass[attacker] && containi(weapon, "weapon_") == 0 && get_user_health(victim) - damage > 0) {
		// extra damage
		if (gCustomWeapons[attacker][5])
			gm_ExtraDamage(attacker, victim, floatround(float(damage) * BULLET_DMGMUL), weapon[7], 0, DMG_BULLET)
		else
			gm_ExtraDamage(attacker, victim, floatround(float(damage) * EXTRADMG_MUL), weapon[7], 0, DMG_BULLET)
	}
}

show_buymenu(id) {
	new keys = (1<<9)
	temp = "\yBuy menu^n^n"
	/* Extra Ammo */
	if (gCustomWeapons[id][0]) {
		add(temp, 255, "\w1. Drop Extra Ammo^n")
		keys |= (1<<0)
	}
	else if (gm_GetPoints(id) >= AMMO_REQP) {
		addpointitem("\w1. Buy Extra Ammo", AMMO_REQP)
		keys |= (1<<0)
	}
	else
		addpointitem("\d1. Buy Extra Ammo", AMMO_REQP)
	/* AUG */
	if (gCustomWeapons[id][1]) {
		add(temp, 255, "\w2. Drop Steyr Aug^n")
		keys |= (1<<1)
	}
	else if (gm_GetPoints(id) >= AUG_REQP) {
		addpointitem("\w2. Buy Steyr Aug", AUG_REQP)
		keys |= (1<<1)
	}
	else
		addpointitem("\d2. Buy Steyr Aug", AUG_REQP)
	/* AK 47 */
	if (gCustomWeapons[id][2]) {
		add(temp, 255, "\w3. Drop AK 47^n")
		keys |= (1<<2)
	}
	else if (gm_GetPoints(id) >=  AK47_REQP) {
		addpointitem("\w3. Buy AK 47", AK47_REQP)
		keys |= (1<<2)
	}
	else
		addpointitem("\d3. Buy AK 47", AK47_REQP)
	/* XM 1014 */
	if (gCustomWeapons[id][3]) {
		add(temp, 255, "\w4. Drop XM 1014^n")
		keys |= (1<<3)
	}
	else if (gm_GetPoints(id) >= XM1014_REQP) {
		addpointitem("\w4. Buy XM 1014", XM1014_REQP)
		keys |= (1<<3)
	}
	else
		addpointitem("\d4. Buy XM 1014", XM1014_REQP)
	/* SG 552 */
	if (gCustomWeapons[id][4]) {
		add(temp, 255, "\w5. Drop SG 552^n")
		keys |= (1<<4)
	}
	else if (gm_GetPoints(id) >= SG552_REQP) {
		addpointitem("\w5. Buy SG 552", SG552_REQP)
		keys |= (1<<4)
	}
	else
		addpointitem("\d5. Buy SG 552", SG552_REQP)
	/* Improved Bullets */
	if (gCustomWeapons[id][5]) {
		add(temp, 255, "\w6. Drop Improved Bullets^n")
		keys |= (1<<5)
	}
	else if (gm_GetPoints(id) >= BULLET_REQP) {
		addpointitem("\w6. Buy Improved Bullets", BULLET_REQP)
		keys |= (1<<5)
	}
	else
		addpointitem("\d6. Buy Improved Bullets", BULLET_REQP)
	/* Strength (HP+armor) */
	if (gCustomWeapons[id][6]) {
		add(temp, 255, "\w7. Drop Strength^n")
		keys |= (1<<6)
	}
	else if (gm_GetPoints(id) >= STRENGTH_REQP) {
		addpointitem("\w7. Buy Strength (HP+armor)", STRENGTH_REQP)
		keys |= (1<<6)
	}
	else
		addpointitem("\d7. Buy Strength (HP+armor)", STRENGTH_REQP)

	add(temp, 255, "^n\w0. Exit")
	
	show_menu(id, keys, temp, -1, "BuyMenu") // Display menu
}

addpointitem(title[], points) {
	new tmp[64]
	format(tmp, 63, "%s (%d points)^n", title, points)
	add(temp, 255, tmp)
}

public PressedBuyMenu(id, key) {
	if (!gm_IsEnabled()) return
	
	/* Custom weapons:
	* [0] = Extra ammo
	* [1] = AUG
	* [2] = AK47
	* [3] = XM 1014
	* [4] = SG 552
	* [5] = Improved Bullets
	* [6] = Strength (HE+armor)
	*/

	switch (key) {
		case 0: {
			if (gCustomWeapons[id][0])
				gm_AddPoints(id, AMMO_REQP)
			else
				gm_RemPoints(id, AMMO_REQP)
			gCustomWeapons[id][0] = gCustomWeapons[id][0] ? 0: 1
		}
		case 1: {
			if (gCustomWeapons[id][1])
				gm_AddPoints(id, AUG_REQP)
			else
				gm_RemPoints(id, AUG_REQP)
			gCustomWeapons[id][1] = gCustomWeapons[id][1] ? 0: 1
			
		}
		case 2: {
			if (gCustomWeapons[id][2])
				gm_AddPoints(id, AK47_REQP)
			else
				gm_RemPoints(id, AK47_REQP)
			gCustomWeapons[id][2] = gCustomWeapons[id][2] ? 0: 1
		}
		case 3: {
			if (gCustomWeapons[id][3])
				gm_AddPoints(id, XM1014_REQP)
			else
				gm_RemPoints(id, XM1014_REQP)
			gCustomWeapons[id][3] = gCustomWeapons[id][3] ? 0: 1
		}
		case 4: {
			if (gCustomWeapons[id][4])
				gm_AddPoints(id, SG552_REQP)
			else
				gm_RemPoints(id, SG552_REQP)
			gCustomWeapons[id][4] = gCustomWeapons[id][4] ? 0: 1
		}
		case 5: {
			if (gCustomWeapons[id][5])
				gm_AddPoints(id, BULLET_REQP)
			else
				gm_RemPoints(id, BULLET_REQP)
			gCustomWeapons[id][5] = gCustomWeapons[id][5] ? 0: 1
		}
		case 6: {
			if (gCustomWeapons[id][6])
				gm_AddPoints(id, STRENGTH_REQP)
			else
				gm_RemPoints(id, STRENGTH_REQP)
			gCustomWeapons[id][6] = gCustomWeapons[id][6] ? 0: 1
		}
		case 9: {
			return
		}
	}

	show_buymenu(id)
}

