local mod = DBM:NewMod("Patchwerk", "DBM-Naxx", 2)
local L = mod:GetLocalizedStrings()

mod:SetRevision(("$Revision: 456 $"):sub(12, -3))
mod:SetCreatureID(16028)
mod:SetZone()

mod:RegisterCombat("yell", L.yell1, L.yell2)

mod:EnableModel()

mod:RegisterEvents(
	"SPELL_DAMAGE",
	"SPELL_MISSED"
)

mod:AddBoolOption("WarningHateful", false, "announce")
local enrageTimer = mod:NewEnrageTimer(360)

local function announceStrike(target, damage)
	SendChatMessage(L.HatefulStrike:format(target, damage), "RAID")
end

function mod:OnCombatStart(delay)
	enrageTimer:Start()
end

function mod:SPELL_DAMAGE(args)
	if (args.spellId == 28308 or args.spellId == 59192) and self.Options.WarningHateful and DBM:GetRaidRank() >= 1 then
		announceStrike(args.destName, args.amount or 0)
	end
end

function mod:SPELL_MISSED(args)
	if (args.spellId == 28308 or args.spellId == 59192) and self.Options.WarningHateful and DBM:GetRaidRank() >= 1 then
		announceStrike(args.destName, getglobal("ACTION_SPELL_MISSED_"..(args.missType)) or "")
	end	
end

