-- Minimap Button Handling

FishingBuddy.Minimap = {};

FishingBuddy.Minimap.Button_OnLoad = function()
   this:SetFrameLevel(this:GetFrameLevel()+1)
   this:RegisterForDrag("LeftButton");
   this:RegisterForClicks("LeftButtonUp", "RightButtonUp");
--   this:RegisterEvent("VARIABLES_LOADED");
end

FishingBuddy.Minimap.Button_OnClick = function(button)
   if ( button == "RightButton" ) then
      if ( IsAltKeyDown() ) then
         ToggleFishingBuddyFrame("FishingOptionsFrame");
      else
         -- Toggle menu
         local menu = getglobal("FishingBuddyMinimapMenu");
         UIDropDownMenu_Initialize(menu, FishingBuddy.Minimap.Menu_Initialize, "MENU");
         menu.point = "TOPRIGHT";
         menu.relativePoint = "CENTER";
         ToggleDropDownMenu(1, nil, menu, "FishingBuddyMinimapButton", 0, 0);
      end
   elseif ( FishingBuddy.IsSwitchClick("MinimapClickToSwitch") ) then
      FishingBuddy.Command(FBConstants.SWITCH);
   else
      FishingBuddy.Command("");
   end
end

local function BeingDragged()
   -- Thanks to Gello for this code
   local xpos,ypos = GetCursorPosition();
   local xmin,ymin = Minimap:GetLeft(), Minimap:GetBottom();

   xpos = xmin-xpos/UIParent:GetScale()+80;
   ypos = ypos/UIParent:GetScale()-ymin-80;

   local ang = math.deg(math.atan2(ypos,xpos));
   if ( ang < 0 ) then
      ang = ang + 360;
   end
   FishingBuddy.SetSetting("MinimapButtonPosition", ang);
   FishingBuddyMinimapButton_MoveButton();
end

FishingBuddy.Minimap.Button_OnDragStart = function(button)
   this:SetScript("OnUpdate", BeingDragged);
end

FishingBuddy.Minimap.Button_OnDragStop = function(button)
   this:SetScript("OnUpdate", nil);
end

FishingBuddyMinimapButton_MoveButton = function()
   if ( FishingBuddy.IsLoaded() ) then
      local where = FishingBuddy.GetSetting("MinimapButtonPosition");
      local radius = FishingBuddy.GetSetting("MinimapButtonRadius");
      FishingBuddyMinimapFrame:ClearAllPoints();
      FishingBuddyMinimapFrame:SetPoint("TOPLEFT", "Minimap", "TOPLEFT",
					 52 - (radius * cos(where)),
					 (radius * sin(where)) - 52);
   end
end

FishingBuddy.UpdateMinimap = function()
   FishingBuddyMinimapButton_MoveButton();
   if ( FishingBuddy.GetSettingBool("MinimapButtonVisible") and
        Minimap:IsVisible() ) then
      FishingBuddyMinimapButton:EnableMouse(true);
      FishingBuddyMinimapButton:Show();
      FishingBuddyMinimapFrame:Show();
   else
      FishingBuddyMinimapButton:EnableMouse(false);
      FishingBuddyMinimapButton:Hide();
      FishingBuddyMinimapFrame:Hide();
   end
end

FishingBuddy.Minimap.Button_OnEvent = function()
end

FishingBuddy.Minimap.Button_OnEnter = function()
   if ( GameTooltip.fbmmbfinished ) then
      return;
   end
   GameTooltip.fbmmbfinished = 1;
   GameTooltip:SetOwner(FishingBuddyMinimapFrame, "ANCHOR_LEFT");
   GameTooltip:AddLine(FBConstants.NAME);
   local text = FishingBuddy.TooltipBody("MinimapClickToSwitch");
   GameTooltip:AddLine(text,.8,.8,.8,1);
   GameTooltip:Show();
end

FishingBuddy.Minimap.Button_OnLeave = function()
   GameTooltip:Hide();
   GameTooltip.fbmmbfinished = nil;
end

function FishingBuddy_ToggleMinimap()
   FishingBuddy.SavedToggleMinimap();
   FishingBuddy.UpdateMinimap();
end

FishingBuddy.Minimap.Menu_Initialize = function()
   FishingBuddy.MakeDropDown(FBConstants.CLICKTOSWITCH_ONOFF, "MinimapClickToSwitch");
end

local MinimapEvents = {};
MinimapEvents["VARIABLES_LOADED"] = FishingBuddy.UpdateMinimap;

FishingBuddy.Minimap.OnLoad = function()
   FishingBuddy.API.RegisterHandlers(MinimapEvents);
end

FishingBuddy.Minimap.OnEvent = function()
end

