-- Handle all the option settings

FishingBuddy.OptionsFrame = {};

local function SetKeyValue(what, value)
   local show = FBConstants.Keys[value];
   FishingBuddy.SetSetting(what, value);
   local menu = getglobal("FishingBuddyOption_"..what);
   if ( menu ) then
      local label = getglobal("FishingBuddyOption_"..what.."Label");
      UIDropDownMenu_SetWidth(menu, 90);
      UIDropDownMenu_SetSelectedValue(menu, show);
      UIDropDownMenu_SetText(menu, show);
      label:SetText(FBConstants.KEYS_LABEL_TEXT);
   end
end
FishingBuddy.OptionsFrame.SetKeyValue = SetKeyValue;

FishingBuddy.CheckButton_OnShow = function(self)
   self:SetChecked(FishingBuddy.GetSetting(self.name));
   if (self.right and self.offset) then
      self:SetPoint("RIGHT", FishingOptionsFrame, "RIGHT", -self.offset, 0);
   end
end

local function CheckBox_Able(value, checkbox)
   if ( not checkbox ) then
      checkbox = this;
   end
   if ( value == nil ) then
      value = checkbox:GetChecked();
   end
   local color;
   if ( value ) then
      checkbox:Enable();
      color = NORMAL_FONT_COLOR;
   else
      checkbox:Disable();
      color = GRAY_FONT_COLOR;
   end
   local text = getglobal(checkbox:GetName().."Text");
   if ( text ) then
      text:SetTextColor(color.r, color.g, color.b);
   end
end

local function CheckButton_HandleDeps(parent, checkbox)
   if ( checkbox.deps ) then
      local value = parent and (checkbox:GetChecked() ~= nil);
      for button,what in pairs(checkbox.deps) do
         if ( what == "d" ) then
            CheckBox_Able(value, button);
            CheckButton_HandleDeps(value, button);
         elseif ( what == "h" ) then
            button:Hide();
            if ( value == 1 ) then
               if ( not button.visible or button.visible() == 1 ) then
                  button:Show();
               end
            end
         end
      end
   end
end

local function CheckButton_OnClick(checkbox, quiet)
   local value = 0;
   if ( not checkbox ) then
      checkbox = this;
   end
   if ( checkbox:GetChecked() ) then
      if ( not quiet ) then
         PlaySound("igMainMenuOptionCheckBoxOn");
      end
      value = 1;
   else
      if ( not quiet ) then
         PlaySound("igMainMenuOptionCheckBoxOff");
      end
   end
   FishingBuddy.SetSetting(checkbox.name, value);
   if ( checkbox.update ) then
      checkbox.update();
   end
   CheckButton_HandleDeps((checkbox:GetChecked() ~= nil), checkbox);
end
FishingBuddy.CheckButton_OnClick = CheckButton_OnClick;

FishingBuddy.CheckButton_OnEnter = function()
   local tooltip = this.tooltip;
   if ( tooltip ) then
      GameTooltip:SetOwner(this, "ANCHOR_RIGHT");
      GameTooltip:SetText(tooltip, nil, nil, nil, nil, 1);
      GameTooltip:Show();
   end
end

FishingBuddy.CheckButton_OnLeave = function()
   GameTooltip:Hide();
end

FishingBuddy.OptionsFrame.Setup = function()
   for name,option in pairs(FishingBuddy.OPTIONS) do
      local button = getglobal("FishingBuddyOption_"..name);
      if ( button ) then
         if ( option.v ) then
            local enable = true;
            if ( option.check ) then
               enable = option.check();
            end
            button.name = name;
            button.update = option.update;
            local text = getglobal("FishingBuddyOption_"..name.."Text");
            if ( option.text ) then
               button.text = option.text;
            else
               button.text = "";
            end
            if (text) then
               text:SetText(button.text);
            end
            button.tooltip = option.tooltip;
            button:SetChecked(FishingBuddy.GetSetting(name));
            if ( option.deps ) then
               for n,what in pairs(option.deps) do
                  local b = getglobal("FishingBuddyOption_"..n);
                  if ( b ) then
                     if ( not b.deps ) then
                        b.deps = {};
                     end
                     b.deps[button] = what;
                  end
               end
            end
         end
      end
   end
end

FishingBuddy.OptionsFrame.OnShow = function(self)
   local maxoffset = 0;
   -- now that we've collected all of the dependencies, handle them
   for name,option in pairs(FishingBuddy.OPTIONS) do
      if ( option.v ) then
         local button = getglobal("FishingBuddyOption_"..name);
         if ( button ) then
            local showit = 1;
            if ( option.visible ) then
               button.visible = option.visible;
               showit = button.visible();
            end
            if ( showit ) then
               button:Show();
            else
               button:Hide();
            end
            CheckButton_HandleDeps((button:GetChecked() ~= nil), button);
            if (button.right and not button.offset) then
               local text = getglobal("FishingBuddyOption_"..name.."Text");
               local offset = button:GetWidth() + text:GetWidth();
                if ( maxoffset < offset ) then
                   maxoffset = offset;
                end
            end
         end
      end
   end

   if ( maxoffset > 0 ) then
      for name,option in pairs(FishingBuddy.OPTIONS) do
         if ( option.v ) then
            local button = getglobal("FishingBuddyOption_"..name);
            if ( button and button.right ) then
               button.offset = maxoffset + 32;
               FishingBuddy.CheckButton_OnShow(button);
            end
         end
      end
   end
   local gs = FishingBuddy.GetSetting;
   SetKeyValue("EasyCastKeys", gs("EasyCastKeys"));
end

FishingBuddy.OptionsFrame.LoadKeyMenu = function(what)
   local info = {};
   local setting = FishingBuddy.GetSetting(what);
   for value,label in pairs(FBConstants.Keys) do
      local v = value;
      local w = what;
      info.text = label;
      info.func = function() SetKeyValue(w, v); end;
      if ( setting == value ) then
         info.checked = true;
      else
         info.checked = false;
      end
      UIDropDownMenu_AddButton(info);
   end
end

FishingBuddy.OptionsFrame.KeyMenuSetup = function(what)
   UIDropDownMenu_Initialize(this,
                             function()
                                local w = what;
                                FishingBuddy.OptionsFrame.LoadKeyMenu(what);
                             end);
end
